<?php
// api/get_application_amounts.php
declare(strict_types=1);
require __DIR__.'/_bootstrap.php';

header('Content-Type: application/json; charset=utf-8');

$appId = isset($_GET['application_id']) ? (int)$_GET['application_id'] : 0;
if ($appId <= 0) { echo json_encode(['error'=>'invalid application_id']); exit; }

// Ensure release_amount column exists (safe no-op if already there)
if (!column_exists($pdo,'loan_applications','release_amount')) {
  $pdo->exec("ALTER TABLE loan_applications ADD COLUMN release_amount DECIMAL(12,2) NULL DEFAULT NULL AFTER loan_amount");
}

$st = $pdo->prepare("SELECT application_id, application_ref_id, customer_id, loan_amount AS requested_amount, release_amount FROM loan_applications WHERE application_id=? LIMIT 1");
$st->execute([$appId]);
$row = $st->fetch();
if (!$row) { echo json_encode(['error'=>'application not found']); exit; }

$cnt = $pdo->prepare("SELECT COUNT(*) FROM track_changes WHERE table_name='loan_applications' AND field_name='release_amount' AND reference_id=?");
$cnt->execute([$appId]);
$updateCount = (int)$cnt->fetchColumn();

echo json_encode([
  'application_id'    => (int)$row['application_id'],
  'application_ref_id'=> $row['application_ref_id'],
  'customer_id'       => (int)$row['customer_id'],
  'requested_amount'  => $row['requested_amount'] !== null ? (float)$row['requested_amount'] : null,
  'release_amount'    => $row['release_amount']   !== null ? (float)$row['release_amount']   : null,
  'update_count'      => $updateCount
]);
