<?php
// api/business_details_get.php
declare(strict_types=1);

require __DIR__.'/_bootstrap.php';

header('Content-Type: application/json; charset=utf-8');

$application_id = (int)($_GET['application_id'] ?? 0);
if ($application_id <= 0) {
  json_out(['error' => 'Invalid application_id'], 400);
}

// Resolve application & customer
$st = $pdo->prepare("SELECT application_id, customer_id FROM loan_applications WHERE application_id=? LIMIT 1");
$st->execute([$application_id]);
$app = $st->fetch();
if (!$app) {
  json_out(['error' => 'Application not found'], 404);
}

$sel = $pdo->prepare("
  SELECT business_details_id, customer_id, loan_application_id,
         business_type, company_number, company_name, company_address,
         company_directors, vat_number, industry_type, created_at, updated_at
    FROM business_details
   WHERE loan_application_id = ?
   LIMIT 1
");
$sel->execute([$application_id]);
$row = $sel->fetch();

function decode_directors(?string $raw): array {
  if (!$raw) return [];
  // Try strict JSON first
  $j = json_decode($raw, true);
  if (is_array($j)) {
    // normalize to [{name, number}]
    $out = [];
    foreach ($j as $it) {
      if (is_array($it)) {
        $out[] = [
          'name'   => trim((string)($it['name']   ?? '')),
          'number' => trim((string)($it['number'] ?? '')),
        ];
      }
    }
    return $out;
  }
  // Fallback: try lines "Name - Number"
  $out = [];
  foreach (preg_split('/\r?\n+/', $raw) as $line) {
    $line = trim($line);
    if ($line === '') continue;
    if (strpos($line, '-') !== false) {
      [$n,$m] = array_map('trim', explode('-', $line, 2));
      $out[] = ['name'=>$n,'number'=>$m];
    } else {
      $out[] = ['name'=>$line,'number'=>''];
    }
  }
  return $out;
}

if (!$row) {
  json_out([
    'ok' => true,
    'business' => [
      'business_details_id' => null,
      'customer_id'         => (int)$app['customer_id'],
      'loan_application_id' => (int)$app['application_id'],
      'business_type'       => '',
      'company_number'      => '',
      'company_name'        => '',
      'company_address'     => '',
      'company_directors'   => [], // array for frontend
      'vat_number'          => '',
      'industry_type'       => '',
    ]
  ]);
} else {
  $row['business_details_id'] = (int)$row['business_details_id'];
  $row['customer_id']         = (int)$row['customer_id'];
  $row['loan_application_id'] = (int)$row['loan_application_id'];
  $row['company_directors']   = decode_directors((string)$row['company_directors']);
  // Strip timestamps for frontend (per request)
  unset($row['created_at'], $row['updated_at']);
  json_out(['ok' => true, 'business' => $row]);
}
