<?php
// api/_audit.php
declare(strict_types=1);

/** Insert one audit row into track_changes */
function audit(PDO $pdo, string $table, $reference_id, string $field, $old, $new, string $updated_by='SYSTEM', string $reason=''): void {
  $stmt = $pdo->prepare("
    INSERT INTO track_changes (table_name, reference_id, field_name, old_data, new_data, updated_by, updated_at, change_reason)
    VALUES (?, ?, ?, ?, ?, ?, NOW(), ?)
  ");
  $stmt->execute([$table, (string)$reference_id, $field, $old, $new, $updated_by, ($reason!=='' ? $reason : null)]);
}
