<?php
include 'includes/session.php';
// users.php - User Management List
$pageTitle = "User Management";
$currentPage = "users";
require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        
        <!-- Header -->
        <div class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 animate-fade-in-down relative z-50 overflow-visible">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Users</h1>
                <p class="text-gray-500 dark:text-gray-400 mt-1">Manage system access, roles, and permissions across all platforms.</p>
            </div>
            
            <!-- Controls Bar -->
            <div class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                
                <!-- Search (Transparent) -->
                <div class="relative group w-full sm:w-48 shrink-0">
                    <ion-icon name="search-outline" class="absolute left-2 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                    <input type="text" id="userSearch" class="pl-8 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium bg-transparent" placeholder="Search users...">
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>
                
                <!-- System Access Filter -->
                <div class="relative z-30" id="systemAccessFilter">
                    <button id="systemFilterBtn" class="flex items-center gap-2 px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 rounded-lg text-sm text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white transition-all border border-transparent hover:border-gray-200 dark:hover:border-gray-600 min-w-[140px] justify-between">
                        <div class="flex items-center gap-2">
                            <ion-icon name="filter-outline" class="text-gray-400 text-lg"></ion-icon>
                            <span id="currentSystemFilter" class="font-medium">All Systems</span>
                        </div>
                        <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 h-3 w-3 transition-transform duration-300"></ion-icon>
                    </button>
                    <!-- Dropdown Menu -->
                    <div id="systemFilterDropdown" class="absolute top-full left-0 mt-2 w-56 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 invisible opacity-0 -translate-y-2 transition-all duration-200 z-50">
                        <div class="p-1">
                            <div class="system-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors active" data-value="all" data-label="All Systems">
                                <div class="flex items-center gap-2">
                                    <div class="w-1.5 h-1.5 rounded-full bg-gray-400 group-hover:bg-primary transition-colors"></div>
                                    All Systems
                                </div>
                                <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-100"></ion-icon>
                            </div>
                            <div class="system-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors" data-value="portal" data-label="Portal">
                                <div class="flex items-center gap-2">
                                    <ion-icon name="globe-outline" class="text-gray-400 group-hover:text-blue-500"></ion-icon>
                                    Portal
                                </div>
                                <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-0"></ion-icon>
                            </div>
                            <div class="system-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors" data-value="admin" data-label="Cashbox Admin">
                                <div class="flex items-center gap-2">
                                    <ion-icon name="construct-outline" class="text-gray-400 group-hover:text-purple-500"></ion-icon>
                                    Cashbox Admin
                                </div>
                                <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-0"></ion-icon>
                            </div>
                            <div class="system-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors" data-value="till" data-label="Cashbox Till">
                                <div class="flex items-center gap-2">
                                    <ion-icon name="calculator-outline" class="text-gray-400 group-hover:text-green-500"></ion-icon>
                                    Cashbox Till
                                </div>
                                <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-0"></ion-icon>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Create User -->
                <a href="user_form.php" class="flex items-center gap-2 px-3 py-2 text-primary font-bold text-sm hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors shrink-0 whitespace-nowrap">
                    <ion-icon name="person-add-outline" class="text-lg"></ion-icon>
                    <span>Add User</span>
                </a>

            </div>
        </div>

        <!-- Data Table -->
        <div class="glass-panel rounded-2xl overflow-hidden animate-fade-in-up delay-100 relative z-0">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                            <th class="p-4 pl-6 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">User</th>
                            <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">System Access</th>
                            <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Role(s)</th>
                            <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Last Login</th>
                            <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider text-center">Status</th>
                            <th class="p-4 pr-6 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody id="usersTableBody" class="divide-y divide-gray-100 dark:divide-gray-700">
                        <!-- Mock Row 1: Super Admin (All Access) -->
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors" data-access="portal admin till" data-status="active">
                            <td class="p-4 pl-6">
                                <div class="flex items-center gap-3">
                                    <img class="w-10 h-10 rounded-full ring-2 ring-white dark:ring-slate-800" src="https://ui-avatars.com/api/?name=Admin+User&background=orange&color=fff" alt="Admin"/>
                                    <div>
                                        <div class="font-semibold text-gray-800 dark:text-white">Admin User</div>
                                        <div class="text-xs text-gray-400">admin@cashbox.com</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="flex items-center gap-1.5 flex-wrap">
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-md text-[10px] font-bold bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400 border border-blue-100 dark:border-blue-800/30">
                                        PORTAL
                                    </span>
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-md text-[10px] font-bold bg-purple-50 dark:bg-purple-900/20 text-purple-600 dark:text-purple-400 border border-purple-100 dark:border-purple-800/30">
                                        ADMIN
                                    </span>
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-md text-[10px] font-bold bg-green-50 dark:bg-green-900/20 text-green-600 dark:text-green-400 border border-green-100 dark:border-green-800/30">
                                        TILL
                                    </span>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="space-y-1">
                                    <div class="text-xs text-gray-500 dark:text-gray-400"><span class="font-bold text-gray-700 dark:text-gray-300">Portal:</span> Superadmin</div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400"><span class="font-bold text-gray-700 dark:text-gray-300">Till:</span> Store Manager</div>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <div class="font-medium text-gray-700 dark:text-gray-300">Today</div>
                                    <div>10:45 AM</div>
                                </div>
                            </td>
                            <td class="p-4 text-center">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400 border border-green-200 dark:border-green-800">
                                    Active
                                </span>
                            </td>
                            <td class="p-4 pr-6 text-right">
                                <div class="flex items-center justify-end gap-3">
                                    <button onclick="openDisableModal('Admin User')" class="p-1.5 rounded-lg transition-colors text-emerald-600 bg-emerald-50 hover:bg-emerald-100 dark:text-emerald-400 dark:bg-emerald-900/20 border border-emerald-100 dark:border-emerald-800/30" title="Disable User">
                                        <ion-icon name="power" class="text-lg"></ion-icon>
                                    </button>
                                    <a href="user_form.php?id=1" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit Permissions">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </a>
                                </div>
                            </td>
                        </tr>

                        <!-- Mock Row 2: Cashier (Till Only) -->
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors" data-access="till" data-status="active">
                            <td class="p-4 pl-6">
                                <div class="flex items-center gap-3">
                                    <img class="w-10 h-10 rounded-full ring-2 ring-white dark:ring-slate-800" src="https://ui-avatars.com/api/?name=Sarah+Jones&background=random" alt="Sarah"/>
                                    <div>
                                        <div class="font-semibold text-gray-800 dark:text-white">Sarah Jones</div>
                                        <div class="text-xs text-gray-400">sarah.j@cashbox.com</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="flex items-center gap-1.5 flex-wrap">
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-md text-[10px] font-bold bg-green-50 dark:bg-green-900/20 text-green-600 dark:text-green-400 border border-green-100 dark:border-green-800/30">
                                        TILL
                                    </span>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="text-xs text-gray-500 dark:text-gray-400"><span class="font-bold text-gray-700 dark:text-gray-300">Till:</span> Cashier</div>
                            </td>
                            <td class="p-4">
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <div class="font-medium text-gray-700 dark:text-gray-300">Yesterday</div>
                                    <div>18:30 PM</div>
                                </div>
                            </td>
                            <td class="p-4 text-center">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400 border border-green-200 dark:border-green-800">
                                    Active
                                </span>
                            </td>
                            <td class="p-4 pr-6 text-right">
                                <div class="flex items-center justify-end gap-3">
                                    <button onclick="openDisableModal('Sarah Jones')" class="p-1.5 rounded-lg transition-colors text-emerald-600 bg-emerald-50 hover:bg-emerald-100 dark:text-emerald-400 dark:bg-emerald-900/20 border border-emerald-100 dark:border-emerald-800/30" title="Disable User">
                                        <ion-icon name="power" class="text-lg"></ion-icon>
                                    </button>
                                    <a href="user_form.php?id=2" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit Permissions">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        
                        <!-- Mock Row 3: Manager (Portal + Admin) -->
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors" data-access="portal admin" data-status="inactive">
                            <td class="p-4 pl-6">
                                <div class="flex items-center gap-3">
                                    <img class="w-10 h-10 rounded-full ring-2 ring-white dark:ring-slate-800 grayscale" src="https://ui-avatars.com/api/?name=Mike+Brown&background=random" alt="Mike"/>
                                    <div>
                                        <div class="font-semibold text-gray-500 dark:text-gray-400">Mike Brown</div>
                                        <div class="text-xs text-gray-400">mike.b@cashbox.com</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="flex items-center gap-1.5 flex-wrap opacity-50">
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-md text-[10px] font-bold bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400 border border-blue-100 dark:border-blue-800/30">
                                        PORTAL
                                    </span>
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-md text-[10px] font-bold bg-purple-50 dark:bg-purple-900/20 text-purple-600 dark:text-purple-400 border border-purple-100 dark:border-purple-800/30">
                                        ADMIN
                                    </span>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="space-y-1 opacity-50">
                                    <div class="text-xs text-gray-500 dark:text-gray-400"><span class="font-bold text-gray-700 dark:text-gray-300">Portal:</span> Manager</div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400"><span class="font-bold text-gray-700 dark:text-gray-300">Admin:</span> Manager</div>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="text-xs text-gray-400 italic">Never</div>
                            </td>
                            <td class="p-4 text-center">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-400 border border-red-200 dark:border-red-800">
                                    Inactive
                                </span>
                            </td>
                            <td class="p-4 pr-6 text-right">
                                <div class="flex items-center justify-end gap-3">
                                    <button class="p-1.5 rounded-lg transition-colors text-red-600 bg-red-50 hover:bg-red-100 dark:text-red-400 dark:bg-red-900/20 border border-red-100 dark:border-red-800/30" title="Enable User">
                                        <ion-icon name="power" class="text-lg"></ion-icon>
                                    </button>
                                    <a href="user_form.php?id=3" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit Permissions">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </a>
                                </div>
                            </td>
                        </tr>

                    </tbody>
                </table>
            </div>
            
            <!-- Pagination Footer (Consistent Style) -->
            <div class="px-6 py-4 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between bg-white dark:bg-slate-800">
                <span class="pagination-text text-xs text-gray-500 dark:text-gray-400 font-medium" id="paginationInfo">
                    Showing 3 of 3 users
                </span>
                <div class="flex items-center gap-2">
                    <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center disabled:opacity-50 disabled:hover:bg-gray-50 disabled:hover:text-gray-500 cursor-pointer disabled:cursor-not-allowed group" disabled>
                        <ion-icon name="chevron-back-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                    <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center cursor-pointer group" disabled>
                        <ion-icon name="chevron-forward-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                </div>
            </div>
        </div>

    </div>
    
    <!-- Disable User Modal -->
    <div id="disableModal" class="fixed inset-0 z-[100] hidden">
        <div class="absolute inset-0 bg-black/50 backdrop-blur-sm transition-opacity opacity-0" id="disableModalOverlay"></div>
        <div class="absolute inset-0 flex items-center justify-center p-4">
            <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-xl w-full max-w-md transform scale-95 opacity-0 transition-all" id="disableModalContent">
                <div class="p-6 border-b border-gray-100 dark:border-gray-700 flex justify-between items-center">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white">Disable User Access</h3>
                    <button onclick="closeDisableModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-200">
                        <ion-icon name="close-outline" class="text-2xl"></ion-icon>
                    </button>
                </div>
                
                <div class="p-6 space-y-4">
                    <div class="bg-red-50 dark:bg-red-900/20 p-4 rounded-xl flex items-start gap-3 border border-red-100 dark:border-red-800/50">
                        <ion-icon name="warning-outline" class="text-xl text-red-600 dark:text-red-400 mt-0.5"></ion-icon>
                        <p class="text-sm text-red-700 dark:text-red-300">This will immediately block <span class="font-bold" id="disableUserName">User</span> from logging into Portal, Admin App, and Till App.</p>
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Reason for disabling (Required)</label>
                        <textarea id="disableReason" rows="3" class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-red-500/20 focus:border-red-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400" placeholder="e.g. Employee left the company..."></textarea>
                    </div>
                </div>

                <div class="p-6 pt-0 flex justify-end gap-3">
                    <button onclick="closeDisableModal()" class="px-6 py-2.5 bg-gray-100 dark:bg-slate-700 hover:bg-gray-200 dark:hover:bg-slate-600 text-gray-700 dark:text-gray-200 font-bold rounded-xl transition-colors">Cancel</button>
                    <button onclick="confirmDisable()" class="px-6 py-2.5 bg-red-500 hover:bg-red-600 text-white font-bold rounded-xl shadow-lg shadow-red-500/20 hover:shadow-red-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="power" class="text-xl"></ion-icon>
                        <span>Disable Access</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script>
       // Minimal JS for Filter Dropdown and Modals
       document.addEventListener('DOMContentLoaded', () => {
           setupDropdown('systemFilterBtn', 'systemFilterDropdown', 'currentSystemFilter', '.system-filter-option');
       });

       function openDisableModal(name) {
           const modal = document.getElementById('disableModal');
           const overlay = document.getElementById('disableModalOverlay');
           const content = document.getElementById('disableModalContent');
           
           document.getElementById('disableUserName').textContent = name;
           modal.classList.remove('hidden');
           
           requestAnimationFrame(() => {
                overlay.classList.remove('opacity-0');
                content.classList.remove('opacity-0', 'scale-95');
                content.classList.add('scale-100');
           });
       }

       function closeDisableModal() {
           const modal = document.getElementById('disableModal');
           const overlay = document.getElementById('disableModalOverlay');
           const content = document.getElementById('disableModalContent');
           
           overlay.classList.add('opacity-0');
           content.classList.remove('scale-100');
           content.classList.add('opacity-0', 'scale-95');
           
           setTimeout(() => {
                modal.classList.add('hidden');
                document.getElementById('disableReason').value = '';
           }, 200);
       }

       function confirmDisable() {
           const reason = document.getElementById('disableReason').value.trim();
           if(!reason) {
               showToast('Please provide a reason.', 'warning');
               return;
           }
           showToast('User access disabled successfully.', 'success');
           closeDisableModal();
           // In real app, would reload or update row status
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
