<?php
include 'includes/session.php';
$pageTitle = "User Permission Overrides";
$currentPage = "users";
require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Mock User Data
$user = [
    'name' => 'Sarah Jenkins',
    'role' => 'Store Manager',
    'store' => 'FNF Cardiff'
];

// Mock Permissions with Overrides
$permissions = [
    ['key' => 'sale.discount', 'label' => 'Apply Discounts', 'group' => 'Sales', 'default' => 'Allow', 'override' => 'inherit'],
    ['key' => 'sale.void', 'label' => 'Void Items', 'group' => 'Sales', 'default' => 'Allow', 'override' => 'deny'], // Specifically denied
    ['key' => 'users.create', 'label' => 'Create Users', 'group' => 'System', 'default' => 'Deny', 'override' => 'allow'], // Specifically allowed
    ['key' => 'reports.view_finance', 'label' => 'View Financial Reports', 'group' => 'Reports', 'default' => 'Deny', 'override' => 'inherit'],
];

?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full custom-scrollbar">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20 space-y-8">

            <!-- Back Nav -->
            <a href="users.php"
                class="inline-flex items-center gap-2 text-gray-400 hover:text-primary transition-all text-xs font-black uppercase tracking-widest group">
                <div
                    class="w-8 h-8 rounded-full bg-gray-100 dark:bg-slate-800 flex items-center justify-center group-hover:bg-primary group-hover:text-white transition-all">
                    <ion-icon name="arrow-back-outline"></ion-icon>
                </div>
                Back to User Directory
            </a>

            <!-- User Status Card -->
            <div class="glass-panel p-8 rounded-[2.5rem] relative overflow-hidden group border border-white/20">
                <div class="absolute -right-10 -top-10 w-40 h-40 bg-orange-500/10 rounded-full blur-3xl"></div>

                <div class="flex flex-col md:flex-row items-center justify-between gap-8 relative z-10">
                    <div class="flex items-center gap-6">
                        <div class="relative">
                            <div
                                class="w-24 h-24 rounded-[2rem] bg-gradient-to-br from-orange-400 via-orange-500 to-pink-500 p-1.5 shadow-2xl shadow-orange-500/20 rotate-3 group-hover:rotate-0 transition-transform duration-500">
                                <div
                                    class="w-full h-full rounded-[1.7rem] bg-white dark:bg-slate-900 flex items-center justify-center text-3xl font-black text-gray-800 dark:text-white opacity-95">
                                    <?php echo substr($user['name'], 0, 1); ?>
                                </div>
                            </div>
                            <div
                                class="absolute -bottom-1 -right-1 w-8 h-8 bg-green-500 border-4 border-white dark:border-slate-800 rounded-full flex items-center justify-center shadow-lg">
                                <ion-icon name="shield-checkmark" class="text-white text-xs"></ion-icon>
                            </div>
                        </div>
                        <div>
                            <h1 class="text-3xl font-black text-gray-800 dark:text-white tracking-tight leading-none">
                                <?php echo $user['name']; ?>
                            </h1>
                            <div class="flex items-center gap-3 mt-3">
                                <span
                                    class="px-3 py-1 rounded-lg bg-gray-100 dark:bg-slate-800 text-gray-500 dark:text-gray-400 text-[10px] font-black uppercase tracking-widest"><?php echo $user['role']; ?></span>
                                <div class="w-1 h-1 rounded-full bg-gray-300"></div>
                                <span class="text-gray-400 text-xs font-bold flex items-center gap-1">
                                    <ion-icon name="business" class="text-sm"></ion-icon>
                                    <?php echo $user['store']; ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="flex flex-col items-center md:items-end gap-3 text-center md:text-right">
                        <span class="text-[10px] font-black text-gray-400 uppercase tracking-[0.2em]">Active Security
                            Schema</span>
                        <div
                            class="px-5 py-2.5 rounded-2xl bg-orange-50 dark:bg-orange-500/10 text-orange-600 dark:text-orange-400 border border-orange-200/50 dark:border-orange-500/20 text-xs font-black flex items-center gap-2 shadow-sm">
                            <div
                                class="w-2 h-2 rounded-full bg-orange-500 animate-pulse shadow-[0_0_8px_rgba(249,115,22,0.5)]">
                            </div>
                            2 CUSTOM OVERRIDES APPLIED
                        </div>
                    </div>
                </div>
            </div>

            <!-- Matrix Controls Aligned to stores.php -->
            <div
                class="flex flex-col sm:flex-row items-center justify-between gap-4 bg-gray-50/50 dark:bg-slate-800/50 p-2 rounded-2xl shadow-xl shadow-gray-200/50 dark:shadow-none border border-gray-100 dark:border-gray-700">
                <div class="relative group w-full max-w-[12rem] shrink-0">
                    <ion-icon name="search-outline"
                        class="absolute left-2.5 top-2.5 text-gray-400 group-focus-within:text-orange-500 transition-colors text-lg"></ion-icon>
                    <input type="text" id="perm-search" placeholder="Search..."
                        class="w-full pl-8 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none text-sm font-medium text-gray-600 dark:text-gray-200 placeholder-gray-400">
                </div>

                <div class="flex items-center gap-2">
                    <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>
                    <div
                        class="flex p-1 bg-gray-50/50 dark:bg-slate-900/50 rounded-xl border border-gray-100 dark:border-gray-700">
                        <button
                            class="px-5 py-2 rounded-lg text-[10px] font-black uppercase tracking-widest bg-gray-900 text-white shadow-xl shadow-gray-900/10 dark:bg-primary dark:shadow-primary/20">All
                            System Points</button>
                        <button
                            class="px-5 py-2 rounded-lg text-[10px] font-black uppercase tracking-widest text-gray-400 hover:text-gray-800 dark:hover:text-white transition-all">Customized
                            Only</button>
                    </div>
                </div>
            </div>

            <!-- Overrides Table -->
            <div
                class="glass-panel rounded-[2rem] overflow-hidden shadow-2xl shadow-gray-200/50 dark:shadow-none border border-white/20">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr
                            class="bg-gray-50/50 dark:bg-slate-800/80 text-[10px] font-black text-gray-400 uppercase tracking-[0.2em] border-b border-gray-100 dark:border-gray-700">
                            <th class="px-8 py-5">Permission Feature</th>
                            <th class="px-8 py-5 text-center w-40">Default Logic</th>
                            <th class="px-8 py-5 text-center w-80">Manual Override</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-gray-700/50">
                        <?php foreach ($permissions as $perm): ?>
                            <tr
                                class="group hover:bg-gray-50/30 dark:hover:bg-slate-800/30 transition-colors pr-row <?php echo $perm['override'] !== 'inherit' ? 'bg-orange-50/20 dark:bg-orange-950/10' : ''; ?>">
                                <td class="px-8 py-6">
                                    <div class="flex items-center gap-3">
                                        <div
                                            class="w-8 h-8 rounded-lg bg-gray-100 dark:bg-slate-800 flex items-center justify-center text-gray-400 group-hover:bg-orange-500/10 group-hover:text-orange-500 transition-colors">
                                            <ion-icon name="keypad-outline"></ion-icon>
                                        </div>
                                        <div>
                                            <div
                                                class="text-sm font-black text-gray-800 dark:text-white group-hover:translate-x-1 transition-transform">
                                                <?php echo $perm['label']; ?>
                                            </div>
                                            <div class="text-[10px] text-gray-400 font-mono font-bold mt-1 tracking-tight">
                                                <?php echo $perm['key']; ?>
                                            </div>
                                        </div>
                                    </div>
                                </td>

                                <!-- Role Default -->
                                <td class="px-8 py-6 text-center">
                                    <?php if ($perm['default'] == 'Allow'): ?>
                                        <span
                                            class="inline-flex items-center px-3 py-1 rounded-full bg-green-100/50 text-green-600 dark:bg-green-500/10 dark:text-green-400 text-[10px] font-black uppercase tracking-widest border border-green-200/30">
                                            ALLOW
                                        </span>
                                    <?php else: ?>
                                        <span
                                            class="inline-flex items-center px-3 py-1 rounded-full bg-red-100/50 text-red-600 dark:bg-red-500/10 dark:text-red-400 text-[10px] font-black uppercase tracking-widest border border-red-200/30">
                                            DENY
                                        </span>
                                    <?php endif; ?>
                                </td>

                                <!-- Override Controls -->
                                <td class="px-8 py-6">
                                    <div
                                        class="flex items-center justify-between p-1 bg-gray-100/80 dark:bg-slate-800/80 backdrop-blur-sm rounded-2xl border border-gray-200/50 dark:border-gray-700 w-full">
                                        <!-- Inherit -->
                                        <label
                                            class="cursor-pointer group/label flex-1 relative px-2 py-2 rounded-xl transition-all text-center <?php echo $perm['override'] == 'inherit' ? 'bg-white dark:bg-slate-700 shadow-xl' : 'hover:bg-white/50 dark:hover:bg-slate-700/50'; ?>">
                                            <input type="radio" name="perm_<?php echo $perm['key']; ?>" class="sr-only"
                                                <?php echo $perm['override'] == 'inherit' ? 'checked' : ''; ?>>
                                            <div class="flex items-center justify-center gap-1.5">
                                                <div
                                                    class="w-1.5 h-1.5 rounded-full <?php echo $perm['override'] == 'inherit' ? 'bg-orange-500 animate-pulse' : 'bg-gray-300'; ?>">
                                                </div>
                                                <span
                                                    class="text-[10px] font-black uppercase tracking-widest <?php echo $perm['override'] == 'inherit' ? 'text-gray-800 dark:text-white' : 'text-gray-400 group-hover/label:text-gray-600'; ?>">Inherit</span>
                                            </div>
                                        </label>

                                        <!-- Allow -->
                                        <label
                                            class="cursor-pointer group/label flex-1 relative px-2 py-2 rounded-xl transition-all text-center <?php echo $perm['override'] == 'allow' ? 'bg-green-500 text-white shadow-xl shadow-green-500/20' : 'hover:bg-green-50 dark:hover:bg-green-500/10'; ?>">
                                            <input type="radio" name="perm_<?php echo $perm['key']; ?>" class="sr-only"
                                                <?php echo $perm['override'] == 'allow' ? 'checked' : ''; ?>>
                                            <span
                                                class="text-[10px] font-black uppercase tracking-widest <?php echo $perm['override'] == 'allow' ? 'text-white' : 'text-gray-400 group-hover/label:text-green-600'; ?>">Override
                                                Allow</span>
                                        </label>

                                        <!-- Deny -->
                                        <label
                                            class="cursor-pointer group/label flex-1 relative px-2 py-2 rounded-xl transition-all text-center <?php echo $perm['override'] == 'deny' ? 'bg-red-500 text-white shadow-xl shadow-red-500/20' : 'hover:bg-red-50 dark:hover:bg-red-500/10'; ?>">
                                            <input type="radio" name="perm_<?php echo $perm['key']; ?>" class="sr-only"
                                                <?php echo $perm['override'] == 'deny' ? 'checked' : ''; ?>>
                                            <span
                                                class="text-[10px] font-black uppercase tracking-widest <?php echo $perm['override'] == 'deny' ? 'text-white' : 'text-gray-400 group-hover/label:text-red-600'; ?>">Override
                                                Deny</span>
                                        </label>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Global Action Bar -->
            <div class="flex flex-col sm:flex-row items-center justify-between gap-4 pt-6">
                <button
                    class="px-8 py-3.5 text-[10px] font-black uppercase tracking-widest text-gray-500 hover:text-red-500 transition-colors flex items-center gap-2">
                    <ion-icon name="refresh-outline" class="text-lg"></ion-icon>
                    Purge All Custom Overrides
                </button>
                <button
                    class="w-full sm:w-auto px-10 py-4 bg-gray-900 dark:bg-primary text-white rounded-[1.5rem] text-sm font-black uppercase tracking-[0.1em] hover:opacity-90 transition-all shadow-2xl shadow-gray-900/20 dark:shadow-primary/30 active:scale-95 flex items-center justify-center gap-3">
                    <ion-icon name="cloud-upload-outline" class="text-xl"></ion-icon>
                    Finalize Security Overrides
                </button>
            </div>
        </div>

        <!-- Footer -->
        <?php include 'includes/footer.php'; ?>
    </main>

<script>
    // Search Logic
    document.getElementById('perm-search').addEventListener('input', function (e) {
        const term = e.target.value.toLowerCase();
        const rows = document.querySelectorAll('.pr-row');

        rows.forEach(row => {
            const text = row.innerText.toLowerCase();
            row.style.display = text.includes(term) ? '' : 'none';
        });
    });

    // Row Highlight Logic on change
    const radios = document.querySelectorAll('input[type="radio"]');
    radios.forEach(radio => {
        radio.addEventListener('change', function () {
            // Find parent row
            const row = this.closest('.pr-row');
            const container = this.closest('div');
            const labels = container.querySelectorAll('label');

            // Reset all labels in this container
            labels.forEach(l => {
                const input = l.querySelector('input');
                const dot = l.querySelector('div div');
                const span = l.querySelector('span');

                l.classList.remove('bg-white', 'dark:bg-slate-700', 'shadow-xl', 'bg-green-500', 'text-white', 'shadow-green-500/20', 'bg-red-500', 'shadow-red-500/20');
                l.classList.add('hover:bg-white/50', 'dark:hover:bg-slate-700/50');

                if (span) {
                    span.classList.remove('text-gray-800', 'dark:text-white', 'text-white');
                    span.classList.add('text-gray-400');
                }
                if (dot) {
                    dot.classList.remove('bg-orange-500', 'animate-pulse');
                    dot.classList.add('bg-gray-300');
                }
            });

            // Apply new styles
            const selectedLabel = this.closest('label');
            const selectedSpan = selectedLabel.querySelector('span');
            const selectedDot = selectedLabel.querySelector('div div');

            selectedLabel.classList.remove('hover:bg-white/50', 'dark:hover:bg-slate-700/50');
            selectedSpan.classList.remove('text-gray-400');

            if (this.value === 'inherit' || selectedLabel.innerText.toLowerCase().includes('inherit')) {
                selectedLabel.classList.add('bg-white', 'dark:bg-slate-700', 'shadow-xl');
                selectedSpan.classList.add('text-gray-800', 'dark:text-white');
                if (selectedDot) selectedDot.classList.add('bg-orange-500', 'animate-pulse');
                row.classList.remove('bg-orange-50/20', 'dark:bg-orange-950/10');
            } else if (selectedLabel.innerText.toLowerCase().includes('allow')) {
                selectedLabel.classList.add('bg-green-500', 'text-white', 'shadow-xl', 'shadow-green-500/20');
                selectedSpan.classList.add('text-white');
                row.classList.add('bg-orange-50/20', 'dark:bg-orange-950/10');
            } else {
                selectedLabel.classList.add('bg-red-500', 'text-white', 'shadow-xl', 'shadow-red-500/20');
                selectedSpan.classList.add('text-white');
                row.classList.add('bg-orange-50/20', 'dark:bg-orange-950/10');
            }
        });
    });
</script>