<?php
include 'includes/session.php';
// user_form.php - Create/Edit User
$userId = $_GET['id'] ?? null;
$mode = $userId ? 'edit' : 'create';
$pageTitle = $mode === 'edit' ? "Edit User" : "Create User";
$currentPage = "users";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";
$checkboxWrapper = "flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 border border-gray-100 dark:border-gray-700 rounded-xl h-fit cursor-pointer hover:border-primary/30 transition-colors";
$checkboxLabel = "font-medium text-gray-700 dark:text-gray-300 select-none";

require_once 'includes/header.php';

// Helper Function for Custom Select (Exact copy from store_form.php)
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    // Identify selected label
    $selectedLabel = $label; // Default fallback
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    // If no specific selection, maybe show first option or label? 
    // Standard select behavior: first option selected by default if nothing matches.
    if ($selectedVal === '' && !empty($options)) {
        $selectedVal = array_key_first($options);
        $selectedLabel = $options[$selectedVal];
    }

    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            <div class="p-1 space-y-0.5">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}

?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="userFormContent" class="flex-1 p-6 md:p-8 pb-20">
            <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header -->
            <div class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                <div class="flex items-center gap-4">

                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight" id="pageHeaderTitle">
                            <?php echo $mode === 'edit' ? 'Edit User' : 'Create New User'; ?>
                        </h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Configure user details, system access, and permissions.</p>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <?php if($mode === 'edit'): ?>
                    <button type="button" class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-red-500 hover:border-red-200 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-xl text-sm font-semibold transition-all shadow-sm flex items-center gap-2" onclick="history.back()">
                        <span>Cancel</span>
                    </button>
                    <?php endif; ?>
                    <button type="submit" form="userForm" class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save User</span>
                    </button>
                </div>
            </div>

            <!-- Tabbed Form Container -->
            <div class="glass-panel rounded-2xl animate-fade-in-up delay-100">
                
                <!-- Tabs Header -->
                <div class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 px-6 pt-4 rounded-t-2xl">
                    <div class="flex gap-6 overflow-x-auto custom-scrollbar" id="formTabs">
                        <button class="tab-btn active pb-4 px-2 text-sm font-semibold border-b-2 border-primary text-primary transition-colors whitespace-nowrap" data-target="tab-general">
                            General Info
                        </button>
                        <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-access">
                            System Access
                        </button>
                        <!-- Dynamic Tabs -->
                        <button id="tab-btn-portal" class="tab-btn hidden pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-portal">
                            Web Portal
                        </button>
                        <button id="tab-btn-admin" class="tab-btn hidden pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-admin">
                            Admin App
                        </button>
                        <button id="tab-btn-till" class="tab-btn hidden pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-till">
                            Till App
                        </button>
                    </div>
                </div>

                <form id="userForm" class="p-6 md:p-8" onsubmit="event.preventDefault(); saveUser();">
                    
                    <!-- TAB: General Info -->
                    <div id="tab-general" class="tab-content space-y-8">
                        
                        <div class="space-y-6">
                            <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Basic Information</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Full Name <span class="text-red-500">*</span></label>
                                    <input type="text" name="full_name" class="<?php echo $inputClass; ?>" placeholder="e.g. John Doe" required>
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Email Address <span class="text-red-500">*</span></label>
                                    <input type="email" name="email" class="<?php echo $inputClass; ?>" placeholder="john.doe@cashbox.com" required>
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Mobile Number</label>
                                    <input type="tel" name="mobile" class="<?php echo $inputClass; ?>" placeholder="e.g. 07123 456789">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                                    <div class="flex items-center gap-3 pt-2">
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="user_status" value="active" class="sr-only peer" checked>
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-green-500"></div>
                                            <span class="ml-3 text-sm font-medium text-gray-600 dark:text-gray-300 status-label" id="statusLabel">Active</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <!-- TAB: System Access -->
                    <div id="tab-access" class="tab-content hidden space-y-8">
                        
                        <!-- Access Selection -->
                        <div class="space-y-4">
                            <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Where can this user log in?</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <!-- Portal Access -->
                                <label class="<?php echo $checkboxWrapper; ?> group">
                                    <span class="<?php echo $checkboxLabel; ?>">Web Portal</span>
                                    <div class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="access_portal" class="sr-only peer" onchange="toggleSystemTab('portal', this.checked)">
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                    </div>
                                </label>

                                <!-- Admin Access -->
                                <label class="<?php echo $checkboxWrapper; ?> group">
                                    <span class="<?php echo $checkboxLabel; ?>">Cashbox Admin App</span>
                                    <div class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="access_admin" class="sr-only peer" onchange="toggleSystemTab('admin', this.checked)">
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                    </div>
                                </label>

                                <!-- Till Access -->
                                <label class="<?php echo $checkboxWrapper; ?> group">
                                    <span class="<?php echo $checkboxLabel; ?>">Cashbox Till App</span>
                                    <div class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="access_till" class="sr-only peer" onchange="toggleSystemTab('till', this.checked)">
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: Portal Config -->
                    <div id="tab-portal" class="tab-content hidden space-y-6 animate-fade-in-up">
                        <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700 flex items-center gap-2">
                             <ion-icon name="globe-outline" class="text-primary"></ion-icon> Portal Configuration
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Role</label>
                                <?php 
                                    echo renderCustomSelect('Role', 'portal_role', [
                                        'viewer' => 'Viewer (Read Only)',
                                        'manager' => 'Manager (Store Mgmt)',
                                        'admin' => 'Admin (Full Access)'
                                    ], 'viewer'); 
                                ?>
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Store Access</label>
                                <?php 
                                    echo renderCustomSelect('Store Access', 'portal_stores', [
                                        'all' => 'All Stores',
                                        'specific' => 'Specific Stores...'
                                    ], 'all'); 
                                ?>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: Admin Config -->
                    <div id="tab-admin" class="tab-content hidden space-y-6 animate-fade-in-up">
                        <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700 flex items-center gap-2">
                            <ion-icon name="construct-outline" class="text-primary"></ion-icon> Admin App Configuration
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Admin Role</label>
                                <?php 
                                    echo renderCustomSelect('Admin Role', 'admin_role', [
                                        'store_manager' => 'Store Manager',
                                        'regional_manager' => 'Regional Manager',
                                        'technician' => 'Technician'
                                    ], 'store_manager'); 
                                ?>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: Till Config -->
                    <div id="tab-till" class="tab-content hidden space-y-8 animate-fade-in-up">
                        <div class="flex items-center justify-between border-b border-gray-100 dark:border-gray-700 pb-2">
                            <h3 class="text-base font-semibold text-gray-800 dark:text-white flex items-center gap-2">
                                <ion-icon name="calculator-outline" class="text-primary"></ion-icon> Till App Configuration
                            </h3>
                        </div>

                        <!-- Role & Store -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Till Role <span class="text-red-500">*</span></label>
                                <?php 
                                    echo renderCustomSelect('Till Role', 'till_role', [
                                        'cashier' => 'Cashier',
                                        'supervisor' => 'Supervisor',
                                        'manager' => 'Store Manager'
                                    ], 'cashier'); 
                                ?>
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Assigned Store <span class="text-red-500">*</span></label>
                                <?php 
                                    echo renderCustomSelect('Assigned Store', 'till_store', [
                                        '1001' => 'FNF Cardiff',
                                        '1002' => 'FNF Swansea'
                                    ], '1001'); 
                                ?>
                            </div>
                        </div>

                        <!-- Authentication Methods -->
                        <div class="space-y-4">
                            <h4 class="text-sm font-bold text-gray-800 dark:text-gray-200 uppercase tracking-wider">Login Methods</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- PIN Code -->
                                <div class="p-4 bg-gray-50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700 space-y-3">
                                    <div class="flex items-center justify-between">
                                        <span class="font-medium text-gray-700 dark:text-gray-300">4-Digit PIN</span>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="till_auth_pin" class="sr-only peer" checked onchange="toggleInput('pinInput', this.checked)">
                                            <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all peer-checked:bg-green-500"></div>
                                        </label>
                                    </div>
                                    <input type="password" id="pinInput" name="till_pin" maxlength="4" class="<?php echo $inputClass; ?> tracking-widest text-center" placeholder="••••" required>
                                    <p class="text-xs text-gray-500">Used for quick terminal login.</p>
                                </div>

                                <!-- Swipe Card -->
                                <div class="p-4 bg-gray-50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700 space-y-3 opacity-50 pointer-events-none" title="Coming Soon">
                                    <div class="flex items-center justify-between">
                                        <span class="font-medium text-gray-700 dark:text-gray-300">Swipe Card / RFID</span>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="till_auth_card" class="sr-only peer" disabled>
                                            <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all peer-checked:bg-green-500"></div>
                                        </label>
                                    </div>
                                    <input type="text" class="<?php echo $inputClass; ?>" placeholder="Card ID / Track Data" disabled>
                                    <p class="text-xs text-gray-500">Scan ID card to link (Hardware required).</p>
                                </div>
                            </div>
                        </div>

                        <!-- Permissions Preview -->
                        <div class="space-y-4">
                            <div class="flex items-center justify-between">
                                    <h4 class="text-sm font-bold text-gray-800 dark:text-gray-200 uppercase tracking-wider">Effective Permissions</h4>
                                    <button type="button" class="text-xs text-primary font-bold hover:underline" onclick="showOverrideModal()">Override Permissions</button>
                            </div>
                            
                            <div class="bg-gray-50 dark:bg-slate-800/80 rounded-xl border border-gray-200 dark:border-gray-700 p-4">
                                <div id="permissionsList" class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-3">
                                    <!-- Populated by JS -->
                                </div>
                            </div>
                        </div>

                    </div>

                </form>
            </div>

        </div>
    </div>
    
    <!-- Permission Override Modal (Placeholder) -->
    <!-- Ideally this would be a detailed modal. For now, we will handle overrides in V2 or separate logic if requested, but let's keep the button for UI completeness -->

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initTabs();
             initCustomSelects(); // Initialize Custom Selects
             // Initial Check
             checkEditMode();
             updatePermissionPreview('cashier'); // Default
       });

        function initTabs() {
             const tabs = document.querySelectorAll('.tab-btn');
             const contents = document.querySelectorAll('.tab-content');
 
             tabs.forEach(tab => {
                 tab.addEventListener('click', () => {
                     // Remove active classes
                     tabs.forEach(t => {
                         t.classList.remove('active', 'border-primary', 'text-primary');
                         t.classList.add('border-transparent', 'text-gray-500', 'dark:text-gray-400');
                     });
 
                     // Add active classes
                     tab.classList.add('active', 'border-primary', 'text-primary');
                     tab.classList.remove('border-transparent', 'text-gray-500', 'dark:text-gray-400');
 
                     // Hide/Show content
                     contents.forEach(c => c.classList.add('hidden'));
                     const targetId = tab.dataset.target;
                     const target = document.getElementById(targetId);
                     if (target) {
                         target.classList.remove('hidden');
                         target.classList.add('animate-fade-in-up');
                     }
                 });
             });
         }

       // --- Custom Select Logic ---
       function initCustomSelects() {
            // Toggle Dropdown
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');

                    // Close all other dropdowns
                    closeAllSelects(trigger);

                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');

                    // Rotate chevron
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron) {
                        if (!dropdown.classList.contains('invisible')) {
                            chevron.classList.add('rotate-180');
                            chevron.classList.add('text-primary');
                        } else {
                            chevron.classList.remove('rotate-180');
                            chevron.classList.remove('text-primary');
                        }
                    }
                });
            });

            // Option Click
            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');

                    // Update value
                    const val = option.dataset.value;
                    const label = option.dataset.label;

                    hiddenInput.value = val;
                    triggerLabel.textContent = label;

                    // Update active styling
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        
                        const check = opt.querySelector('.check-icon');
                        if (check) {
                            check.classList.remove('opacity-100');
                            check.classList.add('opacity-0');
                        }
                    });
                    
                    option.classList.add('active');

                    const check = option.querySelector('.check-icon');
                    if (check) {
                        check.classList.remove('opacity-0');
                        check.classList.add('opacity-100');
                    }

                    // Trigger change event on hidden input if needed (for other listeners)
                    const event = new Event('change', { bubbles: true });
                    hiddenInput.dispatchEvent(event);

                    // Close dropdown
                    dropdown.classList.add('opacity-0');
                    dropdown.classList.add('invisible');
                    dropdown.classList.add('-translate-y-2');

                    // Reset chevron
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron) {
                        chevron.classList.remove('rotate-180');
                        chevron.classList.remove('text-primary');
                    }
                    
                    // Special Handling for Till Role Preview Update
                    if(hiddenInput.name === 'till_role') {
                        updatePermissionPreview(val);
                    }
                });
            });

            // Click Outside
            document.addEventListener('click', () => {
                closeAllSelects();
            });
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');

                if (exceptTrigger && trigger === exceptTrigger) return;

                if (!dropdown.classList.contains('invisible')) {
                    dropdown.classList.add('opacity-0');
                    dropdown.classList.add('invisible');
                    dropdown.classList.add('-translate-y-2');

                    // Reset chevron
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron) {
                        chevron.classList.remove('rotate-180');
                        chevron.classList.remove('text-primary');
                    }
                }
            });
       }

       // Toggle System Tabs based on selection
       function toggleSystemTab(system, checked) {
           const tabBtn = document.getElementById(`tab-btn-${system}`);
           if(tabBtn) {
               if(checked) {
                   tabBtn.classList.remove('hidden');
                   // Optional: Automatically switch to the newly enabled tab?
                   // tabBtn.click(); // Uncomment if we want auto-switch
                   showToast(`${system.charAt(0).toUpperCase() + system.slice(1)} configuration tab enabled.`, 'info');
               } else {
                   tabBtn.classList.add('hidden');
                   // If we are currently ON this tab, switch back to 'System Access'
                   if(tabBtn.classList.contains('active')) {
                       document.querySelector('[data-target="tab-access"]').click();
                   }
               }
           }
       }
       
       function toggleInput(inputId, enable) {
           const input = document.getElementById(inputId);
           if(input) {
               input.disabled = !enable;
               if (!enable) {
                    input.classList.add('opacity-50', 'bg-gray-50');
                    input.classList.remove('bg-white', 'dark:bg-slate-800');
               } else {
                    input.classList.remove('opacity-50', 'bg-gray-50');
                    input.classList.add('bg-white', 'dark:bg-slate-800');
               }
           }
       }

       // Mock Roles Data
       const ROLE_PERMISSIONS = {
           'cashier': ['Sales', 'Returns (Low Value)', 'X Report'],
           'supervisor': ['Sales', 'Returns (All)', 'Voids', 'X Report', 'Z Report', 'Price Override'],
           'manager': ['ALL ACCESS']
       };

       function updatePermissionPreview(role) {
           const container = document.getElementById('permissionsList');
           if (!container) return; // Guard clause
           container.innerHTML = '';
           
           const perms = ROLE_PERMISSIONS[role] || [];
           
           if(role === 'manager') {
                container.innerHTML = `<div class="col-span-full text-center py-2 text-sm font-bold text-green-600 dark:text-green-400">
                    <ion-icon name="shield-checkmark" class="text-lg align-middle mr-1"></ion-icon> Full System Access
                </div>`;
                return;
           }

           perms.forEach(perm => {
               const div = document.createElement('div');
               div.className = 'flex items-center gap-2 text-xs font-medium text-gray-600 dark:text-gray-300 bg-white dark:bg-slate-700 px-2 py-1.5 rounded-lg border border-gray-100 dark:border-gray-600';
               div.innerHTML = `<ion-icon name="checkmark-circle" class="text-green-500"></ion-icon> ${perm}`;
               container.appendChild(div);
           });
       }

       function saveUser() {
           showToast('Saving user...', 'info');
           // Mock Save
           setTimeout(() => {
               showToast('User saved successfully!', 'success');
               setTimeout(() => {
                   window.location.href = 'users.php';
               }, 1000);
           }, 800);
       }
       
       function checkEditMode() {
            const urlParams = new URLSearchParams(window.location.search);
            if(urlParams.get('id')) {
                // Mock Pre-fill for edit
                // For layout testing mostly
            }
       }

       function showOverrideModal() {
           showToast('Permission overrides unavailable in this version.', 'warning');
       }

       // Status Toggle Listener
        const statusCheck = document.querySelector('input[name="user_status"]');
        if (statusCheck) {
            statusCheck.addEventListener('change', (e) => {
                const label = document.getElementById('statusLabel');
                if (label) label.textContent = e.target.checked ? 'Active' : 'Inactive';
            });
        }

    </script>

    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
