<?php
include 'includes/session.php';
$pageTitle = "Search Transactions";
$currentPage = "transactions_search";
require_once 'includes/header.php';

// Mock Data (Expanded to match screenshot)
$transactions = [
    [
        'id' => '492054-TP-R-12', 
        'name' => 'Christine Brooks', 
        'time' => '06:27:42', 
        'date' => '04 Sep 2025', 
        'type' => 'CASH', 
        'status' => 'Refund', 
        'sales_by' => 'Madu', 
        'amount' => '800.00'
    ],
    [
        'id' => '492054-TP-C-12', 
        'name' => 'Rosie Pearson', 
        'time' => '06:27:42', 
        'date' => '04 Sep 2025', 
        'type' => '-', 
        'status' => 'Cash Lift', 
        'sales_by' => 'Madu', 
        'amount' => '800.00'
    ],
    [
        'id' => '492054-TP-12', 
        'name' => 'Darrell Caldwell', 
        'time' => '06:27:42', 
        'date' => '04 Sep 2025', 
        'type' => '-', 
        'status' => 'Void', 
        'sales_by' => 'Madu', 
        'amount' => '800.00'
    ],
    [
        'id' => '492054-TP-12', 
        'name' => 'Gilbert Johnston', 
        'time' => '06:27:42', 
        'date' => '04 Sep 2025', 
        'type' => 'CARD', 
        'status' => 'Penny Sale', 
        'sales_by' => 'Madu', 
        'amount' => '800.00'
    ],
    [
        'id' => '492054-TP-12', 
        'name' => 'Alan Cain', 
        'time' => '06:27:42', 
        'date' => '04 Sep 2025', 
        'type' => 'CASH', 
        'status' => 'Completed', 
        'sales_by' => 'Madu', 
        'amount' => '800.00'
    ],
    [
        'id' => '492054-TP-12', 
        'name' => 'Alfred Murray', 
        'time' => '06:27:42', 
        'date' => '04 Sep 2025', 
        'type' => 'CARD', 
        'status' => 'Line Void', 
        'sales_by' => 'Madu', 
        'amount' => '800.00'
    ],
    [
        'id' => '492054-TP-12', 
        'name' => 'Maggie Sullivan', 
        'time' => '06:27:42', 
        'date' => '04 Sep 2025', 
        'type' => 'CASH', 
        'status' => 'Completed', 
        'sales_by' => 'Madu', 
        'amount' => '800.00'
    ],
    [
        'id' => '492054-TP-P-12', 
        'name' => 'Rosie Todd', 
        'time' => '06:27:42', 
        'date' => '04 Sep 2025', 
        'type' => 'CASH', 
        'status' => 'Payout', 
        'sales_by' => 'Madu', 
        'amount' => '800.00'
    ],
     [
        'id' => '492054-TP-12', 
        'name' => 'Dollie Hines', 
        'time' => '06:27:42', 
        'date' => '04 Sep 2025', 
        'type' => 'CARD', 
        'status' => 'Completed', 
        'sales_by' => 'Madu', 
        'amount' => '800.00'
    ],
];

function getStatusBadgeClass($status) {
    switch($status) {
        case 'Refund': return 'bg-blue-100 text-blue-700 dark:bg-blue-900/30 dark:text-blue-400';
        case 'Cash Lift': return 'bg-slate-200 text-slate-700 dark:bg-slate-700 dark:text-slate-300'; // Greyish blue
        case 'Void': return 'bg-red-100 text-red-700 dark:bg-red-900/30 dark:text-red-400';
        case 'Penny Sale': return 'bg-gray-200 text-gray-700 dark:bg-gray-700 dark:text-gray-300';
        case 'Completed': return 'bg-[#DCFCE7] text-[#166534] dark:bg-green-900/30 dark:text-green-400'; // Light Green
        case 'Line Void': return 'bg-[#FEF3C7] text-[#92400E] dark:bg-yellow-900/30 dark:text-yellow-400'; // Light Orange
        case 'Payout': return 'bg-[#E0E7FF] text-[#3730A3] dark:bg-indigo-900/30 dark:text-indigo-400'; // Purpleish
        default: return 'bg-gray-100 text-gray-700';
    }
}

// Helper to render a single row
function renderTransactionRow($row) {
    global $transactions; // Ensure access if needed, though passed as arg
    ?>
    <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
        <!-- Transaction ID -->
        <td class="p-4 pl-6">
            <span class="text-sm font-bold text-gray-600 dark:text-gray-300 font-mono tracking-tight"><?php echo $row['id']; ?></span>
        </td>

        <!-- Name -->
        <td class="p-4">
            <span class="text-sm font-medium text-gray-700 dark:text-gray-200"><?php echo $row['name']; ?></span>
        </td>

        <!-- Store Code (New) -->
        <td class="p-4">
            <div class="flex items-center gap-2">
                <div class="w-8 h-8 rounded-lg bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400 flex items-center justify-center text-[10px] font-bold">
                    CDF
                </div>
                <span class="text-xs font-bold text-gray-700 dark:text-gray-200">FNF Cardiff</span>
            </div>
        </td>

        <!-- Time & Date -->
        <td class="p-4 text-center">
            <div class="flex flex-col">
                <span class="text-sm font-bold text-gray-700 dark:text-gray-300"><?php echo $row['time']; ?></span>
                <span class="text-xs text-gray-400"><?php echo $row['date']; ?></span>
            </div>
        </td>
        
            <!-- Type (Cash/Card/-) -->
        <td class="p-4">
            <span class="text-xs font-semibold text-gray-600 dark:text-gray-400 uppercase"><?php echo $row['type']; ?></span>
        </td>

        <!-- Status Badge -->
        <td class="p-4">
            <span class="inline-flex items-center justify-center px-4 py-1.5 rounded-lg text-xs font-bold <?php echo getStatusBadgeClass($row['status']); ?> w-28 text-center">
                <?php echo $row['status']; ?>
            </span>
        </td>

        <!-- Sales By -->
        <td class="p-4">
            <span class="text-sm text-gray-600 dark:text-gray-400"><?php echo $row['sales_by']; ?></span>
        </td>

        <!-- Amount -->
        <td class="p-4 text-right">
            <span class="text-sm font-bold text-gray-800 dark:text-white tracking-tight">£ <?php echo $row['amount']; ?></span>
        </td>

        <!-- Actions -->
        <td class="p-4 pr-6 text-center">
            <div class="flex items-center justify-center gap-3">
                <button onclick="openViewModal('<?php echo $row['id']; ?>')" class="p-1.5 text-gray-400 hover:text-gray-600 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg transition-colors" title="View Details">
                    <ion-icon name="eye-outline" class="text-lg"></ion-icon>
                </button>
                    <button onclick="openEditModal('<?php echo $row['id']; ?>')" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit">
                    <ion-icon name="create-outline" class="text-lg"></ion-icon>
                </button>
                <button class="p-1.5 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-lg transition-colors" title="Delete">
                    <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                </button>
            </div>
        </td>
    </tr>
    <?php
}

// AJAX Handler
if (isset($_GET['ajax'])) {
    // In a real scenario, filter $transactions based on $_GET params (date_from, date_to, stores, etc.)
    foreach ($transactions as $row) {
        renderTransactionRow($row);
    }
    exit;
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="transactionContent" class="flex-1 p-6 md:p-8 pb-20">
        
        <!-- Header -->
        <div class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-50 overflow-visible">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Search Transactions</h1>
                <p class="text-gray-500 dark:text-gray-400 mt-1">Advanced transaction filtering and history.</p>
            </div>
            
            <!-- Controls Bar -->
            <div class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                
                <!-- Store Filter (Multi) -->
                <div class="relative group w-full sm:w-auto shrink-0 z-50">
                    <?php 
                        $filterId = 'store_filter'; // Optional, defaults to 'store_filter'
                        include 'includes/components/store_filter_multi.php'; 
                    ?>
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Date Range Picker (Unified) -->
                <div class="relative group w-full sm:w-auto shrink-0">
                   <?php 
                        $pickerId = 'search_range'; 
                        $startParam = 'date_from';
                        $endParam = 'date_to';
                        include 'includes/components/date_range_picker.php'; 
                   ?>
                </div>

                <!-- Manual Apply Button -->
                <button onclick="applyFilters()" class="flex items-center gap-2 px-4 py-2 bg-[#E65100] hover:bg-[#F57C00] text-white font-bold rounded-xl shadow-lg shadow-orange-500/20 transition-all transform hover:-translate-y-0.5 text-sm">
                    <ion-icon name="filter-outline" class="text-lg"></ion-icon>
                    <span>Filter</span>
                </button>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Export (Primary) -->
                <button type="button" class="flex items-center gap-2 px-6 py-2 bg-[#E65100] hover:bg-[#F57C00] text-white font-bold rounded-xl shadow-lg shadow-orange-500/20 transition-all transform hover:-translate-y-0.5 text-sm">
                    <ion-icon name="download-outline" class="text-lg"></ion-icon>
                    <span>Export</span>
                </button>
            </div>
        </div>
        
        <script>
            // Staged Filter Change (No Fetch)
            window.handleDateChange = function(url, pickerId, formattedDate) {
                console.log(`Filter staged: ${formattedDate} (${pickerId}) - Waiting for Apply`);
                // URL is already updated by the components via pushState
            };

            // Manual Apply Trigger
            function applyFilters() {
                const url = window.location.href;
                console.log('Applying filters:', url);

                // Fetch new table content via AJAX
                const ajaxUrl = new URL(url);
                ajaxUrl.searchParams.set('ajax', '1');
                
                const tbody = document.querySelector('tbody');
                if(tbody) {
                    tbody.style.opacity = '0.5';
                    tbody.style.transition = 'opacity 0.2s';
                }

                fetch(ajaxUrl)
                    .then(response => response.text())
                    .then(html => {
                        if(tbody) {
                            tbody.innerHTML = html;
                            tbody.style.opacity = '1';
                        }
                    })
                    .catch(error => {
                        console.error('Error fetching transactions:', error);
                        if(tbody) tbody.style.opacity = '1';
                        // Fallback
                        window.location.reload();
                    });
            }
        </script>

        <!-- Data Table -->
        <div class="glass-panel rounded-2xl overflow-visible shadow-sm relative z-0 min-h-[500px]">
            <div class="overflow-x-auto overflow-y-visible">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                            
                            <!-- Column: Transaction ID (Modern Search Popup) -->
                            <th class="p-4 pl-6 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[220px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-id" class="transition-colors duration-200">Transaction ID</span>
                                    <button onclick="toggleSearchPopup('searchPopup-id')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                
                                <!-- Search Popup -->
                                <div id="searchPopup-id" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Filter ID</span>
                                        <ion-icon name="qr-code-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-id" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Search ID...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('id')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">
                                            Clear
                                        </button>
                                        <button onclick="applyTextFilter('id')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">
                                            Apply
                                        </button>
                                    </div>
                                </div>
                            </th>

                            <!-- Column: Name (Modern Search Popup) -->
                            <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[220px]">
                                 <div class="flex items-center justify-between">
                                    <span id="header-name" class="transition-colors duration-200">Name</span>
                                    <button onclick="toggleSearchPopup('searchPopup-name')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <!-- Search Popup -->
                                <div id="searchPopup-name" class="absolute top-full right-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-right backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Name</span>
                                        <ion-icon name="people-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-name" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Customer Name...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('name')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">
                                            Clear
                                        </button>
                                        <button onclick="applyTextFilter('name')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">
                                            Apply
                                        </button>
                                    </div>
                            </th>

                            <!-- Column: Store (New) -->
                            <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[180px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-store" class="transition-colors duration-200">Store</span>
                                    <button onclick="toggleSearchPopup('searchPopup-store')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="storefront-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <!-- Search Popup -->
                                <div id="searchPopup-store" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Store</span>
                                        <ion-icon name="storefront-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-store" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Store Name...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('store')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">
                                            Clear
                                        </button>
                                        <button onclick="applyTextFilter('store')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">
                                            Apply
                                        </button>
                                    </div>
                                </div>
                            </th>

                            <th class="p-4 text-center text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase border-r border-gray-100 dark:border-gray-700/50">TIME</th>
                            
                            <!-- Column: Type (Modern Filter Popup - List Style) -->
                            <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[140px]">
                                 <div class="flex items-center justify-between">
                                    <span>TYPE</span>
                                    <button onclick="toggleSearchPopup('searchPopup-type')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="filter-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <!-- Search Popup -->
                                <div id="searchPopup-type" class="absolute top-full right-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-2 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-right backdrop-blur-xl">
                                    <div class="space-y-1">
                                         <!-- Option: All -->
                                        <div class="group flex items-center justify-between w-full px-3 py-2.5 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-xl cursor-pointer transition-colors" onclick="toggleFilterOption(this)">
                                            <div class="flex items-center gap-3">
                                                 <div class="w-8 h-8 rounded-lg bg-gray-100 dark:bg-gray-700 flex items-center justify-center text-gray-500 dark:text-gray-400">
                                                    <ion-icon name="apps-outline"></ion-icon>
                                                 </div>
                                                 <span class="text-xs font-bold text-gray-700 dark:text-gray-200">All Types</span>
                                            </div>
                                            <ion-icon name="checkmark-circle" class="text-primary text-xl opacity-0 transition-opacity"></ion-icon>
                                        </div>

                                        <!-- Option: Cash -->
                                        <div class="group flex items-center justify-between w-full px-3 py-2.5 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-xl cursor-pointer transition-colors" onclick="toggleFilterOption(this)">
                                            <div class="flex items-center gap-3">
                                                 <div class="w-8 h-8 rounded-lg bg-green-100 dark:bg-green-900/30 flex items-center justify-center text-green-600 dark:text-green-400">
                                                    <ion-icon name="cash-outline"></ion-icon>
                                                 </div>
                                                 <span class="text-xs font-bold text-gray-700 dark:text-gray-200">Cash</span>
                                            </div>
                                            <ion-icon name="checkmark-circle" class="text-primary text-xl opacity-0 transition-opacity"></ion-icon>
                                        </div>

                                        <!-- Option: Card -->
                                        <div class="group flex items-center justify-between w-full px-3 py-2.5 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-xl cursor-pointer transition-colors" onclick="toggleFilterOption(this)">
                                            <div class="flex items-center gap-3">
                                                 <div class="w-8 h-8 rounded-lg bg-blue-100 dark:bg-blue-900/30 flex items-center justify-center text-blue-600 dark:text-blue-400">
                                                    <ion-icon name="card-outline"></ion-icon>
                                                 </div>
                                                 <span class="text-xs font-bold text-gray-700 dark:text-gray-200">Card</span>
                                            </div>
                                            <ion-icon name="checkmark-circle" class="text-primary text-xl opacity-0 transition-opacity"></ion-icon>
                                        </div>
                                    </div>
                                    
                                    <div class="mt-2 pt-2 border-t border-gray-100 dark:border-gray-700 flex justify-end px-1">
                                         <button class="px-4 py-1.5 rounded-lg text-xs font-bold text-white bg-primary hover:bg-orange-600 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">
                                            Apply
                                        </button>
                                    </div>
                                </div>
                            </th>

                            <!-- Column: Status (Modern Filter Popup - List Style) -->
                            <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[160px]">
                                <div class="flex items-center justify-between">
                                    <span>STATUS</span>
                                    <button onclick="toggleSearchPopup('searchPopup-status')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="filter-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <!-- Search Popup -->
                                <div id="searchPopup-status" class="absolute top-full right-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-2 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-right backdrop-blur-xl">
                                    <div class="space-y-1">
                                        <!-- Option: All -->
                                        <div class="group flex items-center justify-between w-full px-3 py-2.5 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-xl cursor-pointer transition-colors" onclick="toggleFilterOption(this)">
                                            <div class="flex items-center gap-3">
                                                 <span class="w-2.5 h-2.5 rounded-full border border-gray-400"></span>
                                                 <span class="text-xs font-bold text-gray-700 dark:text-gray-200">All Status</span>
                                            </div>
                                            <ion-icon name="checkmark-circle" class="text-primary text-xl opacity-0 transition-opacity"></ion-icon>
                                        </div>

                                        <!-- Option: Completed -->
                                        <div class="group flex items-center justify-between w-full px-3 py-2.5 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-xl cursor-pointer transition-colors" onclick="toggleFilterOption(this)">
                                            <div class="flex items-center gap-3">
                                                 <span class="w-2.5 h-2.5 rounded-full bg-green-500 shadow-sm shadow-green-500/50"></span>
                                                 <span class="text-xs font-bold text-gray-700 dark:text-gray-200">Completed</span>
                                            </div>
                                            <ion-icon name="checkmark-circle" class="text-primary text-xl opacity-0 transition-opacity"></ion-icon>
                                        </div>

                                        <!-- Option: Void -->
                                        <div class="group flex items-center justify-between w-full px-3 py-2.5 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-xl cursor-pointer transition-colors" onclick="toggleFilterOption(this)">
                                            <div class="flex items-center gap-3">
                                                 <span class="w-2.5 h-2.5 rounded-full bg-red-500 shadow-sm shadow-red-500/50"></span>
                                                 <span class="text-xs font-bold text-gray-700 dark:text-gray-200">Void</span>
                                            </div>
                                            <ion-icon name="checkmark-circle" class="text-primary text-xl opacity-0 transition-opacity"></ion-icon>
                                        </div>

                                        <!-- Option: Refund -->
                                        <div class="group flex items-center justify-between w-full px-3 py-2.5 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-xl cursor-pointer transition-colors" onclick="toggleFilterOption(this)">
                                            <div class="flex items-center gap-3">
                                                 <span class="w-2.5 h-2.5 rounded-full bg-blue-500 shadow-sm shadow-blue-500/50"></span>
                                                 <span class="text-xs font-bold text-gray-700 dark:text-gray-200">Refund</span>
                                            </div>
                                            <ion-icon name="checkmark-circle" class="text-primary text-xl opacity-0 transition-opacity"></ion-icon>
                                        </div>
                                    </div>
                                    
                                     <div class="mt-2 pt-2 border-t border-gray-100 dark:border-gray-700 flex justify-end px-1">
                                         <button class="px-4 py-1.5 rounded-lg text-xs font-bold text-white bg-primary hover:bg-orange-600 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">
                                            Apply
                                        </button>
                                    </div>
                                </div>
                            </th>

                            <!-- Column: Sales By (Modern Search Popup) -->
                            <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[220px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-sales" class="transition-colors duration-200">SALES BY</span>
                                    <button onclick="toggleSearchPopup('searchPopup-sales')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <!-- Search Popup -->
                                <div id="searchPopup-sales" class="absolute top-full right-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-right backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Filter Staff</span>
                                        <ion-icon name="person-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-sales" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Staff Name...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('sales')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">
                                            Clear
                                        </button>
                                        <button onclick="applyTextFilter('sales')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">
                                            Apply
                                        </button>
                                    </div>
                                </div>
                            </th>
                            <th class="p-4 text-right text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase">AMOUNT</th>
                            <th class="p-4 pr-6 text-center text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                        <?php foreach ($transactions as $row): 
                            renderTransactionRow($row);
                        endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination (Standard Store Style) -->
            <div class="p-4 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between">
                <span class="pagination-text text-xs text-gray-500 dark:text-gray-400 font-medium">Showing 0 of 0 transactions</span>
                <div class="flex gap-2">
                    <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center disabled:opacity-50 disabled:hover:bg-gray-50 disabled:hover:text-gray-500 cursor-pointer disabled:cursor-not-allowed group" disabled>
                        <ion-icon name="chevron-back-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                    <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center cursor-pointer group">
                        <ion-icon name="chevron-forward-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                </div>
            </div>
        </div>

    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
    
    <!-- Transaction Modals -->
    <?php include 'includes/components/transaction_modals.php'; ?>
</main>

<script>
    // Toggle Search Popups in Table Headers
    function toggleSearchPopup(popupId) {
        // Close all others first
        document.querySelectorAll('[id^="searchPopup-"]').forEach(el => {
            if(el.id !== popupId) {
                el.classList.add('invisible', 'opacity-0', 'translate-y-4'); // Modern transition style
            }
        });

        const popup = document.getElementById(popupId);
        if(popup) {
            if(popup.classList.contains('invisible')) {
                popup.classList.remove('invisible', 'opacity-0', 'translate-y-4');
            } else {
                popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
            }
        }
    }

    // Close on click outside
    document.addEventListener('click', (e) => {
        if (!e.target.closest('th')) {
            document.querySelectorAll('[id^="searchPopup-"]').forEach(el => {
                 el.classList.add('invisible', 'opacity-0', 'translate-y-4');
            });
        }
    });

    // Prevent closing when clicking inside the popup
    document.querySelectorAll('[id^="searchPopup-"]').forEach(popup => {
        popup.addEventListener('click', (e) => {
            e.stopPropagation();
        });
    });

    // Toggle Checkmark Selection (Stores.php Style)
    function toggleFilterOption(element) {
        // Find the checkmark icon within the clicked element
        const checkmark = element.querySelector('ion-icon[name="checkmark-circle"]');
        
        // Toggle opacity class
        if (checkmark.classList.contains('opacity-0')) {
            checkmark.classList.remove('opacity-0');
            checkmark.classList.add('opacity-100');
            element.classList.add('bg-gray-50', 'dark:bg-slate-700/50'); // Keep highlighted
        } else {
            checkmark.classList.add('opacity-0');
            checkmark.classList.remove('opacity-100');
             element.classList.remove('bg-gray-50', 'dark:bg-slate-700/50'); // Remove highlight
        }
    }

    // Apply Text Filter (Highlight Header)
    function applyTextFilter(type) {
        const input = document.getElementById('input-' + type);
        const header = document.getElementById('header-' + type);
        const popupId = 'searchPopup-' + type;

        if (input.value.trim() !== "") {
            header.classList.add('text-primary');
        } else {
            header.classList.remove('text-primary');
        }
        
        // Close Popup
        const popup = document.getElementById(popupId);
        popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
        popup.classList.remove('translate-y-0');
    }

    // Clear Text Filter (Remove Highlight)
    function clearTextFilter(type) {
        const input = document.getElementById('input-' + type);
        const header = document.getElementById('header-' + type);
        
        input.value = "";
        header.classList.remove('text-primary');
    }
</script>
</body>
</html>
