<?php
include 'includes/session.php';
$pageTitle = "Clone Store Data";
$currentPage = "tools_clone";
require_once 'includes/header.php';

// Mock Stores
$stores = [
    ['id' => 1, 'name' => 'FNF Cardiff', 'type' => 'Grocery'],
    ['id' => 2, 'name' => 'FNF Bristol', 'type' => 'fGrocery'],
    ['id' => 3, 'name' => 'Steakhouse London', 'type' => 'Restaurant'],
    ['id' => 4, 'name' => 'Burger Joint', 'type' => 'Restaurant']
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-4xl mx-auto space-y-6">

            <!-- Header -->
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Clone Store Data</h1>
                <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Copy configurations, menus, and products between stores.</p>
            </div>

            <!-- Wizard Progress -->
            <div class="flex items-center justify-between px-4">
                <div class="flex flex-col items-center gap-2 relative z-10 w-24">
                    <div class="w-8 h-8 rounded-full bg-primary text-white flex items-center justify-center font-bold text-sm shadow-lg shadow-orange-500/20 ring-4 ring-white dark:ring-slate-900 transition-all step-indicator" data-step="1">1</div>
                    <span class="text-xs font-bold text-gray-800 dark:text-white">Source</span>
                </div>
                <div class="flex-1 h-0.5 bg-gray-200 dark:bg-gray-700 -mx-4 relative top-[-10px]">
                    <div class="h-full bg-primary transition-all duration-300 w-0" id="progress-bar"></div>
                </div>
                <div class="flex flex-col items-center gap-2 relative z-10 w-24">
                     <div class="w-8 h-8 rounded-full bg-gray-200 dark:bg-slate-700 text-gray-500 dark:text-gray-400 flex items-center justify-center font-bold text-sm ring-4 ring-white dark:ring-slate-900 transition-all step-indicator" data-step="2">2</div>
                    <span class="text-xs font-bold text-gray-500 dark:text-gray-400">Target</span>
                </div>
                 <div class="flex-1 h-0.5 bg-gray-200 dark:bg-gray-700 -mx-4 relative top-[-10px]"></div>
                <div class="flex flex-col items-center gap-2 relative z-10 w-24">
                     <div class="w-8 h-8 rounded-full bg-gray-200 dark:bg-slate-700 text-gray-500 dark:text-gray-400 flex items-center justify-center font-bold text-sm ring-4 ring-white dark:ring-slate-900 transition-all step-indicator" data-step="3">3</div>
                    <span class="text-xs font-bold text-gray-500 dark:text-gray-400">Scope</span>
                </div>
                 <div class="flex-1 h-0.5 bg-gray-200 dark:bg-gray-700 -mx-4 relative top-[-10px]"></div>
                <div class="flex flex-col items-center gap-2 relative z-10 w-24">
                     <div class="w-8 h-8 rounded-full bg-gray-200 dark:bg-slate-700 text-gray-500 dark:text-gray-400 flex items-center justify-center font-bold text-sm ring-4 ring-white dark:ring-slate-900 transition-all step-indicator" data-step="4">4</div>
                    <span class="text-xs font-bold text-gray-500 dark:text-gray-400">Rules</span>
                </div>
                 <div class="flex-1 h-0.5 bg-gray-200 dark:bg-gray-700 -mx-4 relative top-[-10px]"></div>
                <div class="flex flex-col items-center gap-2 relative z-10 w-24">
                     <div class="w-8 h-8 rounded-full bg-gray-200 dark:bg-slate-700 text-gray-500 dark:text-gray-400 flex items-center justify-center font-bold text-sm ring-4 ring-white dark:ring-slate-900 transition-all step-indicator" data-step="5">5</div>
                    <span class="text-xs font-bold text-gray-500 dark:text-gray-400">Confirm</span>
                </div>
            </div>

            <!-- Wizard Content -->
            <form id="clone-form" class="glass-panel p-6 md:p-8 rounded-2xl min-h-[400px] flex flex-col relative">
                
                <!-- Step 1: Source -->
                <div class="wizard-step flex-1 space-y-6" data-step="1">
                    <h2 class="text-xl font-bold text-gray-800 dark:text-white">Select Source Store</h2>
                    <p class="text-gray-500 dark:text-gray-400 text-sm">Choose the store you want to copy information FROM.</p>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <?php foreach ($stores as $store): ?>
                        <label class="cursor-pointer group">
                            <input type="radio" name="source_store" value="<?php echo $store['id']; ?>" class="peer sr-only">
                            <div class="p-4 rounded-xl border-2 border-gray-200 dark:border-gray-700 hover:border-primary/50 dark:hover:border-primary/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-full bg-gray-100 dark:bg-slate-700 flex items-center justify-center text-gray-500 dark:text-gray-300 peer-checked:bg-primary peer-checked:text-white transition-colors">
                                        <ion-icon name="storefront" class="text-lg"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800 dark:text-white"><?php echo $store['name']; ?></div>
                                        <div class="text-xs text-gray-500"><?php echo $store['type']; ?></div>
                                    </div>
                                    <div class="ml-auto opacity-0 peer-checked:opacity-100 text-primary text-xl">
                                        <ion-icon name="checkmark-circle"></ion-icon>
                                    </div>
                                </div>
                            </div>
                        </label>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Step 2: Target -->
                <div class="wizard-step flex-1 space-y-6 hidden bg-opacity-0 transition-opacity duration-300" data-step="2">
                    <h2 class="text-xl font-bold text-gray-800 dark:text-white">Select Target Store(s)</h2>
                    <p class="text-gray-500 dark:text-gray-400 text-sm">Choose one or more stores to apply these changes TO.</p>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <?php foreach ($stores as $store): ?>
                        <label class="cursor-pointer group store-option" data-id="<?php echo $store['id']; ?>">
                            <input type="checkbox" name="target_store[]" value="<?php echo $store['id']; ?>" class="peer sr-only">
                            <div class="p-4 rounded-xl border-2 border-gray-200 dark:border-gray-700 hover:border-primary/50 dark:hover:border-primary/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-full bg-gray-100 dark:bg-slate-700 flex items-center justify-center text-gray-500 dark:text-gray-300 peer-checked:bg-primary peer-checked:text-white transition-colors">
                                        <ion-icon name="arrow-down-circle-outline" class="text-lg"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800 dark:text-white"><?php echo $store['name']; ?></div>
                                        <div class="text-xs text-gray-500"><?php echo $store['type']; ?></div>
                                    </div>
                                    <div class="ml-auto opacity-0 peer-checked:opacity-100 text-primary text-xl">
                                        <ion-icon name="checkmark-circle"></ion-icon>
                                    </div>
                                </div>
                            </div>
                        </label>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Step 3: Scope -->
                <div class="wizard-step flex-1 space-y-6 hidden transition-opacity duration-300" data-step="3">
                    <h2 class="text-xl font-bold text-gray-800 dark:text-white">What to Clone?</h2>
                    <p class="text-gray-500 dark:text-gray-400 text-sm">Select the data modules you wish to copy.</p>
                    
                    <div class="space-y-3">
                        <label class="flex items-center gap-4 p-4 rounded-xl border border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-slate-800 cursor-pointer transition-colors">
                            <input type="checkbox" name="scope[]" value="config" class="w-5 h-5 rounded border-gray-300 text-primary focus:ring-primary">
                            <div class="flex-1">
                                <div class="font-bold text-gray-800 dark:text-white">Store Configuration</div>
                                <div class="text-xs text-gray-500">Tax rates, receipt templates, currency, timezone settings</div>
                            </div>
                        </label>
                        
                        <label class="flex items-center gap-4 p-4 rounded-xl border border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-slate-800 cursor-pointer transition-colors">
                            <input type="checkbox" name="scope[]" value="products" class="w-5 h-5 rounded border-gray-300 text-primary focus:ring-primary" checked>
                            <div class="flex-1">
                                <div class="font-bold text-gray-800 dark:text-white">Products & Inventory</div>
                                <div class="text-xs text-gray-500">Master products, store pricing, stock thresholds, categories</div>
                            </div>
                        </label>
                        
                        <label class="flex items-center gap-4 p-4 rounded-xl border border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-slate-800 cursor-pointer transition-colors">
                            <input type="checkbox" name="scope[]" value="restaurant" class="w-5 h-5 rounded border-gray-300 text-primary focus:ring-primary">
                            <div class="flex-1">
                                <div class="font-bold text-gray-800 dark:text-white">Restaurant Data</div>
                                <div class="text-xs text-gray-500">Menu categories, items, modifiers, floor plans, reservation rules</div>
                            </div>
                        </label>

                         <label class="flex items-center gap-4 p-4 rounded-xl border border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-slate-800 cursor-pointer transition-colors">
                            <input type="checkbox" name="scope[]" value="procurement" class="w-5 h-5 rounded border-gray-300 text-primary focus:ring-primary">
                            <div class="flex-1">
                                <div class="font-bold text-gray-800 dark:text-white">Procurement</div>
                                <div class="text-xs text-gray-500">Suppliers list, payment terms</div>
                            </div>
                        </label>
                    </div>
                </div>

                <!-- Step 4: Conflict Rules -->
                 <div class="wizard-step flex-1 space-y-6 hidden transition-opacity duration-300" data-step="4">
                    <h2 class="text-xl font-bold text-gray-800 dark:text-white">Conflict Resolution</h2>
                    <p class="text-gray-500 dark:text-gray-400 text-sm">How should we handle data that already exists in the target stores?</p>
                    
                    <div class="space-y-4">
                        <label class="cursor-pointer group block">
                            <input type="radio" name="conflict" value="skip" class="peer sr-only" checked>
                            <div class="p-4 rounded-xl border border-gray-200 dark:border-gray-700 hover:border-primary peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="w-5 h-5 rounded-full border-2 border-gray-300 flex items-center justify-center peer-checked:border-primary peer-checked:bg-primary">
                                        <div class="w-2.5 h-2.5 rounded-full bg-white opacity-0 peer-checked:opacity-100"></div>
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800 dark:text-white">Skip Duplicates (Safe)</div>
                                        <div class="text-xs text-gray-500">If a record exists (e.g. same SKU), do not touch it. Only add new data.</div>
                                    </div>
                                </div>
                            </div>
                        </label>

                        <label class="cursor-pointer group block">
                            <input type="radio" name="conflict" value="merge" class="peer sr-only">
                            <div class="p-4 rounded-xl border border-gray-200 dark:border-gray-700 hover:border-primary peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="w-5 h-5 rounded-full border-2 border-gray-300 flex items-center justify-center peer-checked:border-primary peer-checked:bg-primary">
                                        <div class="w-2.5 h-2.5 rounded-full bg-white opacity-0 peer-checked:opacity-100"></div>
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800 dark:text-white">Merge / Update Empty Fields</div>
                                        <div class="text-xs text-gray-500">If a record exists, only update fields that are currently empty.</div>
                                    </div>
                                </div>
                            </div>
                        </label>

                         <label class="cursor-pointer group block">
                            <input type="radio" name="conflict" value="overwrite" class="peer sr-only">
                            <div class="p-4 rounded-xl border-2 border-red-100 dark:border-red-900/30 hover:border-red-500 peer-checked:border-red-600 peer-checked:bg-red-50 dark:peer-checked:bg-red-900/10 transition-all">
                                <div class="flex items-center gap-3">
                                    <div class="w-5 h-5 rounded-full border-2 border-gray-300 flex items-center justify-center peer-checked:border-red-600 peer-checked:bg-red-600">
                                        <div class="w-2.5 h-2.5 rounded-full bg-white opacity-0 peer-checked:opacity-100"></div>
                                    </div>
                                    <div>
                                        <div class="font-bold text-red-700 dark:text-red-400">Overwrite (Destructive)</div>
                                        <div class="text-xs text-red-600/70 dark:text-red-400/70">Forcefully update target data to match source. This cannot be undone.</div>
                                    </div>
                                </div>
                            </div>
                        </label>
                    </div>
                </div>

                <!-- Step 5: Confirm -->
                 <div class="wizard-step flex-1 space-y-6 hidden transition-opacity duration-300" data-step="5">
                    <div class="text-center space-y-2">
                        <div class="w-16 h-16 rounded-full bg-orange-100 dark:bg-orange-900/20 text-orange-600 flex items-center justify-center text-3xl mx-auto mb-4">
                            <ion-icon name="warning-outline"></ion-icon>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-800 dark:text-white">Ready to Clone?</h2>
                        <p class="text-gray-500 dark:text-gray-400 max-w-md mx-auto">Please review your choices. This action will modify data on the target stores.</p>
                    </div>

                    <div class="bg-gray-50 dark:bg-slate-800 p-4 rounded-xl text-sm space-y-2 max-w-lg mx-auto">
                        <div class="flex justify-between">
                            <span class="text-gray-500">Source:</span>
                            <span class="font-bold text-gray-800 dark:text-white" id="summary-source">-</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-500">Targets:</span>
                            <span class="font-bold text-gray-800 dark:text-white" id="summary-targets">-</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-500">Scope:</span>
                            <span class="font-bold text-gray-800 dark:text-white" id="summary-scope">-</span>
                        </div>
                         <div class="flex justify-between">
                            <span class="text-gray-500">Conflict Rule:</span>
                            <span class="font-bold text-gray-800 dark:text-white" id="summary-rule">-</span>
                        </div>
                    </div>

                    <div class="max-w-lg mx-auto">
                         <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Reason for Action <span class="text-red-500">*</span></label>
                         <textarea id="reason" class="w-full bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm h-24" placeholder="e.g. Rolling out new menu to Bristol branch..."></textarea>
                    </div>

                    <!-- Progress Bar (Hidden Initially) -->
                    <div id="execution-progress" class="hidden max-w-lg mx-auto space-y-2 pt-4">
                        <div class="flex justify-between text-xs font-bold text-gray-500">
                            <span>Processing...</span>
                            <span id="progress-percent">0%</span>
                        </div>
                        <div class="h-2 bg-gray-200 dark:bg-gray-700 rounded-full overflow-hidden">
                            <div class="h-full bg-green-500 w-0 transition-all duration-300" id="execution-bar"></div>
                        </div>
                    </div>
                </div>

                <!-- Footer Nav -->
                <div class="mt-8 flex justify-between pt-6 border-t border-gray-100 dark:border-gray-700">
                     <button type="button" id="prev-btn" class="px-6 py-2 bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300 rounded-xl text-sm font-bold hover:bg-gray-200 dark:hover:bg-slate-600 transition-colors hidden">
                        Back
                    </button>
                    <div class="ml-auto">
                        <button type="button" id="next-btn" class="px-8 py-2 bg-gray-900 dark:bg-primary text-white rounded-xl text-sm font-bold hover:opacity-90 transition-all shadow-lg shadow-gray-900/20">
                            Continue
                        </button>
                        <button type="button" id="finish-btn" class="px-8 py-2 bg-red-600 text-white rounded-xl text-sm font-bold hover:opacity-90 transition-all shadow-lg shadow-red-600/20 hidden">
                            Start Cloning
                        </button>
                    </div>
                </div>

            </form>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        let currentStep = 1;
        const totalSteps = 5;
        
        const nextBtn = document.getElementById('next-btn');
        const prevBtn = document.getElementById('prev-btn');
        const finishBtn = document.getElementById('finish-btn');
        const progressBar = document.getElementById('progress-bar');
        
        // Update View
        function showStep(step) {
            // Hide all steps
            document.querySelectorAll('.wizard-step').forEach(el => {
                el.classList.add('hidden');
            });
            // Show current
            const currentEl = document.querySelector(`.wizard-step[data-step="${step}"]`);
            currentEl.classList.remove('hidden');

            // Update Header Indicators
            document.querySelectorAll('.step-indicator').forEach(el => {
                const s = parseInt(el.getAttribute('data-step'));
                if (s <= step) {
                    el.classList.remove('bg-gray-200', 'dark:bg-slate-700', 'text-gray-500', 'dark:text-gray-400');
                    el.classList.add('bg-primary', 'text-white');
                } else {
                    el.classList.add('bg-gray-200', 'dark:bg-slate-700', 'text-gray-500', 'dark:text-gray-400');
                    el.classList.remove('bg-primary', 'text-white');
                }
            });

            // Update Top Progress Bar
            const percent = ((step - 1) / (totalSteps - 1)) * 100;
            progressBar.style.width = `${percent}%`;

            // Buttons
            if (step === 1) prevBtn.classList.add('hidden');
            else prevBtn.classList.remove('hidden');

            if (step === totalSteps) {
                nextBtn.classList.add('hidden');
                finishBtn.classList.remove('hidden');
                updateSummary();
            } else {
                nextBtn.classList.remove('hidden');
                finishBtn.classList.add('hidden');
            }
        }

        // Logic check before proceeding
        function validateStep(step) {
            if (step === 1) {
                const source = document.querySelector('input[name="source_store"]:checked');
                if (!source) {
                if(window.showToast) {
                    showToast('Please select a source store.', 'error');
                } else {
                    alert('Please select a source store.');
                }
                    return false;
                }
                // Disable source in target list
                document.querySelectorAll('input[name="target_store[]"]').forEach(box => {
                    const row = box.closest('.store-option');
                    if (box.value === source.value) {
                         box.disabled = true;
                         row.classList.add('opacity-50', 'pointer-events-none');
                         box.checked = false;
                    } else {
                         box.disabled = false;
                         row.classList.remove('opacity-50', 'pointer-events-none');
                    }
                });
            }
            if (step === 2) {
                const targets = document.querySelectorAll('input[name="target_store[]"]:checked');
                if (targets.length === 0) {
                if(window.showToast) {
                    showToast('Please select at least one target store.', 'error');
                } else {
                    alert('Please select at least one target store.');
                }
                    return false;
                }
            }
            return true;
        }

        function updateSummary() {
            // Source
            const source = document.querySelector('input[name="source_store"]:checked');
            if (source) {
                const name = source.closest('label').querySelector('.font-bold').innerText;
                document.getElementById('summary-source').innerText = name;
            }

            // Targets
            const targets = Array.from(document.querySelectorAll('input[name="target_store[]"]:checked')).map(cb => {
                 return cb.closest('label').querySelector('.font-bold').innerText;
            });
            document.getElementById('summary-targets').innerText = targets.join(', ');

            // Scope
            const scope = Array.from(document.querySelectorAll('input[name="scope[]"]:checked')).map(cb => {
                 return cb.nextElementSibling.querySelector('.font-bold').innerText;
            });
            document.getElementById('summary-scope').innerText = scope.join(', ');

            // Rule
            const rule = document.querySelector('input[name="conflict"]:checked');
            document.getElementById('summary-rule').innerText = rule ? rule.value.toUpperCase() : 'SKIP';
        }

        nextBtn.addEventListener('click', () => {
            if (validateStep(currentStep)) {
                currentStep++;
                showStep(currentStep);
            }
        });

        prevBtn.addEventListener('click', () => {
            currentStep--;
            showStep(currentStep);
        });

        finishBtn.addEventListener('click', () => {
            const reason = document.getElementById('reason').value.trim();
            if (!reason) {
                if(window.showToast) {
                    showToast('Please provide a reason for this operation.', 'error');
                } else {
                    alert('Please provide a reason for this operation.');
                }
                return;
            }

            // Mock Execution
            finishBtn.classList.add('opacity-50', 'pointer-events-none');
            finishBtn.innerHTML = '<ion-icon name="sync" class="animate-spin"></ion-icon> Processing...';
            document.getElementById('execution-progress').classList.remove('hidden');

            let p = 0;
            const interval = setInterval(() => {
                p += Math.floor(Math.random() * 10) + 5;
                if (p > 100) p = 100;
                
                document.getElementById('execution-bar').style.width = `${p}%`;
                document.getElementById('progress-percent').innerText = `${p}%`;

                if (p === 100) {
                    clearInterval(interval);
                    setTimeout(() => {
                        if(window.showToast) {
                            showToast('Cloning Complete! Data has been synchronized.', 'success');
                        } else {
                            alert('Cloning Complete! Data has been synchronized.');
                        }
                        
                        setTimeout(() => {
                            window.location.reload();
                        }, 2000);
                    }, 500);
                }
            }, 300);
        });

        // Initialize
        showStep(1);
    });
</script>
