<?php
include 'includes/session.php';
$pageTitle = "Suppliers Management";
$currentPage = "suppliers";
require_once 'includes/header.php';

// Mock Data (Expanded for better visual)
$suppliers = [
    [
        'id' => 1,
        'name' => 'Booker Wholesale',
        'contact' => 'New Customer Team',
        'phone' => '0800 123 4567',
        'email' => 'orders@booker.co.uk',
        'terms' => 'Net 30',
        'status' => 'Active',
        'updated_by' => 'John Doe'
    ],
    [
        'id' => 2,
        'name' => 'Coca Cola Direct',
        'contact' => 'Sarah Smith',
        'phone' => '020 7987 6543',
        'email' => 'sarah@coke-orders.com',
        'terms' => 'Net 14',
        'status' => 'Active',
        'updated_by' => 'Alice Smith'
    ],
    [
        'id' => 3,
        'name' => 'Local Farm Veg',
        'contact' => 'Dave',
        'phone' => '07700 900 123',
        'email' => 'dave@farm.com',
        'terms' => 'COD',
        'status' => 'Inactive',
        'updated_by' => 'System Admin'
    ],
    [
        'id' => 4,
        'name' => 'Bestway Wholesale',
        'contact' => 'Regional Manager',
        'phone' => '0845 123 7890',
        'email' => 'info@bestway.com',
        'terms' => 'Net 30',
        'status' => 'Active',
        'updated_by' => 'John Doe'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="supplierContent" class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-10 overflow-visible">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Suppliers List</h1>
                    <p class="text-gray-500 dark:text-gray-400 mt-1">Manage vendor details, contact info, and payment terms.</p>
                </div>
                
                <div class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto">
                    <div class="relative group w-full sm:w-64 shrink-0">
                        <div class="absolute inset-y-0 left-0 pl-3.5 flex items-center pointer-events-none">
                            <ion-icon name="search-outline" class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                        </div>
                        <input type="text" class="w-full bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg pl-10 pr-4 py-2 text-sm focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all outline-none" placeholder="Search suppliers...">
                    </div>
                    
                    <div class="h-8 w-px bg-gray-200 dark:bg-gray-700 mx-1 hidden sm:block"></div>
                    
                    <div class="flex items-center gap-2">
                        <button class="p-2 text-gray-500 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-all" title="Filter Options">
                            <ion-icon name="filter-outline" class="text-xl"></ion-icon>
                        </button>
                        <button class="p-2 text-gray-500 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-all" title="Export List">
                            <ion-icon name="download-outline" class="text-xl"></ion-icon>
                        </button>
                    </div>

                    <a href="supplier_form.php" class="ml-2 px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-lg text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center gap-2 whitespace-nowrap">
                        <ion-icon name="add-circle-outline" class="text-xl"></ion-icon>
                        <span>Add Supplier</span>
                    </a>
                </div>
            </div>

            <!-- Suppliers Table -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm border border-gray-100 dark:border-gray-700/50">
                <div class="overflow-x-auto overflow-visible">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Supplier Details</th>
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Contact Info</th>
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Payment Terms</th>
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Status</th>
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Updated By</th>
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700/50">
                            <?php foreach ($suppliers as $sup): ?>
                            <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/30 transition-all">
                                <td class="py-5 px-6">
                                    <div class="flex items-center gap-4">
                                        <div class="w-10 h-10 rounded-xl bg-primary/10 flex items-center justify-center text-primary font-bold shadow-sm">
                                            <?php echo strtoupper(substr($sup['name'], 0, 1)); ?>
                                        </div>
                                        <div>
                                            <div class="text-sm font-bold text-gray-800 dark:text-white group-hover:text-primary transition-colors"><?php echo $sup['name']; ?></div>
                                            <div class="text-[11px] font-medium text-gray-400 uppercase tracking-wider mt-0.5">Contact: <?php echo $sup['contact']; ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-5 px-6 font-medium">
                                    <div class="flex flex-col gap-1.5">
                                        <div class="flex items-center gap-2 text-xs text-gray-600 dark:text-gray-300">
                                            <div class="w-6 h-6 rounded-lg bg-blue-50 dark:bg-blue-900/20 flex items-center justify-center text-blue-500">
                                                <ion-icon name="call-outline"></ion-icon>
                                            </div>
                                            <span><?php echo $sup['phone']; ?></span>
                                        </div>
                                        <div class="flex items-center gap-2 text-xs text-gray-600 dark:text-gray-300">
                                            <div class="w-6 h-6 rounded-lg bg-purple-50 dark:bg-purple-900/20 flex items-center justify-center text-purple-500">
                                                <ion-icon name="mail-outline"></ion-icon>
                                            </div>
                                            <span><?php echo $sup['email']; ?></span>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-5 px-6 text-center">
                                    <span class="inline-flex items-center px-3 py-1 rounded-full bg-gray-100 dark:bg-slate-700 text-[11px] font-bold text-gray-600 dark:text-gray-300 border border-gray-200 dark:border-gray-600 shadow-sm">
                                        <ion-icon name="card-outline" class="mr-1.5 text-sm"></ion-icon>
                                        <?php echo strtoupper($sup['terms']); ?>
                                    </span>
                                </td>
                                <td class="py-5 px-6 text-center">
                                    <?php if ($sup['status'] === 'Active'): ?>
                                        <span class="inline-flex items-center px-2.5 py-1 rounded-lg bg-emerald-50 dark:bg-emerald-900/20 text-[11px] font-bold text-emerald-600 dark:text-emerald-400 border border-emerald-100 dark:border-emerald-800/50">
                                            <span class="w-1.5 h-1.5 rounded-full bg-emerald-500 mr-2 animate-pulse"></span>
                                            ACTIVE
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-2.5 py-1 rounded-lg bg-gray-50 dark:bg-gray-800/50 text-[11px] font-bold text-gray-400 dark:text-gray-500 border border-gray-100 dark:border-gray-700/50">
                                            <span class="w-1.5 h-1.5 rounded-full bg-gray-300 dark:bg-gray-600 mr-2"></span>
                                            INACTIVE
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td class="py-5 px-6 text-sm font-medium text-gray-600 dark:text-gray-400">
                                    <div class="flex items-center gap-2">
                                        <div class="w-7 h-7 rounded-lg bg-gray-100 dark:bg-slate-700 flex items-center justify-center text-[10px] fold-bold">
                                            <?php 
                                                $parts = explode(' ', $sup['updated_by']);
                                                echo strtoupper(substr($parts[0], 0, 1) . (isset($parts[1]) ? substr($parts[1], 0, 1) : ''));
                                            ?>
                                        </div>
                                        <span><?php echo $sup['updated_by']; ?></span>
                                    </div>
                                </td>
                                <td class="py-5 px-6 text-right">
                                    <div class="flex items-center justify-end gap-2 opacity-0 group-hover:opacity-100 transition-all transform translate-x-2 group-hover:translate-x-0">
                                        <a href="supplier_form.php?id=<?php echo $sup['id']; ?>" class="p-2 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-500 hover:text-primary hover:border-primary/30 rounded-xl shadow-sm transition-all" title="Edit Supplier">
                                            <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                        </a>
                                        <button class="p-2 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-500 hover:text-red-500 hover:border-red-500/30 rounded-xl shadow-sm transition-all cursor-pointer" title="Delete">
                                            <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination Footer -->
                <div class="p-6 bg-gray-50/50 dark:bg-slate-800/50 border-t border-gray-100 dark:border-gray-700/50 flex flex-col sm:flex-row items-center justify-between gap-4">
                    <p class="text-xs font-bold text-gray-500 uppercase tracking-widest">Showing 1 to 4 of 24 Suppliers</p>
                    <div class="flex gap-2">
                        <button class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl text-xs font-bold text-gray-600 dark:text-gray-400 hover:border-primary hover:text-primary transition-all disabled:opacity-50 disabled:hover:border-gray-200" disabled>Previous</button>
                        <div class="flex gap-1">
                            <button class="w-9 h-9 flex items-center justify-center rounded-xl bg-primary text-white text-xs font-bold shadow-lg shadow-orange-500/30">1</button>
                            <button class="w-9 h-9 flex items-center justify-center rounded-xl bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-xs font-bold text-gray-600 dark:text-gray-400 hover:border-primary hover:text-primary transition-all">2</button>
                        </div>
                        <button class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl text-xs font-bold text-gray-600 dark:text-gray-400 hover:border-primary hover:text-primary transition-all">Next</button>
                    </div>
                </div>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

