<?php
include 'includes/session.php';
// supplier_form.php - Create/Edit Supplier
$supId = $_GET['id'] ?? null;
$mode = $supId ? 'edit' : 'create';
$pageTitle = $mode === 'edit' ? "Edit Supplier" : "Create Supplier";
$currentPage = "suppliers";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Custom Select Helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            <div class="p-1 space-y-0.5 custom-select-options">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="supplierFormContent" class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Glass Panel) -->
            <div class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                <div class="flex items-center gap-4">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">
                            <?php echo $pageTitle; ?>
                        </h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Configure company details and payment terms.</p>
                    </div>
                </div>
                <!-- Actions -->
                <div class="flex items-center gap-3">
                    <button type="submit" form="supplierForm" class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save Supplier</span>
                    </button>
                </div>
            </div>

            <!-- Main Panel -->
            <div class="glass-panel rounded-2xl animate-fade-in-up p-8 overflow-visible">
                <form id="supplierForm" class="space-y-10" method="POST">
                    
                    <div class="grid grid-cols-1 lg:grid-cols-12 gap-10 items-start">
                        
                        <!-- Left Column (Core Info) - Spans 8 cols -->
                        <div class="lg:col-span-8 space-y-8">
                            
                            <!-- Company Info Section -->
                            <div class="space-y-6">
                                <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest flex items-center gap-2">
                                    <span class="w-8 h-px bg-gray-200 dark:bg-gray-700"></span>
                                    Company Information
                                </h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div class="space-y-2">
                                        <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Supplier Name <span class="text-red-500">*</span></label>
                                        <input type="text" name="name" class="<?php echo $inputClass; ?>" placeholder="e.g. Booker Wholesale" required>
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-bold text-gray-700 dark:text-gray-300">VAT / Tax ID</label>
                                        <input type="text" name="tax_id" class="<?php echo $inputClass; ?>" placeholder="Enter VAT Number">
                                    </div>
                                    <div class="space-y-2 md:col-span-2">
                                        <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Website</label>
                                        <div class="relative">
                                            <span class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-gray-400">
                                                <ion-icon name="globe-outline"></ion-icon>
                                            </span>
                                            <input type="url" name="website" class="<?php echo $inputClass; ?> pl-11" placeholder="https://www.example.com">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Contact Person Section -->
                            <div class="space-y-6">
                                <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest flex items-center gap-2">
                                    <span class="w-8 h-px bg-gray-200 dark:bg-gray-700"></span>
                                    Contact Details
                                </h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div class="space-y-2">
                                        <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Contact Name <span class="text-red-500">*</span></label>
                                        <input type="text" name="contact_name" class="<?php echo $inputClass; ?>" placeholder="e.g. Sarah Smith" required>
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Contact Phone <span class="text-red-500">*</span></label>
                                        <input type="tel" name="phone" class="<?php echo $inputClass; ?>" placeholder="e.g. +44 20 7946 0000" required>
                                    </div>
                                    <div class="space-y-2 md:col-span-2">
                                        <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Contact Email <span class="text-red-500">*</span></label>
                                        <input type="email" name="email" class="<?php echo $inputClass; ?>" placeholder="e.g. orders@supplier.com" required>
                                    </div>
                                </div>
                            </div>

                            <!-- Address Section -->
                            <div class="space-y-6">
                                <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest flex items-center gap-2">
                                    <span class="w-8 h-px bg-gray-200 dark:bg-gray-700"></span>
                                    Office Address
                                </h3>
                                <div class="grid grid-cols-1 md:grid-cols-12 gap-6">
                                    <div class="space-y-2 md:col-span-12">
                                        <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Address Line 1</label>
                                        <input type="text" name="address_1" class="<?php echo $inputClass; ?>" placeholder="Street address or P.O. box">
                                    </div>
                                    <div class="space-y-2 md:col-span-6">
                                        <label class="text-sm font-bold text-gray-700 dark:text-gray-300">City / Town</label>
                                        <input type="text" name="city" class="<?php echo $inputClass; ?>" placeholder="e.g. London">
                                    </div>
                                    <div class="space-y-2 md:col-span-6">
                                        <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Postcode</label>
                                        <input type="text" name="postcode" class="<?php echo $inputClass; ?>" placeholder="e.g. SW1A 1AA">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Right Column (Status & Image) - Spans 4 cols -->
                        <div class="lg:col-span-4 space-y-10 flex flex-col">
                            
                            <!-- Status Toggle Card -->
                            <div class="bg-gray-50/50 dark:bg-slate-800/50 rounded-2xl p-6 border border-gray-100 dark:border-gray-700">
                                <label class="text-xs font-bold text-gray-400 uppercase tracking-widest mb-4 block">Supplier Status</label>
                                <div class="flex items-center justify-between p-4 bg-white dark:bg-slate-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-lg bg-emerald-50 dark:bg-emerald-900/20 flex items-center justify-center text-emerald-500">
                                            <ion-icon name="radio-button-on-outline" class="text-xl"></ion-icon>
                                        </div>
                                        <div>
                                            <div class="text-sm font-bold text-gray-700 dark:text-gray-200">Active Account</div>
                                            <div class="text-[11px] text-gray-500">Allow orders and adjustments</div>
                                        </div>
                                    </div>
                                    <label class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="active" class="sr-only peer" checked>
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-emerald-500"></div>
                                    </label>
                                </div>
                            </div>

                            <!-- Logo Upload -->
                            <div class="space-y-4">
                                <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Supplier Logo</label>
                                <div class="w-full aspect-square max-w-[240px] rounded-3xl bg-gray-50 dark:bg-slate-800 border-2 border-dashed border-gray-300 dark:border-gray-600 flex items-center justify-center relative overflow-hidden group hover:border-primary transition-colors cursor-pointer mx-auto" onclick="document.getElementById('supLogoInput').click()">
                                    <img id="supLogoPreview" class="w-full h-full object-cover hidden z-10 relative" alt="Supplier Logo">
                                    
                                    <button type="button" id="removeSupLogoBtn" class="absolute top-2 right-2 z-20 bg-white/90 dark:bg-black/50 text-red-500 hover:text-red-600 rounded-full p-1.5 shadow-sm hidden opacity-0 group-hover:opacity-100 transition-all hover:bg-white" onclick="event.stopPropagation(); removeSupLogo(event);">
                                        <ion-icon name="close-circle" class="text-2xl"></ion-icon>
                                    </button>

                                    <div class="absolute inset-0 flex flex-col items-center justify-center text-gray-400 group-hover:text-primary transition-colors z-0" id="supLogoPlaceholder">
                                        <div class="w-16 h-16 rounded-2xl bg-white dark:bg-slate-700 shadow-sm flex items-center justify-center mb-3">
                                            <ion-icon name="cloud-upload-outline" class="text-3xl"></ion-icon>
                                        </div>
                                        <span class="text-xs font-bold uppercase tracking-wider">Upload Logo</span>
                                        <span class="text-[10px] mt-1">PNG, JPG up to 5MB</span>
                                    </div>
                                    
                                    <div class="absolute inset-0 bg-black/40 hidden group-hover:flex items-center justify-center text-white text-xs font-bold opacity-0 group-hover:opacity-100 transition-opacity z-10" id="imageOverlay">
                                        Change Logo
                                    </div>
                                </div>
                                <input type="file" id="supLogoInput" name="supplier_logo" class="hidden" accept="image/png, image/jpeg">
                            </div>

                            <!-- Payment Terms -->
                            <div class="space-y-2">
                                <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Payment Terms <span class="text-red-500">*</span></label>
                                <?php 
                                    echo renderCustomSelect('Select Terms', 'payment_terms', [
                                        'cod' => 'Cash on Delivery (COD)',
                                        'net7' => 'Net 7 Days',
                                        'net14' => 'Net 14 Days',
                                        'net30' => 'Net 30 Days',
                                        'net60' => 'Net 60 Days'
                                    ], 'net30'); 
                                ?>
                            </div>

                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    // --- Custom Select Logic (Delegated) ---
    function closeAllSelects() {
        document.querySelectorAll('.custom-select-container').forEach(container => {
            const dropdown = container.querySelector('.custom-select-dropdown');
            const trigger = container.querySelector('.custom-select-trigger');
            if (dropdown && !dropdown.classList.contains('invisible')) {
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                if (chevron) chevron.classList.remove('rotate-180', 'text-primary');
            }
        });
    }

    document.addEventListener('click', (e) => {
        const trigger = e.target.closest('.custom-select-trigger');
        if (trigger) {
            e.stopPropagation();
            const container = trigger.closest('.custom-select-container');
            const dropdown = container.querySelector('.custom-select-dropdown');
            if (dropdown) {
                const wasOpen = !dropdown.classList.contains('invisible');
                closeAllSelects();
                if (!wasOpen) {
                    dropdown.classList.remove('opacity-0', 'invisible', '-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron) chevron.classList.add('rotate-180', 'text-primary');
                }
            }
            return;
        }

        const option = e.target.closest('.custom-select-option');
        if (option) {
            e.stopPropagation();
            const container = option.closest('.custom-select-container');
            const hiddenInput = container.querySelector('input[type="hidden"]');
            const triggerLabel = container.querySelector('.select-label');
            hiddenInput.value = option.dataset.value;
            triggerLabel.textContent = option.dataset.label;
            container.querySelectorAll('.custom-select-option').forEach(opt => {
                opt.classList.remove('active');
                const check = opt.querySelector('.check-icon');
                if (check) check.classList.replace('opacity-100', 'opacity-0');
            });
            option.classList.add('active');
            const check = option.querySelector('.check-icon');
            if (check) check.classList.replace('opacity-0', 'opacity-100');
            closeAllSelects();
            return;
        }
        closeAllSelects();
    });

    // Image Upload Logic
    document.getElementById('supLogoInput').addEventListener('change', function(e) {
        if (this.files && this.files[0]) {
            const file = this.files[0];
            const validTypes = ['image/jpeg', 'image/png', 'image/jpg'];
            if (!validTypes.includes(file.type)) {
                if(window.showToast) showToast('Only JPG and PNG files are allowed.', 'error');
                else alert('Invalid file type');
                this.value = ''; 
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('supLogoPreview');
                const placeholder = document.getElementById('supLogoPlaceholder');
                const removeBtn = document.getElementById('removeSupLogoBtn');
                preview.src = e.target.result;
                preview.classList.remove('hidden');
                placeholder.classList.add('hidden');
                removeBtn.classList.remove('hidden');
            }
            reader.readAsDataURL(file);
        }
    });

    function removeSupLogo(e) {
        const preview = document.getElementById('supLogoPreview');
        const placeholder = document.getElementById('supLogoPlaceholder');
        const removeBtn = document.getElementById('removeSupLogoBtn');
        const input = document.getElementById('supLogoInput');
        preview.src = '';
        preview.classList.add('hidden');
        placeholder.classList.remove('hidden');
        removeBtn.classList.add('hidden');
        input.value = ''; 
    }

    // Form Submission
    document.getElementById('supplierForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const btn = this.querySelector('button[type="submit"]');
        const originalContent = btn.innerHTML;
        btn.disabled = true;
        btn.innerHTML = '<ion-icon name="sync-outline" class="animate-spin text-lg"></ion-icon> Saving...';
        
        setTimeout(() => {
            if(window.showToast) showToast('Supplier saved successfully!', 'success');
            else alert('Supplier saved successfully!');
            btn.disabled = false;
            btn.innerHTML = originalContent;
            setTimeout(() => { window.location.href = 'suppliers.php'; }, 1000);
        }, 1200);
    });
</script>
