<?php
include 'includes/session.php';
// stores.php - Stores Management List
$pageTitle = "Stores Management";
$currentPage = "stores";
require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        
        <!-- Header -->
        <div class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 animate-fade-in-down relative z-50 overflow-visible">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Stores</h1>
                <p class="text-gray-500 dark:text-gray-400 mt-1">Manage all your store locations and configurations.</p>
            </div>
            
            <!-- Controls Bar -->
            <div class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                
                <!-- Search (Transparent) -->
                <div class="relative group w-full sm:w-48 shrink-0">
                    <ion-icon name="search-outline" class="absolute left-2 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                    <input type="text" id="storeSearch" class="pl-8 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium bg-transparent" placeholder="Search...">
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>
                
                <!-- Type Filter -->
                <div class="relative z-30" id="storeTypeFilter">
                    <button id="typeFilterBtn" class="flex items-center gap-2 px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 rounded-lg text-sm text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white transition-all border border-transparent hover:border-gray-200 dark:hover:border-gray-600 min-w-[120px] justify-between">
                        <div class="flex items-center gap-2">
                            <ion-icon name="filter-outline" class="text-gray-400 text-lg"></ion-icon>
                            <span id="currentTypeFilter" class="font-medium">All Types</span>
                        </div>
                        <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 h-3 w-3 transition-transform duration-300"></ion-icon>
                    </button>
                                <!-- Dropdown Menu -->
                                <div id="typeFilterDropdown" class="absolute top-full left-0 mt-2 w-48 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 invisible opacity-0 -translate-y-2 transition-all duration-200 z-50">
                                    <div class="p-1">
                                        <div class="type-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors active" data-value="all" data-label="All Types">
                                            <div class="flex items-center gap-2">
                                                <div class="w-1.5 h-1.5 rounded-full bg-gray-400 group-hover:bg-primary transition-colors"></div>
                                                All Types
                                            </div>
                                            <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-100"></ion-icon>
                                        </div>
                                        <div class="type-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors" data-value="restaurant" data-label="Restaurant">
                                            <div class="flex items-center gap-2">
                                                <ion-icon name="restaurant-outline" class="text-gray-400 group-hover:text-amber-500"></ion-icon>
                                                Restaurant
                                            </div>
                                            <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-0"></ion-icon>
                                        </div>
                                        <div class="type-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors" data-value="retail" data-label="Retail">
                                            <div class="flex items-center gap-2">
                                                <ion-icon name="shirt-outline" class="text-gray-400 group-hover:text-purple-500"></ion-icon>
                                                Retail
                                            </div>
                                            <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-0"></ion-icon>
                                        </div>
                                        <div class="type-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors" data-value="grocery" data-label="Grocery">
                                            <div class="flex items-center gap-2">
                                                <ion-icon name="basket-outline" class="text-gray-400 group-hover:text-emerald-500"></ion-icon>
                                                Grocery
                                            </div>
                                            <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-0"></ion-icon>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        <!-- Status Filter -->
                        <div class="relative z-20" id="storeStatusFilter">
                            <button id="statusFilterBtn" class="flex items-center gap-2 px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 rounded-lg text-sm text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white transition-all border border-transparent hover:border-gray-200 dark:hover:border-gray-600 min-w-[120px] justify-between">
                                <div class="flex items-center gap-2">
                                    <ion-icon name="ellipse-outline" class="text-gray-400 text-xs"></ion-icon>
                                    <span id="currentStatusFilter" class="font-medium">All Status</span>
                                </div>
                                <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 h-3 w-3 transition-transform duration-300"></ion-icon>
                            </button>
                            <!-- Dropdown Menu -->
                            <div id="statusFilterDropdown" class="absolute top-full left-0 mt-2 w-40 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50">
                                <div class="p-2 space-y-1">
                                    <button class="status-filter-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors text-left active" data-value="all" data-label="All Status">
                                        <span class="w-2 h-2 rounded-full border border-gray-400"></span>
                                        <span class="text-sm font-medium text-gray-700 dark:text-gray-200">All Status</span>
                                        <ion-icon name="checkmark-circle" class="ml-auto text-primary text-lg opacity-100 check-icon"></ion-icon>
                                    </button>
                                        <button class="status-filter-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors text-left" data-value="active" data-label="Active">
                                        <span class="w-2 h-2 rounded-full bg-green-500"></span>
                                        <span class="text-sm font-medium text-gray-700 dark:text-gray-200">Active</span>
                                        <ion-icon name="checkmark-circle" class="ml-auto text-primary text-lg opacity-0 check-icon"></ion-icon>
                                    </button>
                                    <button class="status-filter-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors text-left" data-value="inactive" data-label="Inactive">
                                        <span class="w-2 h-2 rounded-full bg-gray-400"></span>
                                        <span class="text-sm font-medium text-gray-700 dark:text-gray-200">Inactive</span>
                                        <ion-icon name="checkmark-circle" class="ml-auto text-primary text-lg opacity-0 check-icon"></ion-icon>
                                    </button>
                                </div>
                            </div>
                        </div>
        
                        <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                        <!-- Create Store (Secondary) -->
                        <a href="store_form.php" class="flex items-center gap-2 px-3 py-2 text-primary font-bold text-sm hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors shrink-0 whitespace-nowrap">
                            <ion-icon name="add-circle-outline" class="text-lg"></ion-icon>
                            <span>Create</span>
                        </a>

                        <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>
        
                        <!-- Export (Primary) -->
                        <button class="flex items-center gap-2 px-4 py-2 bg-primary hover:bg-orange-600 text-white text-sm font-bold rounded-lg shadow-lg shadow-orange-500/30 transition-all transform hover:-translate-y-0.5 shrink-0 ml-1">
                            <ion-icon name="download-outline"></ion-icon>
                            <span>Export</span>
                        </button>
                    </div>
        </div>

                <!-- Data Table -->
                <div class="glass-panel rounded-2xl overflow-hidden animate-fade-in-up delay-100 relative z-0">
                    <div class="overflow-x-auto">
                        <table class="w-full text-left border-collapse">
                            <thead>
                                <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                    <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Store Name</th>
                                    <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Type</th>
                                    <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Region</th>
                                    <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider text-center">Devices</th>
                                    <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider text-center">Sessions</th>
                                    <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Last Sync</th>
                                    <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Updated By</th>
                                    <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Updated At</th>
                                    <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider text-center">Status</th>
                                    <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider text-right">Actions</th>
                                </tr>
                            </thead>
                            <tbody id="storesTableBody" class="divide-y divide-gray-100 dark:divide-gray-700">
                                <!-- Mock Row 1 -->
                                <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors" data-type="restaurant" data-status="active">
                                    <td class="p-4">
                                        <div class="flex items-center gap-3">
                                            <div class="w-10 h-10 rounded-lg bg-orange-100 dark:bg-orange-500/20 text-orange-600 dark:text-orange-400 flex items-center justify-center font-bold text-lg">
                                                C
                                            </div>
                                            <div>
                                                <div class="font-semibold text-gray-800 dark:text-white">Cardiff Central</div>
                                                <div class="text-xs text-gray-400">ID: #ST-1001</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full text-xs font-medium bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400 border border-blue-100 dark:border-blue-800/30">
                                            <ion-icon name="restaurant-outline"></ion-icon> Restaurant
                                        </span>
                                    </td>
                                    <td class="p-4">
                                        <div class="text-sm text-gray-700 dark:text-gray-300">Europe/London</div>
                                        <div class="text-xs text-gray-400">GBP (£)</div>
                                    </td>
                                    <td class="p-4 text-center">
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300">
                                            <span class="text-green-500 font-bold mr-1">3</span> / 4
                                        </span>
                                    </td>
                                    <td class="p-4 text-center">
                                        <div class="inline-flex -space-x-2 overflow-hidden">
                                            <img class="inline-block h-6 w-6 rounded-full ring-2 ring-white dark:ring-slate-800" src="https://ui-avatars.com/api/?name=John+Doe&background=random" alt=""/>
                                            <img class="inline-block h-6 w-6 rounded-full ring-2 ring-white dark:ring-slate-800" src="https://ui-avatars.com/api/?name=Jane+Smith&background=random" alt=""/>
                                            <span class="inline-flex items-center justify-center h-6 w-6 rounded-full ring-2 ring-white dark:ring-slate-800 bg-gray-100 dark:bg-slate-700 text-[10px] font-medium text-gray-500 dark:text-gray-400">+2</span>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <div class="text-xs text-gray-500 dark:text-gray-400">
                                            <div class="font-medium text-gray-700 dark:text-gray-300">Jan 15, 2026</div>
                                            <div>14:25 PM</div>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <div class="flex items-center gap-2">
                                            <div class="w-6 h-6 rounded-full bg-gray-100 dark:bg-slate-700 flex items-center justify-center text-xs font-bold text-gray-500">JD</div>
                                            <span class="text-sm text-gray-600 dark:text-gray-300">John Doe</span>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <div class="text-xs text-gray-500 dark:text-gray-400">
                                            <div class="font-medium text-gray-700 dark:text-gray-300">Jan 15, 2026</div>
                                            <div>14:30 PM</div>
                                        </div>
                                    </td>
                                    <td class="p-4 text-center">
                                        <span id="status-badge-1001" class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400 border border-green-200 dark:border-green-800">
                                            Active
                                        </span>
                                    </td>
                                    <td class="p-4 text-right">
                                        <div class="flex items-center justify-end gap-3">
                                            <!-- Status Toggle Button -->
                                            <button class="status-toggle-btn p-1.5 rounded-lg transition-colors text-emerald-600 bg-emerald-50 hover:bg-emerald-100 dark:text-emerald-400 dark:bg-emerald-900/20 border border-emerald-100 dark:border-emerald-800/30" 
                                                data-row-id="1001" 
                                                data-status="active"
                                                title="Deactivate Store">
                                                <ion-icon name="power" class="text-lg"></ion-icon>
                                            </button>

                                            <a href="store_form.php?id=1001" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit Store">
                                                <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                            </a>
                                            <button class="p-1.5 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-lg transition-colors" title="Delete Store">
                                                <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                            </button>
                                        </div>
                                    </td>
                                </tr>

                                <!-- Mock Row 2 -->
                                <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors" data-type="grocery" data-status="inactive">
                                    <td class="p-4">
                                        <div class="flex items-center gap-3">
                                            <div class="w-10 h-10 rounded-lg bg-emerald-100 dark:bg-emerald-500/20 text-emerald-600 dark:text-emerald-400 flex items-center justify-center font-bold text-lg">
                                                N
                                            </div>
                                            <div>
                                                <div class="font-semibold text-gray-800 dark:text-white">Newport Express</div>
                                                <div class="text-xs text-gray-400">ID: #ST-1002</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full text-xs font-medium bg-green-50 dark:bg-green-900/20 text-green-600 dark:text-green-400 border border-green-100 dark:border-green-800/30">
                                            <ion-icon name="basket-outline"></ion-icon> Grocery
                                        </span>
                                    </td>
                                    <td class="p-4">
                                        <div class="text-sm text-gray-700 dark:text-gray-300">Europe/London</div>
                                        <div class="text-xs text-gray-400">GBP (£)</div>
                                    </td>
                                    <td class="p-4 text-center">
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300">
                                            <span class="text-green-500 font-bold mr-1">1</span> / 1
                                        </span>
                                    </td>
                                    <td class="p-4 text-center">
                                        <div class="inline-flex -space-x-2 overflow-hidden">
                                            <img class="inline-block h-6 w-6 rounded-full ring-2 ring-white dark:ring-slate-800" src="https://ui-avatars.com/api/?name=Manager+One&background=random" alt=""/>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <div class="text-xs text-gray-500 dark:text-gray-400">
                                            <div class="font-medium text-gray-700 dark:text-gray-300">Jan 15, 2026</div>
                                            <div>11:00 AM</div>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <div class="flex items-center gap-2">
                                            <div class="w-6 h-6 rounded-full bg-gray-100 dark:bg-slate-700 flex items-center justify-center text-xs font-bold text-gray-500">AS</div>
                                            <span class="text-sm text-gray-600 dark:text-gray-300">Alice Smith</span>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <div class="text-xs text-gray-500 dark:text-gray-400">
                                            <div class="font-medium text-gray-700 dark:text-gray-300">Jan 15, 2026</div>
                                            <div>13:15 PM</div>
                                        </div>
                                    </td>
                                    <td class="p-4 text-center">
                                        <span id="status-badge-1002" class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-400 border border-red-200 dark:border-red-800">
                                            Inactive
                                        </span>
                                    </td>
                                    <td class="p-4 text-right">
                                        <div class="flex items-center justify-end gap-3">
                                            <!-- Status Toggle Button -->
                                            <button class="status-toggle-btn p-1.5 rounded-lg transition-colors text-red-600 bg-red-50 hover:bg-red-100 dark:text-red-400 dark:bg-red-900/20 border border-red-100 dark:border-red-800/30" 
                                                data-row-id="1002" 
                                                data-status="inactive"
                                                title="Activate Store">
                                                <ion-icon name="power" class="text-lg"></ion-icon>
                                            </button>

                                            <a href="store_form.php?id=1002" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit Store">
                                                <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                            </a>
                                            <button class="p-1.5 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-lg transition-colors" title="Delete Store">
                                                <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                            </button>
                                        </div>
                                    </td>
                                </tr>

                                 <!-- Mock Row 3 (Inactive) -->
                                 <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors" data-type="restaurant" data-status="inactive">
                                    <td class="p-4">
                                        <div class="flex items-center gap-3">
                                            <div class="w-10 h-10 rounded-lg bg-gray-100 dark:bg-slate-700 text-gray-500 dark:text-gray-400 flex items-center justify-center font-bold text-lg">
                                                B
                                            </div>
                                            <div>
                                                <div class="font-semibold text-gray-800 dark:text-white">Bristol Pop-up</div>
                                                <div class="text-xs text-gray-400">ID: #ST-1003</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full text-xs font-medium bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400 border border-blue-100 dark:border-blue-800/30">
                                            <ion-icon name="restaurant-outline"></ion-icon> Restaurant
                                        </span>
                                    </td>
                                    <td class="p-4">
                                        <div class="text-sm text-gray-700 dark:text-gray-300">Europe/London</div>
                                        <div class="text-xs text-gray-400">GBP (£)</div>
                                    </td>
                                    <td class="p-4 text-center">
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300">
                                            <span class="text-gray-400 font-bold mr-1">0</span> / 2
                                        </span>
                                    </td>
                                    <td class="p-4 text-center">
                                        <span class="text-xs text-gray-400">-</span>
                                    </td>
                                    <td class="p-4">
                                        <div class="text-xs text-gray-500 dark:text-gray-400">
                                            <div class="font-medium text-gray-700 dark:text-gray-300">Jan 11, 2026</div>
                                            <div>08:30 AM</div>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <div class="flex items-center gap-2">
                                            <div class="w-6 h-6 rounded-full bg-gray-100 dark:bg-slate-700 flex items-center justify-center text-xs font-bold text-gray-500">SY</div>
                                            <span class="text-sm text-gray-600 dark:text-gray-300">System Admin</span>
                                        </div>
                                    </td>
                                    <td class="p-4">
                                        <div class="text-xs text-gray-500 dark:text-gray-400">
                                            <div class="font-medium text-gray-700 dark:text-gray-300">Jan 12, 2026</div>
                                            <div>09:00 AM</div>
                                        </div>
                                    </td>
                                    <td class="p-4 text-center">
                                        <span id="status-badge-1003" class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-400 border border-red-200 dark:border-red-800">
                                            Inactive
                                        </span>
                                    </td>
                                    <td class="p-4 text-right">
                                        <div class="flex items-center justify-end gap-3">
                                            <!-- Status Toggle Button -->
                                            <button class="status-toggle-btn p-1.5 rounded-lg transition-colors text-red-600 bg-red-50 hover:bg-red-100 dark:text-red-400 dark:bg-red-900/20 border border-red-100 dark:border-red-800/30" 
                                                data-row-id="1003" 
                                                data-status="inactive"
                                                title="Activate Store">
                                                <ion-icon name="power" class="text-lg"></ion-icon>
                                            </button>

                                            <button class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit Store">
                                                <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                            </button>
                                            <button class="p-1.5 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-lg transition-colors" title="Delete Store">
                                                <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                            </button>
                                        </div>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination (Mock) -->
                    <div class="p-4 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between">
                        <span class="pagination-text text-xs text-gray-500 dark:text-gray-400 font-medium">Showing 0 of 0 stores</span>
                        <div class="flex gap-2">
                            <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center disabled:opacity-50 disabled:hover:bg-gray-50 disabled:hover:text-gray-500 cursor-pointer disabled:cursor-not-allowed group" disabled>
                                <ion-icon name="chevron-back-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                            </button>
                            <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center cursor-pointer group">
                                <ion-icon name="chevron-forward-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                            </button>
                        </div>
                    </div>
                </div>

        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script src="assets/js/stores.js?v=<?php echo time(); ?>"></script>
</body>
</html>
