<?php
include 'includes/session.php';
// store_health.php - Store Health Monitoring
$pageTitle = "Store Health";
$currentPage = "store_health";

// Permission Check (Mock)
// In a real app, this would be: if (!hasPermission('stores.health.view')) redirect...
// For now, we assume admin has access.

require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="storeHealthContent" class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header -->
            <div class="glass-panel rounded-2xl p-6 flex flex-col xl:flex-row justify-between items-center gap-6 animate-fade-in-down relative z-30 overflow-visible">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Store Health</h1>
                    <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Monitor device status, sync latency, and active sessions.</p>
                </div>
                
                <!-- Controls Bar -->
                <div class="flex flex-col sm:flex-row items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                    
                    <!-- Search & Filters -->
                    <div class="flex items-center gap-2 w-full sm:w-auto flex-1 flex-wrap">
                        
                        <!-- Search -->
                        <div class="relative group w-full sm:w-64 shrink-0">
                            <ion-icon name="search-outline" class="absolute left-3 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                            <input type="text" placeholder="Search..." class="pl-10 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium">
                        </div>
                        
                        <div class="h-8 w-px bg-gray-300 dark:bg-gray-600 mx-2 shrink-0"></div>
                        
                        <!-- Filter: Store -->
                        <div class="relative">
                            <button id="healthStoreFilterBtn" onclick="toggleHealthDropdown('healthStoreFilterDropdown', this)" class="flex items-center gap-2 px-3 py-2 text-sm font-medium text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-white dark:hover:bg-slate-700 rounded-lg transition-colors whitespace-nowrap">
                                <ion-icon name="storefront-outline" class="text-gray-400"></ion-icon>
                                <span id="healthStoreLabel">All Stores</span>
                                <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 ml-1 transition-transform duration-300"></ion-icon>
                            </button>
                            
                            <!-- Dropdown -->
                            <div id="healthStoreFilterDropdown" class="absolute top-full left-0 mt-2 w-64 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 z-50 p-2 space-y-1 opacity-0 invisible transform -translate-y-2 transition-all duration-200">
                                <button onclick="selectHealthStore('All Stores', this)" class="w-full flex items-center justify-between p-2 rounded-lg bg-gray-50 dark:bg-slate-700/50 text-gray-800 dark:text-gray-200 transition-colors active">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-orange-100 dark:bg-orange-500/20 flex items-center justify-center text-orange-600 dark:text-orange-400">
                                            <ion-icon name="storefront" class="text-lg"></ion-icon>
                                        </div>
                                        <span class="font-medium text-sm">All Stores</span>
                                    </div>
                                    <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-100"></ion-icon>
                                </button>
                                <button onclick="selectHealthStore('FNF Cardiff', this)" class="w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-blue-50 dark:bg-blue-900/20 flex items-center justify-center text-blue-600 dark:text-blue-400 text-xs font-bold">CDF</div>
                                        <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">FNF Cardiff</span>
                                    </div>
                                    <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                                </button>
                                <button onclick="selectHealthStore('FNF Swansea', this)" class="w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-emerald-50 dark:bg-emerald-900/20 flex items-center justify-center text-emerald-600 dark:text-emerald-400 text-xs font-bold">SWA</div>
                                        <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">FNF Swansea</span>
                                    </div>
                                    <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                                </button>
                            </div>
                        </div>

                        <!-- Filter: Status -->
                        <div class="relative">
                            <button id="healthStatusFilterBtn" onclick="toggleHealthDropdown('healthStatusFilterDropdown', this)" class="flex items-center gap-2 px-3 py-2 text-sm font-medium text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-white dark:hover:bg-slate-700 rounded-lg transition-colors whitespace-nowrap">
                                <ion-icon name="ellipse-outline" class="text-gray-400 text-xs"></ion-icon>
                                <span id="healthStatusLabel">All Status</span>
                                <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 ml-1 transition-transform duration-300"></ion-icon>
                            </button>

                            <!-- Dropdown -->
                            <div id="healthStatusFilterDropdown" class="absolute top-full left-0 mt-2 w-48 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 z-50 p-2 space-y-1 opacity-0 invisible transform -translate-y-2 transition-all duration-200">
                                <button onclick="selectHealthStatus('All Status', this)" class="w-full flex items-center justify-between p-2 rounded-lg bg-gray-50 dark:bg-slate-700/50 text-gray-800 dark:text-gray-200 transition-colors active">
                                    <div class="flex items-center gap-3">
                                        <ion-icon name="ellipse-outline" class="text-gray-400 text-xs"></ion-icon>
                                        <span class="font-medium text-sm">All Status</span>
                                    </div>
                                    <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-100"></ion-icon>
                                </button>
                                <button onclick="selectHealthStatus('Online', this)" class="w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group">
                                     <div class="flex items-center gap-3">
                                        <div class="w-2 h-2 rounded-full bg-emerald-500 shadow-sm shadow-emerald-500/50"></div>
                                        <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">Online</span>
                                    </div>
                                    <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                                </button>
                                <button onclick="selectHealthStatus('Offline', this)" class="w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group">
                                     <div class="flex items-center gap-3">
                                        <div class="w-2 h-2 rounded-full bg-gray-400"></div>
                                        <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">Offline</span>
                                    </div>
                                    <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                                </button>
                            </div>
                        </div>

                    </div>


                </div>
            </div>

            <!-- Widgets -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                
                <!-- Online/Offline Devices -->
                <div class="glass-panel p-6 rounded-2xl animate-fade-in-up" style="animation-delay: 0.1s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-blue-50 dark:bg-blue-900/20 rounded-xl text-blue-600 dark:text-blue-400">
                            <ion-icon name="hardware-chip-outline" class="text-xl"></ion-icon>
                        </div>
                        <span class="text-xs font-bold px-2 py-1 bg-green-100 dark:bg-green-900/30 text-green-600 dark:text-green-400 rounded-lg">95% Online</span>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400 font-medium">Device Status</p>
                        <div class="flex items-end gap-3 mt-1">
                            <h3 class="text-3xl font-bold text-gray-800 dark:text-white">42</h3>
                            <span class="text-sm mb-1 text-gray-400">Total</span>
                        </div>
                    </div>
                    <div class="mt-4 flex items-center gap-4 text-sm font-medium">
                        <div class="flex items-center gap-2">
                            <span class="w-2.5 h-2.5 rounded-full bg-green-500"></span>
                            <span class="text-gray-600 dark:text-gray-300">38 Online</span>
                        </div>
                        <div class="flex items-center gap-2">
                            <span class="w-2.5 h-2.5 rounded-full bg-gray-300 dark:bg-gray-600"></span>
                            <span class="text-gray-400">4 Offline</span>
                        </div>
                    </div>
                </div>

                <!-- Active Sessions -->
                <div class="glass-panel p-6 rounded-2xl animate-fade-in-up" style="animation-delay: 0.2s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-purple-50 dark:bg-purple-900/20 rounded-xl text-purple-600 dark:text-purple-400">
                            <ion-icon name="people-outline" class="text-xl"></ion-icon>
                        </div>
                        <span class="text-xs font-bold px-2 py-1 bg-purple-100 dark:bg-purple-900/30 text-purple-600 dark:text-purple-400 rounded-lg">Active Now</span>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400 font-medium">Active Sessions</p>
                        <div class="flex items-end gap-3 mt-1">
                            <h3 class="text-3xl font-bold text-gray-800 dark:text-white">35</h3>
                            <span class="text-sm mb-1 text-gray-400">Users</span>
                        </div>
                    </div>
                    <div class="mt-4 w-full bg-gray-100 dark:bg-gray-700 rounded-full h-1.5 overflow-hidden">
                        <div class="bg-purple-500 h-full rounded-full" style="width: 85%"></div>
                    </div>
                </div>

                <!-- Sync Health (Chart) -->
                <div class="glass-panel p-6 rounded-2xl animate-fade-in-up" style="animation-delay: 0.3s;">
                    <div class="flex items-start justify-between">
                        <div>
                            <p class="text-sm text-gray-500 dark:text-gray-400 font-medium">Avg Sync Latency</p>
                            <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-1">124<span class="text-sm font-normal text-gray-400 ml-1">ms</span></h3>
                        </div>
                        <div class="p-3 bg-emerald-50 dark:bg-emerald-900/20 rounded-xl text-emerald-600 dark:text-emerald-400">
                            <ion-icon name="pulse-outline" class="text-xl"></ion-icon>
                        </div>
                    </div>
                    <div id="syncHealthChart" class="mt-2" style="min-height: 60px;"></div>
                </div>

            </div>

            <!-- Device Table -->
            <div class="glass-panel rounded-2xl overflow-hidden animate-fade-in-up" style="animation-delay: 0.4s;">
                <div class="p-6 border-b border-gray-100 dark:border-gray-700">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white">Connected Devices</h3>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 text-xs uppercase tracking-wider font-semibold border-b border-gray-100 dark:border-gray-700">
                                <th class="p-4 pl-6">Device</th>
                                <th class="p-4">Status</th>
                                <th class="p-4">Last Heartbeat</th>
                                <th class="p-4">Last Sync</th>
                                <th class="p-4">App Ver</th>
                                <th class="p-4">Current User</th>
                                <th class="p-4">Session ID</th>
                                <th class="p-4 pr-6 text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-sm divide-y divide-gray-100 dark:divide-gray-700" id="healthTableBody">
                            <!-- Row 1: Healthy POS -->
                            <tr class="group hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors" data-store="FNF Cardiff" data-status="Online">
                                <td class="p-4 pl-6">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-xl bg-orange-100 dark:bg-orange-900/20 flex items-center justify-center text-orange-600 dark:text-orange-400">
                                            <ion-icon name="desktop-outline" class="text-xl"></ion-icon>
                                        </div>
                                        <div>
                                            <div class="font-bold text-gray-800 dark:text-white">Counter POS 1</div>
                                            <div class="text-xs text-gray-500">FNF Cardiff</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="p-4">
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-lg text-xs font-semibold bg-green-100 text-green-700 dark:bg-green-900/30 dark:text-green-400 border border-green-200 dark:border-green-800/50">
                                        <span class="w-1.5 h-1.5 rounded-full bg-green-500 animate-pulse"></span>
                                        Online
                                    </span>
                                </td>
                                <td class="p-4 font-medium text-gray-600 dark:text-gray-300">Just now</td>
                                <td class="p-4 font-medium text-gray-600 dark:text-gray-300">2s ago</td>
                                <td class="p-4 text-gray-500">v2.4.1</td>
                                <td class="p-4">
                                    <div class="flex items-center gap-2">
                                        <div class="w-6 h-6 rounded-full bg-gray-200 dark:bg-slate-600 flex items-center justify-center text-xs font-bold text-gray-600 dark:text-gray-300">AS</div>
                                        <span class="text-gray-700 dark:text-gray-300 font-medium">Alex Smith</span>
                                    </div>
                                </td>
                                <td class="p-4 font-mono text-xs text-gray-500 bg-gray-50 dark:bg-slate-900 px-2 py-1 rounded border border-gray-100 dark:border-gray-700 w-fit">
                                    sess_8x92...k29
                                </td>
                                <td class="p-4 pr-6 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                        <button onclick="requestLogout(this)" class="p-2 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/20 rounded-lg transition-colors" title="Force Logout">
                                            <ion-icon name="log-out-outline" class="text-xl"></ion-icon>
                                        </button>
                                        <a href="store_devices.php" class="p-2 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-colors" title="View Details">
                                            <ion-icon name="open-outline" class="text-xl"></ion-icon>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            
                            <!-- Row 2: Offline POS -->
                             <tr class="group hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors" data-store="FNF Swansea" data-status="Offline">
                                <td class="p-4 pl-6">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-xl bg-gray-100 dark:bg-slate-700 flex items-center justify-center text-gray-500 dark:text-gray-400 grayscale">
                                            <ion-icon name="desktop-outline" class="text-xl"></ion-icon>
                                        </div>
                                        <div>
                                            <div class="font-bold text-gray-600 dark:text-gray-400">Kitchen Display</div>
                                            <div class="text-xs text-gray-500">FNF Swansea</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="p-4">
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-lg text-xs font-semibold bg-gray-100 text-gray-600 dark:bg-slate-700 dark:text-gray-400 border border-gray-200 dark:border-gray-600">
                                        <span class="w-1.5 h-1.5 rounded-full bg-gray-400"></span>
                                        Offline
                                    </span>
                                </td>
                                <td class="p-4 font-medium text-gray-500">2h ago</td>
                                <td class="p-4 font-medium text-gray-500">2h ago</td>
                                <td class="p-4 text-gray-500">v2.3.9</td>
                                <td class="p-4 text-gray-400 italic">--</td>
                                <td class="p-4 font-mono text-xs text-gray-400">--</td>
                                <td class="p-4 pr-6 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                         <a href="store_devices.php" class="p-2 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-colors" title="View Details">
                                            <ion-icon name="open-outline" class="text-xl"></ion-icon>
                                        </a>
                                    </div>
                                </td>
                            </tr>

                            <!-- Row 3: Warning High Latency -->
                             <tr class="group hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors" data-store="FNF Swansea" data-status="Online">
                                <td class="p-4 pl-6">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-xl bg-purple-100 dark:bg-purple-900/20 flex items-center justify-center text-purple-600 dark:text-purple-400">
                                            <ion-icon name="tablet-landscape-outline" class="text-xl"></ion-icon>
                                        </div>
                                        <div>
                                            <div class="font-bold text-gray-800 dark:text-white">Manager Tablet</div>
                                            <div class="text-xs text-gray-500">FNF Swansea</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="p-4">
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-lg text-xs font-semibold bg-amber-100 text-amber-700 dark:bg-amber-900/30 dark:text-amber-400 border border-amber-200 dark:border-amber-800/50">
                                        <span class="w-1.5 h-1.5 rounded-full bg-amber-500 animate-pulse"></span>
                                        Slow Sync
                                    </span>
                                </td>
                                <td class="p-4 font-medium text-gray-600 dark:text-gray-300">5s ago</td>
                                <td class="p-4 font-medium text-amber-600 dark:text-amber-400">45s ago</td>
                                <td class="p-4 text-gray-500">v2.4.0</td>
                                <td class="p-4">
                                     <div class="flex items-center gap-2">
                                        <div class="w-6 h-6 rounded-full bg-gray-200 dark:bg-slate-600 flex items-center justify-center text-xs font-bold text-gray-600 dark:text-gray-300">JD</div>
                                        <span class="text-gray-700 dark:text-gray-300 font-medium">John Doe</span>
                                    </div>
                                </td>
                                <td class="p-4 font-mono text-xs text-gray-500 bg-gray-50 dark:bg-slate-900 px-2 py-1 rounded border border-gray-100 dark:border-gray-700 w-fit">
                                    sess_9p21...m55
                                </td>
                                <td class="p-4 pr-6 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                        <button onclick="requestLogout(this)" class="p-2 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/20 rounded-lg transition-colors" title="Force Logout">
                                            <ion-icon name="log-out-outline" class="text-xl"></ion-icon>
                                        </button>
                                        <a href="store_devices.php" class="p-2 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-colors" title="View Details">
                                            <ion-icon name="open-outline" class="text-xl"></ion-icon>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination Footer -->
                <div class="p-4 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between">
                    <span class="pagination-text text-xs text-gray-500 dark:text-gray-400 font-medium">
                        Showing <span id="showingCount">3</span> of <span id="totalCount">3</span> stores
                    </span>
                    <div class="flex gap-2">
                        <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center disabled:opacity-50 disabled:hover:bg-gray-50 disabled:hover:text-gray-500 cursor-pointer disabled:cursor-not-allowed group">
                            <ion-icon name="chevron-back-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                        </button>
                        <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center cursor-pointer group">
                            <ion-icon name="chevron-forward-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                        </button>
                    </div>
                </div>
            </div>

        </div>
    </div>


    <!-- Force Logout Modal -->
    <div id="logoutModal" class="fixed inset-0 z-[100] hidden">
        <div class="absolute inset-0 bg-black/50 backdrop-blur-sm transition-opacity opacity-0" id="logoutModalOverlay"></div>
        <div class="absolute inset-0 flex items-center justify-center p-4">
            <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-xl w-full max-w-md transform scale-95 opacity-0 transition-all" id="logoutModalContent">
                <div class="p-6 border-b border-gray-100 dark:border-gray-700 flex justify-between items-center">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white">Force Logout Device</h3>
                    <button onclick="closeLogoutModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-200">
                        <ion-icon name="close-outline" class="text-2xl"></ion-icon>
                    </button>
                </div>
                
                <div class="p-6 space-y-4">
                    <div class="p-4 bg-amber-50 dark:bg-amber-900/10 rounded-xl border border-amber-100 dark:border-amber-900/30 flex gap-3">
                        <ion-icon name="warning-outline" class="text-amber-500 text-xl shrink-0 mt-0.5"></ion-icon>
                        <div>
                             <h4 class="text-sm font-bold text-amber-800 dark:text-amber-400">Warning</h4>
                             <p class="text-xs text-amber-700 dark:text-amber-500 mt-1">This will immediately terminate the active session. Any unsaved work on the device may be lost.</p>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Reason for Logout <span class="text-red-500">*</span></label>
                        <textarea id="logoutReason" rows="3" class="w-full bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 focus:ring-2 focus:ring-red-500/20 focus:border-red-500 outline-none transition-all resize-none" placeholder="e.g. Device lost/stolen, Security policy update..."></textarea>
                    </div>
                </div>

                <div class="p-6 pt-0 flex justify-end gap-3">
                    <button onclick="closeLogoutModal()" class="px-4 py-2 text-sm font-bold text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 hover:bg-gray-100 dark:hover:bg-slate-700 rounded-xl transition-colors">Cancel</button>
                    <button onclick="confirmLogout()" class="flex items-center gap-2 px-4 py-2 bg-red-500 hover:bg-red-600 text-white text-sm font-bold rounded-xl shadow-lg shadow-red-500/20 transition-all hover:-translate-y-0.5">
                        <ion-icon name="log-out-outline" class="text-lg"></ion-icon>
                        Force Logout
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>

    // --- Dropdown Logic (Store Health) ---
    // Initial Filter State
    document.addEventListener('DOMContentLoaded', () => {
        filterHealthTable(); // Initialize counts
    });

    function toggleHealthDropdown(id, btn) {
        const dropdown = document.getElementById(id);
        const all = ['healthStoreFilterDropdown', 'healthStatusFilterDropdown'];
        
        // Close others
        all.forEach(dId => {
            if (dId !== id) {
                const d = document.getElementById(dId);
                d.classList.add('invisible', 'opacity-0', '-translate-y-2');
                const otherBtnId = dId.replace('Dropdown', 'Btn');
                document.getElementById(otherBtnId)?.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180');
            }
        });

        const isHidden = dropdown.classList.contains('invisible');
        if (isHidden) {
            dropdown.classList.remove('invisible', 'opacity-0', '-translate-y-2');
            btn.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.add('rotate-180');
        } else {
            dropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
            btn.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180');
        }
    }

    function selectHealthStore(label, btn) {
        document.getElementById('healthStoreLabel').textContent = label;
        updateHealthActiveState('healthStoreFilterDropdown', label);
        
        // Close
        const dropdown = document.getElementById('healthStoreFilterDropdown');
        dropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
        document.getElementById('healthStoreFilterBtn').querySelector('ion-icon[name="chevron-down-outline"]').classList.remove('rotate-180');
        
        filterHealthTable();
    }

    function selectHealthStatus(label, btn) {
        document.getElementById('healthStatusLabel').textContent = label;
        updateHealthActiveState('healthStatusFilterDropdown', label);

        // Close
        const dropdown = document.getElementById('healthStatusFilterDropdown');
        dropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
        document.getElementById('healthStatusFilterBtn').querySelector('ion-icon[name="chevron-down-outline"]').classList.remove('rotate-180');
        
        filterHealthTable();
    }

    function updateHealthActiveState(dropdownId, label) {
         const options = document.querySelectorAll(`#${dropdownId} button`);
         options.forEach(b => {
             const check = b.querySelector('.check-icon');
             // Simplistic check logic based on text content since we don't have rigid values
             const bLabel = b.querySelector('.font-medium').textContent.trim();
             
             if (bLabel === label) {
                 b.classList.add('bg-gray-50', 'dark:bg-slate-700/50', 'active');
                 b.classList.remove('hover:bg-gray-50', 'dark:hover:bg-slate-700/50');
                 check.classList.remove('opacity-0');
                 check.classList.add('opacity-100');
             } else {
                 b.classList.remove('bg-gray-50', 'dark:bg-slate-700/50', 'active');
                 b.classList.add('hover:bg-gray-50', 'dark:hover:bg-slate-700/50');
                 check.classList.add('opacity-0');
                 check.classList.remove('opacity-100');
             }
         });
    }

    function filterHealthTable() {
        const storeLabel = document.getElementById('healthStoreLabel').textContent.trim();
        const statusLabel = document.getElementById('healthStatusLabel').textContent.trim();
        
        const rows = document.querySelectorAll('#healthTableBody tr');
        let visibleCount = 0;
        
        rows.forEach(row => {
            const rowStore = row.getAttribute('data-store');
            const rowStatus = row.getAttribute('data-status');
            
            const storeMatch = (storeLabel === 'All Stores') || (rowStore === storeLabel);
            const statusMatch = (statusLabel === 'All Status') || (rowStatus === statusLabel);
            
            if (storeMatch && statusMatch) {
                row.classList.remove('hidden');
                visibleCount++;
            } else {
                row.classList.add('hidden');
            }
        });
        
        document.getElementById('showingCount').textContent = visibleCount;
        document.getElementById('totalCount').textContent = rows.length;
    }

    // Close Dropdowns on Click Outside
    document.addEventListener('click', (e) => {
        if (!e.target.closest('#healthStoreFilterBtn') && !e.target.closest('#healthStoreFilterDropdown')) {
             const d = document.getElementById('healthStoreFilterDropdown');
             if(d && !d.classList.contains('invisible')) {
                 d.classList.add('invisible', 'opacity-0', '-translate-y-2');
                 document.getElementById('healthStoreFilterBtn').querySelector('ion-icon[name="chevron-down-outline"]').classList.remove('rotate-180');
             }
        }
        if (!e.target.closest('#healthStatusFilterBtn') && !e.target.closest('#healthStatusFilterDropdown')) {
             const d = document.getElementById('healthStatusFilterDropdown');
             if(d && !d.classList.contains('invisible')) {
                 d.classList.add('invisible', 'opacity-0', '-translate-y-2');
                 document.getElementById('healthStatusFilterBtn').querySelector('ion-icon[name="chevron-down-outline"]').classList.remove('rotate-180');
             }
        }
    });

    // --- ApexCharts: Sync Health Sparkline ---
    document.addEventListener('DOMContentLoaded', () => {
        const options = {
            series: [{
                name: 'Latency',
                data: [45, 52, 38, 24, 33, 26, 21, 20, 18, 22, 124] // Ended high for the "Avg" visual
            }],
            chart: {
                type: 'area',
                height: 80,
                sparkline: { enabled: true }
            },
            stroke: {
                curve: 'smooth',
                width: 2
            },
            fill: {
                type: 'gradient',
                gradient: {
                    shadeIntensity: 1,
                    opacityFrom: 0.4,
                    opacityTo: 0.05,
                    stops: [0, 100]
                }
            },
            colors: ['#10B981'], // Emerald-500
            tooltip: {
                theme: document.documentElement.classList.contains('dark') ? 'dark' : 'light',
                x: { show: false },
                y: {
                    formatter: function(val) { return val + " ms" }
                }
            }
        };

        const chart = new ApexCharts(document.querySelector("#syncHealthChart"), options);
        chart.render();
    });

    // --- Logout Modal Logic ---
    const modal = document.getElementById('logoutModal');
    const overlay = document.getElementById('logoutModalOverlay');
    const content = document.getElementById('logoutModalContent');

    function requestLogout(btn) {
        // In real app, we might get device ID from data attribute
        modal.classList.remove('hidden');
        
        // Blur Background
        const elementsToBlur = [
            document.querySelector('#sidebar'), // Assuming sidebar ID exists
            document.querySelector('#topbar'),   // Assuming topbar ID exists
            document.getElementById('storeHealthContent')
        ];
        elementsToBlur.forEach(el => el?.classList.add('transition-all', 'duration-300', 'blur-sm'));

        requestAnimationFrame(() => {
            overlay.classList.remove('opacity-0');
            content.classList.remove('opacity-0', 'scale-95');
            content.classList.add('scale-100');
        });
    }

    function closeLogoutModal() {
        overlay.classList.add('opacity-0');
        content.classList.remove('scale-100');
        content.classList.add('opacity-0', 'scale-95');
        
        // Remove Blur
        const elementsToBlur = [
            document.querySelector('#sidebar'),
            document.querySelector('#topbar'),
            document.getElementById('storeHealthContent')
        ];
        elementsToBlur.forEach(el => el?.classList.remove('blur-sm'));

        setTimeout(() => {
            modal.classList.add('hidden');
            document.getElementById('logoutReason').value = ''; // Reset input
        }, 200);
    }

    function confirmLogout() {
        const reason = document.getElementById('logoutReason').value.trim();
        if (!reason) {
            showToast('Please provide a reason for the forced logout.', 'warning');
            return;
        }

        // Mock API Call
        showToast(`Session terminated. Reason: ${reason}`, 'success');
        closeLogoutModal();
    }
</script>
