<?php
include 'includes/session.php';
// store_form.php - Create/Edit Store
$storeId = $_GET['id'] ?? null;
$mode = $storeId ? 'edit' : 'create';
$pageTitle = $mode === 'edit' ? "Edit Store" : "Create Store";
$currentPage = "stores";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";
$selectWrapper = "relative";
$selectClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 appearance-none cursor-pointer";
$chevron = '<div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-gray-400"><ion-icon name="chevron-down-outline" class="text-lg"></ion-icon></div>';

require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="storeFormContent" class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

                <!-- Header (Glass Panel) -->
                <div class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                    <div class="flex items-center gap-4">
                        <div>
                            <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight" id="pageHeaderTitle">
                                <?php echo $mode === 'edit' ? 'Store Create/Edit' : 'Create New Store'; ?>
                            </h1>
                            <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Configure your store settings, taxes, and receipts.</p>
                        </div>
                    </div>
                    <div class="flex items-center gap-3">
                        
                        <?php if($mode === 'edit'): ?>
                        <button type="button" class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-primary hover:border-primary/30 hover:bg-orange-50 dark:hover:bg-slate-700 rounded-xl text-sm font-semibold transition-all shadow-sm flex items-center gap-2" onclick="openCloneModal()">
                            <ion-icon name="copy-outline"></ion-icon>
                            <span>Clone Settings</span>
                        </button>
                        <?php endif; ?>

                        <button type="submit" form="storeForm" class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                            <ion-icon name="save-outline" class="text-lg"></ion-icon>
                            <span>Save Changes</span>
                        </button>
                    </div>
                </div>

                <!-- Main Form Card -->
                <div class="glass-panel rounded-2xl animate-fade-in-up">
                    
                    <!-- Tabs Header -->
                    <div class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 px-6 pt-4 rounded-t-2xl">
                        <div class="flex gap-6 overflow-x-auto custom-scrollbar" id="formTabs">
                            <button class="tab-btn active pb-4 px-2 text-sm font-semibold border-b-2 border-primary text-primary transition-colors whitespace-nowrap" data-target="tab-general">
                                General Info
                            </button>
                            <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-config">
                                Configuration
                            </button>
                            <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-tax">
                                Tax Settings
                            </button>
                             <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-receipt">
                                Receipt
                            </button>
                            <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-security">
                                Security
                            </button>
                            <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-reports">
                                Reports
                            </button>
                            <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-devices">
                                Devices
                            </button>
                        </div>
                    </div>

                    <!-- Form Content -->
                    <form id="storeForm" class="p-6 md:p-8" method="POST" enctype="multipart/form-data">
                        
                        <!-- TAB: General Info -->
                        <div id="tab-general" class="tab-content space-y-8">
                            
                            <!-- Store Details -->
                             <div class="space-y-4">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Store Details</h3>
                                
                                <!-- Store Logo/Image Upload -->
                                <div class="flex items-start gap-6">
                                    <div class="shrink-0">
                                        <div class="w-32 h-32 rounded-2xl bg-gray-50 dark:bg-slate-800 border-2 border-dashed border-gray-300 dark:border-gray-600 flex items-center justify-center relative overflow-hidden group hover:border-primary transition-colors cursor-pointer" onclick="document.getElementById('logoInput').click()">
                                            <img id="logoPreview" class="w-full h-full object-cover hidden z-10 relative" alt="Store Logo">
                                            
                                            <!-- Remove Button -->
                                            <button type="button" id="removeLogoBtn" class="absolute top-1 right-1 z-20 bg-white/90 dark:bg-black/50 text-red-500 hover:text-red-600 rounded-full p-1 shadow-sm hidden opacity-0 group-hover:opacity-100 transition-all hover:bg-white" onclick="event.stopPropagation(); removeLogo(event);">
                                                <ion-icon name="close-circle" class="text-xl"></ion-icon>
                                            </button>

                                            <div class="absolute inset-0 flex flex-col items-center justify-center text-gray-400 group-hover:text-primary transition-colors z-0" id="logoPlaceholder">
                                                <ion-icon name="image-outline" class="text-3xl mb-1"></ion-icon>
                                                <span class="text-xs font-medium">Upload</span>
                                            </div>
                                            <!-- Overlay -->
                                            <div class="absolute inset-0 bg-black/50 hidden group-hover:flex items-center justify-center text-white text-xs font-medium opacity-0 group-hover:opacity-100 transition-opacity z-10" id="logoOverlay">
                                                Change
                                            </div>
                                        </div>
                                        <input type="file" id="logoInput" name="store_logo" class="hidden" accept="image/png, image/jpeg, image/gif, image/svg+xml">
                                        <div class="text-center mt-2">
                                            <p class="text-xs text-gray-500 dark:text-gray-400">Main Logo <span class="text-red-500">*</span></p>
                                            <p class="text-[10px] text-gray-400">JPG, PNG, GIF, SVG</p>
                                        </div>
                                    </div>
                                    
                                    <div class="flex-1 space-y-4">
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                            <div class="space-y-2">
                                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Store Name <span class="text-red-500">*</span></label>
                                                <input type="text" class="<?php echo $inputClass; ?>" placeholder="e.g. Cardiff Central" required>
                                            </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Currency Code <span class="text-red-500">*</span></label>
                                        <?php 
                                            echo renderCustomSelect('Select Currency', 'currency_code', [
                                                'GBP' => 'GBP (£) - British Pound', 
                                                'USD' => 'USD ($) - US Dollar', 
                                                'EUR' => 'EUR (€) - Euro'
                                            ], 'GBP'); 
                                        ?>
                                    </div>
                                        </div>

                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                                    <div class="space-y-4">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Store Type <span class="text-red-500">*</span></label>
                                        <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                                            <label class="cursor-pointer relative">
                                                <input type="radio" name="store_type" value="restaurant" class="peer sr-only" checked>
                                                <div class="p-4 rounded-xl border-2 border-gray-200 dark:border-gray-700 hover:border-primary/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all text-center flex flex-col items-center justify-center gap-2 h-full">
                                                    <ion-icon name="restaurant-outline" class="text-3xl text-gray-400 peer-checked:text-primary"></ion-icon>
                                                    <div class="font-medium text-gray-700 dark:text-white peer-checked:text-primary">Restaurant</div>
                                                </div>
                                            </label>
                                            <label class="cursor-pointer relative">
                                                <input type="radio" name="store_type" value="grocery" class="peer sr-only">
                                                <div class="p-4 rounded-xl border-2 border-gray-200 dark:border-gray-700 hover:border-primary/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all text-center flex flex-col items-center justify-center gap-2 h-full">
                                                    <ion-icon name="basket-outline" class="text-3xl text-gray-400 peer-checked:text-primary"></ion-icon>
                                                    <div class="font-medium text-gray-700 dark:text-white peer-checked:text-primary">Grocery</div>
                                                </div>
                                            </label>
                                            <label class="cursor-pointer relative">
                                                <input type="radio" name="store_type" value="pub" class="peer sr-only">
                                                <div class="p-4 rounded-xl border-2 border-gray-200 dark:border-gray-700 hover:border-primary/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all text-center flex flex-col items-center justify-center gap-2 h-full">
                                                    <ion-icon name="beer-outline" class="text-3xl text-gray-400 peer-checked:text-primary"></ion-icon>
                                                    <div class="font-medium text-gray-700 dark:text-white peer-checked:text-primary">Pub</div>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
                                        <div class="flex items-center gap-3 pt-2">
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="store_status" value="active" class="sr-only peer" checked>
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-green-500"></div>
                                                <span class="ml-3 text-sm font-medium text-gray-600 dark:text-gray-300 status-label">Active</span>
                                            </label>
                                        </div>
                                    </div>
                                
                                </div>
                                    </div>
                                </div>
                             </div>

                             <!-- Owner & Contact -->
                             <div class="space-y-4">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Owner & Contact</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                     <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Owner Mobile <span class="text-red-500">*</span></label>
                                        <div class="flex">
                                            <?php 
                                                echo renderCustomSelect('Code', 'owner_mobile_code', [
                                                    '+44' => '🇬🇧 +44', 
                                                    '+1' => '🇺🇸 +1', 
                                                    '+91' => '🇮🇳 +91', 
                                                    '+353' => '🇮🇪 +353'
                                                ], '+44', 'w-36 shrink-0', 'rounded-r-none border-r-0'); 
                                            ?>
                                            <input type="tel" class="<?php echo $inputClass; ?> rounded-l-none" placeholder="7000 000000">
                                        </div>
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Owner Email <span class="text-red-500">*</span></label>
                                        <input type="email" class="<?php echo $inputClass; ?>" placeholder="owner@store.com">
                                    </div>
                                </div>
                             </div>

                             <!-- Address -->
                             <div class="space-y-4">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Location</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div class="col-span-1 md:col-span-2 space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Address Line 1 <span class="text-red-500">*</span></label>
                                        <input type="text" class="<?php echo $inputClass; ?>" placeholder="Street name, Building number">
                                    </div>
                                    <div class="col-span-1 md:col-span-2 space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Address Line 2</label>
                                        <input type="text" class="<?php echo $inputClass; ?>" placeholder="Apartment, Suite, Unit, etc. (Optional)">
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">City / Town <span class="text-red-500">*</span></label>
                                        <input type="text" class="<?php echo $inputClass; ?>" placeholder="e.g. Cardiff">
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Postcode / Zip <span class="text-red-500">*</span></label>
                                        <input type="text" class="<?php echo $inputClass; ?>" placeholder="e.g. CF10 2BH">
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">County / State</label>
                                        <input type="text" class="<?php echo $inputClass; ?>" placeholder="e.g. South Glamorgan">
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Country <span class="text-red-500">*</span></label>
                                        <?php 
                                            echo renderCustomSelect('Select Country', 'country', [
                                                'United Kingdom' => 'United Kingdom', 
                                                'United States' => 'United States', 
                                                'Ireland' => 'Ireland', 
                                                'India' => 'India'
                                            ], 'United Kingdom'); 
                                        ?>
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Time Zone <span class="text-red-500">*</span></label>
                                        <?php 
                                            echo renderCustomSelect('Select Time Zone', 'timezone', [
                                                'Europe/London' => 'Europe/London', 
                                                'UTC' => 'UTC'
                                            ], 'Europe/London'); 
                                        ?>
                                    </div>
                                </div>
                             </div>
                        </div>

                        <!-- TAB: Configuration -->
                        <div id="tab-config" class="tab-content hidden space-y-8">
                            
                            <!-- Features Grid -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-6">
                                
                                <!-- Helper for Radio Group -->
                                <?php
                                function renderConfigToggle($label, $name, $checkedYes = false) {
                                    $checked = $checkedYes ? 'checked' : '';
                                    echo '
                                    <div class="flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 border border-gray-100 dark:border-gray-700 rounded-xl h-fit">
                                        <span class="font-medium text-gray-700 dark:text-gray-300">'.$label.'</span>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="'.$name.'" value="1" class="sr-only peer" '.$checked.'>
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[\'\'] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary"></div>
                                        </label>
                                    </div>';
                                }

                                function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
                                    // Identify selected label
                                    $selectedLabel = $label; // Default fallback
                                    foreach ($options as $val => $text) {
                                        if ((string)$val === (string)$selectedVal) {
                                            $selectedLabel = $text;
                                            break;
                                        }
                                    }
                                    // If no specific selection, maybe show first option or label? 
                                    // Standard select behavior: first option selected by default if nothing matches.
                                    if ($selectedVal === '' && !empty($options)) {
                                        $selectedVal = array_key_first($options);
                                        $selectedLabel = $options[$selectedVal];
                                    }

                                    $optionsHtml = '';
                                    foreach ($options as $val => $text) {
                                        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
                                        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
                                        
                                        $optionsHtml .= '
                                        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
                                            <span class="truncate">'.$text.'</span>
                                            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
                                        </div>';
                                    }

                                    return '
                                    <div class="relative custom-select-container '.$wrapperClass.'">
                                        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
                                        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
                                            <span class="truncate select-label">'.$selectedLabel.'</span>
                                            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
                                        </button>
                                        
                                        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
                                            <div class="p-1 space-y-0.5">
                                                '.$optionsHtml.'
                                            </div>
                                        </div>
                                    </div>';
                                }
                                ?>

                                <?php renderConfigToggle("Age Verification Dialog (18+)", "is_18_plus", false); ?>
                                <!-- Card Processing Section -->
                                <div class="space-y-3">
                                    <?php renderConfigToggle("Card Processing", "is_credit_enabled", false); ?>
                                    <div id="creditCardFields" class="hidden pl-2 animate-fade-in-up space-y-3">
                                        <!-- No Limit Toggle -->
                                         <?php 
                                            // Manual resize for nested toggle to fit design if needed, or re-use function
                                            $name = "credit_no_limit";
                                            $checked = ''; 
                                            echo '
                                            <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-slate-800/80 border border-gray-100 dark:border-gray-700/50 rounded-lg max-w-sm">
                                                <span class="text-sm font-medium text-gray-700 dark:text-gray-300">No Limit</span>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="'.$name.'" value="1" class="sr-only peer" '.$checked.'>
                                                    <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[\'\'] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all dark:border-gray-600 peer-checked:bg-primary"></div>
                                                </label>
                                            </div>';
                                        ?>
                                        
                                        <!-- Amount Field -->
                                        <div class="relative max-w-xs transition-opacity" id="creditLimitWrapper">
                                             <label class="text-xs font-semibold text-gray-500 uppercase mb-1 block">Minimum Card Amount (Limit)</label>
                                             <div class="relative">
                                                <span class="absolute left-3 top-2.5 text-gray-400">£</span>
                                                <input type="number" step="0.01" name="credit_limit_amount" class="<?php echo $inputClass; ?> pl-8" placeholder="5.00">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Coupon Section -->
                                <div class="space-y-3">
                                    <?php renderConfigToggle("Accept Coupons", "coupon_applicable", false); ?>
                                    <div id="couponFields" class="hidden pl-2 animate-fade-in-up">
                                        <div class="relative max-w-xs">
                                             <label class="text-xs font-semibold text-gray-500 uppercase mb-1 block">Minimum Sale Amount</label>
                                             <div class="relative">
                                                <span class="absolute left-3 top-2.5 text-gray-400">£</span>
                                                <input type="number" step="0.01" class="<?php echo $inputClass; ?> pl-8" placeholder="0.00">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Bag Fee Section -->
                                <div class="space-y-3">
                                    <?php renderConfigToggle("Bag Fees", "bag_fee", false); ?>
                                    <div id="bagFeeFields" class="hidden pl-2 animate-fade-in-up">
                                        <div class="relative max-w-xs">
                                             <label class="text-xs font-semibold text-gray-500 uppercase mb-1 block">Bag Fee Amount</label>
                                             <div class="relative">
                                                <span class="absolute left-3 top-2.5 text-gray-400">£</span>
                                                <input type="number" step="0.01" class="<?php echo $inputClass; ?> pl-8" placeholder="0.10">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>

                            <!-- Payment & Cash -->
                            <!-- Payment & Cash -->
                             <div class="space-y-4">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Cash & Payment Settings</h3>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                     <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Opening Cash Float</label>
                                        <div class="relative">
                                            <span class="absolute left-3 top-2.5 text-gray-400">£</span>
                                            <input type="number" class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400 pl-8" placeholder="0.00">
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Cashback Toggle Section -->
                                <div class="space-y-4 pt-4 border-t border-gray-100 dark:border-gray-700">
                                    <?php renderConfigToggle("Enable Cashback", "is_cashback_enabled", false); ?>
                                    
                                    <div id="cashbackFields" class="hidden grid grid-cols-1 md:grid-cols-3 gap-6 animate-fade-in-up">
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Cash Back Fee</label>
                                            <div class="relative">
                                                <span class="absolute left-3 top-2.5 text-gray-400">£</span>
                                                <input type="number" class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400 pl-8" placeholder="0.00">
                                            </div>
                                        </div>
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Max Cash Back Limit</label>
                                            <div class="relative">
                                                <span class="absolute left-3 top-2.5 text-gray-400">£</span>
                                                <input type="number" class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400 pl-8" placeholder="50.00">
                                            </div>
                                        </div>
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Cash Back Denominations</label>
                                            <input type="text" class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400" placeholder="10, 20, 50">
                                            <p class="text-xs text-gray-500 mt-1">Comma separated values</p>
                                        </div>
                                    </div>
                                </div>
                             </div>

                        </div>

                        <!-- TAB: Tax Settings -->
                        <div id="tab-tax" class="tab-content hidden space-y-6">
                            
                            <div id="taxFields" class="space-y-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <!-- Left Column -->
                                    <div class="space-y-4">
                                        <!-- VAT Number -->
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">VAT/Tax Registration Number</label>
                                            <input type="text" name="vat_number" class="<?php echo $inputClass; ?>" placeholder="e.g. GB 123 4567 89">
                                        </div>
                                        
                                        <!-- Company Reg Number -->
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Company Registration Number</label>
                                            <input type="text" name="company_reg_number" class="<?php echo $inputClass; ?>" placeholder="e.g. 01234567">
                                            <p class="text-xs text-gray-400">Required for official invoices in many jurisdictions.</p>
                                        </div>

                                        <!-- Tax Label - Removed -->
                                    </div>

                                    <!-- Right Column -->
                                    <div class="space-y-4">
                                        <!-- Legal Name -->
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Registered Legal Name</label>
                                            <input type="text" name="legal_name" class="<?php echo $inputClass; ?>" placeholder="e.g. FNF Retail Ltd">
                                            <p class="text-xs text-gray-400">The legal entity name, if different from Store Name.</p>
                                        </div>

                                        <!-- Tax Model - Removed -->
                                        
                                        <!-- Service Charge - Removed -->

                                    </div>
                                </div>
                            </div>
                        </div><!-- TAB: Receipt -->
                        <div id="tab-receipt" class="tab-content hidden space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <!-- Configuration -->
                                <!-- Configuration -->
                                <div class="space-y-6">
                                    <!-- Header Section -->
                                    <div class="space-y-4">
                                        <div class="flex items-center justify-between pb-2 border-b border-gray-100 dark:border-gray-700">
                                            <h4 class="text-sm font-semibold text-gray-800 dark:text-white">Receipt Header</h4>
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="enable_receipt_header" class="sr-only peer" checked>
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                            </label>
                                        </div>
                                        
                                        <div id="receiptHeaderFields" class="space-y-4 transition-opacity duration-200">
                                            <!-- Logo Toggle -->
                                            <div class="flex items-center justify-between py-2 px-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                                <div class="flex items-center gap-2">
                                                    <ion-icon name="image-outline" class="text-gray-500 text-lg"></ion-icon>
                                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Show Logo on Receipt</span>
                                                </div>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="show_receipt_logo" class="sr-only peer">
                                                    <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-600 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all peer-checked:bg-primary"></div>
                                                </label>
                                            </div>

                                            <!-- Title -->
                                            <div class="space-y-2">
                                                <div class="flex items-center justify-between">
                                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Store Name / Title</label>
                                                    <div class="flex items-center gap-2">
                                                        <span class="text-xs text-gray-500">Use Store Name</span>
                                                        <label class="relative inline-flex items-center cursor-pointer">
                                                            <input type="checkbox" name="use_store_name" class="sr-only peer" checked>
                                                            <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all peer-checked:bg-primary"></div>
                                                        </label>
                                                    </div>
                                                </div>
                                                <input type="text" name="receipt_title" class="<?php echo $inputClass; ?>" placeholder="e.g. FNF Cardiff">
                                            </div>
                                            
                                            <div class="grid grid-cols-1 gap-4">
                                                <!-- Header Line 1 -->
                                                <div class="space-y-2">
                                                    <div class="flex items-center justify-between">
                                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Header Line 1 (Address)</label>
                                                        <div class="flex items-center gap-2">
                                                            <span class="text-xs text-gray-500">Use Store Address</span>
                                                            <label class="relative inline-flex items-center cursor-pointer">
                                                                <input type="checkbox" name="use_store_address" class="sr-only peer" checked>
                                                                <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all peer-checked:bg-primary"></div>
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <input type="text" name="receipt_header_1" class="<?php echo $inputClass; ?>" placeholder="e.g. 123 Queen Street">
                                                </div>

                                                <!-- Header Line 2 -->
                                                <div class="space-y-2">
                                                    <div class="flex items-center justify-between">
                                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Header Line 2 (Contact)</label>
                                                        <div class="flex items-center gap-2">
                                                            <span class="text-xs text-gray-500">Use Store Contact</span>
                                                            <label class="relative inline-flex items-center cursor-pointer">
                                                                <input type="checkbox" name="use_store_contact" class="sr-only peer" checked>
                                                                <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all peer-checked:bg-primary"></div>
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <input type="text" name="receipt_header_2" class="<?php echo $inputClass; ?>" placeholder="e.g. Tel: 01234 567890">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Footer Section -->
                                    <div class="space-y-4">
                                        <div class="flex items-center justify-between pb-2 border-b border-gray-100 dark:border-gray-700">
                                            <h4 class="text-sm font-semibold text-gray-800 dark:text-white">Receipt Footer</h4>
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="enable_receipt_footer" class="sr-only peer" checked>
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                            </label>
                                        </div>
                                        
                                        <div id="receiptFooterFields" class="space-y-4 transition-opacity duration-200">
                                            <!-- QR Code Toggle -->
                                            <div class="space-y-4">
                                                <div class="flex items-center justify-between py-2 px-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                                    <div class="flex items-center gap-2">
                                                        <ion-icon name="qr-code-outline" class="text-gray-500 text-lg"></ion-icon>
                                                        <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Show QR Code</span>
                                                    </div>
                                                    <label class="relative inline-flex items-center cursor-pointer">
                                                        <input type="checkbox" name="show_receipt_qr" class="sr-only peer">
                                                        <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-600 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all peer-checked:bg-primary"></div>
                                                    </label>
                                                </div>
                                                
                                                <div id="qrLinkField" class="hidden pl-2 border-l-2 border-orange-200 dark:border-orange-900 ml-2">
                                                    <div class="space-y-2">
                                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">QR Link / URL</label>
                                                        <input type="url" name="receipt_qr_link" class="<?php echo $inputClass; ?>" placeholder="https://www.example.com/feedback">
                                                        <p class="text-xs text-gray-500">A QR code pointing to this link will be generated in the footer.</p>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="space-y-2">
                                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Footer Message</label>
                                                <input type="text" name="receipt_footer_msg" class="<?php echo $inputClass; ?>" placeholder="e.g. Thank you for shopping with us!">
                                            </div>
                                            
                                            <div class="space-y-2">
                                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Return Policy / Info</label>
                                                <input type="text" name="receipt_footer_policy" class="<?php echo $inputClass; ?>" placeholder="e.g. Returns accepted within 30 days">
                                            </div>
                                            
                                            <div class="space-y-2">
                                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Website / Social</label>
                                                <input type="text" name="receipt_footer_extra" class="<?php echo $inputClass; ?>" placeholder="e.g. www.fnf.co.uk">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Legal Content Options -->
                                    <div class="pt-4 border-t border-gray-100 dark:border-gray-700 space-y-4">
                                        <h4 class="text-sm font-semibold text-gray-800 dark:text-gray-200">Legal Details to Display</h4>
                                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                            <?php renderConfigToggle("Show VAT/Tax Number", "show_vat_on_receipt", true); ?>
                                            <?php renderConfigToggle("Show Company Reg No.", "show_crn_on_receipt", false); ?>
                                            <?php renderConfigToggle("Show Legal Name", "show_legal_name_on_receipt", false); ?>
                                            <?php renderConfigToggle("Show VAT Summary in Receipt", "show_vat_summary_receipt", false); ?>
                                        </div>
                                    </div>
                                </div>

                                <!-- Preview / Logo -->
                                <div id="receiptLogoWrapper" class="flex flex-col items-center justify-start pt-8 transition-opacity duration-200">
                                    <div class="w-48 h-48 rounded-2xl bg-gray-50 dark:bg-slate-800 border-2 border-dashed border-gray-300 dark:border-gray-600 flex items-center justify-center relative overflow-hidden group hover:border-primary transition-colors cursor-pointer" onclick="document.getElementById('receiptLogoInput').click()">
                                        <img id="receiptLogoPreview" class="w-full h-full object-cover hidden z-10 relative" alt="Receipt Logo">
                                        
                                        <!-- Remove Button -->
                                        <button type="button" id="removeReceiptLogoBtn" class="absolute top-1 right-1 z-20 bg-white/90 dark:bg-black/50 text-red-500 hover:text-red-600 rounded-full p-1 shadow-sm hidden opacity-0 group-hover:opacity-100 transition-all hover:bg-white" onclick="event.stopPropagation(); removeReceiptLogo(event);">
                                            <ion-icon name="close-circle" class="text-xl"></ion-icon>
                                        </button>

                                        <div class="absolute inset-0 flex flex-col items-center justify-center text-gray-400 group-hover:text-primary transition-colors z-0" id="receiptLogoPlaceholder">
                                            <ion-icon name="image-outline" class="text-4xl mb-2"></ion-icon>
                                            <span class="text-sm font-medium">Upload</span>
                                        </div>
                                        <!-- Overlay -->
                                        <div class="absolute inset-0 bg-black/50 hidden group-hover:flex items-center justify-center text-white text-xs font-medium opacity-0 group-hover:opacity-100 transition-opacity z-10" id="receiptLogoOverlay">
                                            Change
                                        </div>
                                    </div>
                                    <input type="file" id="receiptLogoInput" name="receipt_logo" class="hidden" accept="image/png, image/jpeg">
                                    <div class="text-center mt-3">
                                        <p class="text-sm text-gray-700 dark:text-gray-300 font-medium">Receipt Logo</p>
                                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">JPG, PNG Only</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- TAB: Security -->
                        <div id="tab-security" class="tab-content hidden space-y-8">
                            


                            <!-- Cash Control -->
                            <div class="space-y-4">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Cash Control</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div class="flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 rounded-lg border border-gray-100 dark:border-gray-700">
                                        <div>
                                            <div class="font-medium text-gray-800 dark:text-gray-200">Blind Reconciliation</div>
                                            <div class="text-xs text-gray-500">Hide expected cash amount during closing.</div>
                                        </div>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="blind_reconcile" class="sr-only peer">
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                        </label>
                                    </div>

                                    <div class="flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 rounded-lg border border-gray-100 dark:border-gray-700">
                                        <div>
                                            <div class="font-medium text-gray-800 dark:text-gray-200">Max Cash Warning</div>
                                            <div class="text-xs text-gray-500">Alert when drawer cash exceeds limit.</div>
                                        </div>
                                        <div class="flex items-center gap-4">
                                            <div class="relative w-36">
                                                <input type="number" name="max_cash_warning" class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl py-3 pl-8 pr-4 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400" placeholder="0.00">
                                                <span class="absolute left-3 top-3 text-gray-400 text-sm">£</span>
                                            </div>
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="enable_max_cash_warning" class="sr-only peer">
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Access & Sessions -->
                            <div class="space-y-4">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Access & Sessions</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div class="flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 rounded-lg border border-gray-100 dark:border-gray-700">
                                        <div>
                                            <div class="font-medium text-gray-800 dark:text-gray-200">Session Timeout</div>
                                            <div class="text-xs text-gray-500">Auto-lock POS screen after inactivity.</div>
                                        </div>
                                        <div class="w-48">
                                            <?php 
                                                echo renderCustomSelect('Session Timeout', 'session_timeout', [
                                                    '0' => 'Never',
                                                    '5' => '5 Minutes',
                                                    '15' => '15 Minutes',
                                                    '30' => '30 Minutes',
                                                    '60' => '1 Hour'
                                                ], '5'); 
                                            ?>
                                        </div>
                                    </div>

                                    <div class="flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 rounded-lg border border-gray-100 dark:border-gray-700">
                                        <div>
                                            <div class="font-medium text-gray-800 dark:text-gray-200">Max Login Attempts</div>
                                            <div class="text-xs text-gray-500">Lock account after failed attempts.</div>
                                        </div>
                                        <div class="w-48">
                                            <?php 
                                                echo renderCustomSelect('Max Login Attempts', 'max_login_attempts', [
                                                    '3' => '3 Attempts',
                                                    '5' => '5 Attempts',
                                                    '10' => '10 Attempts',
                                                    '999' => 'Unlimited'
                                                ], '5'); 
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Transaction Rules -->
                            <div class="space-y-4">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Transaction Rules</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div class="flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 rounded-lg border border-gray-100 dark:border-gray-700">
                                        <div>
                                            <div class="font-medium text-gray-800 dark:text-gray-200">Negative Stock Sales</div>
                                            <div class="text-xs text-gray-500">Allow selling items with zero or negative inventory.</div>
                                        </div>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="allow_negative_stock" class="sr-only peer">
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                        </label>
                                    </div>

                                    <!-- Transaction Lock -->
                                    <div class="flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 rounded-lg border border-gray-100 dark:border-gray-700">
                                        <div>
                                            <div class="font-medium text-gray-800 dark:text-gray-200">Transaction Value Lock</div>
                                            <div class="text-xs text-gray-500">Require manager approval for large sales.</div>
                                        </div>
                                        <div class="flex items-center gap-4">
                                            <div class="relative w-36">
                                                <input type="number" name="txn_value_lock" class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl py-3 pl-8 pr-4 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400" placeholder="0.00">
                                                <span class="absolute left-3 top-3 text-gray-400 text-sm">£</span>
                                            </div>
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="enable_txn_value_lock" class="sr-only peer">
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <!-- TAB: Reports -->
                        <div id="tab-reports" class="tab-content hidden space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div class="space-y-6">
                                    <!-- X Reports -->
                                    <div class="space-y-4">
                                        <div class="flex items-center justify-between py-2 border-b border-gray-100 dark:border-gray-700">
                                            <h4 class="text-sm font-semibold text-gray-800 dark:text-white">X Reports</h4>
                                        </div>
                                        
                                        <h5 class="text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Receipt Header</h5>
                                        <div id="xReportFields" class="grid grid-cols-1 md:grid-cols-2 gap-4 transition-opacity duration-200">
                                            <div class="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm">
                                                <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Use Store Address</span>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="x_report_use_address" class="sr-only peer" checked>
                                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                                </label>
                                            </div>
                                            <div class="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm">
                                                <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Use Store Contact</span>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="x_report_use_contact" class="sr-only peer" checked>
                                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                                </label>
                                            </div>
                                            <div class="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm col-span-1 md:col-span-2">
                                                <div class="flex items-center gap-3">
                                                    <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-gray-100 dark:bg-gray-700 text-gray-500 dark:text-gray-400">
                                                        <ion-icon name="image-outline" class="text-lg"></ion-icon>
                                                    </div>
                                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Show Logo on Receipt</span>
                                                </div>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="x_report_show_logo" class="sr-only peer" checked>
                                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Z Reports -->
                                    <div class="space-y-4">
                                        <div class="flex items-center justify-between py-2 border-b border-gray-100 dark:border-gray-700">
                                            <h4 class="text-sm font-semibold text-gray-800 dark:text-white">Z Reports</h4>
                                        </div>
                                        
                                        <h5 class="text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Receipt Header</h5>
                                        <div id="zReportFields" class="grid grid-cols-1 md:grid-cols-2 gap-4 transition-opacity duration-200">
                                            <div class="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm">
                                                <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Use Store Address</span>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="z_report_use_address" class="sr-only peer" checked>
                                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                                </label>
                                            </div>
                                            <div class="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm">
                                                <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Use Store Contact</span>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="z_report_use_contact" class="sr-only peer" checked>
                                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                                </label>
                                            </div>
                                            <div class="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm col-span-1 md:col-span-2">
                                                <div class="flex items-center gap-3">
                                                    <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-gray-100 dark:bg-gray-700 text-gray-500 dark:text-gray-400">
                                                        <ion-icon name="image-outline" class="text-lg"></ion-icon>
                                                    </div>
                                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Show Logo on Receipt</span>
                                                </div>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="z_report_show_logo" class="sr-only peer" checked>
                                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Sales Reports -->
                                    <div class="space-y-4">
                                        <div class="flex items-center justify-between py-2 border-b border-gray-100 dark:border-gray-700">
                                            <h4 class="text-sm font-semibold text-gray-800 dark:text-white">Sales Reports</h4>
                                        </div>
                                        
                                        <h5 class="text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Receipt Header</h5>
                                        <div id="salesReportFields" class="grid grid-cols-1 md:grid-cols-2 gap-4 transition-opacity duration-200">
                                            <div class="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm">
                                                <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Use Store Address</span>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="sales_report_use_address" class="sr-only peer" checked>
                                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                                </label>
                                            </div>
                                            <div class="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm">
                                                <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Use Store Contact</span>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="sales_report_use_contact" class="sr-only peer" checked>
                                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                                </label>
                                            </div>
                                            <div class="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm col-span-1 md:col-span-2">
                                                <div class="flex items-center gap-3">
                                                    <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-gray-100 dark:bg-gray-700 text-gray-500 dark:text-gray-400">
                                                        <ion-icon name="image-outline" class="text-lg"></ion-icon>
                                                    </div>
                                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Show Logo on Receipt</span>
                                                </div>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="sales_report_show_logo" class="sr-only peer" checked>
                                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="space-y-4">
                                        <div class="flex items-center justify-between pb-2 border-b border-gray-100 dark:border-gray-700">
                                            <h4 class="text-sm font-semibold text-gray-800 dark:text-white">Report Footer</h4>
                                        </div>
                                        
                                        <div id="reportFooterFields" class="space-y-4 transition-opacity duration-200">
                                            <div class="space-y-2">
                                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Footer Message</label>
                                                <input type="text" name="report_footer_msg" class="<?php echo $inputClass; ?>" placeholder="e.g. Confidential Report">
                                            </div>
                                            
                                            <div class="space-y-2">
                                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Disclaimer</label>
                                                <input type="text" name="report_footer_disclaimer" class="<?php echo $inputClass; ?>" placeholder="e.g. For internal use only">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="pt-4 border-t border-gray-100 dark:border-gray-700 space-y-4">
                                        <h4 class="text-sm font-semibold text-gray-800 dark:text-gray-200">Legal Details to Display</h4>
                                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                            <?php renderConfigToggle("Show VAT/Tax Number", "show_vat_on_report", false); ?>
                                            <?php renderConfigToggle("Show Company Reg No.", "show_crn_on_report", false); ?>
                                            <?php renderConfigToggle("Show Legal Name", "show_legal_name_on_report", false); ?>
                                            <?php renderConfigToggle("Show VAT Summary in Reports", "show_vat_summary_reports", false); ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Report Logo -->
                                <div id="reportLogoWrapper" class="flex flex-col items-center justify-start pt-8 transition-opacity duration-200">
                                    <div class="w-48 h-48 rounded-2xl bg-gray-50 dark:bg-slate-800 border-2 border-dashed border-gray-300 dark:border-gray-600 flex items-center justify-center relative overflow-hidden group hover:border-primary transition-colors cursor-pointer" onclick="document.getElementById('reportLogoInput').click()">
                                        <img id="reportLogoPreview" class="w-full h-full object-cover hidden z-10 relative" alt="Report Logo">
                                        
                                        <!-- Remove Button -->
                                        <button type="button" id="removeReportLogoBtn" class="absolute top-1 right-1 z-20 bg-white/90 dark:bg-black/50 text-red-500 hover:text-red-600 rounded-full p-1 shadow-sm hidden opacity-0 group-hover:opacity-100 transition-all hover:bg-white" onclick="event.stopPropagation(); removeReportLogo(event);">
                                            <ion-icon name="close-circle" class="text-xl"></ion-icon>
                                        </button>

                                        <div class="absolute inset-0 flex flex-col items-center justify-center text-gray-400 group-hover:text-primary transition-colors z-0" id="reportLogoPlaceholder">
                                            <ion-icon name="image-outline" class="text-4xl mb-2"></ion-icon>
                                            <span class="text-sm font-medium">Upload</span>
                                        </div>
                                        <!-- Overlay -->
                                        <div class="absolute inset-0 bg-black/50 hidden group-hover:flex items-center justify-center text-white text-xs font-medium opacity-0 group-hover:opacity-100 transition-opacity z-10" id="reportLogoOverlay">
                                            Change
                                        </div>
                                    </div>
                                    <input type="file" id="reportLogoInput" name="report_logo" class="hidden" accept="image/png, image/jpeg">
                                    <div class="text-center mt-3">
                                        <p class="text-sm text-gray-700 dark:text-gray-300 font-medium">Report Logo</p>
                                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">JPG, PNG Only</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- TAB: Devices -->
                        <div id="tab-devices" class="tab-content space-y-8 hidden">
                            <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Device Configuration</h3>
                                
                                <!-- Package Selection -->
                                <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-5 gap-4">
                                    <!-- Starter -->
                                    <div class="package-card relative p-5 rounded-2xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 cursor-pointer transition-all hover:border-blue-300 dark:hover:border-blue-700 hover:shadow-md" onclick="selectPackage('starter', this)">
                                        <div class="absolute top-4 right-4">
                                            <div class="w-6 h-6 rounded-full border-2 border-gray-300 dark:border-gray-600 flex items-center justify-center transition-colors">
                                                <ion-icon name="checkmark" class="text-white opacity-0"></ion-icon>
                                            </div>
                                        </div>
                                        <div class="w-12 h-12 rounded-xl bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400 flex items-center justify-center text-2xl mb-4">
                                            <ion-icon name="storefront-outline"></ion-icon>
                                        </div>
                                        <h4 class="text-lg font-bold text-gray-800 dark:text-white">Starter Kit</h4>
                                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">2 POS Terminals</p>
                                        <div class="mt-3 text-xl font-bold text-gray-800 dark:text-white">£20.00<span class="text-xs font-medium text-gray-500 dark:text-gray-400">/mo</span></div>
                                    </div>

                                    <!-- Retail Starter (New) -->
                                    <div class="package-card relative p-5 rounded-2xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 cursor-pointer transition-all hover:border-green-300 dark:hover:border-green-700 hover:shadow-md" onclick="selectPackage('retail', this)">
                                        <div class="absolute top-4 right-4">
                                            <div class="w-6 h-6 rounded-full border-2 border-gray-300 dark:border-gray-600 flex items-center justify-center transition-colors">
                                                <ion-icon name="checkmark" class="text-white opacity-0"></ion-icon>
                                            </div>
                                        </div>
                                        <div class="w-12 h-12 rounded-xl bg-green-50 dark:bg-green-900/20 text-green-600 dark:text-green-400 flex items-center justify-center text-2xl mb-4">
                                            <ion-icon name="pricetags-outline"></ion-icon>
                                        </div>
                                        <h4 class="text-lg font-bold text-gray-800 dark:text-white">Retail Starter</h4>
                                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">1 POS + Inventory</p>
                                        <div class="mt-3 text-xl font-bold text-gray-800 dark:text-white">£20.00<span class="text-xs font-medium text-gray-500 dark:text-gray-400">/mo</span></div>
                                    </div>

                                    <!-- Standard -->
                                    <div class="package-card relative p-5 rounded-2xl border-2 border-primary bg-orange-50/50 dark:bg-orange-900/10 cursor-pointer transition-all hover:shadow-md" onclick="selectPackage('standard', this)">
                                        <div class="absolute top-4 right-4">
                                            <div class="w-6 h-6 rounded-full border-2 border-primary bg-primary flex items-center justify-center">
                                                <ion-icon name="checkmark" class="text-white"></ion-icon>
                                            </div>
                                        </div>
                                        <div class="w-12 h-12 rounded-xl bg-orange-100 dark:bg-orange-900/30 text-orange-600 dark:text-orange-400 flex items-center justify-center text-2xl mb-4">
                                            <ion-icon name="cube-outline"></ion-icon>
                                        </div>
                                        <h4 class="text-lg font-bold text-gray-800 dark:text-white">Standard</h4>
                                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">2 POS, 1 Disp, Inv</p>
                                        <div class="mt-3 text-xl font-bold text-gray-800 dark:text-white">£25.00<span class="text-xs font-medium text-gray-500 dark:text-gray-400">/mo</span></div>
                                    </div>
                                    
                                    <!-- Growth -->
                                    <div class="package-card relative p-5 rounded-2xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 cursor-pointer transition-all hover:border-purple-300 dark:hover:border-purple-700 hover:shadow-md" onclick="selectPackage('growth', this)">
                                        <div class="absolute top-4 right-4">
                                            <div class="w-6 h-6 rounded-full border-2 border-gray-300 dark:border-gray-600 flex items-center justify-center transition-colors">
                                                <ion-icon name="checkmark" class="text-white opacity-0"></ion-icon>
                                            </div>
                                        </div>
                                        <div class="w-12 h-12 rounded-xl bg-purple-50 dark:bg-purple-900/20 text-purple-600 dark:text-purple-400 flex items-center justify-center text-2xl mb-4">
                                            <ion-icon name="trending-up-outline"></ion-icon>
                                        </div>
                                        <h4 class="text-lg font-bold text-gray-800 dark:text-white">Growth Pack</h4>
                                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">4 POS, 2 Disp, Inv</p>
                                        <div class="mt-3 text-xl font-bold text-gray-800 dark:text-white">£40.00<span class="text-xs font-medium text-gray-500 dark:text-gray-400">/mo</span></div>
                                    </div>

                                    <!-- Custom -->
                                    <div class="package-card relative p-5 rounded-2xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 cursor-pointer transition-all hover:border-gray-300 dark:hover:border-gray-600 hover:shadow-md" onclick="selectPackage('custom', this)">
                                        <div class="absolute top-4 right-4">
                                            <div class="w-6 h-6 rounded-full border-2 border-gray-300 dark:border-gray-600 flex items-center justify-center transition-colors">
                                                <ion-icon name="checkmark" class="text-white opacity-0"></ion-icon>
                                            </div>
                                        </div>
                                        <div class="w-12 h-12 rounded-xl bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-400 flex items-center justify-center text-2xl mb-4">
                                            <ion-icon name="settings-outline"></ion-icon>
                                        </div>
                                        <h4 class="text-lg font-bold text-gray-800 dark:text-white">Custom</h4>
                                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Build your own</p>
                                        <div class="mt-3 text-xl font-bold text-gray-800 dark:text-white">Variable</div>
                                    </div>
                                </div>
                                <input type="hidden" name="selected_package" id="selectedPackage" value="standard">

                                <!-- Custom Config Wrapper (Hidden for Standard) -->
                                <div id="customConfigWrapper" class="space-y-6 hidden">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <!-- POS Terminal Count -->
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Number of POS Terminals</label>
                                            <input type="number" id="posCount" name="pos_count" class="<?php echo $inputClass; ?>" min="2" value="2" oninput="calculateCharges()">
                                            <p class="text-xs text-gray-500 dark:text-gray-400">Enter the number of POS terminals required.</p>
                                        </div>

                                        <!-- Display Count -->
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Number of Advertisement Displays</label>
                                            <input type="number" id="displayCount" name="display_count" class="<?php echo $inputClass; ?>" min="0" value="1" oninput="calculateCharges()">
                                            <p class="text-xs text-gray-500 dark:text-gray-400">Enter the number of advertisement displays required.</p>
                                        </div>

                                        <!-- Inventory Add-on -->
                                        <div class="col-span-1 md:col-span-2 pt-2">
                                            <label class="flex items-center gap-3 p-2 rounded-lg cursor-pointer hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors group">
                                                <div class="relative flex items-center">
                                                    <input type="checkbox" id="inventoryAddon" name="inventory_management" class="peer w-5 h-5 cursor-pointer appearance-none rounded border-2 border-gray-300 shadow-sm checked:border-primary checked:bg-primary hover:border-primary focus:ring-0 focus:ring-offset-0 transition-all" onchange="calculateCharges()">
                                                    <ion-icon name="checkmark-sharp" class="absolute left-1/2 top-1/2 -translate-x-1/2 -translate-y-1/2 text-white text-sm opacity-0 peer-checked:opacity-100 pointer-events-none transition-opacity font-bold"></ion-icon>
                                                </div>
                                                <div class="flex-1">
                                                    <div class="text-sm font-bold text-gray-800 dark:text-gray-200 group-hover:text-primary transition-colors">Enable Inventory Management</div>
                                                    <div class="text-xs text-gray-500 dark:text-gray-400">Advanced stock tracking and alerts</div>
                                                </div>
                                                <div class="text-sm font-bold text-gray-800 dark:text-white">+£5.00<span class="text-xs font-normal text-gray-500 dark:text-gray-400">/mo</span></div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Charges Section (Always Visible or Hidden for Standard? "Should show this" implies visible or at least summarizing) -->
                                <!-- I'll keep it visible but maybe simplified or read-only for standard -->
                                <div class="bg-gray-50 dark:bg-slate-800/50 rounded-xl p-6 border border-gray-100 dark:border-gray-700 space-y-4">
                                    <div class="flex items-center justify-between">
                                        <h4 class="text-sm font-semibold text-gray-800 dark:text-gray-200">Monthly Charges</h4>
                                        
                                        <!-- Manual Override Toggle -->
                                        <div class="flex items-center gap-3" id="manualOverrideWrapper">
                                            <span class="text-sm text-gray-600 dark:text-gray-400">Manual Override</span>
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" id="manualOverride" name="manual_override" class="sr-only peer" onchange="toggleManualOverride()">
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Total Charges (GBP)</label>
                                        <div class="relative">
                                            <span class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-500 font-medium">£</span>
                                            <input type="number" id="totalCharges" name="total_charges" class="<?php echo $inputClass; ?> pl-8" value="20.00" step="0.01" readonly>
                                        </div>
                                        <p class="text-xs text-gray-500 dark:text-gray-400" id="chargeCalculationNote">Standard Bundle Rate</p>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </form>
                </div>

        </div>
    </div>
    
    <!-- Clone Store Modal -->
    <div id="cloneModal" class="fixed inset-0 z-[100] hidden">
        <div class="absolute inset-0 bg-black/50 backdrop-blur-sm transition-opacity opacity-0" id="cloneModalOverlay"></div>
        <div class="absolute inset-0 flex items-center justify-center p-4">
            <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-xl w-full max-w-md transform scale-95 opacity-0 transition-all" id="cloneModalContent">
                <div class="p-6 border-b border-gray-100 dark:border-gray-700 flex justify-between items-center">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white">Clone Store Settings</h3>
                    <button onclick="closeCloneModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-200">
                        <ion-icon name="close-outline" class="text-2xl"></ion-icon>
                    </button>
                </div>
                
                <div class="p-6 space-y-4">
                    <div class="bg-orange-50 dark:bg-orange-900/20 p-4 rounded-xl flex items-start gap-3 border border-orange-100 dark:border-orange-800/50">
                        <ion-icon name="information-circle-outline" class="text-xl text-orange-600 dark:text-orange-400 mt-0.5"></ion-icon>
                        <p class="text-sm text-orange-700 dark:text-orange-300">This will overwrite current tax, receipt, and security settings with values from the selected store.</p>
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Source Store</label>
                        <!-- Custom Select for Clone Store -->
                        <div class="relative custom-select-container">
                            <input type="hidden" id="cloneSourceStoreInput" name="clone_source_store" value="">
                            <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group">
                                <span class="truncate select-label" id="cloneSourceStoreLabel">Select a store to clone...</span>
                                <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
                            </button>
                            
                            <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
                                <div class="p-1 space-y-0.5" id="cloneStoreOptions">
                                    <!-- Populated by JS -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="p-6 pt-0 flex justify-end gap-3">
                    <button onclick="closeCloneModal()" class="px-6 py-2.5 bg-gray-100 dark:bg-slate-700 hover:bg-gray-200 dark:hover:bg-slate-600 text-gray-700 dark:text-gray-200 font-bold rounded-xl transition-colors">Cancel</button>
                    <button onclick="applyClone()" class="px-6 py-2.5 bg-primary hover:bg-orange-600 text-white font-bold rounded-xl shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="copy-outline" class="text-xl"></ion-icon>
                        <span>Clone Settings</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="assets/js/store_form.js?v=<?php echo time(); ?>"></script>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
