<?php
include 'includes/session.php';
// store_devices.php - Store Devices Management
$pageTitle = "Store Devices";
$currentPage = "store_devices";
require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="storeDevicesContent" class="flex-1 p-6 md:p-8 pb-20">
        
        <!-- Header -->
        <div class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 animate-fade-in-down relative z-50 overflow-visible">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Store Devices</h1>
                <p class="text-gray-500 dark:text-gray-400 mt-1">Manage POS terminals, printers, and other connected devices.</p>
            </div>
            
            <!-- Controls Bar -->
            <div class="flex flex-col sm:flex-row items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                <!-- Search & Filters -->
                <div class="flex items-center gap-2 w-full sm:w-auto flex-1 flex-wrap">
                    
                    <!-- Search -->
                    <div class="relative group w-full sm:w-64 shrink-0">
                        <ion-icon name="search-outline" class="absolute left-3 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                        <input type="text" id="deviceSearchInput" class="pl-10 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium" placeholder="Search...">
                    </div>
                    
                    <div class="h-8 w-px bg-gray-300 dark:bg-gray-600 mx-2 shrink-0"></div>
                    
                    <!-- Filter: Properties (Stores) -->
                    <div class="relative">
                        <button id="deviceStoreFilterBtn" class="flex items-center gap-2 px-3 py-2 text-sm font-medium text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-white dark:hover:bg-slate-700 rounded-lg transition-colors whitespace-nowrap">
                            <ion-icon id="deviceStoreFilterIcon" name="storefront-outline" class="text-gray-400"></ion-icon>
                            <span id="deviceStoreFilterText">All Stores</span>
                            <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 ml-1 transition-transform duration-300"></ion-icon>
                        </button>
                        
                        <!-- Dropdown Menu -->
                        <div id="deviceStoreFilterDropdown" class="absolute top-full left-0 mt-2 w-64 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 z-50 p-2 space-y-1 opacity-0 invisible transform -translate-y-2 transition-all duration-200">
                            
                            <!-- All Stores -->
                            <button class="device-store-option w-full flex items-center justify-between p-2 rounded-lg bg-gray-50 dark:bg-slate-700/50 text-gray-800 dark:text-gray-200 transition-colors active" data-value="all" data-label="All Stores">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-orange-100 dark:bg-orange-500/20 flex items-center justify-center text-orange-600 dark:text-orange-400">
                                        <ion-icon name="storefront" class="text-lg"></ion-icon>
                                    </div>
                                    <span class="font-medium text-sm">All Stores</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-100"></ion-icon>
                            </button>

                            <!-- FNF Cardiff -->
                            <button class="device-store-option w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group" data-value="cdf" data-label="FNF Cardiff">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-blue-50 dark:bg-blue-900/20 flex items-center justify-center text-blue-600 dark:text-blue-400 text-xs font-bold">
                                        CDF
                                    </div>
                                    <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">FNF Cardiff</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                            </button>

                            <!-- FNF Swansea -->
                            <button class="device-store-option w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group" data-value="swa" data-label="FNF Swansea">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-emerald-50 dark:bg-emerald-900/20 flex items-center justify-center text-emerald-600 dark:text-emerald-400 text-xs font-bold">
                                        SWA
                                    </div>
                                    <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">FNF Swansea</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                            </button>

                            <!-- 3S Penarth -->
                            <button class="device-store-option w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group" data-value="pen" data-label="3S Penarth">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-amber-50 dark:bg-amber-900/20 flex items-center justify-center text-amber-600 dark:text-amber-400 text-xs font-bold">
                                        PEN
                                    </div>
                                    <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">3S Penarth</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                            </button>

                        </div>
                    </div>

                    <!-- Filter: Status -->
                    <div class="relative">
                        <button id="deviceStatusFilterBtn" class="flex items-center gap-2 px-3 py-2 text-sm font-medium text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-white dark:hover:bg-slate-700 rounded-lg transition-colors whitespace-nowrap">
                            <ion-icon id="deviceStatusFilterIcon" name="ellipse-outline" class="text-gray-400 text-xs"></ion-icon>
                            <span id="deviceStatusFilterText">All Status</span>
                            <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 ml-1 transition-transform duration-300"></ion-icon>
                        </button>

                        <!-- Dropdown Menu -->
                        <div id="deviceStatusFilterDropdown" class="absolute top-full left-0 mt-2 w-48 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 z-50 p-2 space-y-1 opacity-0 invisible transform -translate-y-2 transition-all duration-200">
                            
                            <!-- All Status -->
                            <button class="device-status-option w-full flex items-center justify-between p-2 rounded-lg bg-gray-50 dark:bg-slate-700/50 text-gray-800 dark:text-gray-200 transition-colors active" data-value="all" data-label="All Status">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="ellipse-outline" class="text-gray-400 text-xs"></ion-icon>
                                    <span class="font-medium text-sm">All Status</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-100"></ion-icon>
                            </button>

                            <!-- Online -->
                            <button class="device-status-option w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group" data-value="online" data-label="Online">
                                <div class="flex items-center gap-3">
                                    <div class="w-2 h-2 rounded-full bg-emerald-500 shadow-sm shadow-emerald-500/50"></div>
                                    <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">Online</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                            </button>

                            <!-- Offline -->
                            <button class="device-status-option w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group" data-value="offline" data-label="Offline">
                                <div class="flex items-center gap-3">
                                    <div class="w-2 h-2 rounded-full bg-gray-400"></div>
                                    <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">Offline</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                            </button>

                            <!-- Inactive -->
                            <button class="device-status-option w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group" data-value="inactive" data-label="Inactive">
                                <div class="flex items-center gap-3">
                                    <div class="w-2 h-2 rounded-full bg-red-500 shadow-sm shadow-red-500/50"></div>
                                    <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">Inactive</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                            </button>

                        </div>
                    </div>

                </div>

                 <div class="h-8 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block shrink-0"></div>

                <!-- Right: Actions -->
                <div class="flex items-center gap-3 w-full sm:w-auto shrink-0">
                    <button onclick="openAddDeviceModal()" class="flex items-center gap-2 px-4 py-2 text-sm font-bold text-orange-500 hover:text-orange-600 hover:bg-white dark:hover:bg-orange-900/10 rounded-xl transition-colors">
                        <ion-icon name="add-circle-outline" class="text-xl"></ion-icon>
                        <span>Create</span>
                    </button>
                    
                    <div class="h-8 w-px bg-gray-300 dark:bg-gray-600 mx-1"></div>

                    <button class="flex items-center gap-2 px-4 py-2 bg-orange-500 hover:bg-orange-600 text-white text-sm font-bold rounded-xl shadow-lg shadow-orange-500/20 transition-all hover:-translate-y-0.5">
                        <ion-icon name="download-outline" class="text-lg"></ion-icon>
                        <span>Export</span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Devices List -->
        <div class="glass-panel rounded-2xl overflow-hidden animate-fade-in-up delay-100">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50">
                            <th class="text-left p-4 font-semibold text-gray-600 dark:text-gray-400 text-sm">Device Name</th>
                            <th class="text-left p-4 font-semibold text-gray-600 dark:text-gray-400 text-sm">Serial Number</th>
                            <th class="text-left p-4 font-semibold text-gray-600 dark:text-gray-400 text-sm">Type</th>
                            <th class="text-left p-4 font-semibold text-gray-600 dark:text-gray-400 text-sm">Assigned Store</th>
                            <th class="text-left p-4 font-semibold text-gray-600 dark:text-gray-400 text-sm">Status</th>
                            <th class="text-left p-4 font-semibold text-gray-600 dark:text-gray-400 text-sm">Last Active</th>
                            <th class="text-right p-4 font-semibold text-gray-600 dark:text-gray-400 text-sm">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                        <!-- Mock Row 1 -->
                        <tr class="device-row group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors" data-store="cdf" data-status="online">
                            <td class="p-4">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-blue-100 dark:bg-blue-500/20 text-blue-600 dark:text-blue-400 flex items-center justify-center font-bold text-lg">
                                        <ion-icon name="desktop-outline"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="font-semibold text-gray-800 dark:text-white">Main POS 01</div>
                                        <div class="text-xs text-gray-400">ID: #DEV-2001</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <span class="text-sm text-gray-700 dark:text-gray-300 font-mono">SN-1001</span>
                            </td>
                            <td class="p-4">
                                <span class="text-sm text-gray-700 dark:text-gray-300">POS Terminal</span>
                            </td>
                            <td class="p-4">
                                <span class="text-sm text-gray-700 dark:text-gray-300">Cardiff Central</span>
                            </td>
                            <td class="p-4">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400 border border-green-200 dark:border-green-800">
                                    Online
                                </span>
                            </td>
                            <td class="p-4">
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <div class="font-medium text-gray-700 dark:text-gray-300">Just Now</div>
                                </div>
                            </td>
                            <td class="p-4 text-right">
                                <div class="flex items-center justify-end gap-3">
                                    <button onclick="openEditDeviceModal('Main POS 01', 'pos', 'Cardiff Central', '1001', 'SN-1001')" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit Device">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <button class="p-1.5 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-lg transition-colors" title="Delete Device">
                                        <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                    </button>
                                </div>
                            </td>
                        </tr>

                        <!-- Mock Row 2 -->
                        <tr class="device-row group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors" data-store="cdf" data-status="offline">
                            <td class="p-4">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-purple-100 dark:bg-purple-500/20 text-purple-600 dark:text-purple-400 flex items-center justify-center font-bold text-lg">
                                        <ion-icon name="print-outline"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="font-semibold text-gray-800 dark:text-white">Kitchen Printer</div>
                                        <div class="text-xs text-gray-400">ID: #DEV-2002</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <span class="text-sm text-gray-700 dark:text-gray-300 font-mono">SN-1002</span>
                            </td>
                            <td class="p-4">
                                <span class="text-sm text-gray-700 dark:text-gray-300">Network Printer</span>
                            </td>
                            <td class="p-4">
                                <span class="text-sm text-gray-700 dark:text-gray-300">Cardiff Central</span>
                            </td>
                            <td class="p-4">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-400 border border-gray-200 dark:border-gray-600">
                                    Offline
                                </span>
                            </td>
                            <td class="p-4">
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <div class="font-medium text-gray-700 dark:text-gray-300">2 hours ago</div>
                                </div>
                            </td>
                            <td class="p-4 text-right">
                                <div class="flex items-center justify-end gap-3">
                                    <button onclick="openEditDeviceModal('Kitchen Printer', 'pos', 'Cardiff Central', '1001', 'SN-1002')" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit Device">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <button class="p-1.5 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-lg transition-colors" title="Delete Device">
                                        <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                    </button>
                                </div>
                            </td>
                        </tr>

                 <!-- Mock Row 3 (Added for filtering demo) -->
                        <tr class="device-row group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors" data-store="swa" data-status="inactive">
                            <td class="p-4">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-400 flex items-center justify-center font-bold text-lg">
                                        <ion-icon name="tv-outline"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="font-semibold text-gray-800 dark:text-white">Promo Screen</div>
                                        <div class="text-xs text-gray-400">ID: #DEV-2003</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <span class="text-sm text-gray-700 dark:text-gray-300 font-mono">SN-2003</span>
                            </td>
                            <td class="p-4">
                                <span class="text-sm text-gray-700 dark:text-gray-300">Display</span>
                            </td>
                            <td class="p-4">
                                <span class="text-sm text-gray-700 dark:text-gray-300">Newport Express</span>
                            </td>
                            <td class="p-4">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-400 border border-red-200 dark:border-red-800">
                                    Inactive
                                </span>
                            </td>
                            <td class="p-4">
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <div class="font-medium text-gray-700 dark:text-gray-300">5 days ago</div>
                                </div>
                            </td>
                            <td class="p-4 text-right">
                                <div class="flex items-center justify-end gap-3">
                                    <button onclick="openEditDeviceModal('Promo Screen', 'display', 'Newport Express', '1002', 'SN-2003')" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit Device">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <button class="p-1.5 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-lg transition-colors" title="Delete Device">
                                        <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Pagination Footer -->
            <div class="px-6 py-4 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between bg-white dark:bg-slate-800">
                <span class="pagination-text text-xs text-gray-500 dark:text-gray-400 font-medium" id="paginationInfo">
                    Showing 3 of 3 stores
                </span>
                <div class="flex items-center gap-2">
                    <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center disabled:opacity-50 disabled:hover:bg-gray-50 disabled:hover:text-gray-500 cursor-pointer disabled:cursor-not-allowed group" disabled>
                        <ion-icon name="chevron-back-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                    <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center cursor-pointer group" disabled>
                        <ion-icon name="chevron-forward-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                </div>
            </div>
            
            <!-- Empty State (Hidden by default) -->
            <div class="hidden flex flex-col items-center justify-center py-12 text-center">
                <div class="w-20 h-20 bg-gray-50 dark:bg-slate-800 rounded-full flex items-center justify-center mb-4">
                    <ion-icon name="hardware-chip-outline" class="text-4xl text-gray-300 dark:text-gray-600"></ion-icon>
                </div>
                <h3 class="text-lg font-semibold text-gray-800 dark:text-white">No devices found</h3>
                <p class="text-gray-500 dark:text-gray-400 max-w-sm mt-2">Connect POS terminals, printers, and displays to your store.</p>
            </div>
        </div>

    </div>

    <!-- Add Device Modal Template -->
    <div id="deviceModal" class="fixed inset-0 z-[100] hidden">
        <div class="absolute inset-0 bg-black/50 backdrop-blur-sm transition-opacity opacity-0" id="deviceModalOverlay"></div>
        <div class="absolute inset-0 flex items-center justify-center p-4">
            <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-xl w-full max-w-lg transform scale-95 opacity-0 transition-all" id="deviceModalContent">
                <div class="p-6 border-b border-gray-100 dark:border-gray-700 flex justify-between items-center">
                    <h3 id="deviceModalTitle" class="text-lg font-bold text-gray-800 dark:text-white">Add New Device</h3>
                    <button onclick="closeDeviceModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-200">
                        <ion-icon name="close-outline" class="text-2xl"></ion-icon>
                    </button>
                </div>
                
                <div class="p-6 space-y-4">
                    <!-- Example form fields -->
                    <div class="space-y-2">
                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Device Name</label>
                        <input type="text" id="deviceNameInput" class="w-full bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 focus:ring-2 focus:ring-primary/20 focus:border-primary outline-none transition-all" placeholder="e.g. Counter POS 1">
                    </div>
                    
                    <div class="space-y-2">
                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Type</label>
                        <!-- Custom Dropdown for Type -->
                        <div class="relative">
                            <button id="modalTypeBtn" onclick="toggleDropdown('modalTypeDropdown', this)" class="w-full flex items-center justify-between bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 focus:ring-2 focus:ring-primary/20 focus:border-primary outline-none transition-all text-left group">
                                <span id="modalTypeLabel" class="text-gray-700 dark:text-gray-200 font-medium">POS Terminal</span>
                                <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200"></ion-icon>
                            </button>
                            
                            <div id="modalTypeDropdown" class="absolute top-full left-0 mt-2 w-full bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 z-50 p-1 opacity-0 invisible transform -translate-y-2 transition-all duration-200">
                                <button onclick="selectModalType('pos', 'POS Terminal')" class="w-full flex items-center justify-between p-2.5 rounded-lg bg-gray-50 dark:bg-slate-700/50 text-gray-800 dark:text-gray-200 transition-colors text-left active" data-value="pos">
                                    <span class="font-medium">POS Terminal</span>
                                    <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-100"></ion-icon>
                                </button>
                                <button onclick="selectModalType('display', 'Advertisement Display')" class="w-full flex items-center justify-between p-2.5 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors text-left group" data-value="display">
                                    <span class="font-medium">Advertisement Display</span>
                                    <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Serial Number Field (Hidden by default, shown for POS) -->
                    <div id="serialNumberField" class="space-y-2 transition-all duration-300 origin-top">
                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Serial Number <span class="text-red-500">*</span></label>
                        <input type="text" id="serialNumberInput" class="w-full bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 focus:ring-2 focus:ring-primary/20 focus:border-primary outline-none transition-all" placeholder="Enter device serial number">
                    </div>

                     <div class="space-y-2">
                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Assign to Store</label>
                         <!-- Custom Dropdown for Store -->
                        <div class="relative">
                            <button id="modalStoreBtn" onclick="toggleDropdown('modalStoreDropdown', this)" class="w-full flex items-center justify-between bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 focus:ring-2 focus:ring-primary/20 focus:border-primary outline-none transition-all text-left">
                                <span id="modalStoreLabel" class="text-gray-700 dark:text-gray-200 font-medium">Cardiff Central</span>
                                <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200"></ion-icon>
                            </button>
                            
                            <div id="modalStoreDropdown" class="absolute top-full left-0 mt-2 w-full bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 z-50 p-1 opacity-0 invisible transform -translate-y-2 transition-all duration-200 max-h-60 overflow-y-auto no-scrollbar">
                                <button onclick="selectModalStore('1001', 'Cardiff Central', this)" class="w-full flex items-center justify-between p-2.5 rounded-lg bg-gray-50 dark:bg-slate-700/50 text-gray-800 dark:text-gray-200 transition-colors text-left active" data-value="1001">
                                    <span class="font-medium">Cardiff Central</span>
                                    <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-100"></ion-icon>
                                </button>
                                <button onclick="selectModalStore('1002', 'Newport Express', this)" class="w-full flex items-center justify-between p-2.5 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors text-left group" data-value="1002">
                                    <span class="font-medium">Newport Express</span>
                                    <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="p-6 pt-0 flex justify-end gap-3">
                    <button onclick="closeDeviceModal()" class="px-4 py-2 text-sm font-bold text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 hover:bg-gray-100 dark:hover:bg-slate-700 rounded-xl transition-colors">Cancel</button>
                    <button class="flex items-center gap-2 px-4 py-2 bg-orange-500 hover:bg-orange-600 text-white text-sm font-bold rounded-xl shadow-lg shadow-orange-500/20 transition-all hover:-translate-y-0.5" id="deviceModalSubmitBtn">
                        <ion-icon name="add-circle-outline" class="text-lg"></ion-icon>
                        <span id="deviceModalSubmitText">Add Device</span>
                    </button>
                </div>
            </div>
        </div>
    </div>


    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    // Simple Modal Logic
    const deviceModal = document.getElementById('deviceModal');
    const deviceOverlay = document.getElementById('deviceModalOverlay');
    const deviceContent = document.getElementById('deviceModalContent');

    function openDeviceModal() {
        deviceModal.classList.remove('hidden');
        
        // Apply Blur
        const elementsToBlur = [
            document.getElementById('sidebar'),
            document.getElementById('topbar'),
            document.getElementById('storeDevicesContent')
        ];
        
        elementsToBlur.forEach(el => {
            if (el) el.classList.add('transition-all', 'duration-300', 'blur-sm');
        });

        requestAnimationFrame(() => {
            deviceOverlay.classList.remove('opacity-0');
            deviceContent.classList.remove('opacity-0', 'scale-95');
            deviceContent.classList.add('scale-100');
        });
    }

    function closeDeviceModal() {
        deviceOverlay.classList.add('opacity-0');
        deviceContent.classList.remove('scale-100');
        deviceContent.classList.add('opacity-0', 'scale-95');
        
        // Remove Blur
        const elementsToBlur = [
            document.getElementById('sidebar'),
            document.getElementById('topbar'),
            document.getElementById('storeDevicesContent')
        ];
        
        elementsToBlur.forEach(el => {
            if (el) el.classList.remove('blur-sm');
        });

        setTimeout(() => {
            deviceModal.classList.add('hidden');
        }, 200);
    }

    function openAddDeviceModal() {
        document.getElementById('deviceModalTitle').textContent = 'Add New Device';
        document.getElementById('deviceModalSubmitText').textContent = 'Add Device';
        document.getElementById('deviceNameInput').value = '';
        document.getElementById('serialNumberInput').value = '';
        selectModalType('pos', 'POS Terminal');
        selectModalStore('1001', 'Cardiff Central'); 
        openDeviceModal();
    }

    function openEditDeviceModal(name, type, storeName, storeId, serial = '') {
        document.getElementById('deviceModalTitle').textContent = 'Edit Device';
        document.getElementById('deviceModalSubmitText').textContent = 'Save Changes';
        document.getElementById('deviceNameInput').value = name;
        document.getElementById('serialNumberInput').value = serial;
        
        let typeLabel = 'POS Terminal';
        if (type === 'display') typeLabel = 'Advertisement Display';
        selectModalType(type, typeLabel);
        
        selectModalStore(storeId, storeName);
        openDeviceModal();
    }

    // Modal Dropdown Logic
    function toggleDropdown(id, btn) {
        const dropdown = document.getElementById(id);
        const all = ['modalTypeDropdown', 'modalStoreDropdown'];
        
        all.forEach(dId => {
            if (dId !== id) {
                const d = document.getElementById(dId);
                d.classList.add('invisible', 'opacity-0', '-translate-y-2');
                // Reset icon for other button
                const otherBtnId = dId.replace('Dropdown', 'Btn');
                document.getElementById(otherBtnId)?.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180');
            }
        });

        const isHidden = dropdown.classList.contains('invisible');
        if (isHidden) {
            dropdown.classList.remove('invisible', 'opacity-0', '-translate-y-2');
            btn.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.add('rotate-180');
        } else {
            dropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
            btn.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180');
        }
    }

    function selectModalType(value, label) {
        document.getElementById('modalTypeLabel').textContent = label;
        updateActiveState('modalTypeDropdown', value);
        
        // Toggle Serial Number Field
        const serialField = document.getElementById('serialNumberField');
        if (value === 'pos') {
            serialField.classList.remove('hidden', 'opacity-0', '-translate-y-2', 'h-0', 'overflow-hidden');
            serialField.classList.add('block');
        } else {
            serialField.classList.add('hidden', 'opacity-0', '-translate-y-2', 'h-0', 'overflow-hidden');
            serialField.classList.remove('block');
        }
        
        // Close
        const dropdown = document.getElementById('modalTypeDropdown');
        dropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
        document.getElementById('modalTypeBtn')?.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180');
    }

    function selectModalStore(value, label) {
        document.getElementById('modalStoreLabel').textContent = label;
        updateActiveState('modalStoreDropdown', value);
        
        // Close
        const dropdown = document.getElementById('modalStoreDropdown');
        dropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
        document.getElementById('modalStoreBtn')?.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180');
    }

    function updateActiveState(dropdownId, value) {
        const options = document.querySelectorAll(`#${dropdownId} button`);
        options.forEach(btn => {
            const check = btn.querySelector('.check-icon');
            if (btn.dataset.value === value) {
                btn.classList.add('bg-gray-50', 'dark:bg-slate-700/50', 'active');
                btn.classList.remove('hover:bg-gray-50', 'dark:hover:bg-slate-700/50');
                check.classList.remove('opacity-0');
                check.classList.add('opacity-100');
            } else {
                btn.classList.remove('bg-gray-50', 'dark:bg-slate-700/50', 'active');
                btn.classList.add('hover:bg-gray-50', 'dark:hover:bg-slate-700/50');
                check.classList.add('opacity-0');
                check.classList.remove('opacity-100');
            }
        });
    }

    // Close modal dropdowns on outside click
    document.addEventListener('click', (e) => {
        if (!e.target.closest('#modalTypeBtn') && !e.target.closest('#modalTypeDropdown')) {
             const d = document.getElementById('modalTypeDropdown');
             if(d && !d.classList.contains('invisible')) {
                 d.classList.add('invisible', 'opacity-0', '-translate-y-2');
                 document.getElementById('modalTypeBtn').querySelector('ion-icon[name="chevron-down-outline"]').classList.remove('rotate-180');
             }
        }
        if (!e.target.closest('#modalStoreBtn') && !e.target.closest('#modalStoreDropdown')) {
             const d = document.getElementById('modalStoreDropdown');
             if(d && !d.classList.contains('invisible')) {
                 d.classList.add('invisible', 'opacity-0', '-translate-y-2');
                 document.getElementById('modalStoreBtn').querySelector('ion-icon[name="chevron-down-outline"]').classList.remove('rotate-180');
             }
        }
    });
    // Filtering Logic
    document.addEventListener('DOMContentLoaded', () => {
        const searchInput = document.getElementById('deviceSearchInput');
        const rows = document.querySelectorAll('.device-row');
        const paginationInfo = document.getElementById('paginationInfo');
        const emptyState = document.querySelector('.hidden.flex-col');
        // Note: emptyState logic might need adjustment if class structure changes. 
        // Based on lines 270-276, it shares parent with table container? 
        // Actually table is in .glass-panel. Empty state is AFTER .glass-panel? No, inside.
        // Let's rely on class toggle.

        let currentStore = 'all';
        let currentStatus = 'all';
        let searchQuery = '';

        function updateFilters() {
            let visibleCount = 0;
            
            rows.forEach(row => {
                const store = row.dataset.store;
                const status = row.dataset.status;
                const text = row.textContent.toLowerCase();
                
                const matchesStore = currentStore === 'all' || store === currentStore;
                const matchesStatus = currentStatus === 'all' || status === currentStatus;
                const matchesSearch = text.includes(searchQuery);

                if (matchesStore && matchesStatus && matchesSearch) {
                    row.classList.remove('hidden');
                    visibleCount++;
                } else {
                    row.classList.add('hidden');
                }
            });

            // Update Pagination Text
            paginationInfo.textContent = `Showing ${visibleCount} of ${visibleCount} stores`; // "stores" per user request image/text

            // Toggle Empty State
            const tableContainer = document.querySelector('table').closest('.glass-panel').querySelector('.overflow-x-auto');
            const footer = document.querySelector('#paginationInfo').closest('.border-t');
            
            // Note: The empty state div provided in original file was hidden by default.
            // We need to verify if we can target it correctly.
            // It is the div with "No devices found".
            // Let's assume there is only one such div.
            // But I cannot see the empty state div ID. I'll search by content if needed, or assume it's the next sibling of table wrapper.
        }

        // Listeners for Custom Dropdowns
        document.querySelectorAll('.device-store-option').forEach(btn => {
            btn.addEventListener('click', (e) => {
                 // Prevent bubbling if needed, but layout.js handles UI.
                 currentStore = btn.dataset.value;
                 updateFilters();
            });
        });

        document.querySelectorAll('.device-status-option').forEach(btn => {
            btn.addEventListener('click', (e) => {
                 currentStatus = btn.dataset.value;
                 updateFilters();
            });
        });

        // Search Listener
        if(searchInput) {
            searchInput.addEventListener('input', (e) => {
                searchQuery = e.target.value.toLowerCase();
                updateFilters();
            });
        }
    });
</script>
