<?php
include 'includes/session.php';
$pageTitle = "System Settings";
$currentPage = "settings";
require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Shared Style Classes (Matched to store_form.php)
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full custom-scrollbar">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Matched to store_form.php) -->
            <form action="settings_system.php" method="POST" id="settingsForm">
                <div
                    class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                    <div class="flex items-center gap-4">
                        <div
                            class="w-10 h-10 rounded-xl bg-primary/10 text-primary flex items-center justify-center shadow-sm">
                            <ion-icon name="settings-outline" class="text-xl"></ion-icon>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">System Settings
                            </h1>
                            <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Global portal configuration and
                                localization.</p>
                        </div>
                    </div>
                    <button type="submit"
                        class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save Settings</span>
                    </button>
                </div>

                <!-- Main Form Card -->
                <div class="glass-panel rounded-2xl mt-6">
                    <div class="p-6 md:p-8 space-y-10">

                        <!-- Section: Portal Branding -->
                        <div class="space-y-6">
                            <h3
                                class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">
                                Portal Branding</h3>

                            <div class="flex items-start gap-8">
                                <!-- Logo Upload -->
                                <div class="shrink-0 space-y-2">
                                    <label
                                        class="text-xs font-black text-gray-500 uppercase tracking-widest ml-1">Portal
                                        Logo</label>
                                    <div
                                        class="w-32 h-32 rounded-2xl bg-gray-50 dark:bg-slate-800 border-2 border-dashed border-gray-300 dark:border-gray-600 flex items-center justify-center relative overflow-hidden group hover:border-primary transition-colors cursor-pointer">
                                        <div
                                            class="text-center text-gray-400 group-hover:text-primary transition-colors">
                                            <ion-icon name="cloud-upload-outline" class="text-3xl"></ion-icon>
                                            <p class="text-[10px] font-bold mt-1 uppercase">Upload</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="flex-1 grid grid-cols-1 md:grid-cols-2 gap-8 pt-6">
                                    <!-- Portal Name -->
                                    <div class="space-y-2">
                                        <label
                                            class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Organization
                                            Name</label>
                                        <input type="text" name="org_name" value="CashBox Enterprise"
                                            class="<?php echo $inputClass; ?>">
                                    </div>

                                    <!-- Support Email -->
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Support
                                            Email</label>
                                        <input type="email" name="support_email" value="support@cashbox.com"
                                            class="<?php echo $inputClass; ?>">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Section: Regional & Localization -->
                        <div class="space-y-6">
                            <h3
                                class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">
                                Localization Defaults</h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Default
                                        Language</label>
                                    <?php echo renderCustomSelect('', 'default_lang', [
                                        'en' => 'English (UK)',
                                        'us' => 'English (US)',
                                        'es' => 'Spanish',
                                        'fr' => 'French'
                                    ], 'en', 'w-full', 'py-3 px-4 text-sm font-medium rounded-xl'); ?>
                                </div>

                                <div class="space-y-2">
                                    <label
                                        class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Timezone</label>
                                    <?php echo renderCustomSelect('', 'default_timezone', [
                                        'Europe/London' => 'London (GMT/BST)',
                                        'UTC' => 'UTC',
                                        'America/New_York' => 'Eastern Time'
                                    ], 'Europe/London', 'w-full', 'py-3 px-4 text-sm font-medium rounded-xl'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<?php require_once 'includes/footer.php'; ?>