<?php
include 'includes/session.php';
$pageTitle = "Global Security Settings";
$currentPage = "settings";
require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full custom-scrollbar">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Matched to store_form.php) -->
            <form action="settings_security.php" method="POST" id="securitySettingsForm">
                <div
                    class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                    <div class="flex items-center gap-4">
                        <div
                            class="w-10 h-10 rounded-xl bg-orange-500/10 text-orange-500 flex items-center justify-center shadow-sm">
                            <ion-icon name="shield-half-outline" class="text-xl"></ion-icon>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Global Security
                            </h1>
                            <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Manage portal-wide access and
                                security policies.</p>
                        </div>
                    </div>
                    <button type="submit"
                        class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="lock-closed-outline" class="text-lg"></ion-icon>
                        <span>Reinforce Security</span>
                    </button>
                </div>

                <div class="grid grid-cols-1 xl:grid-cols-2 gap-6 mt-6">
                    <!-- Section: Session & Accounts -->
                    <div class="glass-panel rounded-2xl p-6 md:p-8 space-y-8">
                        <div class="space-y-6">
                            <h3
                                class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">
                                Access Policies</h3>

                            <div class="space-y-4">
                                <div
                                    class="flex items-center justify-between p-5 bg-gray-50/50 dark:bg-slate-800/50 rounded-2xl border border-gray-100 dark:border-gray-700 group hover:border-primary/30 transition-all">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-10 h-10 rounded-xl bg-white dark:bg-slate-900 border border-gray-100 dark:border-gray-700 flex items-center justify-center text-primary shadow-sm">
                                            <ion-icon name="key-outline" class="text-xl"></ion-icon>
                                        </div>
                                        <div>
                                            <div class="text-sm font-bold text-gray-800 dark:text-white">Two-Factor
                                                Authentication</div>
                                            <div
                                                class="text-[10px] text-gray-400 uppercase font-black tracking-widest mt-0.5">
                                                Global Requirement</div>
                                        </div>
                                    </div>
                                    <label class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="require_2fa" class="sr-only peer">
                                        <div
                                            class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary">
                                        </div>
                                    </label>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Session
                                            Inactivity Timeout</label>
                                        <?php echo renderCustomSelect('', 'session_timeout', [
                                            '15' => '15 Minutes',
                                            '30' => '30 Minutes',
                                            '60' => '1 Hour',
                                            '120' => '2 Hours'
                                        ], '30', 'w-full', 'py-3 px-4 text-sm font-medium rounded-xl'); ?>
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Max
                                            Login Attempts</label>
                                        <?php echo renderCustomSelect('', 'max_attempts', [
                                            '3' => '3 Attempts',
                                            '5' => '5 Attempts',
                                            '10' => '10 Attempts'
                                        ], '5', 'w-full', 'py-3 px-4 text-sm font-medium rounded-xl'); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Section: Password Complexity -->
                    <div class="glass-panel rounded-2xl p-6 md:p-8 space-y-8">
                        <div class="space-y-6">
                            <h3
                                class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">
                                Password Complexity</h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <?php
                                function renderSecurityToggle($label, $name, $checked = true)
                                {
                                    $checkAttr = $checked ? 'checked' : '';
                                    echo '
                                    <div class="flex items-center justify-between p-4 bg-gray-50/50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700">
                                        <span class="text-sm font-medium text-gray-700 dark:text-gray-300">' . $label . '</span>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="' . $name . '" class="sr-only peer" ' . $checkAttr . '>
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[\'\'] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                                        </label>
                                    </div>';
                                }

                                renderSecurityToggle("Require Digits (0-9)", "require_digits");
                                renderSecurityToggle("Require Special Symbols", "require_special");
                                renderSecurityToggle("Require Caps (A-Z)", "require_caps");
                                renderSecurityToggle("Min 8 Characters", "min_length");
                                ?>
                            </div>

                            <div class="pt-4 border-t border-gray-100 dark:border-gray-700">
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Password
                                        Expiry (Days)</label>
                                    <input type="number" name="pass_expiry" value="90"
                                        class="<?php echo $inputClass; ?>">
                                    <p class="text-[10px] text-gray-400 uppercase font-black tracking-widest ml-1">Users
                                        will be forced to change password</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<?php require_once 'includes/footer.php'; ?>