<?php
include 'includes/session.php';
$pageTitle = "Email Configuration";
$currentPage = "settings";
require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full custom-scrollbar">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Matched to store_form.php) -->
            <form action="settings_email.php" method="POST" id="emailSettingsForm">
                <div
                    class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                    <div class="flex items-center gap-4">
                        <div
                            class="w-10 h-10 rounded-xl bg-blue-500/10 text-blue-500 flex items-center justify-center shadow-sm">
                            <ion-icon name="mail-outline" class="text-xl"></ion-icon>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Email Server
                            </h1>
                            <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Configure SMTP settings for system
                                notifications.</p>
                        </div>
                    </div>
                    <div class="flex items-center gap-3">
                        <button type="button"
                            class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-blue-500 hover:border-blue-500/30 hover:bg-blue-50 dark:hover:bg-slate-700 rounded-xl text-sm font-semibold transition-all shadow-sm flex items-center gap-2">
                            <ion-icon name="send-outline"></ion-icon>
                            <span>Send Test</span>
                        </button>
                        <button type="submit"
                            class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                            <ion-icon name="save-outline" class="text-lg"></ion-icon>
                            <span>Save Config</span>
                        </button>
                    </div>
                </div>

                <div class="grid grid-cols-1 xl:grid-cols-3 gap-6 mt-6">
                    <!-- SMTP Server Settings -->
                    <div class="xl:col-span-2 glass-panel rounded-2xl p-6 md:p-8 space-y-8">
                        <div class="space-y-6">
                            <h3
                                class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">
                                SMTP Credentials</h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">SMTP
                                        Host</label>
                                    <input type="text" name="smtp_host" placeholder="smtp.gmail.com"
                                        class="<?php echo $inputClass; ?>">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">SMTP
                                        Port</label>
                                    <input type="number" name="smtp_port" placeholder="587"
                                        class="<?php echo $inputClass; ?>">
                                </div>
                                <div class="space-y-2">
                                    <label
                                        class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Username</label>
                                    <input type="text" name="smtp_user" placeholder="notifications@yourdomain.com"
                                        class="<?php echo $inputClass; ?>">
                                </div>
                                <div class="space-y-2">
                                    <label
                                        class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Password</label>
                                    <div class="relative group">
                                        <input type="password" name="smtp_pass" placeholder="••••••••••••"
                                            class="<?php echo $inputClass; ?>">
                                        <button type="button"
                                            class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 hover:text-primary transition-colors">
                                            <ion-icon name="eye-outline" class="text-lg"></ion-icon>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div class="space-y-2">
                                    <label
                                        class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Encryption</label>
                                    <?php echo renderCustomSelect('', 'smtp_enc', [
                                        'tls' => 'TLS (Recommended)',
                                        'ssl' => 'SSL',
                                        'none' => 'None'
                                    ], 'tls', 'w-full', 'py-3 px-4 text-sm font-medium rounded-xl'); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sender Identity -->
                    <div class="glass-panel rounded-2xl p-6 md:p-8 space-y-8">
                        <div class="space-y-6">
                            <h3
                                class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">
                                Sender Identity</h3>

                            <div class="space-y-4">
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">From
                                        Name</label>
                                    <input type="text" name="from_name" value="CashBox POS System"
                                        class="<?php echo $inputClass; ?>">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">From
                                        Email</label>
                                    <input type="email" name="from_email" value="no-reply@cashbox.com"
                                        class="<?php echo $inputClass; ?>">
                                </div>

                                <div class="pt-4 border-t border-gray-100 dark:border-gray-700">
                                    <div
                                        class="flex items-center justify-between p-4 bg-gray-50/50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700">
                                        <div class="flex-1 pr-4">
                                            <div class="text-sm font-bold text-gray-800 dark:text-white">Track Delivery
                                            </div>
                                            <div
                                                class="text-[10px] text-gray-400 uppercase font-black tracking-widest mt-0.5">
                                                SMTP Journaling</div>
                                        </div>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="track_emails" class="sr-only peer" checked>
                                            <div
                                                class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary">
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<?php require_once 'includes/footer.php'; ?>