<?php
include 'includes/session.php';
$pageTitle = "Active Sessions";
$currentPage = "sessions_active";
require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Mock Data
$sessions = [
    ['id' => 'SESS-001', 'user' => 'John Doe', 'role' => 'Manager', 'store' => 'FNF Cardiff', 'device' => 'Office PC', 'ip' => '192.168.1.10', 'login_time' => '2026-01-16 08:30', 'status' => 'Active', 'source' => 'Portal'],
    ['id' => 'SESS-002', 'user' => 'Alice Smith', 'role' => 'Cashier', 'store' => 'FNF Bristol', 'device' => 'Till 1', 'ip' => '192.168.2.15', 'login_time' => '2026-01-16 09:00', 'status' => 'Active', 'source' => 'Till'],
    ['id' => 'SESS-003', 'user' => 'Bob Jones', 'role' => 'Admin', 'store' => 'HQ', 'device' => 'Galaxy Tab', 'ip' => '10.0.0.5', 'login_time' => '2026-01-16 10:15', 'status' => 'Idle', 'source' => 'Admin App'],
    ['id' => 'SESS-004', 'user' => 'Sarah James', 'role' => 'Supervisor', 'store' => 'FNF Cardiff', 'device' => 'Till 2', 'ip' => '192.168.1.12', 'login_time' => '2026-01-16 11:45', 'status' => 'Active', 'source' => 'Till'],
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20 overflow-y-auto custom-scrollbar">
        <div class="max-w-[1600px] mx-auto space-y-10">

            <!-- Header & Master Actions -->
            <div class="glass-panel p-8 rounded-[2rem] relative overflow-hidden group border-none shadow-sm">
                <div class="absolute -top-4 -right-4 w-32 h-32 bg-primary/5 rounded-full blur-3xl group-hover:bg-primary/10 transition-colors"></div>
                <div class="relative z-10">
                    <div class="flex flex-col lg:flex-row lg:items-center justify-between gap-6">
                        <div class="flex items-center gap-5">
                            <div class="w-14 h-14 rounded-2xl bg-primary/10 flex items-center justify-center text-primary shadow-sm border border-primary/10">
                                <ion-icon name="shield-checkmark-outline" class="text-3xl"></ion-icon>
                            </div>
                            <div>
                                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Active Sessions</h1>
                                <p class="text-gray-500 dark:text-gray-400 text-sm mt-1 font-medium">Real-time monitoring and security management of user sessions.</p>
                            </div>
                        </div>

                        <div class="flex flex-col sm:flex-row items-center gap-4">
                             <div class="relative group flex-1 w-full sm:w-80">
                                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                    <ion-icon name="search-outline" class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                                </div>
                                <input type="text" id="globalSearch" class="w-full bg-white/50 dark:bg-slate-800/50 border border-gray-100 dark:border-gray-700 rounded-2xl px-5 pl-12 py-3 outline-none focus:ring-4 focus:ring-orange-500/10 focus:border-primary transition-all text-sm font-medium" placeholder="Search sessions by user, ID or IP...">
                            </div>
                            <button class="px-6 py-3 bg-red-500 hover:bg-red-600 text-white rounded-2xl text-xs font-extrabold uppercase tracking-widest shadow-lg shadow-red-500/20 transition-all flex items-center gap-2 group">
                                <ion-icon name="power-outline" class="text-lg group-hover:rotate-90 transition-transform duration-300"></ion-icon>
                                <span>Terminate All Sessions</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Session KPI Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Total Active -->
                <div class="glass-panel p-6 rounded-3xl border-none shadow-sm hover:translate-y-[-4px] transition-all group">
                    <div class="flex justify-between items-start mb-4">
                        <div class="w-12 h-12 rounded-2xl bg-emerald-50 dark:bg-emerald-500/10 text-emerald-500 flex items-center justify-center border border-emerald-100 dark:border-emerald-500/10">
                            <ion-icon name="pulse" class="text-2xl animate-pulse"></ion-icon>
                        </div>
                        <span class="text-[10px] font-extrabold text-emerald-600 bg-emerald-50 px-2.5 py-1 rounded-full border border-emerald-100 uppercase tracking-widest shadow-sm">Real-time</span>
                    </div>
                    <div class="space-y-1">
                        <h3 class="text-3xl font-extrabold text-gray-800 dark:text-white tracking-tighter"><?php echo count($sessions); ?></h3>
                        <p class="text-[11px] text-gray-400 font-bold uppercase tracking-widest">Total Active Sessions</p>
                    </div>
                </div>

                <!-- Managers -->
                <div class="glass-panel p-6 rounded-3xl border-none shadow-sm hover:translate-y-[-4px] transition-all group">
                    <div class="flex justify-between items-start mb-4">
                        <div class="w-12 h-12 rounded-2xl bg-primary/10 text-primary flex items-center justify-center border border-primary/20">
                            <ion-icon name="key-outline" class="text-2xl"></ion-icon>
                        </div>
                    </div>
                    <div class="space-y-1">
                        <h3 class="text-3xl font-extrabold text-gray-800 dark:text-white tracking-tighter">1</h3>
                        <p class="text-[11px] text-gray-400 font-bold uppercase tracking-widest">Managerial Access</p>
                    </div>
                </div>

                <!-- Devices -->
                <div class="glass-panel p-6 rounded-3xl border-none shadow-sm hover:translate-y-[-4px] transition-all group">
                    <div class="flex justify-between items-start mb-4">
                        <div class="w-12 h-12 rounded-2xl bg-blue-50 dark:bg-blue-500/10 text-blue-500 flex items-center justify-center border border-blue-100 dark:border-blue-500/10">
                            <ion-icon name="desktop-outline" class="text-2xl"></ion-icon>
                        </div>
                    </div>
                    <div class="space-y-1">
                        <h3 class="text-3xl font-extrabold text-gray-800 dark:text-white tracking-tighter">2</h3>
                        <p class="text-[11px] text-gray-400 font-bold uppercase tracking-widest">Back-Office Devices</p>
                    </div>
                </div>

                <!-- Alerts -->
                <div class="glass-panel p-6 rounded-3xl border-none shadow-sm hover:translate-y-[-4px] transition-all group bg-amber-50/10">
                    <div class="flex justify-between items-start mb-4">
                        <div class="w-12 h-12 rounded-2xl bg-amber-50 dark:bg-amber-500/10 text-amber-500 flex items-center justify-center border border-amber-100 dark:border-amber-500/10">
                            <ion-icon name="alert-circle-outline" class="text-2xl"></ion-icon>
                        </div>
                        <span class="text-[10px] font-extrabold text-amber-600 bg-amber-50 px-2.5 py-1 rounded-full border border-amber-100 uppercase tracking-widest shadow-sm">1 Idle</span>
                    </div>
                    <div class="space-y-1">
                        <h3 class="text-3xl font-extrabold text-gray-800 dark:text-white tracking-tighter"><?php echo count($sessions); ?></h3>
                        <p class="text-[11px] text-gray-400 font-bold uppercase tracking-widest">Total Logins (24h)</p>
                    </div>
                </div>
            </div>

            <!-- Active Sessions Table -->
            <div class="glass-panel rounded-3xl overflow-visible shadow-sm border-none relative min-h-[500px]">
                <div class="overflow-x-auto overflow-y-visible custom-scrollbar">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <!-- User Column (Filter) -->
                                <th class="p-5 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest relative group border-r border-gray-50 dark:border-gray-700/50 w-[300px]">
                                    <div class="flex items-center justify-between">
                                        <span id="header-user" class="transition-colors duration-200">Staff User</span>
                                        <button onclick="toggleSearchPopup('searchPopup-user')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                            <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                        </button>
                                    </div>
                                    <div id="searchPopup-user" class="absolute top-full left-0 mt-3 w-[240px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                        <div class="flex items-center justify-between mb-3 px-1">
                                            <span class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">Filter by Name</span>
                                            <ion-icon name="person-outline" class="text-primary text-base"></ion-icon>
                                        </div>
                                        <div class="relative mb-3 group/input">
                                            <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                            <input type="text" id="input-user" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Search user...">
                                        </div>
                                        <div class="grid grid-cols-2 gap-2">
                                            <button onclick="clearTextFilter('user')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                            <button onclick="applyTextFilter('user')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                        </div>
                                    </div>
                                </th>

                                <!-- Store Column (Filter) -->
                                <th class="p-5 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest relative group border-r border-gray-50 dark:border-gray-700/50 w-[250px]">
                                    <div class="flex items-center justify-between">
                                        <span id="header-store" class="transition-colors duration-200">Store & Source</span>
                                        <button onclick="toggleSearchPopup('searchPopup-store')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                            <ion-icon name="filter-outline" class="text-sm"></ion-icon>
                                        </button>
                                    </div>
                                    <div id="searchPopup-store" class="absolute top-full left-0 mt-3 w-[240px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl text-left">
                                        <div class="flex items-center justify-between mb-3 px-1">
                                            <span class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">Filter by Source</span>
                                            <ion-icon name="layers-outline" class="text-primary text-base"></ion-icon>
                                        </div>
                                        <div class="space-y-1 mb-3">
                                            <button class="w-full text-left px-3 py-2 rounded-xl text-xs font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700 transition-colors flex items-center justify-between group">
                                                <span>Portal</span> <ion-icon name="checkmark-circle" class="text-primary opacity-0 group-hover:opacity-100"></ion-icon>
                                            </button>
                                            <button class="w-full text-left px-3 py-2 rounded-xl text-xs font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700 transition-colors flex items-center justify-between group">
                                                <span>Till</span> <ion-icon name="checkmark-circle" class="text-primary opacity-0 group-hover:opacity-100"></ion-icon>
                                            </button>
                                            <button class="w-full text-left px-3 py-2 rounded-xl text-xs font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700 transition-colors flex items-center justify-between group">
                                                <span>Admin App</span> <ion-icon name="checkmark-circle" class="text-primary opacity-0 group-hover:opacity-100"></ion-icon>
                                            </button>
                                        </div>
                                        <div class="grid grid-cols-2 gap-2 border-t border-gray-50 dark:border-gray-700/50 pt-3 mt-1">
                                            <button onclick="clearTextFilter('store')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Reset</button>
                                            <button onclick="applyTextFilter('store')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-primary shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                        </div>
                                    </div>
                                </th>

                                <th class="py-5 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">Infra & Time</th>
                                <th class="py-5 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-center">Security Status</th>
                                <th class="py-5 px-8 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">Management</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50 dark:divide-gray-800/30">
                            <?php foreach ($sessions as $row): 
                                $sourceColor = 'gray';
                                if($row['source'] == 'Portal') $sourceColor = 'blue';
                                if($row['source'] == 'Till') $sourceColor = 'indigo';
                                if($row['source'] == 'Admin App') $sourceColor = 'purple';
                            ?>
                            <tr class="group hover:bg-gray-50/50 dark:hover:bg-slate-800/30 transition-all">
                                <!-- User -->
                                <td class="py-5 px-8">
                                    <div class="flex items-center gap-4">
                                        <div class="w-10 h-10 rounded-xl bg-primary/10 flex items-center justify-center text-primary font-bold shadow-sm border border-primary/20">
                                            <?php echo substr($row['user'], 0, 1); ?>
                                        </div>
                                        <div>
                                            <div class="text-sm font-bold text-gray-800 dark:text-white"><?php echo $row['user']; ?></div>
                                            <div class="text-[10px] text-gray-400 font-extrabold uppercase tracking-widest mt-0.5"><?php echo $row['role']; ?></div>
                                        </div>
                                    </div>
                                </td>

                                <!-- Store & Source -->
                                <td class="py-5 px-6">
                                    <div class="flex items-center gap-2 mb-2">
                                        <ion-icon name="storefront-outline" class="text-gray-400"></ion-icon>
                                        <span class="text-sm font-bold text-gray-700 dark:text-gray-300"><?php echo $row['store']; ?></span>
                                    </div>
                                    <div class="flex items-center">
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-lg bg-<?php echo $sourceColor; ?>-50 text-<?php echo $sourceColor; ?>-600 dark:bg-<?php echo $sourceColor; ?>-500/10 dark:text-<?php echo $sourceColor; ?>-400 text-[9px] font-extrabold uppercase tracking-widest border border-<?php echo $sourceColor; ?>-100 dark:border-<?php echo $sourceColor; ?>-500/20 shadow-sm">
                                            <ion-icon name="<?php echo $row['source'] == 'Till' ? 'calculator' : ($row['source'] == 'Portal' ? 'globe' : 'phone-portrait'); ?>-outline" class="mr-1"></ion-icon>
                                            <?php echo $row['source']; ?>
                                        </span>
                                    </div>
                                </td>

                                <!-- Infra & Time -->
                                <td class="py-5 px-6">
                                    <div class="text-sm font-extrabold text-gray-700 dark:text-gray-300 font-mono tracking-tight flex items-center gap-1.5 mb-1">
                                        <ion-icon name="time-outline" class="text-gray-400 text-xs font-normal"></ion-icon>
                                        <?php echo date('H:i', strtotime($row['login_time'])); ?>
                                    </div>
                                    <div class="text-[10px] text-gray-400 font-bold uppercase tracking-tighter flex items-center gap-1.5">
                                        <ion-icon name="hardware-chip-outline" class="text-gray-400/50"></ion-icon>
                                        <?php echo $row['device']; ?> · <?php echo $row['ip']; ?>
                                    </div>
                                </td>

                                <!-- Status -->
                                <td class="py-5 px-6 text-center">
                                    <?php if ($row['status'] == 'Active'): ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-lg bg-emerald-50 text-emerald-600 dark:bg-emerald-500/10 dark:text-emerald-400 text-[10px] font-extrabold uppercase tracking-widest border border-emerald-100 dark:border-emerald-500/20 shadow-sm">
                                            <div class="w-1.5 h-1.5 rounded-full bg-emerald-500 mr-2 shadow-[0_0_8px_rgba(16,185,129,0.5)]"></div>
                                            Active
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-lg bg-amber-50 text-amber-600 dark:bg-amber-500/10 dark:text-amber-400 text-[10px] font-extrabold uppercase tracking-widest border border-amber-100 dark:border-amber-500/20 shadow-sm">
                                            <div class="w-1.5 h-1.5 rounded-full bg-amber-500 mr-2"></div>
                                            Idle
                                        </span>
                                    <?php endif; ?>
                                </td>

                                <!-- Actions -->
                                <td class="py-5 px-8 text-right">
                                    <button class="px-4 py-2 bg-red-50 hover:bg-red-500 text-red-600 hover:text-white dark:bg-red-500/10 dark:hover:bg-red-500 rounded-xl text-[10px] font-extrabold uppercase tracking-widest transition-all shadow-sm ring-1 ring-red-500/20 group hover:shadow-red-500/10" title="Revoke Session Token">
                                        <ion-icon name="log-out-outline" class="mr-1.5 text-xs align-middle"></ion-icon>
                                        <span>Terminate</span>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination (Standard Style) -->
                <div class="p-6 border-t border-gray-50 dark:border-gray-800/50 flex items-center justify-between bg-gray-50/20 dark:bg-slate-800/20">
                    <span class="text-xs text-gray-500 dark:text-gray-400 font-bold uppercase tracking-widest">Showing <?php echo count($sessions); ?> active sessions</span>
                    <div class="flex gap-2">
                        <button class="w-10 h-10 rounded-xl bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-400 flex items-center justify-center hover:text-primary hover:border-primary/20 transition-all opacity-50 cursor-not-allowed">
                            <ion-icon name="chevron-back-outline" class="text-lg"></ion-icon>
                        </button>
                        <button class="w-10 h-10 rounded-xl bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-400 flex items-center justify-center hover:text-primary hover:border-primary/20 transition-all opacity-50 cursor-not-allowed">
                            <ion-icon name="chevron-forward-outline" class="text-lg"></ion-icon>
                        </button>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        // Toggle Search Popups in Table Headers
        function toggleSearchPopup(popupId) {
            // Close all others first
            document.querySelectorAll('[id^="searchPopup-"]').forEach(el => {
                if(el.id !== popupId) {
                    el.classList.add('invisible', 'opacity-0', 'translate-y-4');
                }
            });

            const popup = document.getElementById(popupId);
            if(popup) {
                if(popup.classList.contains('invisible')) {
                    popup.classList.remove('invisible', 'opacity-0', 'translate-y-4');
                } else {
                    popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
                }
            }
        }

        // Close on click outside
        document.addEventListener('click', (e) => {
            if (!e.target.closest('th')) {
                document.querySelectorAll('[id^="searchPopup-"]').forEach(el => {
                     el.classList.add('invisible', 'opacity-0', 'translate-y-4');
                });
            }
        });

        // Prevent closing when clicking inside the popup
        document.querySelectorAll('[id^="searchPopup-"]').forEach(popup => {
            popup.addEventListener('click', (e) => {
                e.stopPropagation();
            });
        });

        // Apply Text Filter (Highlight Header)
        function applyTextFilter(type) {
            const input = document.getElementById('input-' + type);
            const header = document.getElementById('header-' + type);
            const popupId = 'searchPopup-' + type;

            if (input && input.value.trim() !== "") {
                header.classList.add('text-primary');
            } else if (!input && header) {
                 header.classList.add('text-primary'); // For non-input filters
            } else {
                header?.classList.remove('text-primary');
            }
            
            // Close Popup
            const popup = document.getElementById(popupId);
            popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
        }

        // Clear Text Filter (Remove Highlight)
        function clearTextFilter(type) {
            const input = document.getElementById('input-' + type);
            const header = document.getElementById('header-' + type);
            if(input) input.value = "";
            header?.classList.remove('text-primary');
        }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
