<?php
include 'includes/session.php';
// service_providers.php - List of Operational Service Providers
$pageTitle = "Service Providers";
$currentPage = "service_providers";
require_once 'includes/header.php';

// Mock Data for Service Providers (Updated with Billing Info)
$providers = [
    [
        'id' => 'SP-001',
        'name' => 'Amazon Web Services',
        'category' => 'Cloud Infrastructure',
        'account_id' => 'AWS-8829-1002',
        'status' => 'Active',
        'icon' => 'cloud-outline',
        'color' => 'orange',
        'billing_cycle' => 'Monthly',
        'amount' => '1,250.00',
        'amount_type' => 'Variable',
        'next_bill' => '2026-02-01',
        'days_left' => 9
    ],
    [
        'id' => 'SP-002',
        'name' => 'Google Cloud Platform',
        'category' => 'API Services',
        'account_id' => 'GCP-BILL-9922',
        'status' => 'Active',
        'icon' => 'logo-google',
        'color' => 'blue',
        'billing_cycle' => 'Monthly',
        'amount' => '450.00',
        'amount_type' => 'Variable',
        'next_bill' => '2026-02-01',
        'days_left' => 9
    ],
    [
        'id' => 'SP-003',
        'name' => 'Twilio',
        'category' => 'Communication',
        'account_id' => 'AC381909282',
        'status' => 'Active',
        'icon' => 'chatbubble-ellipses-outline',
        'color' => 'red',
        'billing_cycle' => 'Monthly',
        'amount' => '90.00',
        'amount_type' => 'Variable',
        'next_bill' => '2026-02-05',
        'days_left' => 13
    ],
    [
        'id' => 'SP-004',
        'name' => 'DigitalOcean',
        'category' => 'Hosting',
        'account_id' => 'DO-TEAM-01',
        'status' => 'Inactive',
        'icon' => 'server-outline',
        'color' => 'cyan',
        'billing_cycle' => 'Monthly',
        'amount' => '0.00',
        'amount_type' => 'Fixed',
        'next_bill' => '-',
        'days_left' => 0
    ],
    [
        'id' => 'SP-005',
        'name' => 'Office Rent',
        'category' => 'Utility/Rent',
        'account_id' => 'PROP-2291',
        'status' => 'Active',
        'icon' => 'business-outline',
        'color' => 'purple',
        'billing_cycle' => 'Quarterly',
        'amount' => '4,500.00',
        'amount_type' => 'Fixed',
        'next_bill' => '2026-03-25',
        'days_left' => 62
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div
                class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-10">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Service Providers</h1>
                    <p class="text-gray-500 dark:text-gray-400 mt-1">Manage operational vendors, contracts, and billing
                        cycles.</p>
                </div>

                <div
                    class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto">
                    <div class="relative group w-full sm:w-64 shrink-0">
                        <div class="absolute inset-y-0 left-0 pl-3.5 flex items-center pointer-events-none">
                            <ion-icon name="search-outline"
                                class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                        </div>
                        <input type="text"
                            class="w-full bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg pl-10 pr-4 py-2 text-sm focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all outline-none"
                            placeholder="Search Provider...">
                    </div>

                    <button
                        class="p-2 text-gray-500 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-all"
                        title="Filter List">
                        <ion-icon name="filter-outline" class="text-xl"></ion-icon>
                    </button>

                    <a href="service_provider_form.php"
                        class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-lg text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center gap-2 whitespace-nowrap">
                        <ion-icon name="add-circle-outline" class="text-xl"></ion-icon>
                        <span>Add Provider</span>
                    </a>
                </div>
            </div>

            <!-- Providers Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
                <?php foreach ($providers as $provider): ?>
                    <div
                        class="glass-panel rounded-2xl p-6 relative group hover:-translate-y-1 transition-all duration-300">

                        <!-- Card Top -->
                        <div class="flex items-start justify-between mb-4">
                            <div
                                class="w-14 h-14 rounded-2xl bg-<?php echo $provider['color']; ?>-50 dark:bg-<?php echo $provider['color']; ?>-900/20 flex items-center justify-center text-<?php echo $provider['color']; ?>-500 border border-<?php echo $provider['color']; ?>-100 dark:border-<?php echo $provider['color']; ?>-800/50">
                                <ion-icon name="<?php echo $provider['icon']; ?>" class="text-3xl"></ion-icon>
                            </div>
                            <div class="flex flex-col items-end">
                                <?php if ($provider['status'] == 'Active'): ?>
                                    <span
                                        class="px-2.5 py-1 rounded-lg bg-emerald-50 dark:bg-emerald-900/20 text-emerald-600 dark:text-emerald-400 border border-emerald-100 dark:border-emerald-800/50 text-[10px] font-bold uppercase tracking-wider">
                                        Active
                                    </span>
                                <?php else: ?>
                                    <span
                                        class="px-2.5 py-1 rounded-lg bg-gray-50 dark:bg-gray-800 text-gray-500 dark:text-gray-400 border border-gray-100 dark:border-gray-700 text-[10px] font-bold uppercase tracking-wider">
                                        Inactive
                                    </span>
                                <?php endif; ?>

                                <?php if ($provider['status'] == 'Active'): ?>
                                    <div class="mt-2 text-[10px] font-bold text-gray-400 flex items-center gap-1">
                                        <?php if ($provider['days_left'] <= 7): ?>
                                            <span class="text-orange-500 flex items-center gap-1"><ion-icon
                                                    name="time-outline"></ion-icon> Due in <?php echo $provider['days_left']; ?>
                                                days</span>
                                        <?php else: ?>
                                            <span>Due in <?php echo $provider['days_left']; ?> days</span>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <h3 class="text-lg font-bold text-gray-800 dark:text-white mb-1"><?php echo $provider['name']; ?>
                        </h3>
                        <p class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wide mb-4">
                            <?php echo $provider['category']; ?></p>

                        <!-- Billing Info Grid -->
                        <div class="grid grid-cols-2 gap-3 pt-4 border-t border-gray-100 dark:border-gray-700/50">
                            <div class="p-2.5 bg-gray-50 dark:bg-slate-800/50 rounded-xl">
                                <p class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Cycle</p>
                                <p class="text-xs font-bold text-gray-700 dark:text-gray-300 mt-1">
                                    <?php echo $provider['billing_cycle']; ?></p>
                            </div>

                            <div class="p-2.5 bg-gray-50 dark:bg-slate-800/50 rounded-xl">
                                <p class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Amount
                                    <?php echo ($provider['amount_type'] == 'Variable') ? '(Est)' : ''; ?></p>
                                <p class="text-sm font-black text-gray-800 dark:text-white mt-0.5">
                                    £<?php echo $provider['amount']; ?></p>
                            </div>

                            <div
                                class="p-2.5 bg-gray-50 dark:bg-slate-800/50 rounded-xl col-span-2 flex items-center justify-between">
                                <div>
                                    <p class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Next Invoice</p>
                                    <p class="text-xs font-bold text-gray-700 dark:text-gray-300 mt-0.5">
                                        <?php echo ($provider['next_bill'] != '-') ? date('M d, Y', strtotime($provider['next_bill'])) : '-'; ?>
                                    </p>
                                </div>
                                <div class="text-right">
                                    <p class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Account ID</p>
                                    <p
                                        class="text-xs font-bold text-gray-500 dark:text-gray-400 mt-0.5 truncate max-w-[100px]">
                                        <?php echo $provider['account_id']; ?></p>
                                </div>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="mt-4 flex gap-2">
                            <a href="service_provider_form.php?id=<?php echo $provider['id']; ?>"
                                class="flex-1 py-2.5 rounded-xl border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 font-bold text-sm hover:border-primary hover:text-primary hover:bg-orange-50 dark:hover:bg-primary/10 transition-all flex items-center justify-center gap-2">
                                <ion-icon name="create-outline"></ion-icon>
                                Manage
                            </a>
                            <button
                                class="p-2.5 rounded-xl border border-gray-200 dark:border-gray-700 text-gray-400 hover:text-red-500 hover:border-red-200 hover:bg-red-50 dark:hover:bg-red-900/20 transition-all">
                                <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                            </button>
                        </div>
                    </div>
                <?php endforeach; ?>

                <!-- Add New Card -->
                <a href="service_provider_form.php"
                    class="rounded-2xl border-2 border-dashed border-gray-200 dark:border-gray-700 flex flex-col items-center justify-center p-6 text-gray-400 hover:text-primary hover:border-primary/50 hover:bg-orange-50/50 dark:hover:bg-primary/5 transition-all group cursor-pointer min-h-[350px]">
                    <div
                        class="w-16 h-16 rounded-full bg-gray-50 dark:bg-slate-800 flex items-center justify-center mb-4 group-hover:scale-110 transition-transform">
                        <ion-icon name="add-outline" class="text-3xl"></ion-icon>
                    </div>
                    <span class="font-bold text-sm">Add New Provider</span>
                </a>
            </div>

        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>