<?php
include 'includes/session.php';
// service_provider_form.php - Add/Edit Service Provider
$providerId = $_GET['id'] ?? null;
$mode = $providerId ? 'edit' : 'create';
$pageTitle = $mode === 'edit' ? "Edit Service Provider" : "Add Service Provider";
$currentPage = "service_providers";
require_once 'includes/header.php';

// Shared Style Classes (Same as store_form.php)
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

// Mock data for edit mode
$provider = [
    'name' => '',
    'category' => '',
    'account_id' => '',
    'contact_email' => '',
    'support_phone' => '',
    'website' => '',
    'notes' => '',
    'status' => 'Active',
    'color' => 'blue',
    'icon' => 'cube-outline',
    // New Billing Fields
    'billing_cycle' => 'Monthly',
    'amount_type' => 'Fixed',
    'amount' => '',
    'next_bill_date' => '',
    'contract_start' => '',
    'contract_end' => '',
    'auto_renew' => '1',
    'reminder_days' => '3'
];

if ($mode === 'edit') {
    // Simulate fetching data
    $provider = [
        'name' => 'Amazon Web Services',
        'category' => 'Cloud Infrastructure',
        'account_id' => 'AWS-8829-1002',
        'contact_email' => 'billing@aws.amazon.com',
        'support_phone' => '+1-206-266-1000',
        'website' => 'https://aws.amazon.com',
        'notes' => 'Primary infrastructure provider. Usage varies.',
        'status' => 'Active',
        'color' => 'orange',
        'icon' => 'cloud-outline',
        'billing_cycle' => 'Monthly',
        'amount_type' => 'Variable',
        'amount' => '1250.00',
        'next_bill_date' => '2026-02-01',
        'contract_start' => '2025-01-01',
        'contract_end' => '2027-01-01',
        'auto_renew' => '1',
        'reminder_days' => '7'
    ];
}

function renderConfigToggle($label, $name, $checkedYes = false) {
    $checked = $checkedYes ? 'checked' : '';
    echo '
    <div class="flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 border border-gray-100 dark:border-gray-700 rounded-xl h-fit">
        <span class="font-medium text-gray-700 dark:text-gray-300">'.$label.'</span>
        <label class="relative inline-flex items-center cursor-pointer">
            <input type="checkbox" name="'.$name.'" value="1" class="sr-only peer" '.$checked.'>
            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[\'\'] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary"></div>
        </label>
    </div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Glass Panel) -->
            <div class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 relative z-30">
                <div class="flex items-center gap-4">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">
                            <?php echo $mode === 'edit' ? 'Edit Provider' : 'New Service Provider'; ?>
                        </h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Manage vendor contracts, billing cycles, and contact details.</p>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <button type="button" onclick="history.back()" class="px-5 py-2.5 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 rounded-xl hover:text-gray-800 dark:hover:text-white transition-all font-bold text-sm shadow-sm">
                        Cancel
                    </button>
                    <button type="button" onclick="saveProvider()" class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save Provider</span>
                    </button>
                </div>
            </div>

            <!-- Main Form Card -->
            <div class="glass-panel rounded-2xl">
                
                <!-- Tabs Header -->
                <div class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 px-6 pt-4 rounded-t-2xl">
                    <div class="flex gap-6 overflow-x-auto custom-scrollbar">
                        <button class="tab-btn active pb-4 px-2 text-sm font-bold border-b-2 border-primary text-primary transition-colors whitespace-nowrap" onclick="switchTab('tab-general', this)">
                            General Info
                        </button>
                        <button class="tab-btn pb-4 px-2 text-sm font-bold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" onclick="switchTab('tab-contract', this)">
                            Contract & Billing
                        </button>
                        <button class="tab-btn pb-4 px-2 text-sm font-bold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" onclick="switchTab('tab-contact', this)">
                            Contact & Support
                        </button>
                    </div>
                </div>

                <!-- Form Content -->
                <form id="providerForm" class="p-6 md:p-8 space-y-6">
                    
                    <!-- TAB: General Info -->
                    <div id="tab-general" class="tab-content space-y-8 animate-fade-in-up">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            
                            <!-- Basic Details -->
                            <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Provider Identity</h3>
                                
                                <div class="space-y-4">
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Provider Name <span class="text-red-500">*</span></label>
                                        <input type="text" value="<?php echo $provider['name']; ?>" class="<?php echo $inputClass; ?>" placeholder="e.g. Amazon Web Services">
                                    </div>

                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Category <span class="text-red-500">*</span></label>
                                        <div class="relative">
                                            <select class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 appearance-none cursor-pointer">
                                                <option value="" disabled <?php echo empty($provider['category']) ? 'selected' : ''; ?>>Select Category</option>
                                                <option value="Cloud Infrastructure" <?php echo ($provider['category'] == 'Cloud Infrastructure') ? 'selected' : ''; ?>>Cloud Infrastructure</option>
                                                <option value="API Services" <?php echo ($provider['category'] == 'API Services') ? 'selected' : ''; ?>>API Services</option>
                                                <option value="Communication" <?php echo ($provider['category'] == 'Communication') ? 'selected' : ''; ?>>Communication</option>
                                                <option value="Hosting" <?php echo ($provider['category'] == 'Hosting') ? 'selected' : ''; ?>>Hosting</option>
                                                <option value="Utility" <?php echo ($provider['category'] == 'Utility') ? 'selected' : ''; ?>>Utility/Rent</option>
                                                <option value="Other" <?php echo ($provider['category'] == 'Other') ? 'selected' : ''; ?>>Other</option>
                                            </select>
                                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-gray-400">
                                                <ion-icon name="chevron-down-outline" class="text-lg"></ion-icon>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Account ID / Customer Number</label>
                                        <input type="text" value="<?php echo $provider['account_id']; ?>" class="<?php echo $inputClass; ?>" placeholder="e.g. AWS-8829-1002">
                                    </div>

                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                                        <div class="flex items-center gap-3 pt-1">
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="status" value="Active" class="sr-only peer" <?php echo ($provider['status'] == 'Active') ? 'checked' : ''; ?>>
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-emerald-500"></div>
                                                <span class="ml-3 text-sm font-medium text-gray-600 dark:text-gray-300">Active Service</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Visuals -->
                            <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Visual Settings</h3>
                                
                                <div class="grid grid-cols-2 gap-4">
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Icon (Ionicons)</label>
                                        <div class="relative group">
                                            <ion-icon name="image-outline" class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                                            <input type="text" value="<?php echo $provider['icon']; ?>" class="<?php echo $inputClass; ?> pl-11" placeholder="e.g. cloud-outline">
                                        </div>
                                    </div>

                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Theme Color</label>
                                        <div class="relative">
                                            <select class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 appearance-none cursor-pointer">
                                                <option value="blue" <?php echo ($provider['color'] == 'blue') ? 'selected' : ''; ?>>Blue</option>
                                                <option value="orange" <?php echo ($provider['color'] == 'orange') ? 'selected' : ''; ?>>Orange</option>
                                                <option value="red" <?php echo ($provider['color'] == 'red') ? 'selected' : ''; ?>>Red</option>
                                                <option value="emerald" <?php echo ($provider['color'] == 'emerald') ? 'selected' : ''; ?>>Emerald</option>
                                                <option value="purple" <?php echo ($provider['color'] == 'purple') ? 'selected' : ''; ?>>Purple</option>
                                                <option value="gray" <?php echo ($provider['color'] == 'gray') ? 'selected' : ''; ?>>Gray</option>
                                            </select>
                                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-gray-400">
                                                <ion-icon name="chevron-down-outline" class="text-lg"></ion-icon>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="p-4 bg-gray-50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700 flex items-center justify-center h-32">
                                    <div class="flex flex-col items-center gap-3 opacity-50">
                                        <div class="w-12 h-12 rounded-xl bg-orange-100 dark:bg-orange-900/30 flex items-center justify-center text-orange-500">
                                            <ion-icon name="eye-outline" class="text-2xl"></ion-icon>
                                        </div>
                                        <span class="text-xs font-semibold uppercase tracking-wider text-gray-400">Preview</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: Contract & Billing -->
                    <div id="tab-contract" class="tab-content hidden space-y-8 animate-fade-in-up">
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            <!-- Billing Details -->
                            <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Billing Cycle</h3>
                                
                                <div class="grid grid-cols-2 gap-4">
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Payment Cycle</label>
                                        <div class="relative">
                                            <select class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 appearance-none cursor-pointer">
                                                <option value="Monthly" <?php echo ($provider['billing_cycle'] == 'Monthly') ? 'selected' : ''; ?>>Monthly</option>
                                                <option value="Quarterly" <?php echo ($provider['billing_cycle'] == 'Quarterly') ? 'selected' : ''; ?>>Quarterly</option>
                                                <option value="Yearly" <?php echo ($provider['billing_cycle'] == 'Yearly') ? 'selected' : ''; ?>>Yearly</option>
                                                <option value="One-Off" <?php echo ($provider['billing_cycle'] == 'One-Off') ? 'selected' : ''; ?>>One-Off</option>
                                            </select>
                                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-gray-400">
                                                <ion-icon name="chevron-down-outline" class="text-lg"></ion-icon>
                                            </div>
                                        </div>
                                    </div>
                                     <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Cost Type</label>
                                        <div class="relative">
                                            <select class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 appearance-none cursor-pointer">
                                                <option value="Fixed" <?php echo ($provider['amount_type'] == 'Fixed') ? 'selected' : ''; ?>>Fixed Amount</option>
                                                <option value="Variable" <?php echo ($provider['amount_type'] == 'Variable') ? 'selected' : ''; ?>>Variable (Avg)</option>
                                            </select>
                                            <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-gray-400">
                                                <ion-icon name="chevron-down-outline" class="text-lg"></ion-icon>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Expected Amount / Avg</label>
                                    <div class="relative">
                                        <span class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 text-sm font-bold">£</span>
                                        <input type="number" step="0.01" value="<?php echo $provider['amount']; ?>" class="<?php echo $inputClass; ?> pl-8" placeholder="0.00">
                                    </div>
                                </div>

                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Next Billing Date</label>
                                    <div class="relative">
                                        <input type="date" value="<?php echo $provider['next_bill_date']; ?>" class="<?php echo $inputClass; ?>">
                                    </div>
                                    <p class="text-xs text-gray-500">System will use this to generate OpEx payables.</p>
                                </div>
                                
                                <div class="p-4 bg-orange-50 dark:bg-orange-900/10 rounded-xl border border-orange-100 dark:border-orange-900/30 flex items-start gap-3">
                                    <ion-icon name="notifications-outline" class="text-orange-500 text-xl mt-0.5"></ion-icon>
                                    <div class="flex-1">
                                        <div class="flex items-center justify-between mb-1">
                                            <span class="text-sm font-bold text-gray-800 dark:text-white">Payment Reminder</span>
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="enable_reminder" class="sr-only peer" checked>
                                                <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all dark:border-gray-600 peer-checked:bg-primary"></div>
                                            </label>
                                        </div>
                                        <div class="flex items-center gap-2">
                                            <span class="text-xs text-gray-600 dark:text-gray-400">Remind me</span>
                                            <input type="number" value="<?php echo $provider['reminder_days']; ?>" class="w-16 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-lg py-1 px-2 text-xs font-bold text-center outline-none focus:border-primary">
                                            <span class="text-xs text-gray-600 dark:text-gray-400">days before due date.</span>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <!-- Contract Terms -->
                            <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Contract Terms</h3>
                                
                                <div class="grid grid-cols-2 gap-4">
                                     <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Contract Start</label>
                                        <input type="date" value="<?php echo $provider['contract_start']; ?>" class="<?php echo $inputClass; ?>">
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Contract End</label>
                                        <input type="date" value="<?php echo $provider['contract_end']; ?>" class="<?php echo $inputClass; ?>">
                                    </div>
                                </div>
                                
                                <?php renderConfigToggle("Auto-Renewal enabled", "auto_renew", true); ?>

                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Internal Notes / Terms</label>
                                    <textarea class="<?php echo $inputClass; ?> h-32 resize-none" placeholder="Add details about cancellation policy, account manager contact, etc."><?php echo $provider['notes']; ?></textarea>
                                </div>
                            </div>
                        </div>

                    </div>

                    <!-- TAB: Contact -->
                    <div id="tab-contact" class="tab-content hidden space-y-8 animate-fade-in-up">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                             <!-- Contact Info -->
                            <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Support Channels</h3>
                                <div class="space-y-4">
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Billing/Support Email</label>
                                        <div class="relative group">
                                            <ion-icon name="mail-outline" class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                                            <input type="email" value="<?php echo $provider['contact_email']; ?>" class="<?php echo $inputClass; ?> pl-11" placeholder="support@provider.com">
                                        </div>
                                    </div>

                                     <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Support Phone</label>
                                        <div class="relative group">
                                            <ion-icon name="call-outline" class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                                            <input type="tel" value="<?php echo $provider['support_phone']; ?>" class="<?php echo $inputClass; ?> pl-11" placeholder="+1-800-000-0000">
                                        </div>
                                    </div>
                                    
                                     <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Portal Website</label>
                                        <div class="relative group">
                                            <ion-icon name="globe-outline" class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                                            <input type="url" value="<?php echo $provider['website']; ?>" class="<?php echo $inputClass; ?> pl-11" placeholder="https://console.provider.com">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </form>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    function switchTab(tabId, btn) {
        // Hide all tabs
        document.querySelectorAll('.tab-content').forEach(el => el.classList.add('hidden'));
        // Show target tab
        document.getElementById(tabId).classList.remove('hidden');
        
        // Update buttons
        document.querySelectorAll('.tab-btn').forEach(el => {
            el.classList.remove('active', 'border-primary', 'text-primary');
            el.classList.add('border-transparent', 'text-gray-500', 'dark:text-gray-400');
        });
        
        btn.classList.add('active', 'border-primary', 'text-primary');
        btn.classList.remove('border-transparent', 'text-gray-500', 'dark:text-gray-400');
    }

    function saveProvider() {
        const btn = document.querySelector('button[onclick="saveProvider()"]');
        btn.innerHTML = '<ion-icon name="sync-outline" class="animate-spin text-lg"></ion-icon> Saving...';
        btn.disabled = true;

        setTimeout(() => {
            btn.innerHTML = '<ion-icon name="checkmark-circle-outline" class="text-lg"></ion-icon> Saved!';
            btn.classList.add('bg-emerald-500', 'hover:bg-emerald-600');
            btn.classList.remove('bg-primary', 'hover:bg-orange-600');
            
            showToast('Provider details saved successfully', 'success');
            
            setTimeout(() => {
                window.location.href = 'service_providers.php';
            }, 800);
        }, 1000);
    }
</script>