<?php
include 'includes/session.php';

// Date Logic
$selectedDate = $_GET['date'] ?? date('Y-m-d');
$ts = strtotime($selectedDate);
$startOfWeek = strtotime('monday this week', $ts);
if (date('N', $ts) == 1 && date('Y-m-d', $ts) == date('Y-m-d', $startOfWeek)) {
    // Already Monday
} else if (date('Y-m-d', $ts) < date('Y-m-d', $startOfWeek)) {
    $startOfWeek = strtotime('monday last week', $ts);
}

$weekDates = [];
for ($i = 0; $i < 7; $i++) {
    $currentTs = strtotime("+$i days", $startOfWeek);
    $weekDates[] = [
        'full' => date('Y-m-d', $currentTs),
        'day_name' => date('D', $currentTs),
        'day_num' => date('j', $currentTs),
        'is_today' => date('Y-m-d', $currentTs) === date('Y-m-d')
    ];
}

$prevWeek = date('Y-m-d', strtotime('-7 days', $startOfWeek));
$nextWeek = date('Y-m-d', strtotime('+7 days', $startOfWeek));
$weekRangeText = date('M d', $startOfWeek) . ' - ' . date('M d, Y', strtotime('+6 days', $startOfWeek));

$pageTitle = "Rota Calendar";
$currentPage = "rota";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Reuse helper (Short term reuse, TODO: Move to functions.php)
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    if ($selectedVal === '' && !empty($options)) {
         $valRef = array_keys($options)[0];
         $selectedVal = $valRef;
         $selectedLabel = $options[$valRef];
    }

    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            <div class="p-1 space-y-0.5">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-hidden">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 overflow-y-auto custom-scrollbar">
        <div class="max-w-[1920px] mx-auto w-full flex flex-col space-y-6 pb-12">
        
            <!-- Header & Filters -->
            <div class="glass-panel rounded-2xl p-6 z-20">
                <div class="space-y-6">
                    
                    <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4">
                        <div class="flex items-center gap-4">
                            <div class="w-12 h-12 rounded-2xl bg-primary/10 flex items-center justify-center text-primary">
                                <ion-icon name="calendar" class="text-2xl"></ion-icon>
                            </div>
                            <div>
                                <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Rota Calendar</h1>
                                <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Manage shifts and staffing schedules.</p>
                            </div>
                        </div>
                        <div class="flex items-center gap-3">
                            <button class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-primary hover:border-primary/30 rounded-xl text-sm font-bold transition-all shadow-sm flex items-center gap-2">
                                <ion-icon name="download-outline" class="text-lg"></ion-icon>
                                <span>Export</span>
                            </button>
                            <button onclick="openModal('shiftModal')" class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                                <ion-icon name="add-circle-outline" class="text-lg"></ion-icon>
                                <span>Create Shift</span>
                            </button>
                        </div>
                    </div>

                    <!-- Controls -->
                    <div class="flex flex-wrap items-center gap-4">
                        <!-- Store Selector -->
                        <div class="w-full md:w-64">
                            <?php 
                                echo renderCustomSelect('Select Store', 'store_id', [
                                    '1001' => 'FNF Cardiff',
                                    '1002' => 'FNF Swansea'
                                ], '1001'); 
                            ?>
                        </div>

                        <div class="h-8 w-px bg-gray-200 dark:bg-gray-700 hidden md:block"></div>

                        <!-- Date Nav -->
                        <div class="flex items-center gap-1 bg-gray-50 dark:bg-slate-800/50 p-1.5 rounded-xl border border-gray-100 dark:border-gray-700">
                            <a href="?date=<?php echo $prevWeek; ?>" class="p-2 hover:bg-white dark:hover:bg-slate-700 rounded-lg transition-all text-gray-600 dark:text-gray-400 hover:text-primary shadow-sm" title="Previous Week">
                                <ion-icon name="chevron-back-outline"></ion-icon>
                            </a>
                            <div class="px-4 flex flex-col items-center">
                                <span class="font-bold text-sm text-gray-800 dark:text-white"><?php echo $weekRangeText; ?></span>
                            </div>
                            <a href="?date=<?php echo $nextWeek; ?>" class="p-2 hover:bg-white dark:hover:bg-slate-700 rounded-lg transition-all text-gray-600 dark:text-gray-400 hover:text-primary shadow-sm" title="Next Week">
                                <ion-icon name="chevron-forward-outline"></ion-icon>
                            </a>
                        </div>
                        
                        <a href="?date=<?php echo date('Y-m-d'); ?>" class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-primary hover:border-primary/30 rounded-xl text-sm font-bold transition-all shadow-sm">
                            Today
                        </a>
                    </div>
                </div>
            </div>

            <!-- Calendar Grid -->
            <div class="overflow-x-auto custom-scrollbar glass-panel rounded-2xl border-none p-0 relative">
                <div class="min-w-[1400px]">
                    
                    <!-- Table Header -->
                    <div class="grid grid-cols-[280px_repeat(7,1fr)] sticky top-0 bg-white/95 dark:bg-slate-800/95 backdrop-blur-md z-30 border-b border-gray-100 dark:border-gray-700/50">
                        <div class="py-5 px-6 font-bold text-gray-400 dark:text-gray-500 text-[10px] uppercase tracking-[0.15em] flex items-center">
                            Employee
                            <ion-icon name="funnel-outline" class="ml-2 text-xs opacity-50"></ion-icon>
                        </div>
                        <?php foreach($weekDates as $date): ?>
                        <div class="py-5 text-center transition-colors <?php echo $date['is_today'] ? 'bg-primary/[0.03] dark:bg-primary/[0.05]' : ''; ?> border-l border-gray-50 dark:border-gray-700/30 first:border-l-0">
                            <span class="block text-sm font-bold <?php echo $date['is_today'] ? 'text-primary' : 'text-gray-500 dark:text-gray-400'; ?>">
                                <?php echo $date['day_name'] . ' ' . $date['day_num']; ?>
                            </span>
                        </div>
                        <?php endforeach; ?>
                    </div>

                    <!-- Table Body -->
                    <div class="divide-y divide-gray-50 dark:divide-gray-700/30">
                        <?php 
                        // Mock Staff with specialized shift logic
                        $staff = [
                            ['name' => 'John Doe', 'role' => 'Store Manager', 'avatar' => 'JD', 'color' => 'orange'],
                            ['name' => 'Sarah Smith', 'role' => 'Senior Cashier', 'avatar' => 'SS', 'color' => 'blue'],
                            ['name' => 'Mike Jones', 'role' => 'Shift Lead', 'avatar' => 'MJ', 'color' => 'purple'],
                            ['name' => 'Emma Wilson', 'role' => 'Sales Associate', 'avatar' => 'EW', 'color' => 'green'],
                            ['name' => 'David Brown', 'role' => 'Kitchen Staff', 'avatar' => 'DB', 'color' => 'amber'],
                        ];

                        foreach($staff as $emp):
                        ?>
                        <div class="grid grid-cols-[280px_repeat(7,1fr)] hover:bg-gray-50/50 dark:hover:bg-slate-700/20 transition-all group">
                            
                            <!-- Employee Info -->
                            <div class="p-4 px-6 flex items-center gap-4 border-r border-gray-50 dark:border-gray-700/30">
                                <div class="relative">
                                    <div class="w-12 h-12 rounded-xl bg-gray-100 dark:bg-slate-700 flex items-center justify-center text-sm font-bold text-gray-600 dark:text-gray-300 shadow-sm overflow-hidden group-hover:scale-105 transition-transform">
                                        <?php echo $emp['avatar']; ?>
                                    </div>
                                    <div class="absolute -bottom-1 -right-1 w-4 h-4 rounded-full border-2 border-white dark:border-slate-800 bg-green-500"></div>
                                </div>
                                <div class="min-w-0">
                                    <div class="font-bold text-sm text-gray-800 dark:text-white truncate"><?php echo $emp['name']; ?></div>
                                    <div class="text-[11px] text-gray-500 dark:text-gray-400 font-medium"><?php echo $emp['role']; ?></div>
                                </div>
                            </div>

                            <!-- Shift Cells -->
                            <?php foreach($weekDates as $index => $date): 
                                // Enhanced shift logic to support split shifts
                                $dayShifts = [];
                                
                                // Example: Split shift for John Doe on Monday (index 0)
                                if ($emp['name'] == 'John Doe' && $index == 0) {
                                    $dayShifts[] = ['start' => '09:00', 'end' => '11:00', 'area' => 'Office', 'hours' => '2h'];
                                    $dayShifts[] = ['start' => '19:00', 'end' => '21:00', 'area' => 'Floor', 'hours' => '2h'];
                                } else {
                                    // Regular shifts
                                    $hasShift = ($emp['color'] == 'orange' && $index < 5) || ($emp['color'] == 'blue' && $index >= 2);
                                    if ($hasShift) {
                                        $dayShifts[] = ['start' => '09:00', 'end' => '17:00', 'area' => 'Main Floor', 'hours' => '8h'];
                                    }
                                }

                                $isToday = $date['is_today'];
                            ?>
                            <div class="p-2 border-r border-gray-50 dark:border-gray-700/30 last:border-0 relative min-h-[120px] <?php echo $isToday ? 'bg-primary/[0.01] dark:bg-primary/[0.02]' : ''; ?> flex flex-col gap-2">
                                <?php if(!empty($dayShifts)): 
                                    foreach($dayShifts as $shift):
                                        $themeColor = $emp['color'];
                                        $bgMap = [
                                            'orange' => 'bg-orange-50 dark:bg-orange-500/10 border-orange-200 dark:border-orange-500/30 text-orange-600 dark:text-orange-400',
                                            'blue' => 'bg-blue-50 dark:bg-blue-500/10 border-blue-200 dark:border-blue-500/30 text-blue-600 dark:text-blue-400',
                                            'purple' => 'bg-purple-50 dark:bg-purple-500/10 border-purple-200 dark:border-purple-500/30 text-purple-600 dark:text-purple-400',
                                            'green' => 'bg-green-50 dark:bg-green-500/10 border-green-200 dark:border-green-500/30 text-green-600 dark:text-green-400',
                                            'amber' => 'bg-amber-50 dark:bg-amber-500/10 border-amber-200 dark:border-amber-500/30 text-amber-600 dark:text-amber-400',
                                        ];
                                        $style = $bgMap[$themeColor] ?? $bgMap['orange'];
                                ?>
                                <div class="flex-shrink-0 w-full rounded-xl border <?php echo $style; ?> p-3 text-xs cursor-pointer hover:shadow-xl hover:shadow-gray-200/40 dark:hover:shadow-black/40 transition-all flex flex-col justify-between group/shift" onclick="openModal('shiftModal')">
                                    <div class="flex flex-col gap-0.5">
                                        <div class="font-bold text-[13px]"><?php echo $shift['start'] . ' - ' . $shift['end']; ?></div>
                                        <div class="opacity-70 font-medium"><?php echo $shift['area']; ?></div>
                                    </div>
                                    <div class="flex justify-between items-center mt-2 pt-2 border-t border-current/10 opacity-60 font-medium">
                                        <span class="flex items-center gap-1">
                                            <ion-icon name="time-outline"></ion-icon> <?php echo $shift['hours']; ?>
                                        </span>
                                        <ion-icon name="restaurant-outline" class="text-sm"></ion-icon>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                                
                                <button class="w-full py-1.5 rounded-lg border border-dashed border-gray-200 dark:border-gray-700 text-gray-400 hover:text-primary hover:border-primary/30 hover:bg-primary/5 transition-all text-[10px] font-bold opacity-0 group-hover:opacity-100 mt-auto" onclick="openModal('shiftModal')">
                                    ADD SHIFT
                                </button>
                                
                                <?php else: ?>
                                <div class="h-full w-full flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity">
                                    <button class="w-9 h-9 rounded-xl bg-white dark:bg-slate-700 text-gray-400 hover:bg-primary hover:text-white shadow-sm border border-gray-100 dark:border-gray-600 transition-all transform hover:scale-110 flex items-center justify-center" onclick="openModal('shiftModal')">
                                        <ion-icon name="add" class="text-xl"></ion-icon>
                                    </button>
                                </div>
                                <?php endif; ?>
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    </div>

    <!-- Create/Edit Shift Modal -->
    <div id="shiftModal" class="fixed inset-0 z-[100] hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="fixed inset-0 bg-slate-900/40 backdrop-blur-md transition-opacity opacity-0 duration-300" id="modalBackdrop"></div>
        <div class="fixed inset-0 z-10 overflow-y-auto">
            <div class="flex min-h-full items-end justify-center p-4 text-center sm:items-center sm:p-0">
                <div class="relative transform overflow-hidden rounded-[2rem] bg-white dark:bg-slate-900 text-left shadow-2xl transition-all sm:my-8 sm:w-full sm:max-w-xl opacity-0 translate-y-8 duration-300 border border-white/20 dark:border-gray-800" id="modalPanel">
                    
                    <div class="px-8 pt-8 pb-6 border-b border-gray-50 dark:border-gray-800/50">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 rounded-2xl bg-primary/10 flex items-center justify-center text-primary">
                                    <ion-icon name="time" class="text-2xl"></ion-icon>
                                </div>
                                <div>
                                    <h3 class="text-2xl font-bold text-gray-900 dark:text-white" id="modal-title">Manage Shift</h3>
                                    <p class="text-gray-500 dark:text-gray-400 text-sm mt-0.5">Define shift timings and assignments.</p>
                                </div>
                            </div>
                            <button onclick="closeModal('shiftModal')" class="w-10 h-10 rounded-xl bg-gray-50 dark:bg-slate-800 text-gray-400 hover:text-primary hover:bg-primary/5 transition-all flex items-center justify-center">
                                <ion-icon name="close-outline" class="text-2xl"></ion-icon>
                            </button>
                        </div>
                    </div>

                    <div class="p-8 space-y-6">
                        
                        <div class="space-y-2">
                             <label class="text-xs font-bold text-gray-500 dark:text-gray-400 ml-1 uppercase tracking-wider">Assign Employee</label>
                             <?php 
                                echo renderCustomSelect('Select Employee', 'shift_emp', [
                                    '1' => 'John Doe (Store Manager)',
                                    '2' => 'Sarah Smith (Senior Cashier)',
                                    '3' => 'Mike Jones (Shift Lead)'
                                ], '1'); 
                            ?>
                        </div>

                        <div class="grid grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-xs font-bold text-gray-500 dark:text-gray-400 ml-1 uppercase tracking-wider">Date</label>
                                <div class="relative">
                                    <input type="hidden" id="shift_date" name="shift_date" value="<?php echo date('Y-m-d'); ?>">
                                    <?php 
                                        $pickerId = 'shift_date_picker'; 
                                        $urlParam = 'shift_date';
                                        $showApplyButton = false;
                                        $autoApply = true;
                                        $btnClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between cursor-pointer";
                                        include 'includes/components/date_picker.php'; 
                                    ?>
                                </div>
                            </div>
                            <script>
                                function handleDateChange(date, pickerId) {
                                    if (pickerId === 'shift_date_picker') {
                                        document.getElementById('shift_date').value = date;
                                    }
                                }
                            </script>
                            <div class="space-y-2">
                                <label class="text-xs font-bold text-gray-500 dark:text-gray-400 ml-1 uppercase tracking-wider">Break (Minutes)</label>
                                <div class="relative">
                                    <input type="number" class="<?php echo $inputClass; ?>" value="30" placeholder="0">
                                    <div class="absolute inset-y-0 right-4 flex items-center pointer-events-none text-gray-400">
                                        <ion-icon name="restaurant-outline"></ion-icon>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-xs font-bold text-gray-500 dark:text-gray-400 ml-1 uppercase tracking-wider">Start Time</label>
                                <div class="relative">
                                    <?php 
                                        $pickerId = 'start_time'; 
                                        $value = '09:00';
                                        $nextPickerId = 'end_time';
                                        include 'includes/components/time_picker.php'; 
                                    ?>
                                </div>
                            </div>
                            <div class="space-y-2">
                                <label class="text-xs font-bold text-gray-500 dark:text-gray-400 ml-1 uppercase tracking-wider">End Time</label>
                                <div class="relative">
                                    <?php 
                                        $pickerId = 'end_time'; 
                                        $value = '17:00';
                                        include 'includes/components/time_picker.php'; 
                                    ?>
                                </div>
                            </div>
                        </div>

                         <div class="space-y-2">
                            <label class="text-xs font-bold text-gray-500 dark:text-gray-400 ml-1 uppercase tracking-wider">Shift Notes</label>
                            <textarea rows="3" class="<?php echo $inputClass; ?> resize-none" placeholder="Any specific duties or instructions for this shift..."></textarea>
                        </div>

                    </div>

                    <div class="bg-gray-50 dark:bg-slate-800/50 p-8 sm:flex sm:flex-row-reverse gap-3">
                        <button type="button" class="px-8 py-3 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2" onclick="closeModal('shiftModal'); showToast('Shift saved successfully', 'success')">
                            <ion-icon name="save-outline" class="text-lg"></ion-icon>
                            <span>Save Shift</span>
                        </button>
                        <button type="button" class="px-6 py-3 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-slate-700 rounded-xl text-sm font-bold transition-all" onclick="closeModal('shiftModal')">Cancel</button>
                        <button type="button" class="mt-3 sm:mt-0 sm:mr-auto px-4 py-3 text-red-500 hover:text-red-600 dark:text-red-400 dark:hover:text-red-300font-bold text-sm transition-all flex items-center gap-2" onclick="if(confirm('Delete this shift?')) { closeModal('shiftModal'); showToast('Shift deleted', 'info'); }">
                            <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                            <span>Delete</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>

    <!-- Scripts -->
    <script>
        function initRotaPage() {
            if (!document.querySelector('.custom-select-trigger')) return;
            initCustomSelects(); 
        }

        // Support both initial load and SPA transitions
        document.addEventListener('DOMContentLoaded', initRotaPage);

        if (!window.rota_initialized) {
            document.addEventListener('pageLoaded', (e) => {
                if (e.detail.url.includes('rota.php')) {
                    initRotaPage();
                }
            });
            window.rota_initialized = true;
        }

       // Global Modal Functions
       window.openModal = function(modalId) {
            const modal = document.getElementById(modalId);
            if (!modal) return;
            const backdrop = modal.querySelector('#modalBackdrop');
            const panel = modal.querySelector('#modalPanel');
            
            modal.classList.remove('hidden');
            document.body.style.overflow = 'hidden';
            
            setTimeout(() => {
                backdrop?.classList.replace('opacity-0', 'opacity-100');
                if(panel) {
                    panel.classList.replace('opacity-0', 'opacity-100');
                    panel.classList.replace('translate-y-8', 'translate-y-0');
                }
            }, 50);
        }

        window.closeModal = function(modalId) {
            const modal = document.getElementById(modalId);
            if (!modal) return;
            const backdrop = modal.querySelector('#modalBackdrop');
            const panel = modal.querySelector('#modalPanel');

            backdrop?.classList.replace('opacity-100', 'opacity-0');
            if(panel) {
                panel.classList.replace('opacity-100', 'opacity-0');
                panel.classList.replace('translate-y-0', 'translate-y-8');
            }

            setTimeout(() => {
                modal.classList.add('hidden');
                document.body.style.overflow = 'auto';
            }, 300);
        }

        function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                if (trigger.dataset.initialized) return;
                trigger.dataset.initialized = "true";

                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron && !dropdown.classList.contains('invisible')) {
                        chevron.classList.add('rotate-180');
                        chevron.classList.add('text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                if (option.dataset.initialized) return;
                option.dataset.initialized = "true";

                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');

                    const event = new Event('change', { bubbles: true });
                    hiddenInput.dispatchEvent(event);
                });
            });

            if (!document.dataset_select_listener) {
                document.addEventListener('click', () => closeAllSelects());
                document.dataset_select_listener = "true";
            }
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }
    </script>
</main>
<?php require_once 'includes/footer.php'; ?>
