<?php
include 'includes/session.php';
$pageTitle = "Roles Management";
$currentPage = "roles";
require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Mock Data
$roles = [
    [
        'id' => 1,
        'name' => 'Superadmin',
        'scope' => 'Global',
        'users_count' => 3,
        'updated' => '2025-12-10',
        'is_system' => true
    ],
    [
        'id' => 2,
        'name' => 'Store Manager',
        'scope' => 'Store Specific',
        'users_count' => 12,
        'updated' => '2026-01-10',
        'is_system' => false
    ],
    [
        'id' => 3,
        'name' => 'Cashier',
        'scope' => 'Store Specific',
        'users_count' => 45,
        'updated' => '2026-01-15',
        'is_system' => false
    ],
    [
        'id' => 4,
        'name' => 'Inventory Manager',
        'scope' => 'Global',
        'users_count' => 2,
        'updated' => '2026-01-05',
        'is_system' => false
    ]
];

// KPI Calculations
$totalRoles = count($roles);
$systemRoles = count(array_filter($roles, fn($r) => $r['is_system']));
$customRoles = $totalRoles - $systemRoles;
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full custom-scrollbar">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20 space-y-8">

        <!-- Header Alignment Refined (Strictly per stores.php) -->
        <div
            class="glass-panel rounded-2xl p-6 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-50 overflow-visible">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Roles</h1>
                <p class="text-gray-500 dark:text-gray-400 mt-1 text-sm">Define and configure system access levels.
                </p>
            </div>

            <!-- Controls Bar Alignment (as per stores.php) -->
            <div
                class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">

                <!-- Search (Transparent) -->
                <div class="relative group w-full sm:w-48 shrink-0">
                    <ion-icon name="search-outline"
                        class="absolute left-2.5 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                    <input type="text" id="role-search-header"
                        class="pl-8 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium bg-transparent"
                        placeholder="Search...">
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Scope Filter (Matching store Type filter) -->
                <div class="relative">
                    <button
                        class="flex items-center gap-2 px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 rounded-lg text-sm text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white transition-all border border-transparent hover:border-gray-200 dark:hover:border-gray-600 min-w-[120px] justify-between group">
                        <div class="flex items-center gap-2">
                            <ion-icon name="filter-outline"
                                class="text-gray-400 text-lg group-hover:text-primary"></ion-icon>
                            <span class="font-medium">All Scopes</span>
                        </div>
                        <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 h-3 w-3"></ion-icon>
                    </button>
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Create (Match store style) -->
                <a href="role_create.php"
                    class="flex items-center gap-2 px-3 py-2 text-primary font-bold text-sm hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors shrink-0 whitespace-nowrap">
                    <ion-icon name="add-circle-outline" class="text-lg"></ion-icon>
                    <span>Create</span>
                </a>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Export (Primary) -->
                <button
                    class="flex items-center gap-2 px-4 py-2 bg-primary hover:bg-orange-600 text-white text-sm font-bold rounded-lg shadow-lg shadow-orange-500/30 transition-all transform hover:-translate-y-0.5 shrink-0 ml-1">
                    <ion-icon name="download-outline"></ion-icon>
                    <span>Export</span>
                </button>
            </div>
        </div>

        <!-- KPI Cards -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Total Roles -->
            <div class="glass-panel p-6 rounded-2xl relative overflow-hidden group">
                <div
                    class="absolute -right-4 -top-4 w-24 h-24 bg-orange-500/10 rounded-full blur-2xl group-hover:bg-orange-500/20 transition-colors">
                </div>
                <div class="flex items-center gap-4 relative">
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-orange-400 to-orange-600 flex items-center justify-center text-white shadow-lg shadow-orange-500/20">
                        <ion-icon name="shield-checkmark-outline" class="text-2xl"></ion-icon>
                    </div>
                    <div>
                        <p class="text-xs font-bold text-gray-400 uppercase tracking-widest">Total Roles</p>
                        <h3 class="text-2xl font-black text-gray-800 dark:text-white mt-0.5">
                            <?php echo $totalRoles; ?>
                        </h3>
                    </div>
                </div>
            </div>

            <!-- System Roles -->
            <div class="glass-panel p-6 rounded-2xl relative overflow-hidden group border-l-4 border-blue-500">
                <div
                    class="absolute -right-4 -top-4 w-24 h-24 bg-blue-500/10 rounded-full blur-2xl group-hover:bg-blue-500/20 transition-colors">
                </div>
                <div class="flex items-center gap-4 relative">
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center text-white shadow-lg shadow-blue-500/20">
                        <ion-icon name="lock-closed-outline" class="text-2xl"></ion-icon>
                    </div>
                    <div>
                        <p class="text-xs font-bold text-gray-400 uppercase tracking-widest">System Locked</p>
                        <h3 class="text-2xl font-black text-gray-800 dark:text-white mt-0.5">
                            <?php echo $systemRoles; ?>
                        </h3>
                    </div>
                </div>
            </div>

            <!-- Custom Roles -->
            <div class="glass-panel p-6 rounded-2xl relative overflow-hidden group border-l-4 border-purple-500">
                <div
                    class="absolute -right-4 -top-4 w-24 h-24 bg-purple-500/10 rounded-full blur-2xl group-hover:bg-purple-500/20 transition-colors">
                </div>
                <div class="flex items-center gap-4 relative">
                    <div
                        class="w-12 h-12 rounded-xl bg-gradient-to-br from-purple-400 to-purple-600 flex items-center justify-center text-white shadow-lg shadow-purple-500/20">
                        <ion-icon name="color-palette-outline" class="text-2xl"></ion-icon>
                    </div>
                    <div>
                        <p class="text-xs font-bold text-gray-400 uppercase tracking-widest">Custom Roles</p>
                        <h3 class="text-2xl font-black text-gray-800 dark:text-white mt-0.5">
                            <?php echo $customRoles; ?>
                        </h3>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content Area -->
        <div
            class="glass-panel rounded-3xl overflow-hidden shadow-xl shadow-gray-200/50 dark:shadow-none border border-white/20">

            <!-- Table Controls/Filters Removed: Logic moved to refined Header as per stores.php pattern -->

            <!-- Roles Table -->
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse min-w-[800px]">
                    <thead>
                        <tr class="bg-gray-50/50 dark:bg-slate-800/30">
                            <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest relative group cursor-pointer"
                                onclick="toggleSearchPopup('searchPopup-name')">
                                <div class="flex items-center justify-between">
                                    <span>Role Identity</span>
                                    <ion-icon name="filter-outline"
                                        class="text-gray-400 group-hover:text-orange-500 transition-colors"></ion-icon>
                                </div>
                                <!-- Search Popup Placeholder (consistent with products.php type) -->
                                <div id="searchPopup-name"
                                    class="absolute top-full left-0 mt-2 w-[240px] glass-panel p-3 z-50 invisible opacity-0 transform translate-y-2 transition-all duration-200 shadow-2xl">
                                    <div class="relative">
                                        <input type="text" id="input-name"
                                            class="w-full bg-white dark:bg-slate-700 border border-gray-100 dark:border-gray-600 rounded-lg px-3 py-2 text-xs outline-none focus:ring-2 focus:ring-orange-500"
                                            placeholder="Filter role name...">
                                    </div>
                                    <div class="flex gap-2 mt-3">
                                        <button onclick="applyTextFilter('name')"
                                            class="flex-1 py-1.5 bg-orange-500 text-white rounded-lg text-[10px] font-bold uppercase transition-all hover:bg-orange-600">Apply</button>
                                        <button onclick="clearTextFilter('name')"
                                            class="flex-1 py-1.5 bg-gray-100 dark:bg-slate-600 text-gray-500 dark:text-gray-300 rounded-lg text-[10px] font-bold uppercase transition-all hover:bg-gray-200">Clear</button>
                                    </div>
                                </div>
                            </th>
                            <th
                                class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">
                                Scope</th>
                            <th
                                class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-center">
                                Users</th>
                            <th
                                class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">
                                Last Updated</th>
                            <th
                                class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">
                                Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-gray-700/50">
                        <?php foreach ($roles as $role): ?>
                            <tr class="group hover:bg-orange-500/[0.02] transition-colors cursor-pointer pr-row"
                                data-name="<?php echo strtolower($role['name']); ?>">
                                <td class="py-5 px-6">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-12 h-12 rounded-2xl bg-orange-100/50 dark:bg-orange-900/20 text-orange-600 dark:text-orange-400 flex items-center justify-center text-xl font-black transition-transform group-hover:scale-110 shadow-sm border border-orange-500/10">
                                            <?php echo substr($role['name'], 0, 1); ?>
                                        </div>
                                        <div>
                                            <div
                                                class="text-sm font-bold text-gray-800 dark:text-white group-hover:text-orange-500 transition-colors">
                                                <?php echo $role['name']; ?>
                                            </div>
                                            <?php if ($role['is_system']): ?>
                                                <div class="flex items-center gap-1.5 mt-0.5">
                                                    <ion-icon name="lock-closed" class="text-[10px] text-blue-500"></ion-icon>
                                                    <span
                                                        class="text-[10px] text-blue-500 font-bold uppercase tracking-wider">System
                                                        Immutable</span>
                                                </div>
                                            <?php else: ?>
                                                <div class="text-[10px] text-gray-400 uppercase tracking-widest mt-0.5">
                                                    Custom Security Profile</div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-5 px-6">
                                    <span
                                        class="inline-flex items-center px-3 py-1 rounded-lg text-[10px] font-black uppercase tracking-widest <?php echo $role['scope'] == 'Global' ? 'bg-purple-100/80 text-purple-700 dark:bg-purple-900/30 dark:text-purple-400 border border-purple-500/20' : 'bg-blue-100/80 text-blue-700 dark:bg-blue-900/30 dark:text-blue-400 border border-blue-500/20'; ?>">
                                        <ion-icon
                                            name="<?php echo $role['scope'] == 'Global' ? 'earth-outline' : 'business-outline'; ?>"
                                            class="mr-1.5 text-xs"></ion-icon>
                                        <?php echo $role['scope']; ?>
                                    </span>
                                </td>
                                <td class="py-5 px-6 text-center">
                                    <div
                                        class="inline-flex items-center px-2.5 py-1 bg-gray-50 dark:bg-slate-800/80 rounded-lg text-sm font-mono font-bold text-gray-700 dark:text-gray-300 border border-gray-100 dark:border-gray-700">
                                        <?php echo str_pad($role['users_count'], 2, '0', STR_PAD_LEFT); ?>
                                    </div>
                                </td>
                                <td class="py-5 px-6">
                                    <div class="flex flex-col">
                                        <span
                                            class="text-sm font-bold text-gray-700 dark:text-gray-300"><?php echo date('d M Y', strtotime($role['updated'])); ?></span>
                                        <span class="text-[10px] text-gray-400 uppercase tracking-widest mt-0.5">Last
                                            Modification</span>
                                    </div>
                                </td>
                                <td class="py-5 px-6 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                        <a href="permission_editor.php?type=role&id=<?php echo $role['id']; ?>"
                                            class="w-9 h-9 flex items-center justify-center bg-gray-50 dark:bg-slate-800 text-gray-600 dark:text-gray-400 rounded-xl hover:bg-orange-500 hover:text-white dark:hover:bg-orange-600 transition-all active:scale-90 shadow-sm"
                                            title="Configure Permissions">
                                            <ion-icon name="key-outline" class="text-lg"></ion-icon>
                                        </a>
                                        <?php if (!$role['is_system']): ?>
                                            <button
                                                class="w-9 h-9 flex items-center justify-center bg-gray-50 dark:bg-slate-800 text-red-500 dark:text-red-400 rounded-xl hover:bg-red-500 hover:text-white transition-all active:scale-90 shadow-sm"
                                                title="Delete Role">
                                                <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination Placeholder (Consistent with premium tables) -->
            <div class="p-6 border-t border-gray-100 dark:border-gray-700/50 flex items-center justify-between">
                <span class="text-xs font-bold text-gray-400 uppercase tracking-widest">Showing
                    <?php echo $totalRoles; ?> of <?php echo $totalRoles; ?> roles</span>
                <div class="flex gap-2">
                    <button
                        class="w-9 h-9 rounded-xl bg-gray-50 dark:bg-slate-800 text-gray-400 flex items-center justify-center cursor-not-allowed border border-gray-100 dark:border-gray-700"
                        disabled>
                        <ion-icon name="chevron-back"></ion-icon>
                    </button>
                    <button
                        class="w-9 h-9 rounded-xl bg-gray-50 dark:bg-slate-800 text-gray-400 flex items-center justify-center cursor-not-allowed border border-gray-100 dark:border-gray-700"
                        disabled>
                        <ion-icon name="chevron-forward"></ion-icon>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    function toggleSearchPopup(id) {
        const popup = document.getElementById(id);
        const allPopups = document.querySelectorAll('[id^="searchPopup-"]');

        allPopups.forEach(p => {
            if (p.id !== id) {
                p.classList.add('invisible', 'opacity-0', 'translate-y-2');
            }
        });

        if (popup.classList.contains('invisible')) {
            popup.classList.remove('invisible', 'opacity-0', 'translate-y-2');
        } else {
            popup.classList.add('invisible', 'opacity-0', 'translate-y-2');
        }
    }

    function applyTextFilter(column) {
        const input = document.getElementById(`input-${column}`).value.toLowerCase();
        const rows = document.querySelectorAll('.pr-row');

        rows.forEach(row => {
            const val = row.getAttribute(`data-${column}`);
            if (val.includes(input)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });

        toggleSearchPopup(`searchPopup-${column}`);
    }

    function clearTextFilter(column) {
        document.getElementById(`input-${column}`).value = '';
        const rows = document.querySelectorAll('.pr-row');
        rows.forEach(row => row.style.display = '');
        toggleSearchPopup(`searchPopup-${column}`);
    }

    // Global search
    document.getElementById('role-search-header').addEventListener('input', function (e) {
        const term = e.target.value.toLowerCase();
        const rows = document.querySelectorAll('.pr-row');

        rows.forEach(row => {
            const content = row.innerText.toLowerCase();
            if (content.includes(term)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });

    // Close popups on click outside
    document.addEventListener('click', function (e) {
        if (!e.target.closest('th') && !e.target.closest('[id^="searchPopup-"]')) {
            const allPopups = document.querySelectorAll('[id^="searchPopup-"]');
            allPopups.forEach(p => p.classList.add('invisible', 'opacity-0', 'translate-y-2'));
        }
    });
</script>