<?php
include 'includes/session.php';
$pageTitle = "Reservation Rules";
$currentPage = "reservation_rules";
require_once 'includes/header.php';
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

// Custom Select Helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    // Identify selected label
    $selectedLabel = $label; // Default fallback
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    // If no specific selection, use first
    if ($selectedVal === '' && !empty($options)) {
        $selectedVal = array_key_first($options);
        $selectedLabel = $options[$selectedVal];
    }

    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            <div class="p-1 space-y-0.5">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col sm:flex-row sm:items-center justify-between gap-6 relative z-20 mb-6">
                <div class="flex items-center gap-4">
                    <div class="h-12 w-12 rounded-xl bg-gradient-to-br from-orange-500 to-orange-600 flex items-center justify-center shadow-lg shadow-orange-500/30 text-white">
                        <ion-icon name="calendar-number-outline" class="text-2xl"></ion-icon>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Reservation Rules</h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm font-medium">Configure booking policies, deposits, and intervals.</p>
                    </div>
                </div>

                <div class="flex gap-3">
                     <button type="submit" form="rulesForm" class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-xl"></ion-icon>
                        <span>Save Changes</span>
                    </button>
                </div>
            </div>


            <!-- Main Form Card -->
            <div class="glass-panel rounded-2xl animate-fade-in-up">
                
                <!-- Tabs Header -->
                <div class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 px-6 pt-4 rounded-t-2xl">
                    <div class="flex gap-6 overflow-x-auto custom-scrollbar" id="formTabs">
                        <button type="button" class="tab-btn active pb-4 px-2 text-sm font-semibold border-b-2 border-primary text-primary transition-colors whitespace-nowrap" data-target="tab-general">
                            General Info
                        </button>
                        <button type="button" class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-restrictions">
                            Restrictions
                        </button>
                        <button type="button" class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-notifications">
                            Notifications
                        </button>
                        <button type="button" class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-deposits">
                            Deposits & Cancellation
                        </button>
                    </div>
                </div>

                <!-- Form Content -->
                <form id="rulesForm" class="p-6 md:p-8">

                
                    <!-- TAB: General Settings -->
                    <div id="tab-general" class="tab-content space-y-6">
                        <div class="space-y-4">
                            <h3 class="text-lg font-bold text-gray-800 dark:text-white border-b border-gray-100 dark:border-gray-700 pb-2">General Policies</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Booking Interval</label>
                                    <?php 
                                        echo renderCustomSelect('Select Interval', 'booking_interval', [
                                            '15' => '15 Minutes',
                                            '30' => '30 Minutes',
                                            '60' => '60 Minutes'
                                        ], '30'); 
                                    ?>
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Default Duration</label>
                                     <?php 
                                        echo renderCustomSelect('Select Duration', 'default_duration', [
                                            '90' => '90 Minutes',
                                            '120' => '2 Hours',
                                            '150' => '2.5 Hours'
                                        ], '120'); 
                                    ?>
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Turnover Time (Buffer)</label>
                                     <?php 
                                        echo renderCustomSelect('Select Buffer', 'turnover_time', [
                                            '0' => 'None',
                                            '15' => '15 Minutes',
                                            '30' => '30 Minutes'
                                        ], '15'); 
                                    ?>
                                    <p class="text-xs text-gray-400 mt-1 pl-1">Time allowed to clean table between bookings.</p>
                                </div>
                            </div>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Max Party Size (Online)</label>
                                    <input type="number" class="<?php echo $inputClass; ?>" value="8">
                                    <p class="text-xs text-gray-400 mt-1 pl-1">Parties larger than this must call to book.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: Restrictions -->
                    <div id="tab-restrictions" class="tab-content hidden space-y-6">
                         <div class="space-y-4">
                            <h3 class="text-lg font-bold text-gray-800 dark:text-white border-b border-gray-100 dark:border-gray-700 pb-2">Booking Constraints</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="space-y-4">
                                     <div>
                                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Min. Lead Time</label>
                                        <?php 
                                            echo renderCustomSelect('Select Lead Time', 'min_lead_time', [
                                                '0' => 'No Restriction',
                                                '30' => '30 Minutes',
                                                '60' => '1 Hour',
                                                '120' => '2 Hours',
                                                '1440' => '24 Hours'
                                            ], '60'); 
                                        ?>
                                        <p class="text-xs text-gray-400 mt-1 pl-1">How soon before arrival can a guest book?</p>
                                     </div>
                                     <div>
                                         <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Late Arrival Hold Time</label>
                                        <?php 
                                            echo renderCustomSelect('Select Hold Time', 'hold_time', [
                                                '10' => '10 Minutes',
                                                '15' => '15 Minutes',
                                                '20' => '20 Minutes',
                                                '30' => '30 Minutes'
                                            ], '15'); 
                                        ?>
                                        <p class="text-xs text-gray-400 mt-1 pl-1">Time to hold table before releasing.</p>
                                     </div>
                                </div>

                                <div class="space-y-4">
                                     <div>
                                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Max Advance Booking</label>
                                        <?php 
                                            echo renderCustomSelect('Select Advance Booking', 'max_advance_booking', [
                                                '30' => '30 Days',
                                                '60' => '60 Days',
                                                '90' => '90 Days',
                                                '180' => '6 Months',
                                                '365' => '1 Year'
                                            ], '90'); 
                                        ?>
                                        <p class="text-xs text-gray-400 mt-1 pl-1">How far in the future can guests book?</p>
                                     </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: Notifications -->
                    <div id="tab-notifications" class="tab-content hidden space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            <!-- Customer Notifications -->
                            <div class="space-y-4">
                                <h3 class="text-lg font-bold text-gray-800 dark:text-white border-b border-gray-100 dark:border-gray-700 pb-2">Customer Alerts</h3>
                                
                                <div class="space-y-3">
                                    <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700">
                                        <span class="font-bold text-gray-700 dark:text-gray-300 text-sm">Email Confirmation</span>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" class="sr-only peer" checked>
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary"></div>
                                        </label>
                                    </div>
                                    <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700">
                                        <span class="font-bold text-gray-700 dark:text-gray-300 text-sm">SMS Confirmation</span>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" class="sr-only peer">
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary"></div>
                                        </label>
                                    </div>
                                    
                                     <div class="pt-2">
                                         <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Booking Reminder</label>
                                         <?php 
                                            echo renderCustomSelect('Select Reminder', 'booking_reminder', [
                                                'disabled' => 'Disabled',
                                                '2h' => '2 Hours Before',
                                                '24h' => '24 Hours Before',
                                                '48h' => '48 Hours Before'
                                            ], '24h'); 
                                        ?>
                                     </div>
                                </div>
                            </div>

                            <!-- Admin Notifications -->
                             <div class="space-y-4">
                                <h3 class="text-lg font-bold text-gray-800 dark:text-white border-b border-gray-100 dark:border-gray-700 pb-2">Admin Alerts</h3>
                                
                                <div class="space-y-3">
                                     <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700">
                                        <div>
                                            <div class="font-bold text-gray-700 dark:text-gray-300 text-sm">New Booking Alert</div>
                                            <div class="text-xs text-gray-500">Notify manager of new online bookings</div>
                                        </div>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" class="sr-only peer" checked>
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary"></div>
                                        </label>
                                    </div>

                                    <div>
                                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Alert Email Address</label>
                                        <input type="email" class="<?php echo $inputClass; ?>" value="manager@cashbox.com">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: Deposit Rules -->
                    <div id="tab-deposits" class="tab-content hidden space-y-6">
                        <div class="space-y-4">
                            <div class="flex items-center justify-between border-b border-gray-100 dark:border-gray-700 pb-2">
                                <h3 class="text-lg font-bold text-gray-800 dark:text-white">Deposits & Cancellation</h3>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" class="sr-only peer" checked>
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary"></div>
                                    <span class="ml-3 text-sm font-bold text-gray-600 dark:text-gray-300">Enable Deposits</span>
                                </label>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Deposit Amount (Per Person)</label>
                                    <div class="relative">
                                        <span class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-500 font-bold">£</span>
                                        <input type="number" class="<?php echo $inputClass; ?> pl-7" value="10.00">
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Required For Parties Over</label>
                                    <input type="number" class="<?php echo $inputClass; ?>" value="6">
                                </div>
                            </div>

                            <div>
                                <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1.5 px-1">Cancellation Policy Text</label>
                                <textarea class="<?php echo $inputClass; ?> min-h-[100px]" placeholder="Enter policy text displayed to customer...">Cancellations must be made 24 hours in advance for a full refund of your deposit.</textarea>
                            </div>
                        </div>
                    </div>

                </form>
            </div>



        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>

    <script>
        // Init Custom Selects
        document.addEventListener('DOMContentLoaded', () => {
             // Toggle Dropdown
             document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');

                    // Close all others
                    closeAllSelects(trigger);

                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');

                    // Rotate chevron
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron) {
                        if (!dropdown.classList.contains('invisible')) {
                            chevron.classList.add('rotate-180', 'text-primary');
                        } else {
                            chevron.classList.remove('rotate-180', 'text-primary');
                        }
                    }
                });
            });

            // Option Click
            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');

                    const val = option.dataset.value;
                    const label = option.dataset.label;

                    hiddenInput.value = val;
                    triggerLabel.textContent = label;

                    // Update styling
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        const check = opt.querySelector('.check-icon');
                        if (check) check.classList.replace('opacity-100', 'opacity-0');
                    });
                    option.classList.add('active');
                    const check = option.querySelector('.check-icon');
                    if (check) check.classList.replace('opacity-0', 'opacity-100');

                    // Close
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');

                    // Reset chevron
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron) chevron.classList.remove('rotate-180', 'text-primary');
                });
            });

            // Click Outside
            document.addEventListener('click', () => {
                closeAllSelects();
            });

            function closeAllSelects(exceptTrigger) {
                document.querySelectorAll('.custom-select-container').forEach(container => {
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    if (exceptTrigger && trigger === exceptTrigger) return;

                    if (!dropdown.classList.contains('invisible')) {
                        dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                        const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                        if (chevron) chevron.classList.remove('rotate-180', 'text-primary');
                    }
                });
            }
        });

        // Tabs Logic
        document.querySelectorAll('.tab-btn').forEach(button => {
            button.addEventListener('click', () => {
                const targetId = button.dataset.target;

                // Reset all tabs
                document.querySelectorAll('.tab-btn').forEach(btn => {
                    btn.classList.remove('active', 'border-primary', 'text-primary');
                    btn.classList.add('border-transparent', 'text-gray-500');
                    if (btn.classList.contains('dark:text-gray-200')) { 
                        // Simple toggle relying on base class
                    }
                });
                
                // Hide all contents
                document.querySelectorAll('.tab-content').forEach(content => {
                    content.classList.add('hidden');
                });

                // Activate clicked tab
                button.classList.add('active', 'border-primary', 'text-primary');
                button.classList.remove('border-transparent', 'text-gray-500');

                // Show target content
                document.getElementById(targetId).classList.remove('hidden');
                
                // Animate entry (optional)
                document.getElementById(targetId).classList.add('animate-fade-in-up');
            });
        });
    </script>
</main>
