<?php
include 'includes/session.php';
$pageTitle = "Reports Landing";
$currentPage = "reports";

// Config
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Reuse helper (Inlined for standalone functionality)
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) { $selectedLabel = $text; break; }
    }
    if ($selectedVal === '' && !empty($options)) { $selectedVal = array_key_first($options); $selectedLabel = $options[$selectedVal]; }
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        $optionsHtml .= '<div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"><span class="truncate">'.$text.'</span><ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon></div>';
    }
    return '<div class="relative custom-select-container '.$wrapperClass.'"><input type="hidden" name="'.$name.'" value="'.$selectedVal.'"><button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'"><span class="truncate select-label">'.$selectedLabel.'</span><ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon></button><div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar"><div class="p-1 space-y-0.5">'.$optionsHtml.'</div></div></div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-8">

            <!-- Header & Global Filters -->
            <div class="flex flex-col xl:flex-row xl:items-end justify-between gap-6">
                <div>
                     <span class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-orange-100 dark:bg-orange-900/30 text-orange-600 dark:text-orange-400 text-xs font-bold uppercase tracking-wider mb-3">
                        <ion-icon name="analytics"></ion-icon> Analytics Hub
                    </span>
                    <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Reports Dashboard</h1>
                    <p class="text-gray-500 dark:text-gray-400 text-sm mt-2 max-w-2xl">
                        Access detailed insights across your business. Select a date range and store context to pre-filter reports.
                    </p>
                </div>

                <div class="bg-white dark:bg-slate-900 p-2 rounded-2xl border border-gray-200 dark:border-gray-700 shadow-sm flex flex-col sm:flex-row gap-2">
                    <!-- Date Range -->
                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <ion-icon name="calendar-outline" class="text-gray-400 text-lg"></ion-icon>
                        </div>
                        <input type="text" class="pl-10 pr-4 py-2.5 bg-gray-50 dark:bg-slate-800 border-none rounded-xl text-sm font-medium text-gray-700 dark:text-gray-200 focus:ring-0 w-full sm:w-64" placeholder="Last 7 Days" value="Jan 10, 2026 - Jan 16, 2026">
                    </div>
                    
                    <!-- Store Context -->
                    <div class="w-full sm:w-56">
                        <?php echo renderCustomSelect('All Stores', 'context_store_id', ['all' => 'All Stores', '1001' => 'FNF Cardiff'], 'all', '', '!bg-gray-50 dark:!bg-slate-800 !border-none !py-2.5'); ?>
                    </div>

                    <!-- Quick Export -->
                    <button class="px-4 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all flex items-center justify-center gap-2 whitespace-nowrap">
                        <ion-icon name="download-outline" class="text-lg"></ion-icon>
                        <span>Export Summary</span>
                    </button>
                </div>
            </div>

            <div class="border-t border-gray-200 dark:border-gray-800"></div>

            <!-- Report Categories -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">

                <!-- Sales Reports -->
                <div class="glass-panel p-6 rounded-2xl border-t-4 border-t-blue-500 flex flex-col h-full group hover:border-t-blue-600 transition-colors">
                    <div class="flex items-center gap-4 mb-6">
                        <div class="p-3 rounded-xl bg-blue-50 dark:bg-blue-900/20 text-blue-500 text-2xl">
                            <ion-icon name="trending-up-outline"></ion-icon>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-800 dark:text-white">Sales & Revenue</h3>
                            <p class="text-xs text-gray-400 uppercase tracking-wider font-semibold">Performance Metrics</p>
                        </div>
                    </div>
                    
                    <ul class="space-y-1 flex-1">
                        <li>
                            <a href="report_sales_summary.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="document-text-outline" class="text-gray-400 group-hover/link:text-blue-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-blue-600 dark:group-hover/link:text-blue-400">Sales Summary</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_weekly_comparison.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="stats-chart-outline" class="text-gray-400 group-hover/link:text-blue-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-blue-600 dark:group-hover/link:text-blue-400">Weekly Comparison</span>
                                </div>
                                <div class="px-2 py-0.5 rounded text-[10px] font-bold bg-blue-100 text-blue-700 dark:bg-blue-900/30 dark:text-blue-400">CRITICAL</div>
                            </a>
                        </li>
                        <li>
                            <a href="report_sales_by_store.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="storefront-outline" class="text-gray-400 group-hover/link:text-blue-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-blue-600 dark:group-hover/link:text-blue-400">Sales by Store</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_monthly_sales.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="calendar-outline" class="text-gray-400 group-hover/link:text-blue-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-blue-600 dark:group-hover/link:text-blue-400">Monthly Sales</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_sales_detailed.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="list-outline" class="text-gray-400 group-hover/link:text-blue-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-blue-600 dark:group-hover/link:text-blue-400">Detailed Sales</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Finance Reports -->
                <div class="glass-panel p-6 rounded-2xl border-t-4 border-t-green-500 flex flex-col h-full group hover:border-t-green-600 transition-colors">
                    <div class="flex items-center gap-4 mb-6">
                        <div class="p-3 rounded-xl bg-green-50 dark:bg-green-900/20 text-green-500 text-2xl">
                            <ion-icon name="wallet-outline"></ion-icon>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-800 dark:text-white">Finance & Cash</h3>
                            <p class="text-xs text-gray-400 uppercase tracking-wider font-semibold">Audit & Reconcile</p>
                        </div>
                    </div>
                    
                    <ul class="space-y-1 flex-1">
                        <li>
                            <a href="report_z_read.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="receipt-outline" class="text-gray-400 group-hover/link:text-green-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-green-600 dark:group-hover/link:text-green-400">Z-Reports (EOD)</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_vat.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="calculator-outline" class="text-gray-400 group-hover/link:text-green-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-green-600 dark:group-hover/link:text-green-400">VAT / Tax</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_payments.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="card-outline" class="text-gray-400 group-hover/link:text-green-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-green-600 dark:group-hover/link:text-green-400">Payments Split</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_refunds.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="return-down-back-outline" class="text-gray-400 group-hover/link:text-green-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-green-600 dark:group-hover/link:text-green-400">Refunds & Voids</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_discounts.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="pricetag-outline" class="text-gray-400 group-hover/link:text-green-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-green-600 dark:group-hover/link:text-green-400">Discounts</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_cashback.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="cash-outline" class="text-gray-400 group-hover/link:text-green-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-green-600 dark:group-hover/link:text-green-400">Cashback Services</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_payouts.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="wallet-outline" class="text-gray-400 group-hover/link:text-green-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-green-600 dark:group-hover/link:text-green-400">Payouts / Petty Cash</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Operations -->
                <div class="glass-panel p-6 rounded-2xl border-t-4 border-t-purple-500 flex flex-col h-full group hover:border-t-purple-600 transition-colors">
                    <div class="flex items-center gap-4 mb-6">
                        <div class="p-3 rounded-xl bg-purple-50 dark:bg-purple-900/20 text-purple-500 text-2xl">
                            <ion-icon name="cube-outline"></ion-icon>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-800 dark:text-white">Operations</h3>
                            <p class="text-xs text-gray-400 uppercase tracking-wider font-semibold">Inventory & Staff</p>
                        </div>
                    </div>
                    
                    <ul class="space-y-1 flex-1">
                        <li>
                            <a href="rota.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="people-outline" class="text-gray-400 group-hover/link:text-purple-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-purple-600 dark:group-hover/link:text-purple-400">Staff Performance</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_orders.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="list-outline" class="text-gray-400 group-hover/link:text-purple-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-purple-600 dark:group-hover/link:text-purple-400">Order History</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                        <li>
                            <a href="report_tap_tracker.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="finger-print-outline" class="text-gray-400 group-hover/link:text-purple-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-purple-600 dark:group-hover/link:text-purple-400">Tap Tracker (Audit)</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                         <li>
                            <a href="report_inventory.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="warning-outline" class="text-gray-400 group-hover/link:text-purple-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-purple-600 dark:group-hover/link:text-purple-400">Low Stock / Expiry</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                         <li>
                            <a href="report_product_status.php" class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors group/link">
                                <div class="flex items-center gap-3">
                                    <ion-icon name="cube-outline" class="text-gray-400 group-hover/link:text-purple-500 transition-colors"></ion-icon>
                                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300 group-hover/link:text-purple-600 dark:group-hover/link:text-purple-400">Product Lifecycle</span>
                                </div>
                                <ion-icon name="arrow-forward-outline" class="text-gray-300 transform -translate-x-2 opacity-0 group-hover/link:translate-x-0 group-hover/link:opacity-100 transition-all text-xs"></ion-icon>
                            </a>
                        </li>
                    </ul>
                </div>

            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
        });

        // --- Custom Select Logic ---
        function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron && !dropdown.classList.contains('invisible')) {
                        chevron.classList.add('rotate-180');
                        chevron.classList.add('text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
