<?php
include 'includes/session.php';
$pageTitle = "Weekly Comparison";
$currentPage = "report_weekly_comparison";

// Styles
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Reuse helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) { $selectedLabel = $text; break; }
    }
    if ($selectedVal === '' && !empty($options)) { $selectedVal = array_key_first($options); $selectedLabel = $options[$selectedVal]; }
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        $optionsHtml .= '<div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"><span class="truncate">'.$text.'</span><ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon></div>';
    }
    return '<div class="relative custom-select-container '.$wrapperClass.'"><input type="hidden" name="'.$name.'" value="'.$selectedVal.'"><button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'"><span class="truncate select-label">'.$selectedLabel.'</span><ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon></button><div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar"><div class="p-1 space-y-0.5">'.$optionsHtml.'</div></div></div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-8">

            <!-- Breadcrumbs -->
            <nav class="flex text-sm font-medium text-gray-500 dark:text-gray-400">
                <a href="reports.php" class="hover:text-primary transition-colors">Reports</a>
                <span class="mx-2 text-gray-300 dark:text-gray-600">/</span>
                <span class="text-gray-800 dark:text-white">Weekly Comparison</span>
            </nav>

            <!-- Header & Filters -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col xl:flex-row xl:items-start justify-between gap-6 relative z-30">
                <div class="xl:w-1/3">
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Weekly Comparison</h1>
                    <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Compare sales performance between two weeks.</p>
                </div>
                
                <div class="flex-1 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 w-full">
                     <!-- Week Selection -->
                     <div>
                         <?php echo renderCustomSelect('Current Week', 'current_week', ['w1' => 'Jan 10 - Jan 16 (Current)', 'w2' => 'Jan 03 - Jan 09'], 'w1'); ?>
                    </div>
                     <!-- Comparison Week -->
                     <div>
                         <?php echo renderCustomSelect('Compare To: Last Week', 'compare_week', ['w2' => 'Jan 03 - Jan 09 (Last Week)', 'w3' => 'Dec 27 - Jan 02'], 'w2'); ?>
                    </div>
                     <!-- Store -->
                    <div>
                         <?php echo renderCustomSelect('All Stores', 'store_id', ['all' => 'All Stores', '1001' => 'FNF Cardiff'], 'all'); ?>
                    </div>
                </div>
            </div>

            <!-- KPI Cards -->
            <div class="grid grid-cols-1 sm:grid-cols-3 gap-6">
                <!-- Sales Diff -->
                <div class="glass-panel p-6 rounded-2xl relative overflow-hidden">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Total Sales Difference</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">+£1,250.00</h3>
                     <p class="text-xs text-green-600 dark:text-green-400 mt-2 font-medium flex items-center gap-1">
                        <ion-icon name="caret-up-outline"></ion-icon> 12% vs previous period
                    </p>
                </div>
                 <!-- Order Volume -->
                <div class="glass-panel p-6 rounded-2xl relative overflow-hidden">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Order Volume Diff</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">+45</h3>
                    <p class="text-xs text-green-600 dark:text-green-400 mt-2 font-medium flex items-center gap-1">
                        <ion-icon name="caret-up-outline"></ion-icon> 5% vs previous period
                    </p>
                </div>
                <!-- ATV Diff -->
                <div class="glass-panel p-6 rounded-2xl relative overflow-hidden">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">ATV Difference</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">-£0.50</h3>
                     <p class="text-xs text-red-500 dark:text-red-400 mt-2 font-medium flex items-center gap-1">
                        <ion-icon name="caret-down-outline"></ion-icon> 2% vs previous period
                    </p>
                </div>
            </div>

            <!-- Chart Section -->
            <div class="glass-panel p-6 rounded-2xl">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white">Day-by-Day Comparison</h3>
                    <div class="flex items-center gap-2">
                        <span class="flex items-center gap-1 text-xs text-gray-500"><div class="w-3 h-3 bg-orange-500 rounded-full"></div> This Week</span>
                        <span class="flex items-center gap-1 text-xs text-gray-500"><div class="w-3 h-3 bg-gray-300 rounded-full"></div> Last Week</span>
                    </div>
                </div>
                <div id="weeklyComparisonChart" class="w-full h-80"></div>
            </div>

            <!-- Data Table -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Day</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">This Week</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Last Week</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Difference</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">% Change</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                             <!-- Row 1 -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 text-sm font-medium text-gray-800 dark:text-white">Monday</td>
                                <td class="py-4 px-6 text-sm font-bold text-gray-800 dark:text-white text-right font-mono">£1,850.00</td>
                                <td class="py-4 px-6 text-sm text-gray-500 dark:text-gray-400 text-right font-mono">£1,600.00</td>
                                <td class="py-4 px-6 text-sm text-green-600 text-right font-mono font-medium">+£250.00</td>
                                <td class="py-4 px-6 text-sm inline-flex items-center justify-end w-full gap-1 text-green-600 font-bold text-right"><ion-icon name="caret-up-outline"></ion-icon> 15.6%</td>
                            </tr>
                             <!-- Row 2 -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 text-sm font-medium text-gray-800 dark:text-white">Tuesday</td>
                                <td class="py-4 px-6 text-sm font-bold text-gray-800 dark:text-white text-right font-mono">£1,200.00</td>
                                <td class="py-4 px-6 text-sm text-gray-500 dark:text-gray-400 text-right font-mono">£1,350.00</td>
                                <td class="py-4 px-6 text-sm text-red-500 text-right font-mono font-medium">-£150.00</td>
                                <td class="py-4 px-6 text-sm inline-flex items-center justify-end w-full gap-1 text-red-500 font-bold text-right"><ion-icon name="caret-down-outline"></ion-icon> 11.1%</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
             renderComparisonChart();
        });

        // --- Chart Logic ---
        function renderComparisonChart() {
            const el = document.querySelector("#weeklyComparisonChart");
            if (!el) return;
            
            const isDark = document.documentElement.classList.contains('dark');
            const textColor = isDark ? '#e2e8f0' : '#475569';

            const options = {
                chart: {
                    type: 'bar',
                    height: 320,
                    fontFamily: 'Inter, sans-serif',
                    toolbar: { show: false },
                    background: 'transparent'
                },
                series: [
                    { name: 'This Week', data: [1850, 1200, 1600, 1900, 2100, 2400, 2200] },
                    { name: 'Last Week', data: [1600, 1350, 1500, 1800, 2000, 2200, 2100] }
                ],
                colors: ['#FF9909', '#CBD5E1'],
                plotOptions: {
                    bar: {
                         horizontal: false,
                         columnWidth: '50%',
                         borderRadius: 4
                    }
                },
                dataLabels: { enabled: false },
                xaxis: {
                    categories: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
                    axisBorder: { show: false },
                    axisTicks: { show: false },
                    labels: { style: { colors: textColor } }
                },
                yaxis: {
                    labels: {
                        style: { colors: textColor },
                        formatter: (val) => '£' + val
                    }
                },
                legend: { show: false },
                grid: {
                     borderColor: 'rgba(128,128,128, 0.2)',
                     strokeDashArray: 5,
                },
                tooltip: {
                    theme: isDark ? 'dark' : 'light',
                    y: { formatter: (val) => '£' + val }
                }
            };
            
            const chart = new ApexCharts(el, options);
            chart.render();
        }

        // --- Custom Select Logic (Reused) ---
         function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron && !dropdown.classList.contains('invisible')) {
                        chevron.classList.add('rotate-180');
                        chevron.classList.add('text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
