<?php
include 'includes/session.php';
$pageTitle = "Sales Summary Report";
$currentPage = "report_sales_summary";

// Styles
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Reuse helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) { $selectedLabel = $text; break; }
    }
    if ($selectedVal === '' && !empty($options)) { $selectedVal = array_key_first($options); $selectedLabel = $options[$selectedVal]; }
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        $optionsHtml .= '<div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"><span class="truncate">'.$text.'</span><ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon></div>';
    }
    return '<div class="relative custom-select-container '.$wrapperClass.'"><input type="hidden" name="'.$name.'" value="'.$selectedVal.'"><button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'"><span class="truncate select-label">'.$selectedLabel.'</span><ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon></button><div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar"><div class="p-1 space-y-0.5">'.$optionsHtml.'</div></div></div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-8">

            <!-- Breadcrumbs -->
            <nav class="flex text-sm font-medium text-gray-500 dark:text-gray-400">
                <a href="reports.php" class="hover:text-primary transition-colors">Reports</a>
                <span class="mx-2 text-gray-300 dark:text-gray-600">/</span>
                <span class="text-gray-800 dark:text-white">Sales Summary</span>
            </nav>

            <!-- Header & Filters -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col xl:flex-row xl:items-start justify-between gap-6 relative z-30">
                <div class="xl:w-1/3">
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Sales Summary Report</h1>
                    <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Detailed breakdown of sales performance, tax, and revenue.</p>
                </div>
                
                <div class="flex-1 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 w-full">
                    <!-- Date Range -->
                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <ion-icon name="calendar-outline" class="text-gray-400 text-lg"></ion-icon>
                        </div>
                        <input type="text" class="<?php echo $inputClass; ?> !pl-10" value="Jan 10, 2026 - Jan 16, 2026">
                    </div>
                    
                    <!-- Store -->
                    <div>
                         <?php echo renderCustomSelect('All Stores', 'store_id', ['all' => 'All Stores', '1001' => 'FNF Cardiff'], 'all'); ?>
                    </div>

                    <!-- Payment Method -->
                     <div>
                         <?php echo renderCustomSelect('All Payment Methods', 'payment_method', ['all' => 'All Methods', 'card' => 'Card', 'cash' => 'Cash'], 'all'); ?>
                    </div>

                    <!-- Actions -->
                    <div class="flex gap-2">
                        <button class="flex-1 px-4 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all flex items-center justify-center gap-2">
                            <ion-icon name="refresh-outline" class="text-lg"></ion-icon>
                            <span>Run</span>
                        </button>
                        <button class="px-3 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-primary hover:border-primary/30 rounded-xl text-lg flex items-center justify-center shadow-sm" title="Export CSV">
                            <ion-icon name="download-outline"></ion-icon>
                        </button>
                         <button class="px-3 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-primary hover:border-primary/30 rounded-xl text-lg flex items-center justify-center shadow-sm" title="Print">
                            <ion-icon name="print-outline"></ion-icon>
                        </button>
                    </div>
                </div>
            </div>

            <!-- KPI Cards -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Gross Sales -->
                <div class="glass-panel p-6 rounded-2xl relative overflow-hidden">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Gross Sales</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">£12,450.00</h3>
                     <p class="text-xs text-green-600 dark:text-green-400 mt-2 font-medium flex items-center gap-1">
                        <ion-icon name="trending-up"></ion-icon> +8.5%
                    </p>
                </div>
                 <!-- Net Sales -->
                <div class="glass-panel p-6 rounded-2xl relative overflow-hidden">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Net Sales</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">£10,375.00</h3>
                    <p class="text-xs text-gray-500 mt-2">Excl. Tax</p>
                </div>
                <!-- Total Orders -->
                <div class="glass-panel p-6 rounded-2xl relative overflow-hidden">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Total Orders</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">1,245</h3>
                     <p class="text-xs text-red-500 mt-2 font-medium flex items-center gap-1">
                        <ion-icon name="trending-down"></ion-icon> -2.1%
                    </p>
                </div>
                 <!-- ATV -->
                <div class="glass-panel p-6 rounded-2xl relative overflow-hidden">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Avg Transaction</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">£10.00</h3>
                    <p class="text-xs text-gray-500 mt-2">Per Order</p>
                </div>
            </div>

            <!-- Chart Section -->
            <div class="glass-panel p-6 rounded-2xl">
                <h3 class="text-lg font-bold text-gray-800 dark:text-white mb-6">Sales Trend</h3>
                <div id="salesTrendChart" class="w-full h-80"></div>
            </div>

            <!-- Data Table -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm">
                 <div class="px-6 py-4 border-b border-gray-100 dark:border-gray-700 flex justify-between items-center">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white">Daily Breakdown</h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Date</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Orders</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Gross Sales</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Tax</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Net Sales</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                             <!-- Row 1 -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 text-sm font-medium text-gray-800 dark:text-white">Jan 16, 2026</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">185</td>
                                <td class="py-4 px-6 text-sm font-bold text-gray-800 dark:text-white text-right font-mono">£1,850.00</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">£308.33</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">£1,541.67</td>
                            </tr>
                             <!-- Row 2 -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 text-sm font-medium text-gray-800 dark:text-white">Jan 15, 2026</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">160</td>
                                <td class="py-4 px-6 text-sm font-bold text-gray-800 dark:text-white text-right font-mono">£1,600.00</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">£266.67</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">£1,333.33</td>
                            </tr>
                            <!-- Row 3 -->
                             <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 text-sm font-medium text-gray-800 dark:text-white">Jan 14, 2026</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">175</td>
                                <td class="py-4 px-6 text-sm font-bold text-gray-800 dark:text-white text-right font-mono">£1,750.00</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">£291.67</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">£1,458.33</td>
                            </tr>
                        </tbody>
                        <tfoot class="bg-gray-50/50 dark:bg-slate-800/50 font-bold border-t border-gray-200 dark:border-gray-700">
                            <tr>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white">Total</td>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white text-right font-mono">520</td>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white text-right font-mono">£5,200.00</td>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white text-right font-mono">£866.67</td>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white text-right font-mono">£4,333.33</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
             renderSalesTrendChart();
        });

        // --- Chart Logic ---
        function renderSalesTrendChart() {
            const el = document.querySelector("#salesTrendChart");
            if (!el) return;
            
            const isDark = document.documentElement.classList.contains('dark');
            const textColor = isDark ? '#e2e8f0' : '#475569';

            const options = {
                chart: {
                    type: 'area',
                    height: 320,
                    fontFamily: 'Inter, sans-serif',
                    toolbar: { show: false },
                    background: 'transparent',
                    zoom: { enabled: false }
                },
                series: [{
                    name: 'Gross Sales',
                    data: [1750, 1600, 1850, 2100, 1950, 2300, 2500]
                }],
                colors: ['#FF9909'],
                fill: {
                    type: 'gradient',
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.7,
                        opacityTo: 0.1,
                        stops: [0, 90, 100]
                    }
                },
                dataLabels: { enabled: false },
                stroke: { curve: 'smooth', width: 2 },
                xaxis: {
                    categories: ['Jan 10', 'Jan 11', 'Jan 12', 'Jan 13', 'Jan 14', 'Jan 15', 'Jan 16'],
                    axisBorder: { show: false },
                    axisTicks: { show: false },
                    labels: { style: { colors: textColor } }
                },
                yaxis: {
                    labels: {
                        style: { colors: textColor },
                        formatter: (val) => '£' + val
                    }
                },
                grid: {
                     borderColor: 'rgba(128,128,128, 0.2)',
                     strokeDashArray: 5,
                },
                tooltip: {
                    theme: isDark ? 'dark' : 'light',
                    y: { formatter: (val) => '£' + val }
                }
            };
            
            const chart = new ApexCharts(el, options);
            chart.render();
        }

        // --- Custom Select Logic (Reused) ---
         function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron && !dropdown.classList.contains('invisible')) {
                        chevron.classList.add('rotate-180');
                        chevron.classList.add('text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
