<?php
include 'includes/session.php';
$pageTitle = "Refunds & Voids";
$currentPage = "report_refunds";

// Styles
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Reuse helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) { $selectedLabel = $text; break; }
    }
    if ($selectedVal === '' && !empty($options)) { $selectedVal = array_key_first($options); $selectedLabel = $options[$selectedVal]; }
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        $optionsHtml .= '<div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"><span class="truncate">'.$text.'</span><ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon></div>';
    }
    return '<div class="relative custom-select-container '.$wrapperClass.'"><input type="hidden" name="'.$name.'" value="'.$selectedVal.'"><button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'"><span class="truncate select-label">'.$selectedLabel.'</span><ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon></button><div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar"><div class="p-1 space-y-0.5">'.$optionsHtml.'</div></div></div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-8">

            <!-- Breadcrumbs -->
            <nav class="flex text-sm font-medium text-gray-500 dark:text-gray-400">
                <a href="reports.php" class="hover:text-primary transition-colors">Reports</a>
                <span class="mx-2 text-gray-300 dark:text-gray-600">/</span>
                <span class="text-gray-800 dark:text-white">Refunds & Voids</span>
            </nav>

            <!-- Header & Filters -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col xl:flex-row xl:items-start justify-between gap-6 relative z-30">
                <div class="xl:w-1/3">
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Refunds & Voids</h1>
                    <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Audit log of reversed transactions.</p>
                </div>
                
                <div class="flex-1 flex flex-col sm:flex-row items-center justify-end gap-3 w-full">
                    <!-- Date Range -->
                    <div class="relative group w-full sm:w-auto">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <ion-icon name="calendar-outline" class="text-gray-400 text-lg"></ion-icon>
                        </div>
                        <input type="text" class="<?php echo $inputClass; ?> !pl-10" value="Jan 10, 2026 - Jan 16, 2026">
                    </div>
                     <!-- Store -->
                    <div class="w-full sm:w-48">
                         <?php echo renderCustomSelect('All Stores', 'store_id', ['all' => 'All Stores', '1001' => 'FNF Cardiff'], 'all'); ?>
                    </div>
                </div>
            </div>

            <!-- KPI Summary -->
            <div class="grid grid-cols-1 sm:grid-cols-3 gap-6">
                <div class="glass-panel p-6 rounded-2xl border-l-4 border-red-500">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Total Refunds</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">£450.00</h3>
                </div>
                <div class="glass-panel p-6 rounded-2xl border-l-4 border-orange-500">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Refund Count</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">12</h3>
                </div>
                 <div class="glass-panel p-6 rounded-2xl border-l-4 border-gray-500">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Voided Items</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">8</h3>
                </div>
            </div>
            
             <!-- Chart Section -->
            <div class="glass-panel p-6 rounded-2xl">
                <h3 class="text-lg font-bold text-gray-800 dark:text-white mb-6">Refund Trend</h3>
                <div id="refundTrendChart" class="w-full h-72"></div>
            </div>


            <!-- Detailed Table -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Date/Time</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Order ID</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Staff</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Reason</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Amount</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Approved By</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                             <!-- Row 1 -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300">Jan 16, 14:30</td>
                                <td class="py-4 px-6 text-sm font-mono text-primary font-medium">#ORD-9921</td>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white">Sarah Smith</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300">Customer Complaint (Quality)</td>
                                <td class="py-4 px-6 text-sm font-bold text-red-500 text-right font-mono">-£25.50</td>
                                <td class="py-4 px-6 text-right text-sm text-gray-500">John Doe</td>
                            </tr>
                             <!-- Row 2 -->
                             <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300">Jan 15, 11:15</td>
                                <td class="py-4 px-6 text-sm font-mono text-primary font-medium">#ORD-9854</td>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white">Mike Jones</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300">Accidental Entry</td>
                                <td class="py-4 px-6 text-sm font-bold text-red-500 text-right font-mono">-£12.00</td>
                                <td class="py-4 px-6 text-right text-sm text-gray-500">Auto</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
             renderRefundTrendChart();
        });

        // --- Chart Logic ---
        function renderRefundTrendChart() {
            const el = document.querySelector("#refundTrendChart");
            if (!el) return;
            
            const isDark = document.documentElement.classList.contains('dark');
            const textColor = isDark ? '#e2e8f0' : '#475569';

            const options = {
                chart: {
                    type: 'area',
                    height: 280,
                    fontFamily: 'Inter, sans-serif',
                    toolbar: { show: false },
                    background: 'transparent',
                    zoom: { enabled: false }
                },
                series: [{
                    name: 'Refund Amount',
                    data: [50, 25, 0, 120, 30, 45, 20]
                }],
                colors: ['#EF4444'],
                fill: {
                    type: 'gradient',
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.7,
                        opacityTo: 0.1,
                        stops: [0, 90, 100]
                    }
                },
                dataLabels: { enabled: false },
                stroke: { curve: 'smooth', width: 2 },
                 xaxis: {
                    categories: ['Jan 10', 'Jan 11', 'Jan 12', 'Jan 13', 'Jan 14', 'Jan 15', 'Jan 16'],
                    axisBorder: { show: false },
                    axisTicks: { show: false },
                    labels: { style: { colors: textColor } }
                },
                yaxis: {
                    labels: {
                        style: { colors: textColor },
                        formatter: (val) => '£' + val
                    }
                },
                grid: {
                     borderColor: 'rgba(128,128,128, 0.2)',
                     strokeDashArray: 5,
                },
                tooltip: {
                    theme: isDark ? 'dark' : 'light',
                    y: { formatter: (val) => '£' + val }
                }
            };
            
            const chart = new ApexCharts(el, options);
            chart.render();
        }

        // --- Custom Select Logic (Reused) ---
         function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron && !dropdown.classList.contains('invisible')) {
                        chevron.classList.add('rotate-180');
                        chevron.classList.add('text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
