<?php
include 'includes/session.php';
$pageTitle = "Product Status & Lifecycle";
$currentPage = "report_product_status";

// Styles
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Reuse helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) { $selectedLabel = $text; break; }
    }
    if ($selectedVal === '' && !empty($options)) { $selectedVal = array_key_first($options); $selectedLabel = $options[$selectedVal]; }
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        $optionsHtml .= '<div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"><span class="truncate">'.$text.'</span><ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon></div>';
    }
    return '<div class="relative custom-select-container '.$wrapperClass.'"><input type="hidden" name="'.$name.'" value="'.$selectedVal.'"><button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'"><span class="truncate select-label">'.$selectedLabel.'</span><ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon></button><div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar"><div class="p-1 space-y-0.5">'.$optionsHtml.'</div></div></div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-8">

            <!-- Breadcrumbs -->
            <nav class="flex text-sm font-medium text-gray-500 dark:text-gray-400">
                <a href="reports.php" class="hover:text-primary transition-colors">Reports</a>
                <span class="mx-2 text-gray-300 dark:text-gray-600">/</span>
                <span class="text-gray-800 dark:text-white">Product Status</span>
            </nav>

            <!-- Header & Filters -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col xl:flex-row xl:items-start justify-between gap-6 relative z-30">
                <div class="xl:w-1/3">
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Product Lifecycle</h1>
                    <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Manage active, inactive, and dead stock.</p>
                </div>
                
                <div class="flex-1 flex flex-col sm:flex-row items-center justify-end gap-3 w-full">
                     <!-- Store -->
                    <div class="w-full sm:w-48">
                         <?php echo renderCustomSelect('All Stores', 'store_id', ['all' => 'All Stores', '1001' => 'FNF Cardiff'], 'all'); ?>
                    </div>
                     <!-- Category Filter -->
                    <div class="w-full sm:w-48">
                         <?php echo renderCustomSelect('All Categories', 'category_id', ['all' => 'All Categories', 'vapes' => 'Vapes', 'drinks' => 'Soft Drinks'], 'all'); ?>
                    </div>
                     <!-- Status Filter -->
                    <div class="w-full sm:w-48">
                          <?php echo renderCustomSelect('All Statuses', 'status', ['all' => 'All Statuses', 'active' => 'Active', 'innactive' => 'Inactive', 'dead' => 'Dead Stock'], 'all'); ?>
                    </div>
                </div>
            </div>

            <!-- KPI Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                 <!-- Total Active -->
                <div class="glass-panel p-6 rounded-2xl border-l-4 border-l-green-500 relative overflow-hidden group">
                    <div class="absolute right-4 top-4 p-2 bg-green-50 dark:bg-green-900/20 rounded-lg text-green-500 mb-4">
                        <ion-icon name="cube-outline" class="text-xl"></ion-icon>
                    </div>
                    <div class="relative z-10">
                        <div class="text-sm text-gray-500 dark:text-gray-400 font-medium mb-1">Total Active Products</div>
                        <div class="text-3xl font-bold text-gray-800 dark:text-white">2,450</div>
                         <div class="text-xs text-gray-400 mt-2">Currently selling in stores</div>
                    </div>
                </div>

                 <!-- Dead Stock -->
                <div class="glass-panel p-6 rounded-2xl border-l-4 border-l-red-500 relative overflow-hidden group">
                    <div class="absolute right-4 top-4 p-2 bg-red-50 dark:bg-red-900/20 rounded-lg text-red-500 mb-4">
                        <ion-icon name="alert-circle-outline" class="text-xl"></ion-icon>
                    </div>
                     <div class="relative z-10">
                        <div class="text-sm text-gray-500 dark:text-gray-400 font-medium mb-1">Dead Stock</div>
                        <div class="text-3xl font-bold text-gray-800 dark:text-white">45</div>
                        <div class="text-xs text-red-500 font-bold mt-2">No sales in 90+ days</div>
                    </div>
                </div>

                 <!-- New Products -->
                <div class="glass-panel p-6 rounded-2xl border-l-4 border-l-purple-500 relative overflow-hidden group">
                    <div class="absolute right-4 top-4 p-2 bg-purple-50 dark:bg-purple-900/20 rounded-lg text-purple-500 mb-4">
                        <ion-icon name="star-outline" class="text-xl"></ion-icon>
                    </div>
                    <div class="relative z-10">
                        <div class="text-sm text-gray-500 dark:text-gray-400 font-medium mb-1">New Arrivals</div>
                        <div class="text-3xl font-bold text-gray-800 dark:text-white">120</div>
                        <div class="text-xs text-purple-500 font-bold mt-2">Added this month</div>
                    </div>
                </div>
            </div>

            <!-- Chart Section -->
            <div class="glass-panel p-6 rounded-2xl">
                <h3 class="text-lg font-bold text-gray-800 dark:text-white mb-6">Catalog Composition by Category</h3>
                <div id="categoryChart" class="w-full h-80" style="min-height: 320px;"></div>
            </div>

            <!-- Data Table -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm">
                 <div class="px-6 py-4 border-b border-gray-100 dark:border-gray-700 flex justify-between items-center">
                    <h3 class="font-bold text-gray-800 dark:text-white">Product List</h3>
                    <div class="flex gap-2">
                        <button class="px-3 py-1.5 bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300 rounded-lg text-xs font-bold hover:bg-gray-200 dark:hover:bg-slate-600 transition-colors">
                            Filter Dead Stock
                        </button>
                        <button class="text-sm text-primary font-medium hover:text-orange-600 transition-colors flex items-center gap-1">
                            <ion-icon name="download-outline"></ion-icon> Export CSV
                        </button>
                    </div>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Product Name</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">SKU</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Category</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Last Sold</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Stock</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Status</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                             <!-- Item 1 -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 text-sm font-medium text-gray-800 dark:text-white">Crystal Bar - Watermelon Ice</td>
                                <td class="py-4 px-6 text-xs text-gray-500 font-mono">VAPE-CRY-WAT-20</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300">Vapes</td>
                                <td class="py-4 px-6 text-sm text-gray-500 text-center">Today</td>
                                <td class="py-4 px-6 text-sm font-bold text-gray-800 dark:text-white text-center">450</td>
                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400">
                                        Active
                                    </span>
                                </td>
                            </tr>
                             <!-- Item 2 (Dead Stock) -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 text-sm font-medium text-gray-800 dark:text-white">Old Generic Charger Cable</td>
                                <td class="py-4 px-6 text-xs text-gray-500 font-mono">ACC-USB-001</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300">Accessories</td>
                                <td class="py-4 px-6 text-sm text-gray-500 text-center text-red-500 font-bold">120 Days Ago</td>
                                <td class="py-4 px-6 text-sm font-bold text-gray-800 dark:text-white text-center">12</td>
                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400">
                                        Dead Stock
                                    </span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
        });

        // Safe Chart Render
        window.addEventListener('load', () => {
             if (typeof ApexCharts !== 'undefined') {
                 renderCategoryChart();
             } else {
                 console.error('ApexCharts library not loaded.');
             }
        });

        // --- Chart Logic ---
        function renderCategoryChart() {
            const el = document.querySelector("#categoryChart");
            if (!el) return;
            
            const isDark = document.documentElement.classList.contains('dark');
            const textColor = isDark ? '#e2e8f0' : '#475569';

            const options = {
                series: [
                    {
                        data: [
                            { x: 'Vapes', y: 450 },
                            { x: 'Tobacco', y: 200 },
                            { x: 'Drinks', y: 150 },
                            { x: 'Snacks', y: 100 },
                            { x: 'Alcohol', y: 80 },
                            { x: 'Household', y: 40 },
                            { x: 'Pet Food', y: 30 },
                            { x: 'Papers', y: 20 }
                        ]
                    }
                ],
                legend: { show: false },
                chart: {
                    type: 'treemap',
                    height: 320,
                    fontFamily: 'Inter, sans-serif',
                    background: 'transparent',
                    toolbar: { show: false }
                },
                colors: ['#3B82F6', '#10B981', '#F59E0B', '#EF4444', '#8B5CF6', '#EC4899', '#6366F1', '#14B8A6'],
                plotOptions: {
                    treemap: {
                        distributed: true,
                        enableShades: false
                    }
                },
                dataLabels: {
                    enabled: true,
                    style: {
                        fontSize: '12px',
                        fontWeight: 'bold',
                        colors: ['#fff']
                    },
                    formatter: function(text, op) {
                        return [text, op.value];
                    }
                },
                tooltip: { theme: isDark ? 'dark' : 'light' }
            };
            
            try {
                const chart = new ApexCharts(el, options);
                chart.render();
            } catch (e) {
                console.error("Chart render failed:", e);
            }
        }

        // --- Custom Select Logic (Reused) ---
         function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron && !dropdown.classList.contains('invisible')) {
                        chevron.classList.add('rotate-180');
                        chevron.classList.add('text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
