<?php
include 'includes/session.php';
$pageTitle = "Payments Split";
$currentPage = "report_payments";

// Styles
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Reuse helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) { $selectedLabel = $text; break; }
    }
    if ($selectedVal === '' && !empty($options)) { $selectedVal = array_key_first($options); $selectedLabel = $options[$selectedVal]; }
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        $optionsHtml .= '<div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"><span class="truncate">'.$text.'</span><ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon></div>';
    }
    return '<div class="relative custom-select-container '.$wrapperClass.'"><input type="hidden" name="'.$name.'" value="'.$selectedVal.'"><button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'"><span class="truncate select-label">'.$selectedLabel.'</span><ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon></button><div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar"><div class="p-1 space-y-0.5">'.$optionsHtml.'</div></div></div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-8">

            <!-- Breadcrumbs -->
            <nav class="flex text-sm font-medium text-gray-500 dark:text-gray-400">
                <a href="reports.php" class="hover:text-primary transition-colors">Reports</a>
                <span class="mx-2 text-gray-300 dark:text-gray-600">/</span>
                <span class="text-gray-800 dark:text-white">Payments Split</span>
            </nav>

            <!-- Header & Filters -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col xl:flex-row xl:items-start justify-between gap-6 relative z-30">
                <div class="xl:w-1/3">
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Payments Split</h1>
                    <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Breakdown of revenue by payment method.</p>
                </div>
                
                <div class="flex-1 flex flex-col sm:flex-row items-center justify-end gap-3 w-full">
                    <!-- Date Range -->
                    <div class="relative group w-full sm:w-auto">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <ion-icon name="calendar-outline" class="text-gray-400 text-lg"></ion-icon>
                        </div>
                        <input type="text" class="<?php echo $inputClass; ?> !pl-10" value="Jan 10, 2026 - Jan 16, 2026">
                    </div>
                     <!-- Store -->
                    <div class="w-full sm:w-48">
                         <?php echo renderCustomSelect('All Stores', 'store_id', ['all' => 'All Stores', '1001' => 'FNF Cardiff'], 'all'); ?>
                    </div>
                </div>
            </div>

            <!-- Chart Section -->
            <div class="glass-panel p-6 rounded-2xl">
                <div class="flex flex-col md:flex-row gap-8 items-center">
                    <div class="w-full md:w-1/2 h-80 relative">
                        <h3 class="text-lg font-bold text-gray-800 dark:text-white mb-6 absolute top-0 left-0">Payment Distribution</h3>
                        <div id="paymentsChart" class="w-full h-full flex items-center justify-center"></div>
                    </div>
                    <!-- Stats Grid next to chart -->
                    <div class="w-full md:w-1/2 grid grid-cols-2 gap-4">
                        <div class="p-4 rounded-xl bg-gray-50 dark:bg-slate-800/50">
                            <div class="text-sm font-medium text-gray-500 dark:text-gray-400">Card (Credit/Debit)</div>
                            <div class="text-2xl font-bold text-gray-800 dark:text-white mt-1">£8,540.50</div>
                            <div class="text-xs text-green-500 font-medium">+12% vs avg</div>
                        </div>
                         <div class="p-4 rounded-xl bg-gray-50 dark:bg-slate-800/50">
                            <div class="text-sm font-medium text-gray-500 dark:text-gray-400">Cash</div>
                            <div class="text-2xl font-bold text-gray-800 dark:text-white mt-1">£3,909.50</div>
                             <div class="text-xs text-red-500 font-medium">-5% vs avg</div>
                        </div>
                         <div class="p-4 rounded-xl bg-gray-50 dark:bg-slate-800/50">
                            <div class="text-sm font-medium text-gray-500 dark:text-gray-400">Online</div>
                            <div class="text-2xl font-bold text-gray-800 dark:text-white mt-1">£0.00</div>
                        </div>
                         <div class="p-4 rounded-xl bg-gray-50 dark:bg-slate-800/50">
                            <div class="text-sm font-medium text-gray-500 dark:text-gray-400">Other</div>
                            <div class="text-2xl font-bold text-gray-800 dark:text-white mt-1">£0.00</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detailed Table -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Payment Method</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Transactions</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Total Amount</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">% of Total</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                             <!-- Row 1 -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-indigo-100 text-indigo-600 dark:bg-indigo-900/30 dark:text-indigo-400 flex items-center justify-center text-lg"><ion-icon name="card-outline"></ion-icon></div>
                                        <span class="font-medium text-gray-800 dark:text-white">Card</span>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">850</td>
                                <td class="py-4 px-6 text-sm font-bold text-gray-800 dark:text-white text-right font-mono">£8,540.50</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">68.6%</td>
                            </tr>
                             <!-- Row 2 -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                 <td class="py-4 px-6">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-green-100 text-green-600 dark:bg-green-900/30 dark:text-green-400 flex items-center justify-center text-lg"><ion-icon name="cash-outline"></ion-icon></div>
                                        <span class="font-medium text-gray-800 dark:text-white">Cash</span>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">395</td>
                                <td class="py-4 px-6 text-sm font-bold text-gray-800 dark:text-white text-right font-mono">£3,909.50</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">31.4%</td>
                            </tr>
                        </tbody>
                        <tfoot class="bg-gray-50/50 dark:bg-slate-800/50 font-bold border-t border-gray-200 dark:border-gray-700">
                            <tr>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white">Total</td>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white text-right font-mono">1,245</td>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white text-right font-mono">£12,450.00</td>
                                <td class="py-4 px-6 text-sm text-gray-800 dark:text-white text-right font-mono">100.0%</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
             renderPaymentsChart();
        });

        // --- Chart Logic ---
        function renderPaymentsChart() {
            const el = document.querySelector("#paymentsChart");
            if (!el) return;
            
            const isDark = document.documentElement.classList.contains('dark');
            const textColor = isDark ? '#e2e8f0' : '#475569';

            const options = {
                chart: {
                    type: 'donut',
                    height: 280,
                    fontFamily: 'Inter, sans-serif',
                    background: 'transparent'
                },
                series: [68.6, 31.4],
                labels: ['Card', 'Cash'],
                colors: ['#4F46E5', '#10B981'],
                plotOptions: {
                    pie: {
                        donut: {
                            size: '70%',
                            labels: {
                                show: true,
                                total: {
                                    show: true,
                                    label: 'Total',
                                    color: textColor,
                                    formatter: () => '£12.4k'
                                }
                            }
                        }
                    }
                },
                dataLabels: { enabled: false },
                legend: { 
                    position: 'bottom',
                    labels: { colors: textColor }
                },
                stroke: { show: false },
                tooltip: {
                    theme: isDark ? 'dark' : 'light'
                }
            };
            
            const chart = new ApexCharts(el, options);
            chart.render();
        }

        // --- Custom Select Logic (Reused) ---
         function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron && !dropdown.classList.contains('invisible')) {
                        chevron.classList.add('rotate-180');
                        chevron.classList.add('text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
