<?php
include 'includes/session.php';
$pageTitle = "Inventory & Stock";
$currentPage = "report_inventory";

// Styles
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Reuse helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) { $selectedLabel = $text; break; }
    }
    if ($selectedVal === '' && !empty($options)) { $selectedVal = array_key_first($options); $selectedLabel = $options[$selectedVal]; }
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        $optionsHtml .= '<div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"><span class="truncate">'.$text.'</span><ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon></div>';
    }
    return '<div class="relative custom-select-container '.$wrapperClass.'"><input type="hidden" name="'.$name.'" value="'.$selectedVal.'"><button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'"><span class="truncate select-label">'.$selectedLabel.'</span><ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon></button><div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar"><div class="p-1 space-y-0.5">'.$optionsHtml.'</div></div></div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-8">

            <!-- Breadcrumbs -->
            <nav class="flex text-sm font-medium text-gray-500 dark:text-gray-400">
                <a href="reports.php" class="hover:text-primary transition-colors">Reports</a>
                <span class="mx-2 text-gray-300 dark:text-gray-600">/</span>
                <span class="text-gray-800 dark:text-white">Inventory Reports</span>
            </nav>

            <!-- Header & Filters -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col xl:flex-row xl:items-start justify-between gap-6 relative z-30">
                <div class="xl:w-1/3">
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Inventory & Stock</h1>
                    <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Stock levels, valuation, and reorder alerts.</p>
                </div>
                
                <div class="flex-1 flex flex-col sm:flex-row items-center justify-end gap-3 w-full">
                     <!-- Category -->
                    <div class="w-full sm:w-48">
                         <?php echo renderCustomSelect('All Categories', 'category_id', ['all' => 'All Categories', 'beverages' => 'Beverages', 'snack' => 'Snacks'], 'all'); ?>
                    </div>
                     <!-- Stock Status -->
                    <div class="w-full sm:w-48">
                         <?php echo renderCustomSelect('All Status', 'stock_status', ['all' => 'All Status', 'low' => 'Low Stock', 'out' => 'Out of Stock'], 'all'); ?>
                    </div>
                </div>
            </div>

            <!-- Stats -->
             <div class="grid grid-cols-1 sm:grid-cols-3 gap-6">
                <div class="glass-panel p-6 rounded-2xl border-l-4 border-blue-500">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Total Stock Value</p>
                    <h3 class="text-3xl font-bold text-gray-800 dark:text-white mt-2">£45,200.00</h3>
                </div>
                <div class="glass-panel p-6 rounded-2xl border-l-4 border-orange-500">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Low Stock Items</p>
                    <h3 class="text-3xl font-bold text-orange-500 mt-2">24</h3>
                </div>
                 <div class="glass-panel p-6 rounded-2xl border-l-4 border-red-500">
                     <p class="text-sm font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Out of Stock</p>
                    <h3 class="text-3xl font-bold text-red-500 mt-2">5</h3>
                </div>
            </div>

            <!-- Inventory Table -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Product Name</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">SKU</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Category</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Stock</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Value</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Status</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                             <!-- Row 1 -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 font-medium text-gray-800 dark:text-white">Coca Cola 500ml</td>
                                <td class="py-4 px-6 text-sm text-gray-500 font-mono">BEV-001</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300">Beverages</td>
                                <td class="py-4 px-6 text-sm font-bold text-gray-800 dark:text-white text-right">145</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">£188.50</td>
                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400">
                                        In Stock
                                    </span>
                                </td>
                            </tr>
                             <!-- Row 2 -->
                            <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 font-medium text-gray-800 dark:text-white">Walkers Ready Salted</td>
                                <td class="py-4 px-6 text-sm text-gray-500 font-mono">SNK-102</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300">Snacks</td>
                                <td class="py-4 px-6 text-sm font-bold text-orange-500 text-right">12</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">£10.20</td>
                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-orange-100 text-orange-800 dark:bg-orange-900/30 dark:text-orange-400">
                                        Low Stock
                                    </span>
                                </td>
                            </tr>
                            <!-- Row 3 -->
                             <tr class="hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6 font-medium text-gray-800 dark:text-white">Mars Bar</td>
                                <td class="py-4 px-6 text-sm text-gray-500 font-mono">SNK-205</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300">Snacks</td>
                                <td class="py-4 px-6 text-sm font-bold text-red-500 text-right">0</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono">£0.00</td>
                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400">
                                        Out of Stock
                                    </span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
        });

        // --- Custom Select Logic (Reused) ---
         function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron && !dropdown.classList.contains('invisible')) {
                        chevron.classList.add('rotate-180');
                        chevron.classList.add('text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
