<?php
include 'includes/session.php';
$pageTitle = "Purchase Orders Management";
$currentPage = "purchase_orders";
require_once 'includes/header.php';

// Mock Data
$orders = [
    [
        'id' => 'PO-2024-001',
        'supplier' => 'Booker Wholesale',
        'store' => 'FNF Cardiff',
        'status' => 'Draft',
        'total_items' => 12,
        'total_amount' => '1,240.50',
        'expected' => '2026-01-20',
        'created_by' => 'Ali K.'
    ],
    [
        'id' => 'PO-2024-002',
        'supplier' => 'Coca Cola Direct',
        'store' => 'FNF Bristol',
        'status' => 'Sent',
        'total_items' => 5,
        'total_amount' => '850.00',
        'expected' => '2026-01-18',
        'created_by' => 'Sarah J.'
    ],
    [
        'id' => 'PO-2023-899',
        'supplier' => 'Local Farm Veg',
        'store' => 'FNF Cardiff',
        'status' => 'Received',
        'total_items' => 8,
        'total_amount' => '320.45',
        'expected' => '2026-01-15',
        'created_by' => 'Ali K.'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="poContent" class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-10">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Purchase Orders</h1>
                    <p class="text-gray-500 dark:text-gray-400 mt-1">Track procurement, manage supplier orders, and incoming shipments.</p>
                </div>
                
                <div class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto">
                    <div class="relative group w-full sm:w-64 shrink-0">
                        <div class="absolute inset-y-0 left-0 pl-3.5 flex items-center pointer-events-none">
                            <ion-icon name="search-outline" class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                        </div>
                        <input type="text" class="w-full bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg pl-10 pr-4 py-2 text-sm focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all outline-none" placeholder="Search PO # or Supplier...">
                    </div>
                    
                    <div class="h-8 w-px bg-gray-200 dark:bg-gray-700 mx-1 hidden sm:block"></div>
                    
                    <div class="flex items-center gap-2">
                        <button class="p-2 text-gray-500 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-all" title="Filter Options">
                            <ion-icon name="filter-outline" class="text-xl"></ion-icon>
                        </button>
                        <button class="p-2 text-gray-500 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-all" title="Export List">
                            <ion-icon name="download-outline" class="text-xl"></ion-icon>
                        </button>
                    </div>

                    <a href="purchase_order_form.php" class="ml-2 px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-lg text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center gap-2 whitespace-nowrap">
                        <ion-icon name="add-circle-outline" class="text-xl"></ion-icon>
                        <span>Create PO</span>
                    </a>
                </div>
            </div>

            <!-- PO Table -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm border border-gray-100 dark:border-gray-700/50">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Purchase Order</th>
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Supplier Details</th>
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Status</th>
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Details</th>
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Expected Date</th>
                                <th class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700/50">
                            <?php foreach ($orders as $po): ?>
                            <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/30 transition-all">
                                <td class="py-5 px-6">
                                    <div class="flex items-center gap-4">
                                        <div class="w-10 h-10 rounded-xl bg-gray-100 dark:bg-slate-700 flex items-center justify-center text-gray-500 dark:text-gray-400 shadow-sm border border-gray-200/50 dark:border-gray-600/30">
                                            <ion-icon name="document-text-outline" class="text-xl"></ion-icon>
                                        </div>
                                        <div>
                                            <div class="text-sm font-bold text-gray-800 dark:text-white group-hover:text-primary transition-colors"><?php echo $po['id']; ?></div>
                                            <div class="text-[11px] font-medium text-gray-400 uppercase tracking-wider mt-0.5">Created By: <?php echo $po['created_by']; ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-5 px-6">
                                    <div class="text-sm font-bold text-gray-700 dark:text-gray-200"><?php echo $po['supplier']; ?></div>
                                    <div class="flex items-center gap-1.5 text-[11px] text-gray-400 font-medium mt-0.5 uppercase tracking-wide">
                                        <ion-icon name="storefront-outline" class="text-xs"></ion-icon>
                                        <?php echo $po['store']; ?>
                                    </div>
                                </td>
                                <td class="py-5 px-6 text-center">
                                    <?php 
                                        $statusClass = '';
                                        $dotClass = '';
                                        if ($po['status'] == 'Draft') {
                                            $statusClass = 'bg-gray-50 dark:bg-gray-800/50 text-gray-500 dark:text-gray-400 border-gray-100 dark:border-gray-700';
                                            $dotClass = 'bg-gray-400';
                                        } elseif ($po['status'] == 'Sent') {
                                            $statusClass = 'bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400 border-blue-100 dark:border-blue-800/50';
                                            $dotClass = 'bg-blue-500';
                                        } elseif ($po['status'] == 'Received') {
                                            $statusClass = 'bg-emerald-50 dark:bg-emerald-900/20 text-emerald-600 dark:text-emerald-400 border-emerald-100 dark:border-emerald-800/50';
                                            $dotClass = 'bg-emerald-500';
                                        }
                                    ?>
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-lg text-[11px] font-bold border <?php echo $statusClass; ?>">
                                        <span class="w-1.5 h-1.5 rounded-full <?php echo $dotClass; ?> mr-2"></span>
                                        <?php echo strtoupper($po['status']); ?>
                                    </span>
                                </td>
                                <td class="py-5 px-6 text-center">
                                    <div class="flex flex-col items-center">
                                        <div class="text-sm font-bold text-gray-700 dark:text-gray-200">£<?php echo $po['total_amount']; ?></div>
                                        <div class="text-[10px] text-gray-400 font-medium uppercase tracking-widest mt-0.5"><?php echo $po['total_items']; ?> ITEMS</div>
                                    </div>
                                </td>
                                <td class="py-5 px-6">
                                    <div class="flex items-center gap-2 text-sm text-gray-600 dark:text-gray-400 font-medium">
                                        <ion-icon name="calendar-outline" class="text-gray-400"></ion-icon>
                                        <?php echo date('M d, Y', strtotime($po['expected'])); ?>
                                    </div>
                                </td>
                                <td class="py-5 px-6 text-right">
                                    <div class="flex items-center justify-end gap-2 opacity-0 group-hover:opacity-100 transition-all transform translate-x-2 group-hover:translate-x-0">
                                        <a href="purchase_order_form.php?id=<?php echo $po['id']; ?>" class="p-2 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-500 hover:text-primary hover:border-primary/30 rounded-xl shadow-sm transition-all" title="Edit Order">
                                            <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                        </a>
                                        <button class="p-2 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-500 hover:text-gray-800 dark:hover:text-white hover:border-gray-300 dark:hover:border-gray-600 rounded-xl shadow-sm transition-all" title="Download PDF">
                                            <ion-icon name="download-outline" class="text-lg"></ion-icon>
                                        </button>
                                        <button class="p-2 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-500 hover:text-red-500 hover:border-red-500/30 rounded-xl shadow-sm transition-all cursor-pointer" title="Delete">
                                            <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination Footer -->
                <div class="p-6 bg-gray-50/50 dark:bg-slate-800/50 border-t border-gray-100 dark:border-gray-700/50 flex flex-col sm:flex-row items-center justify-between gap-4">
                    <p class="text-xs font-bold text-gray-500 uppercase tracking-widest">Showing 3 Purchase Orders</p>
                    <div class="flex gap-2">
                        <button class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl text-xs font-bold text-gray-600 dark:text-gray-400 hover:border-primary hover:text-primary transition-all disabled:opacity-50" disabled>Previous</button>
                        <div class="flex gap-1">
                            <button class="w-9 h-9 flex items-center justify-center rounded-xl bg-primary text-white text-xs font-bold shadow-lg shadow-orange-500/30">1</button>
                        </div>
                        <button class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl text-xs font-bold text-gray-600 dark:text-gray-400 hover:border-primary hover:text-primary transition-all disabled:opacity-50" disabled>Next</button>
                    </div>
                </div>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

