<?php
include 'includes/session.php';
// purchase_order_form.php - Create/Edit Purchase Order
$poId = $_GET['id'] ?? null;
$mode = $poId ? 'edit' : 'create';
$pageTitle = $mode === 'edit' ? "Edit Purchase Order" : "Create Purchase Order";
$currentPage = "purchase_orders";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Custom Select Helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '', $searchable = false) {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    $searchHtml = $searchable ? '
    <div class="p-2 sticky top-0 bg-white dark:bg-slate-800 z-10 border-b border-gray-50 dark:border-gray-700/50 text-center">
        <input type="text" class="custom-select-search w-full px-3 py-1.5 bg-gray-50 dark:bg-slate-700/50 border border-gray-100 dark:border-gray-600 rounded-lg text-xs outline-none focus:border-primary/50" placeholder="Search...">
    </div>' : '';

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            '.$searchHtml.'
            <div class="p-1 space-y-0.5 custom-select-options">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="poFormContent" class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 relative z-50">
                <div class="flex items-center gap-4">
                    <a href="purchase_orders.php" class="w-10 h-10 rounded-xl bg-gray-50 dark:bg-slate-800 border border-gray-200 dark:border-gray-700 flex items-center justify-center text-gray-500 hover:text-primary transition-colors">
                        <ion-icon name="arrow-back-outline" class="text-xl"></ion-icon>
                    </a>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">
                            <?php echo $pageTitle; ?>
                            <?php if ($mode === 'edit'): ?>
                                <span class="text-primary ml-2">#<?php echo $poId; ?></span>
                            <?php endif; ?>
                        </h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Fill in the details to generate a new purchase order.</p>
                    </div>
                </div>
                <!-- Actions -->
                <div class="flex items-center gap-3">
                    <button type="button" class="px-5 py-2.5 bg-gray-50 dark:bg-slate-800 text-gray-700 dark:text-gray-300 rounded-xl text-sm font-bold border border-gray-200 dark:border-gray-700 hover:bg-gray-100 transition-all flex items-center gap-2">
                        <ion-icon name="print-outline" class="text-lg"></ion-icon>
                        <span>Print</span>
                    </button>
                    <button type="submit" form="poForm" class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save PO</span>
                    </button>
                </div>
            </div>

            <form id="poForm" class="space-y-6 overflow-visible" method="POST">
                <!-- Info Grid -->
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 relative z-40">
                    <div class="glass-panel p-6 rounded-2xl space-y-4">
                        <div class="flex items-center gap-2 text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">
                            <ion-icon name="business-outline" class="text-primary"></ion-icon>
                            Logistics Info
                        </div>
                        <div class="space-y-4">
                            <div class="space-y-2">
                                <label class="text-xs font-bold text-gray-500 dark:text-gray-400 ml-1">Select Supplier <span class="text-red-500">*</span></label>
                                <?php 
                                    echo renderCustomSelect('Choose Supplier', 'supplier_id', [
                                        '1' => 'Booker Wholesale',
                                        '2' => 'Coca Cola Direct',
                                        '3' => 'Local Farm Veg',
                                        '4' => 'Bestway Wholesale'
                                    ], '', '', '', true); 
                                ?>
                            </div>
                            <div class="space-y-2">
                                <label class="text-xs font-bold text-gray-500 dark:text-gray-400 ml-1">Ship To Store <span class="text-red-500">*</span></label>
                                <?php 
                                    echo renderCustomSelect('Select Store', 'store_id', [
                                        '101' => 'FNF Cardiff',
                                        '102' => 'FNF Bristol',
                                        '103' => 'FNF London'
                                    ], '101'); 
                                ?>
                            </div>
                        </div>
                    </div>

                    <div class="glass-panel p-6 rounded-2xl space-y-4">
                        <div class="flex items-center gap-2 text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">
                            <ion-icon name="calendar-outline" class="text-primary"></ion-icon>
                            Dates & Reference
                        </div>
                        <div class="space-y-4">
                            <div class="space-y-2">
                                <label class="text-xs font-bold text-gray-500 dark:text-gray-400 ml-1">Expected Delivery</label>
                                <?php 
                                    $pickerId = 'expected_date'; 
                                    $urlParam = 'expected_date';
                                    $showApplyButton = false;
                                    $autoApply = true;
                                    $btnClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between cursor-pointer";
                                    include 'includes/components/date_picker.php'; 
                                ?>
                                <input type="hidden" name="expected_date" id="hidden_expected_date" value="<?php echo $_GET['expected_date'] ?? date('Y-m-d', strtotime('+3 days')); ?>">
                            </div>
                            <div class="space-y-2">
                                <label class="text-xs font-bold text-gray-500 dark:text-gray-400 ml-1">Supplier Ref / Invoice #</label>
                                <input type="text" name="reference" class="<?php echo $inputClass; ?>" placeholder="e.g. INV-90032">
                            </div>
                        </div>
                    </div>

                    <div class="glass-panel p-6 rounded-2xl space-y-4">
                        <div class="flex items-center gap-2 text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">
                            <ion-icon name="information-circle-outline" class="text-primary"></ion-icon>
                            Additional Notes
                        </div>
                        <textarea class="<?php echo $inputClass; ?> min-h-[140px] resize-none" placeholder="Any special instructions for the supplier..."></textarea>
                    </div>
                </div>

                <!-- Item Selection & Table -->
                <div class="glass-panel rounded-2xl p-6 space-y-6 relative z-10 overflow-visible">
                    <div class="flex flex-col md:flex-row justify-between items-center gap-4">
                        <div class="relative group w-full md:max-w-md">
                            <div class="absolute inset-y-0 left-0 pl-3.5 flex items-center pointer-events-none">
                                <ion-icon name="search-outline" class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                            </div>
                            <input type="text" id="itemSearch" class="w-full bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-xl pl-10 pr-4 py-3 text-sm focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all shadow-sm outline-none" placeholder="Search product by name or SKU...">
                            
                            <!-- Search Results Dropdown -->
                            <div id="searchResults" class="absolute top-full left-0 mt-2 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-2xl opacity-0 invisible transform -translate-y-2 transition-all duration-200 z-[100] max-h-80 overflow-y-auto custom-scrollbar">
                                <div class="p-2 space-y-1" id="resultsList">
                                    <!-- Search items will be injected here -->
                                </div>
                            </div>
                        </div>
                        
                        <div class="flex items-center gap-3">
                             <div class="px-4 py-2 bg-primary/5 text-primary rounded-lg text-xs font-bold border border-primary/10">
                                <span id="itemCount">0</span> Items Selected
                             </div>
                             <button type="button" class="text-xs font-bold text-gray-400 hover:text-red-500 transition-colors uppercase tracking-widest" onclick="clearTable()">Clear All</button>
                        </div>
                    </div>

                    <div class="overflow-x-auto">
                        <table class="w-full text-left border-separate border-spacing-0">
                            <thead>
                                <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                    <th class="py-4 px-6 text-[10px] font-bold text-gray-400 uppercase tracking-widest first:rounded-tl-xl">Product Details</th>
                                    <th class="py-4 px-4 text-[10px] font-bold text-gray-400 uppercase tracking-widest text-center">Current Stock</th>
                                    <th class="py-4 px-4 text-[10px] font-bold text-gray-400 uppercase tracking-widest text-center">Order Quantity</th>
                                    <th class="py-4 px-4 text-[10px] font-bold text-gray-400 uppercase tracking-widest text-center w-32">Unit Cost (£)</th>
                                    <th class="py-4 px-4 text-[10px] font-bold text-gray-400 uppercase tracking-widest text-center w-24">Tax (%)</th>
                                    <th class="py-4 px-4 text-[10px] font-bold text-gray-400 uppercase tracking-widest text-right">Row Total</th>
                                    <th class="py-4 px-6 text-[10px] font-bold text-gray-400 uppercase tracking-widest text-right last:rounded-tr-xl"></th>
                                </tr>
                            </thead>
                            <tbody id="poTableBody" class="divide-y divide-gray-50 dark:divide-gray-700/50">
                                <tr id="emptyRow">
                                    <td colspan="7" class="py-12 text-center">
                                        <div class="flex flex-col items-center justify-center text-gray-400">
                                            <ion-icon name="cart-outline" class="text-5xl mb-3 opacity-20"></ion-icon>
                                            <p class="text-sm font-medium">No items added to this order yet.</p>
                                            <p class="text-xs mt-1">Search for products above to start adding.</p>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Totals Section -->
                    <div class="flex flex-col md:flex-row justify-end pt-6 border-t border-gray-100 dark:border-gray-700">
                        <div class="w-full md:w-80 space-y-3">
                            <div class="flex justify-between items-center text-sm font-medium text-gray-500 dark:text-gray-400">
                                <span>Subtotal</span>
                                <span class="text-gray-800 dark:text-white" id="subtotal">£0.00</span>
                            </div>
                            <div class="flex justify-between items-center text-sm font-medium text-gray-500 dark:text-gray-400">
                                <span>Tax Total</span>
                                <span class="text-gray-800 dark:text-white" id="taxTotal">£0.00</span>
                            </div>
                            <div class="flex justify-between items-center pt-3 border-t border-gray-100 dark:border-gray-700">
                                <span class="text-base font-bold text-gray-800 dark:text-white">Grand Total</span>
                                <span class="text-xl font-bold text-primary" id="grandTotal">£0.00</span>
                            </div>
                        </div>
                    </div>
                </div>
            </form>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    // --- Date Picker Handler ---
    window.handleDateChange = async function(url, pickerId, formattedDate) {
        if(pickerId === 'expected_date') {
            const hiddenInput = document.getElementById('hidden_expected_date');
            if(hiddenInput) hiddenInput.value = formattedDate;
        }
    };

    // --- Custom Select Logic ---
    function closeAllSelects() {
        document.querySelectorAll('.custom-select-container').forEach(container => {
            const dropdown = container.querySelector('.custom-select-dropdown');
            const trigger = container.querySelector('.custom-select-trigger');
            if (dropdown && !dropdown.classList.contains('invisible')) {
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                if (chevron) chevron.classList.remove('rotate-180', 'text-primary');
            }
        });
    }

    document.addEventListener('click', (e) => {
        const trigger = e.target.closest('.custom-select-trigger');
        if (trigger) {
            e.stopPropagation();
            const container = trigger.closest('.custom-select-container');
            const dropdown = container.querySelector('.custom-select-dropdown');
            const wasOpen = !dropdown.classList.contains('invisible');
            closeAllSelects();
            if (!wasOpen) {
                dropdown.classList.remove('opacity-0', 'invisible', '-translate-y-2');
                const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                if (chevron) chevron.classList.add('rotate-180', 'text-primary');
            }
            return;
        }

        const option = e.target.closest('.custom-select-option');
        if (option) {
            e.stopPropagation();
            const container = option.closest('.custom-select-container');
            const hiddenInput = container.querySelector('input[type="hidden"]');
            const triggerLabel = container.querySelector('.select-label');
            hiddenInput.value = option.dataset.value;
            triggerLabel.textContent = option.dataset.label;
            closeAllSelects();
            return;
        }
        closeAllSelects();
    });

    // Search Logic
    const products = [
        { id: 101, name: 'Heinz Baked Beans', sku: 'HB-001', stock: 156, price: 0.85, tax: 2, image: 'assets/images/products/heinz.png' },
        { id: 102, name: 'Coca Cola 500ml', sku: 'CC-500', stock: 24, price: 0.95, tax: 20, image: 'assets/images/products/coke.png' },
        { id: 103, name: 'Walkers Ready Salted', sku: 'WK-RS-01', stock: 89, price: 0.45, tax: 20, image: 'assets/images/products/walkers.png' },
        { id: 104, name: 'Fairy Liquid 500ml', sku: 'FL-01', stock: 12, price: 1.20, tax: 20, image: 'assets/images/products/fairy.png' }
    ];

    const searchInput = document.getElementById('itemSearch');
    const searchResults = document.getElementById('searchResults');
    const resultsList = document.getElementById('resultsList');

    searchInput.addEventListener('input', (e) => {
        const query = e.target.value.toLowerCase().trim();
        resultsList.innerHTML = '';
        
        if (!query) {
            searchResults.classList.add('opacity-0', 'invisible', '-translate-y-2');
            return;
        }

        const filtered = products.filter(p => p.name.toLowerCase().includes(query) || p.sku.toLowerCase().includes(query));
        
        if (filtered.length > 0) {
            filtered.forEach(p => {
                const item = document.createElement('div');
                item.className = 'flex items-center gap-3 p-3 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-xl cursor-pointer transition-colors group';
                item.innerHTML = `
                    <div class="w-10 h-10 rounded-lg bg-gray-50 dark:bg-slate-700 flex items-center justify-center p-1 border border-gray-100 dark:border-gray-600">
                        <img src="${p.image}" class="w-full h-full object-contain" onerror="this.src='https://via.placeholder.com/40'">
                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="text-sm font-bold text-gray-800 dark:text-white group-hover:text-primary transition-colors truncate">${p.name}</div>
                        <div class="text-[10px] font-mono text-gray-400 mt-0.5">${p.sku} • Stock: ${p.stock}</div>
                    </div>
                `;
                item.onclick = () => addItem(p);
                resultsList.appendChild(item);
            });
            searchResults.classList.remove('opacity-0', 'invisible', '-translate-y-2');
        } else {
            resultsList.innerHTML = '<div class="p-4 text-center text-xs text-gray-500">No products found.</div>';
            searchResults.classList.remove('opacity-0', 'invisible', '-translate-y-2');
        }
    });

    document.addEventListener('click', (e) => {
        if (!searchInput.contains(e.target) && !searchResults.contains(e.target)) {
            searchResults.classList.add('opacity-0', 'invisible', '-translate-y-2');
        }
    });

    // Table Logic
    function addItem(p) {
        const tbody = document.getElementById('poTableBody');
        const emptyRow = document.getElementById('emptyRow');
        if (emptyRow) emptyRow.remove();

        // Check if already exists
        const existingRow = Array.from(tbody.querySelectorAll('tr')).find(row => row.dataset.id == p.id);
        if (existingRow) {
            const qtyInput = existingRow.querySelector('.qty-input');
            qtyInput.value = parseInt(qtyInput.value) + 1;
            updateRow(qtyInput);
            searchInput.value = '';
            searchResults.classList.add('opacity-0', 'invisible', '-translate-y-2');
            return;
        }

        const row = document.createElement('tr');
        row.className = "group hover:bg-gray-50 dark:hover:bg-slate-800/20 transition-all";
        row.dataset.id = p.id;
        row.innerHTML = `
            <td class="py-5 px-6">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 rounded-xl bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 p-1.5 flex items-center justify-center shadow-sm">
                        <img src="${p.image}" class="w-full h-full object-contain" onerror="this.src='https://via.placeholder.com/40'">
                    </div>
                    <div>
                        <div class="text-sm font-bold text-gray-800 dark:text-white">${p.name}</div>
                        <div class="text-[10px] font-mono text-gray-400 mt-0.5">${p.sku}</div>
                    </div>
                </div>
            </td>
            <td class="py-5 px-4 text-center">
                <span class="text-sm font-bold text-gray-500 dark:text-gray-400">${p.stock}</span>
            </td>
            <td class="py-5 px-4">
                <div class="flex items-center justify-center">
                    <input type="number" class="qty-input w-20 bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg px-2 py-1.5 text-center text-sm font-bold focus:ring-2 focus:ring-primary/20 outline-none" value="1" min="1" oninput="updateRow(this)">
                </div>
            </td>
            <td class="py-5 px-4">
                <input type="number" step="0.01" class="cost-input w-24 bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg px-2 py-1.5 text-center text-sm font-medium focus:ring-2 focus:ring-primary/20 outline-none" value="${p.price}" oninput="updateRow(this)">
            </td>
            <td class="py-5 px-4">
                <input type="number" class="tax-input w-16 bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg px-1 py-1.5 text-center text-xs font-medium text-gray-500 focus:ring-2 focus:ring-primary/20 outline-none" value="${p.tax}" oninput="updateRow(this)">
            </td>
            <td class="py-5 px-4 text-right">
                <div class="text-sm font-bold text-gray-800 dark:text-white row-total">£${p.price.toFixed(2)}</div>
            </td>
            <td class="py-5 px-6 text-right">
                <button type="button" class="p-2 text-gray-400 hover:text-red-500 transition-colors" onclick="removeRow(this)">
                    <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                </button>
            </td>
        `;
        tbody.appendChild(row);
        calculateTotals();
        updateItemCount();
        searchInput.value = '';
        searchResults.classList.add('opacity-0', 'invisible', '-translate-y-2');
    }

    function removeRow(btn) {
        btn.closest('tr').remove();
        if (document.getElementById('poTableBody').children.length === 0) {
            document.getElementById('poTableBody').innerHTML = `
                <tr id="emptyRow">
                    <td colspan="7" class="py-12 text-center">
                        <div class="flex flex-col items-center justify-center text-gray-400">
                            <ion-icon name="cart-outline" class="text-5xl mb-3 opacity-20"></ion-icon>
                            <p class="text-sm font-medium">No items added to this order yet.</p>
                        </div>
                    </td>
                </tr>
            `;
        }
        calculateTotals();
        updateItemCount();
    }

    function updateRow(input) {
        const row = input.closest('tr');
        const qty = parseFloat(row.querySelector('.qty-input').value) || 0;
        const cost = parseFloat(row.querySelector('.cost-input').value) || 0;
        const total = (qty * cost).toFixed(2);
        row.querySelector('.row-total').textContent = '£' + total;
        calculateTotals();
    }

    function calculateTotals() {
        let subtotal = 0;
        let taxTotal = 0;
        document.querySelectorAll('#poTableBody tr[data-id]').forEach(row => {
            const qty = parseFloat(row.querySelector('.qty-input').value) || 0;
            const cost = parseFloat(row.querySelector('.cost-input').value) || 0;
            const taxPerc = parseFloat(row.querySelector('.tax-input').value) || 0;
            const rowBase = qty * cost;
            const rowTax = rowBase * (taxPerc / 100);
            subtotal += rowBase;
            taxTotal += rowTax;
        });
        document.getElementById('subtotal').textContent = '£' + subtotal.toFixed(2);
        document.getElementById('taxTotal').textContent = '£' + taxTotal.toFixed(2);
        document.getElementById('grandTotal').textContent = '£' + (subtotal + taxTotal).toFixed(2);
    }

    function updateItemCount() {
        const count = document.querySelectorAll('#poTableBody tr[data-id]').length;
        document.getElementById('itemCount').textContent = count;
    }

    function clearTable() {
        document.getElementById('poTableBody').innerHTML = '';
        removeRow({ closest: () => ({ remove: () => {} }) }); // Trigger empty state
    }

    // Form Submission
    document.getElementById('poForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const items = document.querySelectorAll('#poTableBody tr[data-id]');
        if (items.length === 0) {
            if(window.showToast) showToast('Please add at least one item to the PO.', 'error');
            else alert('Please add at least one item');
            return;
        }
        
        const btn = this.querySelector('button[type="submit"]');
        const originalContent = btn.innerHTML;
        btn.disabled = true;
        btn.innerHTML = '<ion-icon name="sync-outline" class="animate-spin text-lg"></ion-icon> Generating...';
        
        setTimeout(() => {
            if(window.showToast) showToast('Purchase Order generated successfully!', 'success');
            else alert('PO generated successfully!');
            btn.disabled = false;
            btn.innerHTML = originalContent;
            setTimeout(() => { window.location.href = 'purchase_orders.php'; }, 1000);
        }, 1500);
    });
</script>
