<?php
include 'includes/session.php';
$id = $_GET['id'] ?? 'NEW';
$pageTitle = "PO: $id";
$currentPage = "purchase_orders";
require_once 'includes/header.php';

// Mock Detail
$po = [
    'id' => $id,
    'supplier' => 'Booker Wholesale',
    'store' => 'FNF Cardiff',
    'status' => 'Draft',
    'items' => [
        ['name' => 'Heinz Baked Beans', 'qty' => 50, 'cost' => '0.85', 'total' => '42.50'],
        ['name' => 'Walkers Ready Salted', 'qty' => 100, 'cost' => '0.45', 'total' => '45.00'],
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-4xl mx-auto space-y-6">

            <!-- Back Nav -->
             <div class="flex items-center justify-between">
                <a href="purchase_orders.php" class="inline-flex items-center gap-2 text-gray-500 hover:text-gray-800 dark:hover:text-white transition-colors text-sm font-bold">
                    <ion-icon name="arrow-back-outline"></ion-icon> Back to List
                </a>
                <div class="flex gap-2">
                    <button class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-red-600 dark:text-red-400 rounded-xl text-sm font-bold hover:bg-red-50 dark:hover:bg-red-900/10 transition-colors">
                        Cancel PO
                    </button>
                    <button class="px-4 py-2 bg-gray-900 dark:bg-primary text-white rounded-xl text-sm font-bold hover:opacity-90 transition-all shadow-lg shadow-gray-900/20">
                        Save Draft
                    </button>
                     <button class="px-4 py-2 bg-green-600 text-white rounded-xl text-sm font-bold hover:opacity-90 transition-all shadow-lg shadow-green-600/20">
                        Mark Sent
                    </button>
                </div>
            </div>

            <!-- PO Header -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col md:flex-row gap-6 justify-between">
                <div class="space-y-4">
                     <h1 class="text-3xl font-bold text-gray-800 dark:text-white"><?php echo $id; ?></h1>
                     <div class="flex gap-6 text-sm">
                         <div>
                             <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">Supplier</label>
                             <div class="font-bold text-gray-800 dark:text-white text-lg"><?php echo $po['supplier']; ?></div>
                         </div>
                         <div>
                             <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">Store</label>
                             <div class="font-medium text-gray-700 dark:text-gray-300"><?php echo $po['store']; ?></div>
                         </div>
                     </div>
                </div>
                <div class="flex flex-col items-end justify-center">
                    <div class="text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">Total Estimated Cost</div>
                    <div class="text-2xl font-bold text-gray-800 dark:text-white">£87.50</div>
                </div>
            </div>

            <!-- Line Items -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm">
                <div class="px-6 py-4 border-b border-gray-100 dark:border-gray-700 flex justify-between items-center bg-gray-50/50 dark:bg-slate-800/50">
                    <h3 class="text-sm font-bold text-gray-700 dark:text-gray-200">Order Items</h3>
                    <button class="text-xs font-bold text-primary hover:text-primary-dark">+ Add Product</button>
                </div>
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-50 dark:bg-slate-800 border-b border-gray-100 dark:border-gray-700">
                            <th class="py-3 px-6 text-xs font-bold text-gray-500 uppercase">Product</th>
                            <th class="py-3 px-6 text-xs font-bold text-gray-500 uppercase text-center w-24">Qty</th>
                            <th class="py-3 px-6 text-xs font-bold text-gray-500 uppercase text-right w-32">Unit Cost</th>
                            <th class="py-3 px-6 text-xs font-bold text-gray-500 uppercase text-right w-32">Total</th>
                            <th class="py-3 px-6 text-xs font-bold text-gray-500 uppercase w-10"></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                        <?php foreach ($po['items'] as $item): ?>
                        <tr>
                            <td class="py-3 px-6 text-sm font-medium text-gray-800 dark:text-white">
                                <?php echo $item['name']; ?>
                            </td>
                            <td class="py-3 px-6">
                                <input type="number" value="<?php echo $item['qty']; ?>" class="w-full bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg px-2 py-1 text-sm text-center font-bold">
                            </td>
                            <td class="py-3 px-6 text-right">
                                <span class="text-sm text-gray-600 dark:text-gray-400">£<?php echo $item['cost']; ?></span>
                            </td>
                            <td class="py-3 px-6 text-right">
                                <span class="text-sm font-bold text-gray-800 dark:text-white">£<?php echo $item['total']; ?></span>
                            </td>
                            <td class="py-3 px-6 text-center">
                                <button class="text-gray-400 hover:text-red-500 transition-colors"><ion-icon name="trash-outline"></ion-icon></button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
