<?php
include 'includes/session.php';
$pageTitle = "Products Management";
$currentPage = "products";
require_once 'includes/header.php';

// Mock Data
$products = [
    [
        'id' => 1001,
        'name' => 'Heinz Baked Beans',
        'barcode' => '5000157001234',
        'brand' => 'Heinz',
        'subcategory' => 'Canned Food',
        'store' => 'FNF Cardiff',
        'sell_price' => '1.20',
        'cost_price' => '0.85',
        'stock' => 150,
        'reorder' => 50,
        'tax' => '0%',
        'active' => true,
        'image' => null,
        'updated_by' => 'John Doe',
        'updated_at' => '2026-01-15 14:30:00'
    ],
    [
        'id' => 1002,
        'name' => 'Coca Cola 500ml',
        'barcode' => '5449000000996',
        'brand' => 'Coca Cola',
        'subcategory' => 'Soft Drinks',
        'store' => 'FNF Cardiff',
        'sell_price' => '1.50',
        'cost_price' => '0.90',
        'stock' => 24, // Low stock
        'reorder' => 40,
        'tax' => '20%',
        'active' => true,
        'image' => null,
        'updated_by' => 'Alice Smith',
        'updated_at' => '2026-01-18 09:15:00'
    ],
    [
        'id' => 1002,
        'name' => 'Coca Cola 500ml',
        'barcode' => '5449000000996',
        'brand' => 'Coca Cola',
        'subcategory' => 'Soft Drinks',
        'store' => 'FNF Bristol', // Same product, different store
        'sell_price' => '1.60', // Different price
        'cost_price' => '0.92',
        'stock' => 200,
        'reorder' => 40,
        'tax' => '20%',
        'active' => true,
        'image' => null,
         'updated_by' => 'System Admin',
        'updated_at' => '2026-01-10 11:00:00'
    ],
    [
        'id' => 1003,
        'name' => 'Walkers Ready Salted',
        'barcode' => '5000328901111',
        'brand' => 'Walkers',
        'subcategory' => 'Crisps',
        'store' => 'FNF Cardiff',
        'sell_price' => '0.85',
        'cost_price' => '0.45',
        'stock' => 0,
        'reorder' => 20,
        'tax' => '20%',
        'active' => false, // Inactive
        'image' => null,
        'updated_by' => 'John Doe',
        'updated_at' => '2026-01-12 16:45:00'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="productContent" class="flex-1 p-6 md:p-8 pb-20">
        
        <!-- Header -->
        <div class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-50 overflow-visible">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Products List</h1>
                <p class="text-gray-500 dark:text-gray-400 mt-1">Master catalog and store-specific linking.</p>
            </div>
            
             <!-- Controls Bar -->
            <div class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                 <!-- Global Search (Transparent) -->
                <div class="relative group w-full sm:w-64 shrink-0">
                    <ion-icon name="search-outline" class="absolute left-2 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                    <input type="text" id="globalSearch" class="pl-9 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium" placeholder="Search products...">
                </div>

                 <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <div class="flex flex-wrap gap-2">
                     <button class="px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 text-gray-600 dark:text-gray-300 rounded-lg text-sm font-bold border border-transparent hover:border-gray-200 dark:hover:border-gray-600 transition-all flex items-center gap-2">
                        <ion-icon name="cloud-upload-outline" class="text-lg"></ion-icon> <span class="hidden sm:inline">Import</span>
                    </button>
                    <button class="px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 text-gray-600 dark:text-gray-300 rounded-lg text-sm font-bold border border-transparent hover:border-gray-200 dark:hover:border-gray-600 transition-all flex items-center gap-2">
                        <ion-icon name="link-outline" class="text-lg"></ion-icon> <span class="hidden sm:inline">Link</span>
                    </button>
                </div>

                 <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Create Product (Primary) -->
                <a href="product_form.php" class="flex items-center gap-2 px-4 py-2 bg-primary hover:bg-orange-600 text-white text-sm font-bold rounded-lg shadow-lg shadow-orange-500/30 transition-all transform hover:-translate-y-0.5 shrink-0">
                    <ion-icon name="add-circle-outline" class="text-lg"></ion-icon>
                    <span>Create</span>
                </a>


        </div>
    </div>

        <!-- Products Table -->
        <div class="glass-panel rounded-2xl overflow-visible shadow-sm relative z-0 min-h-[500px]">
             <div class="overflow-x-auto overflow-y-visible">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                            <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider w-16">Img</th>
                            
                            <!-- Product Name (Filter) -->
                            <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[250px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-name" class="transition-colors duration-200">Product</span>
                                    <button onclick="toggleSearchPopup('searchPopup-name')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-name" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Name</span>
                                        <ion-icon name="cube-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-name" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Product Name...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('name')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('name')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                             <!-- Subcategory (Filter) -->
                             <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[160px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-sub" class="transition-colors duration-200">Subcategory</span>
                                    <button onclick="toggleSearchPopup('searchPopup-sub')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="filter-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-sub" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Subcat</span>
                                        <ion-icon name="list-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-sub" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Subcategory...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('sub')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('sub')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                             <!-- Store (Filter) -->
                             <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[180px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-store" class="transition-colors duration-200">Store</span>
                                    <button onclick="toggleSearchPopup('searchPopup-store')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="storefront-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-store" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Store</span>
                                        <ion-icon name="storefront-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-store" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Store Name...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('store')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('store')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                            <!-- Selling Price (Filter) -->
                            <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[140px] text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <span id="header-sell" class="transition-colors duration-200">Selling</span>
                                    <button onclick="toggleSearchPopup('searchPopup-sell')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-sell" class="absolute top-full right-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-right backdrop-blur-xl text-left">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Filter Price</span>
                                        <ion-icon name="pricetag-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <span class="absolute left-3 top-2.5 text-gray-400 font-bold text-xs">£</span>
                                        <input type="number" id="input-sell" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="0.00">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('sell')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('sell')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                            <!-- Cost Price (Filter) -->
                            <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[140px] text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <span id="header-cost" class="transition-colors duration-200">Cost</span>
                                    <button onclick="toggleSearchPopup('searchPopup-cost')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-cost" class="absolute top-full right-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-right backdrop-blur-xl text-left">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Filter Cost</span>
                                        <ion-icon name="wallet-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <span class="absolute left-3 top-2.5 text-gray-400 font-bold text-xs">£</span>
                                        <input type="number" id="input-cost" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="0.00">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('cost')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('cost')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                            <!-- Stock (Filter) -->
                            <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[120px] text-center">
                                <div class="flex items-center justify-center gap-2">
                                    <span id="header-stock" class="transition-colors duration-200">Stock</span>
                                    <button onclick="toggleSearchPopup('searchPopup-stock')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-stock" class="absolute top-full left-1/2 -translate-x-1/2 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top backdrop-blur-xl text-left">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Filter Stock</span>
                                        <ion-icon name="layers-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="number" id="input-stock" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Quantity...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('stock')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('stock')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>
                            
                            <!-- Updated By (Filter) -->
                             <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[200px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-user" class="transition-colors duration-200">Updated By</span>
                                    <button onclick="toggleSearchPopup('searchPopup-user')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-user" class="absolute top-full right-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-right backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Filter User</span>
                                        <ion-icon name="person-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-user" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="User Name...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('user')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('user')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>
                            
                            <!-- Status (Filter) -->
                            <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-l border-gray-100 dark:border-gray-700/50 w-[120px] text-center">
                                <div class="flex items-center justify-center gap-2">
                                    <span>Status</span>
                                </div>
                            </th>
                            
                            <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                        <?php foreach ($products as $prod): 
                             // Initials for updated by
                            $names = explode(' ', $prod['updated_by']);
                            $initials = '';
                            foreach($names as $n) { $initials .= $n[0]; }
                            $initials = strtoupper(substr($initials, 0, 2));
                        ?>
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                            <td class="py-4 px-6">
                                <div class="w-10 h-10 rounded-lg bg-white dark:bg-slate-700 border border-gray-100 dark:border-gray-600 flex items-center justify-center text-gray-400 shadow-sm overflow-hidden">
                                    <?php if($prod['image']): ?>
                                        <img src="<?php echo $prod['image']; ?>" class="w-full h-full object-cover">
                                    <?php else: ?>
                                        <ion-icon name="image-outline" class="text-lg"></ion-icon>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="py-4 px-6">
                                <div>
                                    <div class="text-sm font-bold text-gray-800 dark:text-white"><?php echo $prod['name']; ?></div>
                                    <div class="flex items-center gap-2 mt-0.5">
                                        <span class="text-[10px] bg-gray-100 dark:bg-slate-700 px-1.5 rounded text-gray-500 font-mono"><?php echo $prod['barcode']; ?></span>
                                        <span class="text-[10px] text-gray-400"><?php echo $prod['brand']; ?></span>
                                    </div>
                                </div>
                            </td>
                            <td class="py-4 px-6">
                                <span class="text-xs font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-slate-700/50 px-2 py-1 rounded-lg">
                                    <?php echo $prod['subcategory']; ?>
                                </span>
                            </td>
                            <td class="py-4 px-6">
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-blue-50 text-blue-700 dark:bg-blue-900/30 dark:text-blue-400 border border-blue-100 dark:border-blue-900/50">
                                    <?php echo $prod['store']; ?>
                                </span>
                            </td>
                            <td class="py-4 px-6 text-right">
                                <div class="text-sm font-bold text-gray-800 dark:text-white">£<?php echo $prod['sell_price']; ?></div>
                                <div class="text-[10px] text-gray-500"><?php echo $prod['tax']; ?> Tax</div>
                            </td>
                            <td class="py-4 px-6 text-right">
                                <span class="text-sm font-mono text-gray-500">£<?php echo $prod['cost_price']; ?></span>
                            </td>
                             <td class="py-4 px-6 text-center">
                                <div class="flex flex-col items-center">
                                    <?php if ($prod['stock'] <= 0): ?>
                                        <span class="text-sm font-bold text-red-500">Out of Stock</span>
                                    <?php elseif ($prod['stock'] < $prod['reorder']): ?>
                                        <span class="text-sm font-bold text-orange-500"><?php echo $prod['stock']; ?></span>
                                        <span class="text-[10px] text-orange-400 font-bold">Low</span>
                                    <?php else: ?>
                                        <span class="text-sm font-bold text-gray-700 dark:text-gray-300"><?php echo $prod['stock']; ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <!-- Updated By -->
                            <td class="py-4 px-6">
                                <div class="flex items-center gap-2">
                                    <div class="w-6 h-6 rounded-full bg-orange-100 dark:bg-orange-900/30 flex items-center justify-center text-[10px] font-bold text-orange-600 dark:text-orange-400 border border-orange-200 dark:border-orange-800">
                                        <?php echo $initials; ?>
                                    </div>
                                    <div class="flex flex-col">
                                        <span class="text-xs font-semibold text-gray-700 dark:text-gray-200"><?php echo $prod['updated_by']; ?></span>
                                        <span class="text-[10px] text-gray-400"><?php echo $prod['updated_at']; ?></span>
                                    </div>
                                </div>
                            </td>
                            
                             <td class="py-4 px-6 text-center">
                                <?php if ($prod['active']): ?>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-bold bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400 border border-green-200 dark:border-green-800">Active</span>
                                <?php else: ?>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-bold bg-gray-100 dark:bg-gray-800 text-gray-500 dark:text-gray-400 border border-gray-200 dark:border-gray-700">Inactive</span>
                                <?php endif; ?>
                            </td>

                            <td class="py-4 px-6 text-right">
                                <div class="flex items-center justify-end gap-2">
                                     <!-- Status Toggle -->
                                    <button onclick="toggleStatus(this)" class="p-1.5 rounded-lg transition-colors border <?php echo $prod['active'] ? 'text-emerald-600 bg-emerald-50 hover:bg-emerald-100 border-emerald-100 dark:border-emerald-800/30 dark:bg-emerald-900/20 dark:text-emerald-400' : 'text-gray-400 bg-gray-50 hover:bg-gray-100 border-gray-200 dark:border-gray-700 dark:bg-slate-700 dark:text-gray-500'; ?>" title="<?php echo $prod['active'] ? 'Deactivate' : 'Activate'; ?>">
                                        <ion-icon name="power" class="text-lg"></ion-icon>
                                    </button>

                                    <a href="product_form.php?id=<?php echo $prod['id']; ?>" class="p-1.5 bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 rounded-lg hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 border border-transparent hover:border-orange-100 dark:hover:border-orange-900/30 transition-colors" title="Edit">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </a>
                                     <button class="p-1.5 bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 rounded-lg hover:text-blue-600 hover:bg-blue-50 dark:hover:bg-blue-900/10 border border-transparent hover:border-blue-100 dark:hover:border-blue-900/30 transition-colors" title="Price History">
                                        <ion-icon name="trending-up-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <!-- Delete -->
                                    <button class="p-1.5 bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 rounded-lg hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 border border-transparent hover:border-red-100 dark:hover:border-red-900/30 transition-colors" title="Delete">
                                        <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
             <!-- Pagination (Standard Store Style) -->
            <div class="p-4 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between">
                <span class="pagination-text text-xs text-gray-500 dark:text-gray-400 font-medium">Showing products 1-4 of 4</span>
                <div class="flex gap-2">
                    <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center disabled:opacity-50 disabled:hover:bg-gray-50 disabled:hover:text-gray-500 cursor-pointer disabled:cursor-not-allowed group" disabled>
                        <ion-icon name="chevron-back-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                    <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center cursor-pointer group" disabled>
                        <ion-icon name="chevron-forward-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    // Toggle Search Popups in Table Headers
    function toggleSearchPopup(popupId) {
        // Close all others first
        document.querySelectorAll('[id^="searchPopup-"]').forEach(el => {
            if(el.id !== popupId) {
                el.classList.add('invisible', 'opacity-0', 'translate-y-4');
            }
        });

        const popup = document.getElementById(popupId);
        if(popup) {
            if(popup.classList.contains('invisible')) {
                popup.classList.remove('invisible', 'opacity-0', 'translate-y-4');
            } else {
                popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
            }
        }
    }

    // Close on click outside
    document.addEventListener('click', (e) => {
        if (!e.target.closest('th')) {
            document.querySelectorAll('[id^="searchPopup-"]').forEach(el => {
                 el.classList.add('invisible', 'opacity-0', 'translate-y-4');
            });
        }
    });

    // Prevent closing when clicking inside the popup
    document.querySelectorAll('[id^="searchPopup-"]').forEach(popup => {
        popup.addEventListener('click', (e) => {
            e.stopPropagation();
        });
    });

    // Apply Text Filter (Highlight Header)
    function applyTextFilter(type) {
        const input = document.getElementById('input-' + type);
        const header = document.getElementById('header-' + type);
        const popupId = 'searchPopup-' + type;

        if (input.value.trim() !== "") {
            header.classList.add('text-primary');
        } else {
            header.classList.remove('text-primary');
        }
        
        // Close Popup
        const popup = document.getElementById(popupId);
        popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
    }

    // Clear Text Filter (Remove Highlight)
    function clearTextFilter(type) {
        const input = document.getElementById('input-' + type);
        const header = document.getElementById('header-' + type);
        input.value = "";
        header.classList.remove('text-primary');
    }

    // Toggle Status (Mock Visual Toggle)
    function toggleStatus(btn) {
        const icon = btn.querySelector('ion-icon');
        const isActive = btn.classList.contains('text-emerald-600');
        
        if (isActive) {
            // Switch to Inactive
            btn.classList.remove('text-emerald-600', 'bg-emerald-50', 'hover:bg-emerald-100', 'border-emerald-100', 'dark:border-emerald-800/30', 'dark:bg-emerald-900/20', 'dark:text-emerald-400');
            btn.classList.add('text-gray-400', 'bg-gray-50', 'hover:bg-gray-100', 'border-gray-200', 'dark:border-gray-700', 'dark:bg-slate-700', 'dark:text-gray-500');
            btn.title = "Activate";
            
            // Update Badge (Sibling)
            const row = btn.closest('tr');
            const badge = row.querySelector('td:nth-last-child(2) span');
            badge.className = "inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-bold bg-gray-100 dark:bg-gray-800 text-gray-500 dark:text-gray-400 border border-gray-200 dark:border-gray-700";
            badge.innerText = "Inactive";
            
            if(window.showToast) showToast('Product deactivated', 'success');
        } else {
            // Switch to Active
            btn.classList.remove('text-gray-400', 'bg-gray-50', 'hover:bg-gray-100', 'border-gray-200', 'dark:border-gray-700', 'dark:bg-slate-700', 'dark:text-gray-500');
            btn.classList.add('text-emerald-600', 'bg-emerald-50', 'hover:bg-emerald-100', 'border-emerald-100', 'dark:border-emerald-800/30', 'dark:bg-emerald-900/20', 'dark:text-emerald-400');
            btn.title = "Deactivate";

             // Update Badge (Sibling)
            const row = btn.closest('tr');
            const badge = row.querySelector('td:nth-last-child(2) span');
            badge.className = "inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-bold bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400 border border-green-200 dark:border-green-800";
            badge.innerText = "Active";

            if(window.showToast) showToast('Product activated', 'success');
        }
    }
</script>
</body>
</html>
