<?php
include 'includes/session.php';
$pageTitle = "Product Sub Categories";
$currentPage = "product_subcategories";
require_once 'includes/header.php';

// Mock Data
$subcategories = [
    ['id' => 101, 'name' => 'Soft Drinks', 'parent' => 'Drinks', 'image' => 'assets/images/categories/soft_drinks.png', 'stores' => ['CDF', 'BRI', 'LDN'], 'updated_by' => 'Admin', 'updated_at' => '2023-10-25', 'active' => true],
    ['id' => 102, 'name' => 'Alcohol', 'parent' => 'Drinks', 'image' => 'assets/images/categories/alcohol.png', 'stores' => ['CDF', 'BRI'], 'updated_by' => 'Manager', 'updated_at' => '2023-10-24', 'active' => true],
    ['id' => 103, 'name' => 'Crisps', 'parent' => 'Snacks', 'image' => 'assets/images/categories/crisps.png', 'stores' => ['ALL'], 'updated_by' => 'Admin', 'updated_at' => '2023-10-22', 'active' => true],
    ['id' => 104, 'name' => 'Chocolate', 'parent' => 'Snacks', 'image' => 'assets/images/categories/chocolate.png', 'stores' => ['CDF'], 'updated_by' => 'User1', 'updated_at' => '2023-10-20', 'active' => true],
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto">
            
            <!-- Header -->
            <div class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-50 overflow-visible">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Product Sub Categories</h1>
                    <p class="text-gray-500 dark:text-gray-400 mt-1">Refine your product categorization.</p>
                </div>
                
                 <!-- Controls Bar -->
                <div class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                     <!-- Global Search (Transparent) -->
                    <div class="relative group w-full sm:w-64 shrink-0">
                        <ion-icon name="search-outline" class="absolute left-2 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                        <input type="text" id="globalSearch" class="pl-9 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium" placeholder="Search sub categories...">
                    </div>

                     <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                    <div class="flex flex-wrap gap-2">
                         <button class="px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 text-gray-600 dark:text-gray-300 rounded-lg text-sm font-bold border border-transparent hover:border-gray-200 dark:hover:border-gray-600 transition-all flex items-center gap-2">
                            <ion-icon name="cloud-upload-outline" class="text-lg"></ion-icon> <span class="hidden sm:inline">Import</span>
                        </button>
                    </div>

                     <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                    <!-- Create Category (Primary) -->
                    <a href="product_subcategory_form.php" class="flex items-center gap-2 px-4 py-2 bg-primary hover:bg-orange-600 text-white text-sm font-bold rounded-lg shadow-lg shadow-orange-500/30 transition-all transform hover:-translate-y-0.5 shrink-0">
                        <ion-icon name="add-circle-outline" class="text-lg"></ion-icon>
                        <span>Create</span>
                    </a>
                </div>
            </div>

            <!-- Categories Table -->
            <div class="glass-panel rounded-2xl overflow-visible shadow-sm relative z-0 min-h-[500px]">
                <div class="overflow-x-auto overflow-y-visible">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider w-16">Img</th>
                                <th class="py-4 px-4 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider leading-tight">Sub<br>ID</th>
                                
                                <!-- Sub Category Name (Filter) -->
                                <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[250px]">
                                    <div class="flex items-center justify-between">
                                        <span class="transition-colors duration-200">Sub Category</span>
                                        <button onclick="toggleSearchPopup('searchPopup-subName')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                            <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                        </button>
                                    </div>
                                    <div id="searchPopup-subName" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                        <div class="flex items-center justify-between mb-3 px-1">
                                            <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Name</span>
                                            <ion-icon name="pricetag-outline" class="text-primary text-base"></ion-icon>
                                        </div>
                                        <div class="relative mb-3 group/input">
                                            <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                            <input type="text" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Sub Category Name...">
                                        </div>
                                         <div class="grid grid-cols-2 gap-2">
                                            <button onclick="toggleSearchPopup('searchPopup-subName')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Close</button>
                                            <button class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                        </div>
                                    </div>
                                </th>

                                <!-- Parent Category (Filter) -->
                                <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[200px]">
                                    <div class="flex items-center justify-between">
                                        <span class="transition-colors duration-200">Parent Category</span>
                                        <button onclick="toggleSearchPopup('searchPopup-parent')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                            <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                        </button>
                                    </div>
                                    <div id="searchPopup-parent" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                        <div class="flex items-center justify-between mb-3 px-1">
                                            <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Parent</span>
                                            <ion-icon name="pricetags-outline" class="text-primary text-base"></ion-icon>
                                        </div>
                                        <div class="relative mb-3 group/input">
                                            <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                            <input type="text" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Parent Name...">
                                        </div>
                                         <div class="grid grid-cols-2 gap-2">
                                            <button onclick="toggleSearchPopup('searchPopup-parent')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Close</button>
                                            <button class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                        </div>
                                    </div>
                                </th>

                                 <!-- Stores (Filter) -->
                                <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[150px]">
                                    <div class="flex items-center justify-between">
                                        <span class="transition-colors duration-200">Store</span>
                                        <button onclick="toggleSearchPopup('searchPopup-store')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                            <ion-icon name="storefront-outline" class="text-sm"></ion-icon>
                                        </button>
                                    </div>
                                    <div id="searchPopup-store" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                        <div class="flex items-center justify-between mb-3 px-1">
                                            <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Store</span>
                                            <ion-icon name="storefront-outline" class="text-primary text-base"></ion-icon>
                                        </div>
                                        <div class="relative mb-3 group/input">
                                            <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                            <input type="text" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Store Name...">
                                        </div>
                                         <div class="grid grid-cols-2 gap-2">
                                            <button onclick="toggleSearchPopup('searchPopup-store')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Close</button>
                                            <button class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                        </div>
                                    </div>
                                </th>

                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Updated By</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Updated At</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Status</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                            <?php foreach ($subcategories as $sub): ?>
                            <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-3 px-6">
                                     <div class="w-10 h-10 rounded-lg bg-white dark:bg-slate-700 flex items-center justify-center p-1 border border-gray-100 dark:border-gray-600 shadow-sm">
                                        <?php if(isset($sub['image']) && $sub['image']): ?>
                                             <!-- Mock Image -->
                                            <ion-icon name="image-outline" class="text-xl text-gray-400"></ion-icon>
                                        <?php else: ?>
                                            <ion-icon name="image-outline" class="text-xl text-gray-400"></ion-icon>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td class="py-4 px-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wider">
                                    #<?php echo $sub['id']; ?>
                                </td>
                                <td class="py-4 px-4">
                                    <div class="text-sm font-bold text-gray-800 dark:text-white"><?php echo $sub['name']; ?></div>
                                     <div class="text-[10px] text-gray-400 font-medium mt-0.5"><?php echo $sub['parent']; ?> -> <?php echo $sub['name']; ?></div>
                                </td>
                                <td class="py-4 px-4">
                                     <span class="inline-flex items-center px-2 py-1 rounded-md bg-purple-50 dark:bg-purple-900/10 text-purple-600 dark:text-purple-400 text-xs font-bold">
                                        <?php echo $sub['parent']; ?>
                                     </span>
                                </td>
                                <td class="py-4 px-4">
                                    <div class="flex flex-wrap gap-1">
                                        <?php foreach($sub['stores'] as $store): ?>
                                            <span class="px-1.5 py-0.5 rounded text-[10px] font-bold bg-blue-50 dark:bg-blue-900/10 text-blue-600 dark:text-blue-400 border border-blue-100 dark:border-blue-900/20"><?php echo $store; ?></span>
                                        <?php endforeach; ?>
                                    </div>
                                </td>
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-2">
                                        <div class="w-6 h-6 rounded-full bg-orange-100 dark:bg-orange-900/30 flex items-center justify-center text-[10px] font-bold text-orange-600 dark:text-orange-400 border border-orange-200 dark:border-orange-800">
                                            <?php echo substr($sub['updated_by'], 0, 1); ?>
                                        </div>
                                        <span class="text-xs font-medium text-gray-600 dark:text-gray-300"><?php echo $sub['updated_by']; ?></span>
                                    </div>
                                </td>
                                <td class="py-4 px-6">
                                    <div class="text-xs font-medium text-gray-600 dark:text-gray-400"><?php echo date('Y-m-d', strtotime($sub['updated_at'])); ?></div>
                                    <div class="text-[10px] text-gray-400 mt-0.5"><?php echo date('H:i', strtotime($sub['updated_at'])); ?></div>
                                </td>
                                <td class="py-4 px-6 text-center">
                                     <button class="relative group/status inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full bg-green-50 dark:bg-green-900/10 border border-green-100 dark:border-green-900/30 transition-all hover:bg-green-100 dark:hover:bg-green-900/20 cursor-pointer">
                                        <div class="w-1.5 h-1.5 rounded-full bg-green-500 animate-pulse"></div>
                                        <span class="text-[10px] font-bold text-green-600 dark:text-green-400 uppercase tracking-wider">ACTIVE</span>
                                    </button>
                                </td>
                                <td class="py-4 px-6 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                        <button class="w-8 h-8 rounded-lg flex items-center justify-center text-gray-400 hover:text-emerald-500 hover:bg-emerald-50 dark:hover:bg-emerald-900/10 border border-transparent hover:border-emerald-100 dark:hover:border-emerald-900/30 transition-all" title="View details">
                                            <ion-icon name="power-outline" class="text-lg"></ion-icon>
                                        </button>
                                         <a href="product_subcategory_form.php?id=<?php echo $sub['id']; ?>" class="w-8 h-8 rounded-lg flex items-center justify-center text-gray-400 hover:text-blue-500 hover:bg-blue-50 dark:hover:bg-blue-900/10 border border-transparent hover:border-blue-100 dark:hover:border-blue-900/30 transition-all" title="Edit">
                                            <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                        </a>
                                        <button class="w-8 h-8 rounded-lg flex items-center justify-center text-gray-400 hover:text-purple-500 hover:bg-purple-50 dark:hover:bg-purple-900/10 border border-transparent hover:border-purple-100 dark:hover:border-purple-900/30 transition-all" title="Analytics">
                                            <ion-icon name="stats-chart-outline" class="text-lg"></ion-icon>
                                        </button>
                                         <button class="w-8 h-8 rounded-lg flex items-center justify-center text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 border border-transparent hover:border-red-100 dark:hover:border-red-900/30 transition-all" title="Delete">
                                            <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    function toggleSearchPopup(id) {
        const popup = document.getElementById(id);
        const allPopups = document.querySelectorAll('[id^="searchPopup-"]');
        
        allPopups.forEach(p => {
            if (p.id !== id) {
                p.classList.add('invisible', 'opacity-0', 'translate-y-4');
            }
        });

        if (popup.classList.contains('invisible')) {
            popup.classList.remove('invisible', 'opacity-0', 'translate-y-4');
        } else {
            popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
        }
    }

    // Close on click outside
    document.addEventListener('click', function(event) {
        if (!event.target.closest('th')) {
            const allPopups = document.querySelectorAll('[id^="searchPopup-"]');
            allPopups.forEach(p => {
                p.classList.add('invisible', 'opacity-0', 'translate-y-4');
            });
        }
    });
</script>
