<?php
include 'includes/session.php';
$pageTitle = "Create Permission Template";
$currentPage = "permission_templates";
require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full custom-scrollbar">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Matched to store_form.php) -->
            <form action="permission_templates.php" method="POST" id="templateCreateForm">
                <div
                    class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                    <div class="flex items-center gap-4">
                        <a href="permission_templates.php"
                            class="w-10 h-10 rounded-xl bg-gray-50 dark:bg-slate-800 text-gray-400 flex items-center justify-center hover:bg-primary hover:text-white transition-all shadow-sm group">
                            <ion-icon name="arrow-back-outline"
                                class="text-xl group-hover:-translate-x-1 transition-transform"></ion-icon>
                        </a>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Create Template
                            </h1>
                            <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Design reusable permission
                                blueprints.</p>
                        </div>
                    </div>
                    <div class="flex items-center gap-3">
                        <a href="permission_templates.php"
                            class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-primary hover:border-primary/30 hover:bg-orange-50 dark:hover:bg-slate-700 rounded-xl text-sm font-semibold transition-all shadow-sm">
                            Cancel
                        </a>
                        <button type="submit"
                            class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                            <ion-icon name="copy-outline" class="text-lg"></ion-icon>
                            <span>Save Template</span>
                        </button>
                    </div>
                </div>

                <!-- Main Form Card -->
                <div class="glass-panel rounded-2xl mt-6">
                    <div class="p-6 md:p-8 space-y-10">

                        <!-- Section: Template Details -->
                        <div class="space-y-6">
                            <h3
                                class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">
                                Template Details</h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <!-- Template Name -->
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Template
                                        Name <span class="text-red-500">*</span></label>
                                    <input type="text" name="template_name" placeholder="e.g. Premium Night Shift"
                                        required
                                        class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400">
                                </div>

                                <!-- Template Category -->
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Store
                                        Category <span class="text-red-500">*</span></label>
                                    <?php echo renderCustomSelect('', 'template_type', [
                                        'grocery' => 'Grocery',
                                        'restaurant' => 'Restaurant',
                                        'pub' => 'Pub/Bar',
                                        'all' => 'Generic/All'
                                    ], 'all', 'w-full', 'py-3 px-4 text-sm font-medium rounded-xl'); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Section: Foundation -->
                        <div class="space-y-6">
                            <h3
                                class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">
                                Foundation Blueprint</h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300 ml-1">Base
                                        Blueprint (Optional)</label>
                                    <?php echo renderCustomSelect('', 'base_blueprint', [
                                        '' => 'Blank Slate',
                                        '101' => 'Standard Grocery Cashier',
                                        '102' => 'Restaurant Wait Staff'
                                    ], '', 'w-full', 'py-3 px-4 text-sm font-medium rounded-xl'); ?>
                                    <p class="text-xs text-gray-400 font-medium ml-1">Clone an existing template as a
                                        starting point. Roles linked to this template will inherit these permissions.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Footer Action -->
                    <div
                        class="px-8 py-6 bg-gray-50/50 dark:bg-slate-800/50 border-t border-gray-100 dark:border-gray-700 rounded-b-2xl flex justify-end">
                        <button type="submit"
                            class="px-8 py-3 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 transition-all active:scale-95">
                            Finalize Template
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<?php require_once 'includes/footer.php'; ?>