<?php
include 'includes/session.php';
$pageTitle = "Permission Templates";
$currentPage = "permission_templates";
require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Mock Data
$templates = [
    [
        'id' => 101,
        'name' => 'Standard Grocery Cashier',
        'type' => 'Grocery',
        'used_by' => 3
    ],
    [
        'id' => 102,
        'name' => 'Restaurant Wait Staff',
        'type' => 'Restaurant',
        'used_by' => 1
    ],
    [
        'id' => 103,
        'name' => 'Kitchen Display',
        'type' => 'Restaurant',
        'used_by' => 0
    ],
    [
        'id' => 104,
        'name' => 'Stock Taker',
        'type' => 'All',
        'used_by' => 2
    ]
];

// Calculation
$totalTemplates = count($templates);
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full custom-scrollbar">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20 space-y-8">

        <!-- Header Alignment Refined (Strictly per stores.php) -->
        <div
            class="glass-panel rounded-2xl p-6 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-50 overflow-visible shadow-xl border border-white/20">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight leading-none">Permission
                    Templates</h1>
                <p class="text-gray-500 dark:text-gray-400 mt-1 text-sm">Blueprint permission sets for rapid
                    deployment.</p>
            </div>

            <!-- Controls Bar Alignment (as per stores.php) -->
            <div
                class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">

                <!-- Search (Transparent) -->
                <div class="relative group w-full sm:w-48 shrink-0">
                    <ion-icon name="search-outline"
                        class="absolute left-2.5 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                    <input type="text" id="template-search-header"
                        class="pl-8 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium bg-transparent"
                        placeholder="Search...">
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Create (Match store style) -->
                <a href="permission_templates_create.php"
                    class="flex items-center gap-2 px-3 py-2 text-primary font-bold text-sm hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors shrink-0 whitespace-nowrap">
                    <ion-icon name="add-circle-outline" class="text-lg"></ion-icon>
                    <span>Create</span>
                </a>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Export (Primary) -->
                <button
                    class="flex items-center gap-2 px-4 py-2 bg-primary hover:bg-orange-600 text-white text-sm font-bold rounded-lg shadow-lg shadow-orange-500/30 transition-all transform hover:-translate-y-0.5 shrink-0 ml-1">
                    <ion-icon name="download-outline"></ion-icon>
                    <span>Export</span>
                </button>
            </div>
        </div>

        <!-- Templates List Container -->
        <div
            class="glass-panel rounded-3xl overflow-hidden shadow-xl shadow-gray-200/50 dark:shadow-none border border-white/20">

            <!-- Filters Row Removed in favor of Consolidated Header as per stores.php -->

            <!-- Table -->
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-50/50 dark:bg-slate-800/30">
                            <th
                                class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">
                                Template Blueprint</th>
                            <th
                                class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">
                                Store Category</th>
                            <th
                                class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-center">
                                Applied Roles</th>
                            <th
                                class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">
                                Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-gray-700/50">
                        <?php foreach ($templates as $tmpl): ?>
                            <tr class="group hover:bg-primary/[0.02] transition-colors cursor-pointer template-row">
                                <td class="py-5 px-6">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-10 h-10 rounded-xl bg-gray-100 dark:bg-slate-800 text-gray-500 flex items-center justify-center transition-all group-hover:bg-primary/20 group-hover:text-primary">
                                            <ion-icon name="copy-outline" class="text-xl"></ion-icon>
                                        </div>
                                        <div
                                            class="text-sm font-bold text-gray-800 dark:text-white group-hover:text-primary transition-colors">
                                            <?php echo $tmpl['name']; ?>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-5 px-6">
                                    <span
                                        class="inline-flex items-center px-2.5 py-1 rounded-lg text-xs font-bold bg-gray-100/80 text-gray-600 dark:bg-slate-700/50 dark:text-gray-400 border border-gray-200 dark:border-gray-700">
                                        <?php echo $tmpl['type']; ?>
                                    </span>
                                </td>
                                <td class="py-5 px-6 text-center">
                                    <div
                                        class="inline-flex items-center px-2 py-1 bg-white dark:bg-slate-800 rounded-lg text-xs font-bold text-gray-700 dark:text-gray-300 border border-gray-100 dark:border-gray-700 shadow-sm">
                                        <?php echo $tmpl['used_by']; ?> Roles
                                    </div>
                                </td>
                                <td class="py-5 px-6 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                        <a href="permission_editor.php?type=template&id=<?php echo $tmpl['id']; ?>"
                                            class="w-9 h-9 flex items-center justify-center bg-gray-50 dark:bg-slate-800 text-gray-500 rounded-xl hover:bg-primary hover:text-white transition-all active:scale-95 shadow-sm"
                                            title="Edit Template">
                                            <ion-icon name="create-outline"></ion-icon>
                                        </a>
                                        <button
                                            class="w-9 h-9 flex items-center justify-center bg-gray-50 dark:bg-slate-800 text-gray-500 rounded-xl hover:bg-blue-500 hover:text-white transition-all active:scale-95 shadow-sm"
                                            title="Deploy to Roles">
                                            <ion-icon name="arrow-redo-outline"></ion-icon>
                                        </button>
                                        <button
                                            class="w-9 h-9 flex items-center justify-center bg-gray-50 dark:bg-slate-800 text-gray-500 rounded-xl hover:bg-gray-900 dark:hover:bg-slate-600 hover:text-white transition-all active:scale-95 shadow-sm"
                                            title="Clone Template">
                                            <ion-icon name="duplicate-outline"></ion-icon>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination Placeholder -->
            <div class="p-6 border-t border-gray-100 dark:border-gray-700/50 flex items-center justify-between">
                <span class="text-xs font-bold text-gray-400 uppercase tracking-widest">Total Templates:
                    <?php echo $totalTemplates; ?></span>
                <div class="flex gap-2">
                    <button
                        class="px-4 py-2 bg-gray-50 dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl text-xs font-bold text-gray-400 cursor-not-allowed"
                        disabled>Prev</button>
                    <button
                        class="px-4 py-2 bg-gray-50 dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl text-xs font-bold text-gray-400 cursor-not-allowed"
                        disabled>Next</button>
                </div>
            </div>
        </div>

    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    document.getElementById('template-search-header').addEventListener('input', function (e) {
        const term = e.target.value.toLowerCase();
        const rows = document.querySelectorAll('.template-row');

        rows.forEach(row => {
            const text = row.innerText.toLowerCase();
            row.style.display = text.includes(term) ? '' : 'none';
        });
    });
</script>