<?php
include 'includes/session.php';
$id = $_GET['id'] ?? 0;
$type = $_GET['type'] ?? 'role'; // 'role' or 'template'

$name = ($type == 'role') ? "Superadmin" : "Standard Grocery Cashier";
$pageTitle = "Edit Permissions: $name";
$currentPage = ($type == 'role') ? 'roles' : 'permission_templates';

require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Mock Feature Groups
$featureGroups = [
    'Dashboard' => ['view_kpi', 'view_charts'],
    'Sales' => ['sale.create', 'sale.discount', 'sale.void', 'sale.refund', 'sale.park'],
    'Inventory' => ['product.view', 'product.create', 'product.edit', 'product.delete', 'stock.adjust'],
    'Users' => ['users.view', 'users.create', 'users.edit', 'users.disable', 'users.reset_password'],
    'Reports' => ['reports.view_sales', 'reports.view_staff', 'reports.export', 'reports.view_finance'],
    'System' => ['settings.view', 'settings.edit', 'audit.view', 'logs.view']
];

$totalPerms = 0;
foreach ($featureGroups as $g => $p)
    $totalPerms += count($p);

?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-hidden w-full h-screen custom-scrollbar">

    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Editor Layout -->
    <div class="flex-1 flex overflow-hidden">

        <!-- Left Sidebar: Feature Groups -->
        <aside
            class="w-72 bg-white/80 dark:bg-slate-900/80 backdrop-blur-xl border-r border-gray-200 dark:border-gray-800 flex flex-col z-10">
            <div class="p-6 border-b border-gray-200 dark:border-gray-800">
                <div class="flex items-center gap-2 mb-2">
                    <span class="w-2 h-2 rounded-full bg-primary animate-pulse"></span>
                    <div class="text-[10px] font-black text-gray-400 uppercase tracking-[0.2em] leading-none">Editing
                        <?php echo $type; ?>
                    </div>
                </div>
                <h2 class="text-xl font-black text-gray-800 dark:text-white truncate leading-tight"
                    title="<?php echo $name; ?>"><?php echo $name; ?></h2>
            </div>

            <nav class="flex-1 overflow-y-auto p-4 space-y-1.5 custom-scrollbar">
                <a href="#group-all"
                    class="group flex items-center justify-between px-4 py-3 text-sm font-black rounded-2xl bg-primary/10 text-primary transition-all hover:scale-[1.02] active:scale-95 group-active">
                    <div class="flex items-center gap-3">
                        <ion-icon name="apps-outline" class="text-lg"></ion-icon>
                        <span>All Features</span>
                    </div>
                    <span
                        class="bg-primary text-white text-[10px] px-2 py-0.5 rounded-full shadow-lg shadow-primary/20"><?php echo $totalPerms; ?></span>
                </a>

                <div class="h-4"></div>

                <?php foreach ($featureGroups as $group => $perms): ?>
                    <a href="#group-<?php echo strtolower($group); ?>"
                        class="group flex items-center justify-between px-4 py-3 text-sm font-bold rounded-2xl text-gray-500 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-slate-800/50 hover:text-gray-900 dark:hover:text-white transition-all hover:translate-x-1 nav-link">
                        <div class="flex items-center gap-3">
                            <div
                                class="w-1.5 h-1.5 rounded-full bg-gray-300 dark:bg-gray-600 transition-colors group-hover:bg-primary">
                            </div>
                            <span><?php echo $group; ?></span>
                        </div>
                        <span
                            class="bg-gray-100 dark:bg-slate-700 text-gray-500 text-[10px] px-2 py-0.5 rounded-full group-hover:bg-primary/10 group-hover:text-primary transition-colors"><?php echo count($perms); ?></span>
                    </a>
                <?php endforeach; ?>
            </nav>

            <div class="p-4 border-t border-gray-200 dark:border-gray-800 bg-gray-50/50 dark:bg-slate-800/30">
                <button
                    class="w-full py-3.5 bg-gray-900 dark:bg-primary text-white rounded-2xl text-sm font-black hover:opacity-90 transition-all shadow-xl shadow-gray-900/20 active:scale-95 flex items-center justify-center gap-2">
                    <ion-icon name="cloud-upload-outline" class="text-lg"></ion-icon>
                    Confirm Changes
                </button>
            </div>
        </aside>

        <!-- Main Content: Matrix -->
        <div class="flex-1 flex flex-col bg-gray-50 dark:bg-black/40 overflow-hidden relative">

            <!-- Matrix Header Controls (Aligned to stores.php pattern) -->
            <div
                class="h-20 bg-white/80 dark:bg-slate-900/80 backdrop-blur-md border-b border-gray-200 dark:border-gray-800 flex items-center justify-between px-8 shrink-0 z-10">
                <div
                    class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 overflow-visible">

                    <!-- Search (Transparent) -->
                    <div class="relative group w-48 shrink-0">
                        <ion-icon name="search-outline"
                            class="absolute left-2.5 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                        <input type="text" id="matrix-search" placeholder="Filter permissions..."
                            class="pl-8 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium bg-transparent">
                    </div>

                    <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                    <!-- Select All Logic -->
                    <label
                        class="flex items-center gap-3 px-3 py-2 cursor-pointer select-none group hover:bg-white dark:hover:bg-slate-700 rounded-lg transition-all">
                        <div class="relative w-5 h-5">
                            <input type="checkbox" id="select-all"
                                class="peer absolute inset-0 opacity-0 cursor-pointer z-10">
                            <div
                                class="absolute inset-0 bg-white dark:bg-slate-800 border-2 border-gray-200 dark:border-gray-700 rounded-lg transition-all peer-checked:bg-primary peer-checked:border-primary flex items-center justify-center shadow-sm">
                                <ion-icon name="checkmark"
                                    class="text-white opacity-0 peer-checked:opacity-100 transition-opacity text-xs"></ion-icon>
                            </div>
                        </div>
                        <span
                            class="text-[10px] font-black text-gray-400 group-hover:text-primary uppercase tracking-widest transition-colors">Select
                            All</span>
                    </label>
                </div>

                <div
                    class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 overflow-visible">
                    <span class="text-[10px] font-black text-gray-400 uppercase tracking-widest ml-2">Rapid
                        Import:</span>
                    <div class="relative min-w-[200px]">
                        <?php echo renderCustomSelect('', 'copy_template', [
                            '' => 'Choose Template...',
                            '101' => 'Standard Grocery Cashier',
                            '102' => 'Restaurant Wait Staff',
                            '103' => 'Kitchen Display'
                        ], '', 'max-w-xs', 'py-1.5 text-[10px] font-black uppercase tracking-widest bg-transparent border-none focus:ring-0'); ?>
                    </div>
                </div>
            </div>

            <!-- Scrollable Matrix -->
            <div class="flex-1 overflow-y-auto p-8 space-y-12 custom-scrollbar scroll-smooth" id="matrix-container">

                <?php foreach ($featureGroups as $group => $perms): ?>
                    <div id="group-<?php echo strtolower($group); ?>" class="scroll-mt-24 feature-section">
                        <div class="flex items-center justify-between mb-6">
                            <div class="flex items-center gap-4">
                                <div
                                    class="w-10 h-10 rounded-2xl bg-white dark:bg-slate-800 shadow-sm flex items-center justify-center text-primary border border-gray-100 dark:border-gray-700">
                                    <ion-icon name="finger-print-outline" class="text-xl"></ion-icon>
                                </div>
                                <div>
                                    <h3 class="text-xl font-black text-gray-800 dark:text-white leading-none">
                                        <?php echo $group; ?>
                                    </h3>
                                    <p class="text-[10px] text-gray-400 font-bold uppercase tracking-widest mt-1.5">
                                        <?php echo count($perms); ?> Control Points
                                    </p>
                                </div>
                            </div>
                            <div class="h-px flex-1 bg-gradient-to-r from-gray-200 dark:from-gray-800 to-transparent ml-6">
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
                            <?php foreach ($perms as $perm): ?>
                                <div class="glass-panel p-4 hover:border-primary/50 hover:shadow-xl hover:shadow-primary/5 transition-all group cursor-pointer select-none relative overflow-hidden perm-card"
                                    onclick="togglePerm(this)">
                                    <div
                                        class="absolute -right-4 -bottom-4 w-12 h-12 bg-primary/5 rounded-full blur-xl group-hover:bg-primary/20 transition-colors">
                                    </div>

                                    <div class="flex items-start gap-4 relative z-10">
                                        <div class="relative w-6 h-6 shrink-0 mt-0.5">
                                            <input type="checkbox" name="perms[]" value="<?php echo $perm; ?>"
                                                class="peer absolute inset-0 opacity-0 cursor-pointer z-10"
                                                onclick="event.stopPropagation()">
                                            <div
                                                class="absolute inset-0 bg-gray-50 dark:bg-slate-800 border-2 border-gray-200 dark:border-gray-700 rounded-lg transition-all peer-checked:bg-primary peer-checked:border-primary flex items-center justify-center">
                                                <ion-icon name="checkmark-sharp"
                                                    class="text-white opacity-0 peer-checked:opacity-100 transition-opacity text-sm font-bold"></ion-icon>
                                            </div>
                                        </div>
                                        <div>
                                            <div
                                                class="text-sm font-black text-gray-700 dark:text-gray-200 group-hover:text-primary transition-colors leading-tight">
                                                <?php
                                                // Format perm key to readable
                                                $parts = explode('.', $perm);
                                                $label = end($parts);
                                                echo str_replace('_', ' ', ucfirst($label));
                                                ?>
                                            </div>
                                            <div class="text-[10px] text-gray-400 font-mono font-bold mt-1 tracking-tight">
                                                <?php echo $perm; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endforeach; ?>

                <div class="h-20"></div>
            </div>

            <!-- Absolute Shadow overlays for scroll -->
            <div
                class="absolute top-20 left-0 right-0 h-8 bg-gradient-to-b from-gray-50 dark:from-black/20 to-transparent pointer-events-none z-0">
            </div>
            <div
                class="absolute bottom-0 left-0 right-0 h-20 bg-gradient-to-t from-gray-50 dark:from-black/20 to-transparent pointer-events-none z-0">
            </div>

        </div>

    </div>
</main>

<script>
    function togglePerm(card) {
        const cb = card.querySelector('input[type="checkbox"]');
        cb.checked = !cb.checked;

        // Animate card
        if (cb.checked) {
            card.classList.add('border-primary/50', 'ring-2', 'ring-primary/10');
        } else {
            card.classList.remove('border-primary/50', 'ring-2', 'ring-primary/10');
        }
    }

    // Select All Logic
    document.getElementById('select-all').addEventListener('change', function (e) {
        const visibleCards = document.querySelectorAll('.perm-card:not([style*="display: none"])');
        visibleCards.forEach(card => {
            const cb = card.querySelector('input');
            cb.checked = e.target.checked;
            if (cb.checked) {
                card.classList.add('border-primary/50', 'ring-2', 'ring-primary/10');
            } else {
                card.classList.remove('border-primary/50', 'ring-2', 'ring-primary/10');
            }
        });
    });

    // Search Logic
    document.getElementById('matrix-search').addEventListener('input', function (e) {
        const term = e.target.value.toLowerCase();
        const sections = document.querySelectorAll('.feature-section');

        sections.forEach(section => {
            const cards = section.querySelectorAll('.perm-card');
            let sectionVisible = false;

            cards.forEach(card => {
                const text = card.innerText.toLowerCase();
                if (text.includes(term)) {
                    card.style.display = '';
                    sectionVisible = true;
                } else {
                    card.style.display = 'none';
                }
            });

            section.style.display = sectionVisible ? '' : 'none';
        });
    });

    // Sidebar active state logic
    const container = document.getElementById('matrix-container');
    const sections = document.querySelectorAll('.feature-section');
    const navLinks = document.querySelectorAll('.nav-link');

    container.addEventListener('scroll', () => {
        let current = '';
        sections.forEach(section => {
            const sectionTop = section.offsetTop;
            if (container.scrollTop >= sectionTop - 150) {
                current = section.getAttribute('id');
            }
        });

        navLinks.forEach(link => {
            link.classList.remove('bg-primary/10', 'text-primary', 'translate-x-1');
            link.querySelector('div div').classList.remove('bg-primary');

            if (link.getAttribute('href').includes(current)) {
                link.classList.add('bg-primary/10', 'text-primary', 'translate-x-1');
                link.querySelector('div div').classList.add('bg-primary');
            }
        });
    });
</script>

<style>
    .custom-scrollbar::-webkit-scrollbar {
        width: 6px;
    }

    .custom-scrollbar::-webkit-scrollbar-track {
        background: transparent;
    }

    .custom-scrollbar::-webkit-scrollbar-thumb {
        background: rgba(0, 0, 0, 0.1);
        border-radius: 10px;
    }

    .dark .custom-scrollbar::-webkit-scrollbar-thumb {
        background: rgba(255, 255, 255, 0.1);
    }
</style>