<?php
include 'includes/session.php';
$pageTitle = "Payroll Preview";
$currentPage = "payroll";

// Styles
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Reuse helper (Inline again for speed/standalone)
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) { $selectedLabel = $text; break; }
    }
    if ($selectedVal === '' && !empty($options)) { $selectedVal = array_key_first($options); $selectedLabel = $options[$selectedVal]; }
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        $optionsHtml .= '<div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"><span class="truncate">'.$text.'</span><ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon></div>';
    }
    return '<div class="relative custom-select-container '.$wrapperClass.'"><input type="hidden" name="'.$name.'" value="'.$selectedVal.'"><button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'"><span class="truncate select-label">'.$selectedLabel.'</span><ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon></button><div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar"><div class="p-1 space-y-0.5">'.$optionsHtml.'</div></div></div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20 overflow-y-auto custom-scrollbar">
        <div class="max-w-[1600px] mx-auto space-y-8">

            <!-- Header & Filters -->
            <div class="flex flex-col lg:flex-row lg:items-center justify-between gap-6">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 rounded-2xl bg-primary/10 flex items-center justify-center text-primary shadow-sm border border-primary/10">
                        <ion-icon name="wallet-outline" class="text-2xl"></ion-icon>
                    </div>
                    <div>
                         <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Payroll Preview</h1>
                         <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Review estimated staff costs and wages.</p>
                    </div>
                </div>

                <div class="flex flex-col sm:flex-row items-center gap-3">
                    <div class="w-full sm:w-48">
                         <?php echo renderCustomSelect('Select Period', 'period', ['week' => 'This Week', 'month' => 'This Month', 'last_month' => 'Last Month'], 'month'); ?>
                    </div>
                     <div class="w-full sm:w-48">
                         <?php echo renderCustomSelect('All Stores', 'store_id', ['all' => 'All Stores', '1001' => 'FNF Cardiff'], 'all'); ?>
                    </div>
                    <button class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold transition-all shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="download-outline" class="text-lg"></ion-icon>
                        <span class="hidden sm:inline">Export Report</span>
                    </button>
                </div>
            </div>

            <!-- Metrics Widgets -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                
                <!-- Total Wages -->
                <div class="glass-panel p-8 rounded-[2rem] relative overflow-hidden group border-none shadow-sm">
                    <div class="absolute -top-4 -right-4 w-32 h-32 bg-primary/5 rounded-full blur-3xl group-hover:bg-primary/10 transition-colors"></div>
                    <div class="relative z-10">
                        <div class="flex items-center gap-3 mb-4">
                            <div class="w-10 h-10 rounded-xl bg-orange-100 dark:bg-orange-500/10 text-orange-600 dark:text-orange-400 flex items-center justify-center text-lg">
                                <ion-icon name="cash-outline"></ion-icon>
                            </div>
                            <p class="text-xs font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest">Estimated Payroll</p>
                        </div>
                        <div class="flex items-baseline gap-2">
                            <h3 class="text-4xl font-extrabold text-gray-800 dark:text-white tracking-tight">£4,250.00</h3>
                        </div>
                        <div class="mt-4 flex items-center gap-2">
                            <span class="flex items-center gap-1 text-[11px] font-bold text-green-500 bg-green-50 dark:bg-green-500/10 px-2.5 py-1 rounded-lg border border-green-100 dark:border-green-500/20">
                                <ion-icon name="trending-up" class="text-sm"></ion-icon> +12%
                            </span>
                            <span class="text-[11px] text-gray-400 dark:text-gray-500 font-medium tracking-tight">vs last month</span>
                        </div>
                    </div>
                </div>

                <!-- Total Hours -->
                <div class="glass-panel p-8 rounded-[2rem] relative overflow-hidden group border-none shadow-sm">
                    <div class="absolute -top-4 -right-4 w-32 h-32 bg-blue-500/5 rounded-full blur-3xl group-hover:bg-blue-500/10 transition-colors"></div>
                    <div class="relative z-10">
                        <div class="flex items-center gap-3 mb-4">
                            <div class="w-10 h-10 rounded-xl bg-blue-100 dark:bg-blue-500/10 text-blue-600 dark:text-blue-400 flex items-center justify-center text-lg">
                                <ion-icon name="time-outline"></ion-icon>
                            </div>
                            <p class="text-xs font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest">Total Hours</p>
                        </div>
                        <h3 class="text-4xl font-extrabold text-gray-800 dark:text-white tracking-tight">345h 30m</h3>
                        <div class="mt-4 flex items-center gap-2">
                            <span class="flex items-center gap-1 text-[11px] font-bold text-blue-500 bg-blue-50 dark:bg-blue-500/10 px-2.5 py-1 rounded-lg border border-blue-100 dark:border-blue-500/20">
                                <ion-icon name="people-outline" class="text-sm"></ion-icon> 12 Staff
                            </span>
                            <span class="text-[11px] text-gray-400 dark:text-gray-500 font-medium tracking-tight">active this period</span>
                        </div>
                    </div>
                </div>

                <!-- Avg Rate -->
                <div class="glass-panel p-8 rounded-[2rem] relative overflow-hidden group border-none shadow-sm">
                    <div class="absolute -top-4 -right-4 w-32 h-32 bg-indigo-500/5 rounded-full blur-3xl group-hover:bg-indigo-500/10 transition-colors"></div>
                    <div class="relative z-10">
                        <div class="flex items-center gap-3 mb-4">
                            <div class="w-10 h-10 rounded-xl bg-indigo-100 dark:bg-indigo-500/10 text-indigo-600 dark:text-indigo-400 flex items-center justify-center text-lg">
                                <ion-icon name="analytics-outline"></ion-icon>
                            </div>
                            <p class="text-xs font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest">Avg Hourly Rate</p>
                        </div>
                        <h3 class="text-4xl font-extrabold text-gray-800 dark:text-white tracking-tight">£12.30</h3>
                        <div class="mt-4 flex items-center gap-2">
                            <span class="flex items-center gap-1 text-[11px] font-bold text-indigo-500 bg-indigo-50 dark:bg-indigo-500/10 px-2.5 py-1 rounded-lg border border-indigo-100 dark:border-indigo-500/20">
                                <ion-icon name="git-compare-outline" class="text-sm"></ion-icon> Normal
                            </span>
                            <span class="text-[11px] text-gray-400 dark:text-gray-500 font-medium tracking-tight">weighted average</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payroll Table -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm border-none">
                <div class="overflow-x-auto custom-scrollbar">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest leading-relaxed">Staff Member</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">Hours</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">Rate</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">Gross Pay</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">Adjustments</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">Net Estimate</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50 dark:divide-gray-700/30">
                             <!-- Row 1 -->
                            <tr class="hover:bg-gray-50/50 dark:hover:bg-slate-800/30 transition-all group">
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-xl bg-orange-100 dark:bg-orange-500/10 text-orange-600 dark:text-orange-400 flex items-center justify-center text-sm font-bold shadow-sm transition-transform group-hover:scale-105">JD</div>
                                        <div>
                                            <div class="font-bold text-sm text-gray-800 dark:text-white">John Doe</div>
                                            <div class="text-[11px] text-gray-500 dark:text-gray-400 font-medium tracking-tight uppercase">Manager</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono font-bold">40.0</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono font-medium">£15.00</td>
                                <td class="py-4 px-6 text-sm font-extrabold text-gray-700 dark:text-gray-200 text-right font-mono tracking-tight cursor-help border-r border-gray-50/50 dark:border-gray-800/50" title="Calculated as 40.0 * £15.00">£600.00</td>
                                <td class="py-4 px-6 text-right font-mono text-sm font-bold text-green-500">+£50.00</td>
                                <td class="py-4 px-6 text-sm font-extrabold text-gray-800 dark:text-white text-right font-mono bg-primary/5 dark:bg-primary/10 tracking-tighter">£650.00</td>
                                <td class="py-4 px-6 text-right">
                                    <button class="p-2 text-gray-400 hover:text-primary hover:bg-primary/5 rounded-lg transition-all" title="View Wage Breakdown">
                                        <ion-icon name="document-text-outline" class="text-xl"></ion-icon>
                                    </button>
                                </td>
                            </tr>
                            <!-- Row 2 -->
                            <tr class="hover:bg-gray-50/50 dark:hover:bg-slate-800/30 transition-all group">
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-xl bg-blue-100 dark:bg-blue-500/10 text-blue-600 dark:text-blue-400 flex items-center justify-center text-sm font-bold shadow-sm transition-transform group-hover:scale-105">SS</div>
                                        <div>
                                            <div class="font-bold text-sm text-gray-800 dark:text-white">Sarah Smith</div>
                                            <div class="text-[11px] text-gray-500 dark:text-gray-400 font-medium tracking-tight uppercase">Sr. Cashier</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono font-bold">32.5</td>
                                <td class="py-4 px-6 text-sm text-gray-600 dark:text-gray-300 text-right font-mono font-medium">£11.50</td>
                                <td class="py-4 px-6 text-sm font-extrabold text-gray-700 dark:text-gray-200 text-right font-mono tracking-tight border-r border-gray-50/50 dark:border-gray-800/50">£373.75</td>
                                <td class="py-4 px-6 text-right font-mono text-sm text-gray-400 dark:text-gray-600 font-medium">--</td>
                                <td class="py-4 px-6 text-sm font-extrabold text-gray-800 dark:text-white text-right font-mono bg-primary/5 dark:bg-primary/10 tracking-tighter">£373.75</td>
                                <td class="py-4 px-6 text-right">
                                    <button class="p-2 text-gray-400 hover:text-primary hover:bg-primary/5 rounded-lg transition-all" title="View Wage Breakdown">
                                        <ion-icon name="document-text-outline" class="text-xl"></ion-icon>
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
        });

        // --- Custom Select Logic ---
        function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    
                    const isHidden = dropdown.classList.contains('invisible');
                    if (isHidden) {
                        dropdown.classList.remove('opacity-0', 'invisible', '-translate-y-2');
                        trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.add('rotate-180', 'text-primary');
                    } else {
                        dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                        trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
