<?php
include 'includes/session.php';
// menu_modifiers_form.php - Create/Edit Modifier Group
$groupId = $_GET['id'] ?? null;
$mode = $groupId ? 'edit' : 'create';
$pageTitle = $mode === 'edit' ? "Edit Modifier Group" : "Create Modifier Group";
$currentPage = "menu_modifiers";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Helper Functions
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '', $searchable = false) {
    // ... (Same helper as other forms)
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    
    $optionsHtml = '';
    foreach ($options as $val => $data) {
        $text = is_array($data) ? $data['label'] : $data;
        $attrString = '';
        if(is_array($data)) {
            foreach($data as $k => $v) {
                if($k !== 'label') $attrString .= ' '.$k.'="'.$v.'"';
            }
        }
        
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"'.$attrString.'>
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            <div class="p-1 space-y-0.5 custom-select-options">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="productFormContent" class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Glass Panel) -->
            <div class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                <div class="flex items-center gap-4">
                     <button onclick="window.location.href='menu_modifiers.php'" class="w-10 h-10 rounded-xl bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 flex items-center justify-center text-gray-500 hover:text-primary hover:border-primary/30 transition-all shadow-sm">
                        <ion-icon name="arrow-back-outline" class="text-xl"></ion-icon>
                    </button>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">
                            <?php echo $pageTitle; ?>
                        </h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Manage modifier options and selection rules.</p>
                    </div>
                </div>
                <!-- Actions -->
                <div class="flex items-center gap-3">
                    <button type="submit" form="modifierForm" class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save Group</span>
                    </button>
                </div>
            </div>

            <!-- Main Panel -->
            <div class="glass-panel rounded-2xl animate-fade-in-up">
                
                <!-- Tabs Header -->
                <div class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 px-6 pt-4 rounded-t-2xl">
                    <div class="flex gap-6 overflow-x-auto custom-scrollbar" id="formTabs">
                        <button class="tab-btn active pb-4 px-2 text-sm font-semibold border-b-2 border-primary text-orange-500 transition-colors whitespace-nowrap" data-target="tab-general">
                            General Config
                        </button>
                        <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-options">
                            Modifiers Options
                        </button>
                         <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-linked">
                            Linked Items
                        </button>
                    </div>
                </div>

                <!-- Form Content -->
                <form id="modifierForm" class="p-6 md:p-8" method="POST">

                    <!-- TAB: General Config -->
                    <div id="tab-general" class="tab-content space-y-8">
                         <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                             <!-- Left Column: Basic Info -->
                             <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Group Details</h3>
                                
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Group Name <span class="text-red-500">*</span></label>
                                    <input type="text" class="<?php echo $inputClass; ?>" placeholder="e.g. Steak Temperature" required>
                                    <p class="text-[10px] text-gray-400">Visible to customers online/kiosk.</p>
                                </div>
                                
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Internal Name</label>
                                    <input type="text" class="<?php echo $inputClass; ?>" placeholder="e.g. MOD_STEAK_TEMP">
                                    <p class="text-[10px] text-gray-400">For reporting and kitchen display.</p>
                                </div>

                                <div class="pt-2">
                                     <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-slate-800/50 border border-gray-100 dark:border-gray-700 rounded-xl">
                                        <div class="flex flex-col">
                                            <span class="font-bold text-gray-700 dark:text-gray-200 text-sm">Required Selection</span>
                                            <span class="text-xs text-gray-400">Customer must make a selection</span>
                                        </div>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="is_required" value="1" class="sr-only peer" checked>
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary"></div>
                                        </label>
                                    </div>
                                </div>
                             </div>

                             <!-- Right Column: Rules -->
                             <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Selection Rules</h3>

                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Selection Type</label>
                                     <div class="grid grid-cols-2 gap-4">
                                        <label class="cursor-pointer">
                                            <input type="radio" name="selection_type" value="single" class="peer sr-only" checked onchange="toggleSelectionRules(this)">
                                            <div class="p-4 rounded-xl border-2 border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-slate-700/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all flex flex-col items-center gap-2">
                                                <ion-icon name="radio-button-on" class="text-2xl text-primary"></ion-icon>
                                                <span class="text-sm font-bold text-gray-700 dark:text-gray-200">Single</span>
                                                <span class="text-[10px] text-gray-400 text-center">User picks exactly one</span>
                                            </div>
                                        </label>
                                        <label class="cursor-pointer">
                                            <input type="radio" name="selection_type" value="multi" class="peer sr-only" onchange="toggleSelectionRules(this)">
                                            <div class="p-4 rounded-xl border-2 border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-slate-700/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all flex flex-col items-center gap-2">
                                                <ion-icon name="checkbox-outline" class="text-2xl text-primary"></ion-icon>
                                                <span class="text-sm font-bold text-gray-700 dark:text-gray-200">Multiple</span>
                                                <span class="text-[10px] text-gray-400 text-center">User picks one or more</span>
                                            </div>
                                        </label>
                                     </div>
                                </div>

                                <div id="multiRules" class="grid grid-cols-2 gap-4 opacity-50 pointer-events-none transition-opacity">
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Min Selections</label>
                                        <input type="number" name="min_selection" class="<?php echo $inputClass; ?>" value="0">
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Max Selections</label>
                                        <input type="number" name="max_selection" class="<?php echo $inputClass; ?>" value="0">
                                        <p class="text-[10px] text-gray-400">0 = Unlimited</p>
                                    </div>
                                </div>

                             </div>
                         </div>
                    </div>

                    <!-- TAB: Options -->
                    <div id="tab-options" class="tab-content hidden space-y-6">
                        <div class="flex items-center justify-between">
                            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Group Options</h3>
                            <button type="button" onclick="addOptionRow()" class="px-4 py-2 bg-gray-100 dark:bg-slate-700 hover:bg-gray-200 dark:hover:bg-slate-600 text-gray-700 dark:text-gray-200 rounded-xl text-xs font-bold transition-all flex items-center gap-2">
                                <ion-icon name="add" class="text-lg"></ion-icon> Add Option
                            </button>
                        </div>
                        
                        <div class="overflow-hidden border border-gray-200 dark:border-gray-700 rounded-xl">
                            <table class="w-full text-left border-collapse">
                                <thead class="bg-gray-50 dark:bg-slate-800/50">
                                    <tr>
                                        <th class="py-3 px-4 text-xs font-semibold text-gray-500 uppercase w-10">#</th>
                                        <th class="py-3 px-4 text-xs font-semibold text-gray-500 uppercase">Option Name</th>
                                        <th class="py-3 px-4 text-xs font-semibold text-gray-500 uppercase w-32">Price (+£)</th>
                                        <th class="py-3 px-4 text-xs font-semibold text-gray-500 uppercase w-24 text-center">Default</th>
                                        <th class="py-3 px-4 text-xs font-semibold text-gray-500 uppercase w-24 text-center">Status</th>
                                        <th class="py-3 px-4 text-xs font-semibold text-gray-500 uppercase w-16"></th>
                                    </tr>
                                </thead>
                                <tbody id="optionsContainer" class="divide-y divide-gray-100 dark:divide-gray-700 text-sm">
                                    <!-- Rows added via JS -->
                                </tbody>
                            </table>
                        </div>
                        
                        <div id="emptyState" class="hidden py-8 flex flex-col items-center justify-center text-gray-400">
                             <ion-icon name="list-outline" class="text-4xl mb-2 opacity-50"></ion-icon>
                             <p class="text-sm">No options added yet.</p>
                        </div>
                    </div>

                    <!-- TAB: Linked Items -->
                    <div id="tab-linked" class="tab-content hidden space-y-8">
                        <div class="glass-panel p-8 rounded-xl border border-gray-100 dark:border-gray-700 flex flex-col items-center justify-center text-center">
                            <div class="w-16 h-16 rounded-full bg-orange-50 dark:bg-primary/10 flex items-center justify-center text-primary mb-4">
                                <ion-icon name="fast-food-outline" class="text-3xl"></ion-icon>
                            </div>
                            <h3 class="text-lg font-bold text-gray-800 dark:text-white">Link to Items</h3>
                            <p class="text-gray-500 dark:text-gray-400 max-w-md mt-2 text-sm">
                                You can link this modifier group to specific items or entire categories. This feature will be available after saving the group.
                            </p>
                            <button type="button" class="mt-6 px-6 py-2.5 bg-gray-900 dark:bg-slate-700 text-white rounded-xl text-sm font-bold shadow-lg hover:opacity-90 transition-all opacity-50 cursor-not-allowed">
                                Manage Links (Save First)
                            </button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    // Tab Switching Logic
    document.addEventListener('DOMContentLoaded', function() {
        const tabs = document.querySelectorAll('.tab-btn');
        const contents = document.querySelectorAll('.tab-content');

        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                // Remove active state
                tabs.forEach(t => {
                    t.classList.remove('active', 'border-primary', 'text-orange-500');
                    t.classList.add('border-transparent', 'text-gray-500');
                });
                // Add active state
                tab.classList.remove('border-transparent', 'text-gray-500');
                tab.classList.add('active', 'border-primary', 'text-orange-500');

                // Hide/Show content
                contents.forEach(c => c.classList.add('hidden'));
                const targetId = tab.getAttribute('data-target');
                document.getElementById(targetId).classList.remove('hidden');
            });
        });
        
        // Init Mock Options
        addOptionRow('Rare', '0.00', false, true);
        addOptionRow('Medium Rare', '0.00', true, true);
        addOptionRow('Medium', '0.00', false, true);
        addOptionRow('Well Done', '0.00', false, true);
        addOptionRow('Burnt (Extra Crispy)', '1.50', false, true);
    });

    // Handle Selection Type Change
    function toggleSelectionRules(radio) {
        const multiRules = document.getElementById('multiRules');
        if(radio.value === 'multi') {
            multiRules.classList.remove('opacity-50', 'pointer-events-none');
        } else {
            multiRules.classList.add('opacity-50', 'pointer-events-none');
        }
    }

    // Custom Select Toggle
    document.addEventListener('click', function(e) {
        if (e.target.closest('.custom-select-trigger')) {
            const trigger = e.target.closest('.custom-select-trigger');
            const dropdown = trigger.parentElement.querySelector('.custom-select-dropdown');
            dropdown.classList.toggle('invisible');
            dropdown.classList.toggle('opacity-0');
            dropdown.classList.toggle('-translate-y-2');
        } else if (!e.target.closest('.custom-select-container')) {
            document.querySelectorAll('.custom-select-dropdown').forEach(d => {
                d.classList.add('invisible', 'opacity-0', '-translate-y-2');
            });
        }
    });

    // Options Management
    const optionsContainer = document.getElementById('optionsContainer');
    let optionCount = 0;

    function addOptionRow(name = '', price = '', isDefault = false, isActive = true) {
        optionCount++;
        const row = document.createElement('tr');
        row.className = "group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors";
        row.id = `option-row-${optionCount}`;
        
        const defaultChecked = isDefault ? 'checked' : '';
        const activeChecked = isActive ? 'checked' : '';

        row.innerHTML = `
            <td class="py-3 px-4 text-xs font-mono text-gray-400 select-none cursor-move">
                <ion-icon name="reorder-two" class="text-base"></ion-icon>
            </td>
            <td class="py-3 px-4">
                <input type="text" class="w-full bg-transparent border-b border-transparent focus:border-primary outline-none px-2 py-1 text-gray-800 dark:text-gray-200 transition-colors" placeholder="Option Name" value="${name}">
            </td>
            <td class="py-3 px-4">
                 <input type="number" step="0.01" class="w-full bg-transparent border-b border-transparent focus:border-primary outline-none px-2 py-1 text-gray-800 dark:text-gray-200 font-mono transition-colors" placeholder="0.00" value="${price}">
            </td>
            <td class="py-3 px-4 text-center">
                <input type="radio" name="default_option" class="w-4 h-4 text-primary border-gray-300 focus:ring-primary" ${defaultChecked}>
            </td>
             <td class="py-3 px-4 text-center">
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" class="sr-only peer" ${activeChecked}>
                    <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all dark:border-gray-600 peer-checked:bg-green-500"></div>
                </label>
            </td>
            <td class="py-3 px-4 text-right">
                <button type="button" onclick="document.getElementById('${row.id}').remove()" class="text-gray-400 hover:text-red-500 transition-colors p-1 rounded-md hover:bg-red-50 dark:hover:bg-red-900/10">
                    <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                </button>
            </td>
        `;

        optionsContainer.appendChild(row);
    }
    
    document.getElementById('modifierForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const btn = this.querySelector('button[type="submit"]');
        const originalContent = btn.innerHTML;
        
        btn.disabled = true;
        btn.innerHTML = '<ion-icon name="sync-outline" class="animate-spin text-lg"></ion-icon> Saving...';
        
        setTimeout(() => {
            if(window.showToast) {
                showToast('Modifier Group saved successfully!', 'success');
            } else {
                alert('Modifier Group saved successfully!');
            }
            btn.disabled = false;
            btn.innerHTML = originalContent;
        }, 1000);
    });
</script>
</body>
</html>
