<?php
include 'includes/session.php';
$pageTitle = "Modifiers";
$currentPage = "menu_modifiers"; 
require_once 'includes/header.php';

// Mock Data
$groups = [
    [
        'id' => 201,
        'name' => 'Steak Temperature',
        'options_count' => 5,
        'required' => true,
        'selection' => 'Single (1 max)',
        'linked_items' => 8,
        'updated_by' => 'Chef Mario',
        'updated_at' => '2023-11-10 14:00:00'
    ],
    [
        'id' => 202,
        'name' => 'Pizza Toppings',
        'options_count' => 12,
        'required' => false,
        'selection' => 'Multi (Max 5)',
        'linked_items' => 12,
        'updated_by' => 'Admin',
        'updated_at' => '2023-11-08 09:30:00'
    ],
    [
        'id' => 203,
        'name' => 'Side Choice (Lunch)',
        'options_count' => 4,
        'required' => true,
        'selection' => 'Single (1 max)',
        'linked_items' => 5,
        'updated_by' => 'Manager',
        'updated_at' => '2023-11-05 16:45:00'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto">
            
            <!-- Header -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col sm:flex-row sm:items-center justify-between gap-6 relative z-20">
                <div class="flex items-center gap-4">
                    <div class="h-12 w-12 rounded-xl bg-gradient-to-br from-orange-500 to-orange-600 flex items-center justify-center shadow-lg shadow-orange-500/30 text-white">
                        <ion-icon name="options-outline" class="text-2xl"></ion-icon>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Modifier Groups</h1>
                         <p class="text-gray-500 dark:text-gray-400 text-sm font-medium">Configure choices, upgrades, and add-ons for your menu items.</p>
                    </div>
                </div>

                <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto">
                    <!-- Global Search -->
                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <ion-icon name="search-outline" class="text-gray-400 text-lg group-focus-within:text-orange-500 transition-colors"></ion-icon>
                        </div>
                        <input type="text" class="w-full sm:w-64 pl-10 pr-4 py-2.5 bg-gray-50 dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 text-sm font-medium transition-all shadow-sm" placeholder="Search groups...">
                    </div>

                    <a href="menu_modifiers_form.php" class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center justify-center gap-2">
                        <ion-icon name="add-circle-outline" class="text-xl"></ion-icon>
                        <span>Create Group</span>
                    </a>
                </div>
            </div>

            <!-- Items Table -->
            <div class="glass-panel rounded-2xl overflow-visible shadow-sm relative z-0 min-h-[500px] mt-6">
                <div class="overflow-x-auto overflow-y-visible">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Group Name</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Options</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Rules</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Linked Items</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Updated</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                            <?php foreach ($groups as $grp): ?>
                            <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-4 px-6">
                                    <div class="text-sm font-bold text-gray-800 dark:text-white mb-0.5"><?php echo $grp['name']; ?></div>
                                    <span class="text-xs text-gray-400">ID: #<?php echo $grp['id']; ?></span>
                                </td>
                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center justify-center min-w-[30px] h-7 px-2 rounded-lg bg-gray-100 dark:bg-slate-700 text-sm font-bold text-gray-700 dark:text-gray-300">
                                        <?php echo $grp['options_count']; ?>
                                    </span>
                                </td>
                                <td class="py-4 px-6">
                                    <div class="flex flex-col gap-1">
                                        <?php if($grp['required']): ?>
                                            <span class="inline-flex items-center gap-1 text-[10px] font-bold text-red-600 dark:text-red-400 bg-red-50 dark:bg-red-900/20 px-1.5 py-0.5 rounded w-fit uppercase">
                                                Required
                                            </span>
                                        <?php else: ?>
                                            <span class="inline-flex items-center gap-1 text-[10px] font-bold text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-slate-700 px-1.5 py-0.5 rounded w-fit uppercase">
                                                Optional
                                            </span>
                                        <?php endif; ?>
                                        <span class="text-xs font-medium text-gray-600 dark:text-gray-300"><?php echo $grp['selection']; ?></span>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full bg-blue-50 dark:bg-blue-900/10 text-blue-600 dark:text-blue-400 text-xs font-bold border border-blue-100 dark:border-blue-900/20">
                                        <ion-icon name="link-outline"></ion-icon>
                                        <?php echo $grp['linked_items']; ?> Items
                                    </span>
                                </td>
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-2">
                                        <div class="w-6 h-6 rounded-full bg-orange-100 dark:bg-orange-900/30 flex items-center justify-center text-[10px] font-bold text-orange-600 dark:text-orange-400 border border-orange-200 dark:border-orange-800">
                                            <?php echo substr($grp['updated_by'], 0, 1); ?>
                                        </div>
                                        <div class="flex flex-col">
                                            <span class="text-[10px] font-bold text-gray-600 dark:text-gray-300"><?php echo $grp['updated_by']; ?></span>
                                            <span class="text-[9px] text-gray-400"><?php echo date('d M, H:i', strtotime($grp['updated_at'])); ?></span>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                         <a href="menu_modifiers_form.php?id=<?php echo $grp['id']; ?>" class="w-8 h-8 rounded-lg flex items-center justify-center text-gray-400 hover:text-blue-500 hover:bg-blue-50 dark:hover:bg-blue-900/10 border border-transparent hover:border-blue-100 dark:hover:border-blue-900/30 transition-all" title="Edit">
                                            <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                        </a>
                                        <button class="w-8 h-8 rounded-lg flex items-center justify-center text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 border border-transparent hover:border-red-100 dark:hover:border-red-900/30 transition-all" title="Delete">
                                            <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
