<?php
include 'includes/session.php';
// menu_items_form.php - Create/Edit Menu Item
$itemId = $_GET['id'] ?? null;
$mode = $itemId ? 'edit' : 'create';
$pageTitle = $mode === 'edit' ? "Edit Menu Item" : "Create Menu Item";
$currentPage = "menu_items";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";
$selectWrapper = "relative";

require_once 'includes/header.php';

// Helper Functions
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '', $searchable = false) {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    
    $optionsHtml = '';
    foreach ($options as $val => $data) {
        $text = is_array($data) ? $data['label'] : $data;
        $attrString = '';
        if(is_array($data)) {
            foreach($data as $k => $v) {
                if($k !== 'label') $attrString .= ' '.$k.'="'.$v.'"';
            }
        }
        
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"'.$attrString.'>
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    $searchHtml = $searchable ? '
    <div class="p-2 sticky top-0 bg-white dark:bg-slate-800 z-10 border-b border-gray-50 dark:border-gray-700/50">
        <div class="relative">
            <ion-icon name="search" class="absolute left-2.5 top-2.5 text-gray-400 text-sm"></ion-icon>
            <input type="text" class="w-full pl-8 pr-3 py-1.5 bg-gray-50 dark:bg-slate-700/50 border border-gray-100 dark:border-gray-600 rounded-lg text-xs text-gray-600 dark:text-gray-300 placeholder-gray-400 focus:outline-none focus:border-primary/50 transition-colors custom-select-search" placeholder="Search...">
        </div>
    </div>' : '';

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            '.$searchHtml.'
            <div class="p-1 space-y-0.5 custom-select-options">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}

function renderConfigToggle($label, $name, $checkedYes = false) {
    $checked = $checkedYes ? 'checked' : '';
    echo '
    <div class="flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 border border-gray-100 dark:border-gray-700 rounded-xl h-fit">
        <span class="font-medium text-gray-700 dark:text-gray-300">'.$label.'</span>
        <label class="relative inline-flex items-center cursor-pointer">
            <input type="checkbox" name="'.$name.'" value="1" class="sr-only peer" '.$checked.'>
            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[\'\'] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary"></div>
        </label>
    </div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="productFormContent" class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Glass Panel) -->
            <div class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                <div class="flex items-center gap-4">
                     <button onclick="window.location.href='menu_items.php'" class="w-10 h-10 rounded-xl bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 flex items-center justify-center text-gray-500 hover:text-primary hover:border-primary/30 transition-all shadow-sm">
                        <ion-icon name="arrow-back-outline" class="text-xl"></ion-icon>
                    </button>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">
                            <?php echo $pageTitle; ?>
                        </h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Configure menu item details, pricing, and ingredients.</p>
                    </div>
                </div>
                <!-- Actions -->
                <div class="flex items-center gap-3">
                    <button type="submit" form="productForm" class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save Menu Item</span>
                    </button>
                </div>
            </div>

            <!-- Main Panel -->
            <div class="glass-panel rounded-2xl animate-fade-in-up">
                
                <!-- Tabs Header -->
                <div class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 px-6 pt-4 rounded-t-2xl">
                    <div class="flex gap-6 overflow-x-auto custom-scrollbar" id="formTabs">
                        <button class="tab-btn active pb-4 px-2 text-sm font-semibold border-b-2 border-primary text-orange-500 transition-colors whitespace-nowrap" data-target="tab-general">
                            General Info
                        </button>
                        <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-pricing">
                            Pricing & Tax
                        </button>
                        <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-inventory">
                            Inventory & Specs
                        </button>
                         <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-other">
                            Compliance & Meta
                        </button>
                    </div>
                </div>

                <!-- Form Content -->
                <form id="productForm" class="p-6 md:p-8" method="POST" enctype="multipart/form-data">

                    <!-- TAB: General Info -->
                    <div id="tab-general" class="tab-content space-y-8">
                         <!-- Product Details Section -->
                         <div class="space-y-4">
                            <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Item Details</h3>
                            
                            <div class="flex flex-col xl:flex-row items-start gap-8">
                                
                                <!-- Image Upload (Matched Style) -->
                                <div class="shrink-0">
                                    <div class="w-32 h-32 rounded-2xl bg-gray-50 dark:bg-slate-800 border-2 border-dashed border-gray-300 dark:border-gray-600 flex items-center justify-center relative overflow-hidden group hover:border-primary transition-colors cursor-pointer" onclick="document.getElementById('productImageInput').click()">
                                        <img id="productImagePreview" class="w-full h-full object-cover hidden z-10 relative" alt="Product Image">
                                        
                                        <!-- Remove Button -->
                                        <button type="button" id="removeImageBtn" class="absolute top-1 right-1 z-20 bg-white/90 dark:bg-black/50 text-red-500 hover:text-red-600 rounded-full p-1 shadow-sm hidden opacity-0 group-hover:opacity-100 transition-all hover:bg-white" onclick="event.stopPropagation(); removeProductImage(event);">
                                            <ion-icon name="close-circle" class="text-xl"></ion-icon>
                                        </button>

                                        <div class="absolute inset-0 flex flex-col items-center justify-center text-gray-400 group-hover:text-primary transition-colors z-0" id="imagePlaceholder">
                                            <ion-icon name="image-outline" class="text-2xl mb-1"></ion-icon>
                                            <span class="text-xs font-medium text-gray-400">Upload</span>
                                        </div>
                                         <!-- Overlay -->
                                        <div class="absolute inset-0 bg-black/50 hidden group-hover:flex items-center justify-center text-white text-xs font-medium opacity-0 group-hover:opacity-100 transition-opacity z-10" id="imageOverlay">
                                            Change
                                        </div>
                                    </div>
                                    <input type="file" id="productImageInput" name="product_image" class="hidden" accept="image/png, image/jpeg, image/gif, image/svg+xml">
                                    <div class="text-center mt-3">
                                        <p class="text-sm text-gray-600 dark:text-gray-300 font-medium">Main Image <span class="text-red-500">*</span></p>
                                        <p class="text-[10px] text-gray-400 mt-0.5">JPG, PNG, GIF, SVG</p>
                                    </div>
                                </div>

                                <!-- Core Fields -->
                                <div class="flex-1 w-full space-y-6">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Select Store <span class="text-red-500">*</span></label>
                                            <?php 
                                                echo renderCustomSelect('Select Store', 'store_id', [
                                                    '1001' => 'FNF Cardiff', 
                                                    '1002' => 'FNF Bristol',
                                                    'all'  => 'All Stores'
                                                ]); 
                                            ?>
                                        </div>
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">SKU / Code <span class="text-red-500">*</span></label>
                                            <div class="relative">
                                                <input type="text" class="<?php echo $inputClass; ?> pr-10 font-mono" placeholder="Enter Item Code">
                                                <button type="button" class="absolute right-3 top-2.5 text-orange-500 hover:text-orange-600 transition-colors">
                                                    <ion-icon name="barcode-outline" class="text-lg"></ion-icon>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Item Name <span class="text-red-500">*</span></label>
                                        <input type="text" class="<?php echo $inputClass; ?>" placeholder="Enter Item Name (e.g. Margarita Pizza)">
                                    </div>

                                     <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Description</label>
                                        <textarea class="<?php echo $inputClass; ?> min-h-[80px] resize-none" placeholder="Enter Item Description (Ingredients, etc.)"></textarea>
                                    </div>
                                    
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Menu Category <span class="text-red-500">*</span></label>
                                             <?php 
                                                echo renderCustomSelect('Select Category', 'category', [
                                                    'starters' => 'Starters', 
                                                    'mains' => 'Mains',
                                                    'desserts' => 'Desserts',
                                                    'drinks' => 'Drinks'
                                                ]); 
                                            ?>
                                        </div>
                                         <div class="space-y-2">
                                            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Kitchen Station</label>
                                             <?php 
                                                echo renderCustomSelect('Select Station', 'station', [
                                                    'kitchen' => 'Main Kitchen', 
                                                    'bar' => 'Bar',
                                                    'grill' => 'Grill Station'
                                                ], 'kitchen');
                                            ?>
                                        </div>
                                    </div>

                                    <div class="space-y-2 pt-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Active Status</label>
                                        <div class="flex items-center gap-3">
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="product_active" value="1" class="sr-only peer" checked>
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-green-500"></div>
                                                <span class="ml-3 text-sm font-medium text-gray-600 dark:text-gray-300">Item is Active</span>
                                            </label>
                                        </div>
                                    </div>

                                </div>
                            </div>
                         </div>
                    </div>

                    <!-- TAB: Pricing & Tax -->
                    <div id="tab-pricing" class="tab-content hidden space-y-8">
                        <div class="space-y-6">
                            <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Pricing Configuration</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                 <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Currency <span class="text-red-500">*</span></label>
                                    <?php 
                                        echo renderCustomSelect('GBP (£)', 'currency', [
                                            'GBP' => 'GBP (£)', 
                                            'USD' => 'USD ($)'
                                        ], 'GBP'); 
                                    ?>
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Selling Price <span class="text-red-500">*</span></label>
                                    <div class="relative">
                                        <span class="absolute left-3 top-3 text-gray-400 text-sm">£</span>
                                        <input type="number" step="0.01" class="<?php echo $inputClass; ?> pl-7" placeholder="0.00">
                                    </div>
                                </div>
                                 <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Cost Price (Optional)</label>
                                     <div class="relative">
                                        <span class="absolute left-3 top-3 text-gray-400 text-sm">£</span>
                                        <input type="number" step="0.01" class="<?php echo $inputClass; ?> pl-7" placeholder="0.00">
                                    </div>
                                </div>
                            </div>

                             <div class="grid grid-cols-1 md:grid-cols-3 gap-6 pt-2">
                                 <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Category Tax Slab Applied?</label>
                                     <div class="flex items-center gap-6 mt-2">
                                        <label class="flex items-center gap-2 cursor-pointer group">
                                            <div class="w-5 h-5 rounded-full border-2 border-gray-300 dark:border-gray-600 flex items-center justify-center group-hover:border-primary transition-colors">
                                                <div class="w-2.5 h-2.5 rounded-full bg-primary opacity-100 transition-opacity"></div>
                                            </div>
                                            <input type="radio" name="tax_slab_applied" value="no" checked class="hidden"> 
                                            <span class="text-sm text-gray-600 dark:text-gray-300 font-medium">Not Applied</span>
                                        </label>
                                         <label class="flex items-center gap-2 cursor-pointer group">
                                            <div class="w-5 h-5 rounded-full border-2 border-gray-300 dark:border-gray-600 flex items-center justify-center group-hover:border-primary transition-colors">
                                                <div class="w-2.5 h-2.5 rounded-full bg-primary opacity-0 transition-opacity"></div>
                                            </div>
                                            <input type="radio" name="tax_slab_applied" value="yes" class="hidden item-radio-subcat-tax" onchange="this.previousElementSibling.firstElementChild.classList.remove('opacity-0')"> 
                                            <span class="text-sm text-gray-600 dark:text-gray-300 font-medium">Applied</span>
                                        </label>
                                    </div>
                                </div>

                                 <div class="space-y-2" id="taxSlabContainer">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Tax Slab <span class="text-red-500">*</span></label>
                                     <?php 
                                        echo renderCustomSelect('Select Value', 'tax_slab', [
                                            '0' => '0% (Zero Rated)', 
                                            '20' => '20% (Standard)'
                                        ]); 
                                    ?>
                                </div>
                             </div>

                             <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700 pt-4">Offers & Promotions</h3>
                             <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="space-y-2" id="multibuyContainer">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Multi-Buy Offer</label>
                                     <?php 
                                        echo renderCustomSelect('NONE', 'multibuy_type', [
                                            'none' => 'NONE', 
                                            'b1g1' => 'Buy 1 Get 1',
                                            '3for2' => '3 for 2'
                                        ], 'none'); 
                                    ?>
                                </div>
                                 <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Offer Price (if applicable)</label>
                                     <div class="relative">
                                        <span class="absolute left-3 top-3 text-gray-400 text-sm">£</span>
                                        <input type="number" step="0.01" id="multibuyPrice" class="<?php echo $inputClass; ?> pl-7" placeholder="0.00" disabled>
                                    </div>
                                </div>
                             </div>

                        </div>
                    </div>

                    <!-- TAB: Inventory & Specs -->
                    <div id="tab-inventory" class="tab-content hidden space-y-8">
                        <div class="space-y-6">
                            <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Stock & Availability</h3>

                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Portion Size</label>
                                    <input type="text" name="portion_size" class="<?php echo $inputClass; ?>" placeholder="e.g. 500g">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Preparation Time</label>
                                    <div class="relative">
                                         <input type="number" name="prep_time" class="<?php echo $inputClass; ?> pr-12" placeholder="15">
                                         <span class="absolute right-4 top-3 text-gray-400 text-xs">mins</span>
                                    </div>
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Daily Order Limit</label>
                                    <input type="number" class="<?php echo $inputClass; ?>" value="0">
                                    <p class="text-[10px] text-gray-400">0 = Unlimited</p>
                                </div>
                            </div>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 pt-4">
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Track Stock?</label>
                                     <div class="flex items-center gap-6 mt-2">
                                        <label class="flex items-center gap-2 cursor-pointer group">
                                            <div class="w-5 h-5 rounded-full border-2 border-gray-300 dark:border-gray-600 flex items-center justify-center group-hover:border-primary transition-colors">
                                                <div class="w-2.5 h-2.5 rounded-full bg-primary opacity-100 transition-opacity"></div>
                                            </div>
                                            <input type="radio" name="track_stock" value="no" checked class="hidden"> 
                                            <span class="text-sm text-gray-600 dark:text-gray-300 font-medium">No</span>
                                        </label>
                                         <label class="flex items-center gap-2 cursor-pointer group">
                                            <div class="w-5 h-5 rounded-full border-2 border-gray-300 dark:border-gray-600 flex items-center justify-center group-hover:border-primary transition-colors">
                                                <div class="w-2.5 h-2.5 rounded-full bg-primary opacity-0 transition-opacity"></div>
                                            </div>
                                            <input type="radio" name="track_stock" value="yes" class="hidden" onchange="this.previousElementSibling.firstElementChild.classList.remove('opacity-0')"> 
                                            <span class="text-sm text-gray-600 dark:text-gray-300 font-medium">Yes</span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                     <!-- TAB: Compliance & Meta -->
                    <div id="tab-other" class="tab-content hidden space-y-8">
                        <div class="space-y-6">
                            <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Legal & Metadata</h3>
                            
                             <div class="grid grid-cols-1 md:grid-cols-2 gap-6 lg:gap-12">
                                <div class="space-y-2 max-w-sm">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Category Disclaimer Applied?</label>
                                     <div class="flex items-center gap-6 mt-3">
                                        <label class="flex items-center gap-2 cursor-pointer group">
                                            <div class="w-5 h-5 rounded-full border-2 border-gray-300 dark:border-gray-600 flex items-center justify-center group-hover:border-primary transition-colors">
                                                <div class="w-2.5 h-2.5 rounded-full bg-primary opacity-100 transition-opacity"></div>
                                            </div>
                                            <input type="radio" name="disclaimer_applied" value="no" checked class="hidden" onchange="this.previousElementSibling.firstElementChild.classList.remove('opacity-0'); this.closest('.flex').querySelectorAll('input').forEach(i => { if(i !== this) i.previousElementSibling.firstElementChild.classList.add('opacity-0') });"> 
                                            <span class="text-sm text-gray-600 dark:text-gray-300 font-medium">Not Applied</span>
                                        </label>
                                         <label class="flex items-center gap-2 cursor-pointer group">
                                            <div class="w-5 h-5 rounded-full border-2 border-gray-300 dark:border-gray-600 flex items-center justify-center group-hover:border-primary transition-colors">
                                                <div class="w-2.5 h-2.5 rounded-full bg-primary opacity-0 transition-opacity"></div>
                                            </div>
                                            <input type="radio" name="disclaimer_applied" value="yes" class="hidden" onchange="this.previousElementSibling.firstElementChild.classList.remove('opacity-0'); this.closest('.flex').querySelectorAll('input').forEach(i => { if(i !== this) i.previousElementSibling.firstElementChild.classList.add('opacity-0') });"> 
                                            <span class="text-sm text-gray-600 dark:text-gray-300 font-medium">Applied</span>
                                        </label>
                                    </div>
                                </div>
                                 <div class="space-y-2 max-w-md" id="disclaimerContainer">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Disclaimer / Dietaries</label>
                                     <?php 
                                        echo renderCustomSelect('Select Disclaimer', 'disclaimer', [
                                            'none' => 'None',
                                            'veg' => 'Vegetarian',
                                            'vegan' => 'Vegan',
                                            'gf' => 'Gluten Free',
                                            'nuts' => 'Contains Nuts',
                                            'alcohol' => 'Contains Alcohol (18+)'
                                        ]); 
                                    ?>
                                </div>
                             </div>

                             <div class="space-y-2">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Keywords / Tags</label>
                                <div id="keywordsWrapper" class="w-full max-w-3xl bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-2 py-2 outline-none focus-within:ring-2 focus-within:ring-orange-500/20 focus-within:border-orange-500 transition-all shadow-sm flex flex-wrap items-center gap-2 min-h-[46px] cursor-text" onclick="document.getElementById('keywordInput').focus()">
                                    <!-- Tags will be injected here -->
                                    <input type="text" id="keywordInput" class="bg-transparent border-none outline-none text-sm text-gray-600 dark:text-gray-300 placeholder-gray-400 min-w-[150px] flex-1" placeholder="Type tag and press Enter...">
                                </div>
                                <input type="hidden" name="keywords" id="keywordsHidden">
                            </div>

                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    // Tab Switching Logic
    document.addEventListener('DOMContentLoaded', function() {
        const tabs = document.querySelectorAll('.tab-btn');
        const contents = document.querySelectorAll('.tab-content');

        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                // Remove active state from all tabs
                tabs.forEach(t => {
                    t.classList.remove('active', 'border-primary', 'text-orange-500');
                    t.classList.add('border-transparent', 'text-gray-500');
                });

                // Add active state to clicked tab
                tab.classList.remove('border-transparent', 'text-gray-500');
                tab.classList.add('active', 'border-primary', 'text-orange-500');

                // Hide all contents
                contents.forEach(c => c.classList.add('hidden'));

                // Show target content
                const targetId = tab.getAttribute('data-target');
                document.getElementById(targetId).classList.remove('hidden');
            });
        });
    });

    // Image Upload Logic (Same as before)
    function removeProductImage(e) {
        const preview = document.getElementById('productImagePreview');
        const placeholder = document.getElementById('imagePlaceholder');
        const overlay = document.getElementById('imageOverlay');
        const removeBtn = document.getElementById('removeImageBtn');
        const input = document.getElementById('productImageInput');
        
        preview.src = '';
        preview.classList.add('hidden');
        placeholder.classList.remove('hidden');
        overlay.classList.add('hidden');
        removeBtn.classList.add('hidden');
        input.value = ''; 
    }

    document.getElementById('productImageInput').addEventListener('change', function(e) {
        if (this.files && this.files[0]) {
             const file = this.files[0];
            
            // Validate File Type
            const validTypes = ['image/jpeg', 'image/png', 'image/jpg', 'image/gif', 'image/svg+xml'];
            if (!validTypes.includes(file.type)) {
                if(window.showToast) {
                    showToast('Only JPG, PNG, GIF, and SVG files are allowed.', 'error');
                } else {
                    alert('Invalid file type'); 
                }
                this.value = ''; // Clear input
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('productImagePreview');
                const placeholder = document.getElementById('imagePlaceholder');
                const overlay = document.getElementById('imageOverlay');
                const removeBtn = document.getElementById('removeImageBtn');
                
                preview.src = e.target.result;
                preview.classList.remove('hidden');
                placeholder.classList.add('hidden');
                overlay.classList.remove('hidden');
                removeBtn.classList.remove('hidden');
            }
            reader.readAsDataURL(file);
        }
    });

    // Toggle Custom Select Dropdown
    document.addEventListener('click', function(e) {
        // Prevent closing if clicking search input
        if (e.target.classList.contains('custom-select-search')) {
            return;
        }

        // Toggle dropdowns
        if (e.target.closest('.custom-select-trigger')) {
            const trigger = e.target.closest('.custom-select-trigger');
            const container = trigger.closest('.custom-select-container');
            const dropdown = container.querySelector('.custom-select-dropdown');
            
            // Close other dropdowns
            document.querySelectorAll('.custom-select-dropdown').forEach(d => {
                if (d !== dropdown) {
                    d.classList.add('invisible', 'opacity-0', '-translate-y-2');
                }
            });

            if (dropdown.classList.contains('invisible')) {
                dropdown.classList.remove('invisible', 'opacity-0', '-translate-y-2');
            } else {
                dropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
            }
        } else {
            // Close all if clicked outside
             document.querySelectorAll('.custom-select-dropdown').forEach(d => {
                d.classList.add('invisible', 'opacity-0', '-translate-y-2');
            });
        }

        // Handle Option Click
        if (e.target.closest('.custom-select-option')) {
            const option = e.target.closest('.custom-select-option');
            const container = option.closest('.custom-select-container');
            const trigger = container.querySelector('.custom-select-trigger');
            const hiddenInput = container.querySelector('input[type="hidden"]');
            const label = trigger.querySelector('.select-label');
            
            // Update UI
            container.querySelectorAll('.custom-select-option').forEach(opt => {
                opt.classList.remove('active');
                opt.querySelector('.check-icon').classList.add('opacity-0');
            });
            option.classList.add('active');
            option.querySelector('.check-icon').classList.remove('opacity-0');

            // Update Value
            hiddenInput.value = option.dataset.value;
            label.textContent = option.dataset.label;
        }
    });

    // Search in Dropdown
    document.addEventListener('input', function(e) {
        if(e.target.classList.contains('custom-select-search')) {
            const term = e.target.value.toLowerCase();
            const container = e.target.closest('.custom-select-dropdown');
            const options = container.querySelectorAll('.custom-select-option');
            
            options.forEach(opt => {
                const text = opt.innerText.toLowerCase();
                if(text.includes(term)) {
                    opt.classList.remove('hidden');
                } else {
                    opt.classList.add('hidden');
                }
            });
        }
    });

    // Tag Input Logic
    const keywordInput = document.getElementById('keywordInput');
    const keywordsWrapper = document.getElementById('keywordsWrapper');
    const keywordsHidden = document.getElementById('keywordsHidden');
    let tags = [];

    function renderTags() {
        // Clear existing tags (keep input)
        const existingTags = keywordsWrapper.querySelectorAll('.tag-item');
        existingTags.forEach(t => t.remove());

        // Render tags
        tags.forEach((tag, index) => {
            const tagEl = document.createElement('div');
            tagEl.className = 'tag-item bg-gray-100 dark:bg-slate-700 text-gray-700 dark:text-gray-300 text-xs font-semibold px-2 py-1 rounded-lg flex items-center gap-1 animate-fade-in';
            tagEl.innerHTML = `
                <span>${tag}</span>
                <button type="button" class="hover:text-red-500 transition-colors" onclick="removeTag(${index})">
                    <ion-icon name="close-circle" class="text-sm"></ion-icon>
                </button>
            `;
            keywordsWrapper.insertBefore(tagEl, keywordInput);
        });

        // Update hidden input
        keywordsHidden.value = tags.join(',');
    }

    function removeTag(index) {
        tags.splice(index, 1);
        renderTags();
    }

    if (keywordInput) {
        keywordInput.addEventListener('keydown', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                const val = this.value.trim();
                if (val && !tags.includes(val)) {
                    tags.push(val);
                    this.value = '';
                    renderTags();
                }
            } else if (e.key === 'Backspace' && !this.value) {
                if(tags.length > 0) {
                    tags.pop();
                    renderTags();
                }
            }
        });
    }

    // Radio Button Group Logic
    document.querySelectorAll('input[type="radio"]').forEach(radio => {
        radio.addEventListener('change', function() {
            // Reset all in this group name
            const name = this.name;
            document.querySelectorAll(`input[name="${name}"]`).forEach(otherRadio => {
                const dot = otherRadio.previousElementSibling.firstElementChild;
                if(dot) dot.classList.add('opacity-0');
            });
            // Set active
            const dot = this.previousElementSibling.firstElementChild;
            if(dot) dot.classList.remove('opacity-0');

            // Logic: Subcat Tax Slab
            if(name === 'tax_slab_applied') {
                 const taxSlabContainer = document.getElementById('taxSlabContainer');
                 if(this.value === 'yes') {
                     taxSlabContainer.classList.add('opacity-50', 'pointer-events-none');
                 } else {
                     taxSlabContainer.classList.remove('opacity-50', 'pointer-events-none');
                 }
            }

            // Logic: Low Stock Alert
            if(name === 'low_stock_enabled') {
                const thresholdInput = document.getElementById('lowStockThreshold');
                if(this.value === 'no') {
                    thresholdInput.disabled = true;
                } else {
                    thresholdInput.disabled = false;
                }
            }

            // Logic: Disclaimer Applied
            if(name === 'disclaimer_applied') {
                 const disclaimerContainer = document.getElementById('disclaimerContainer');
                 if(this.value === 'yes') {
                     disclaimerContainer.classList.add('opacity-50', 'pointer-events-none');
                 } else {
                     disclaimerContainer.classList.remove('opacity-50', 'pointer-events-none');
                 }
            }
        });
    });

    // Handle Dropdown Change Logic for Multi-Buy
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === "attributes" && mutation.attributeName === "value") {
                 const input = mutation.target;
                 if(input.name === 'multibuy_type') {
                     const priceInput = document.getElementById('multibuyPrice');
                     if(input.value === 'none') {
                         priceInput.disabled = true;
                         priceInput.classList.add('bg-gray-100', 'dark:bg-slate-700');
                         priceInput.value = '';
                     } else {
                         priceInput.disabled = false;
                         priceInput.classList.remove('bg-gray-100', 'dark:bg-slate-700');
                     }
                 }
            }
        });
    });

    // Observe hidden inputs in custom selects
    document.querySelectorAll('.custom-select-container input[type="hidden"]').forEach(input => {
        observer.observe(input, { attributes: true });
    });

    document.getElementById('productForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const btn = this.querySelector('button[type="submit"]');
        const originalContent = btn.innerHTML;
        
        btn.disabled = true;
        btn.innerHTML = '<ion-icon name="sync-outline" class="animate-spin text-lg"></ion-icon> Saving...';
        
        setTimeout(() => {
            if(window.showToast) {
                showToast('Menu Item saved successfully!', 'success');
            } else {
                alert('Menu Item saved successfully!');
            }
            btn.disabled = false;
            btn.innerHTML = originalContent;
            
             setTimeout(() => {
                window.location.href = 'menu_items.php';
            }, 1000);
        }, 1000);
    });

</script>
</body>
</html>
