<?php
include 'includes/session.php';
$pageTitle = "Menu Items";
$currentPage = "menu_items";
require_once 'includes/header.php';

// Mock Data
$items = [
    [
        'id' => 101,
        'name' => 'Garlic Bread',
        'category' => 'Starters',
        'price' => '4.50',
        'tax' => '20%',
        'schedule' => 'Always',
        'active' => true,
        'image' => 'assets/img/mock_food_1.jpg',
        'updated_by' => 'Chef Mario',
        'updated_at' => '2023-10-26 14:30:00'
    ],
    [
        'id' => 102,
        'name' => 'Sirloin Steak (8oz)',
        'category' => 'Steaks',
        'price' => '18.95',
        'tax' => '20%',
        'schedule' => 'Dinner Only',
        'active' => true,
        'image' => null,
        'updated_by' => 'Admin',
        'updated_at' => '2023-10-25 09:15:00'
    ],
    [
        'id' => 103,
        'name' => 'House Red Wine',
        'category' => 'Drinks',
        'price' => '6.00',
        'tax' => '20%',
        'schedule' => 'Always',
        'active' => true,
        'image' => null,
        'updated_by' => 'Bar Manager',
        'updated_at' => '2023-10-20 18:00:00'
    ],
    [
        'id' => 104,
        'name' => 'Lobster Thermidor',
        'category' => 'Mains',
        'price' => '32.00',
        'tax' => '20%',
        'schedule' => 'Weekends',
        'active' => false,
        'image' => null,
        'updated_by' => 'Head Office',
        'updated_at' => '2023-10-15 11:20:00'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto">
            
            <!-- Header -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col sm:flex-row sm:items-center justify-between gap-6 relative z-20">
                <div class="flex items-center gap-4">
                    <div class="h-12 w-12 rounded-xl bg-gradient-to-br from-orange-500 to-orange-600 flex items-center justify-center shadow-lg shadow-orange-500/30 text-white">
                        <ion-icon name="fast-food-outline" class="text-2xl"></ion-icon>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Menu Items</h1>
                         <p class="text-gray-500 dark:text-gray-400 text-sm font-medium">Manage dishes, drinks, and individual products.</p>
                    </div>
                </div>

                <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto">
                    <!-- Global Search -->
                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <ion-icon name="search-outline" class="text-gray-400 text-lg group-focus-within:text-orange-500 transition-colors"></ion-icon>
                        </div>
                        <input type="text" class="w-full sm:w-64 pl-10 pr-4 py-2.5 bg-gray-50 dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 text-sm font-medium transition-all shadow-sm" placeholder="Search items...">
                    </div>

                    <button class="px-4 py-2.5 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-700 dark:text-gray-200 rounded-xl text-sm font-bold hover:bg-gray-50 dark:hover:bg-slate-700 transition-all shadow-sm hover:shadow-md flex items-center justify-center gap-2">
                        <ion-icon name="cloud-upload-outline" class="text-lg"></ion-icon>
                        <span>Import</span>
                    </button>

                    <a href="menu_items_form.php" class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center justify-center gap-2">
                        <ion-icon name="add-circle-outline" class="text-xl"></ion-icon>
                        <span>Add Item</span>
                    </a>
                </div>
            </div>

            <!-- Items Table -->
            <div class="glass-panel rounded-2xl overflow-visible shadow-sm relative z-0 min-h-[500px] mt-6">
                <div class="overflow-x-auto overflow-y-visible">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider w-16">Img</th>
                                <th class="py-4 px-4 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider leading-tight">ID</th>
                                
                                <!-- Item Name (Filter) -->
                                <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[250px]">
                                    <div class="flex items-center justify-between">
                                        <span class="transition-colors duration-200">Item Name</span>
                                        <button onclick="toggleSearchPopup('searchPopup-name')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                            <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                        </button>
                                    </div>
                                    <div id="searchPopup-name" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                        <div class="flex items-center justify-between mb-3 px-1">
                                            <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Name</span>
                                            <ion-icon name="text-outline" class="text-primary text-base"></ion-icon>
                                        </div>
                                        <div class="relative mb-3 group/input">
                                            <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                            <input type="text" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Item Name...">
                                        </div>
                                         <div class="grid grid-cols-2 gap-2">
                                            <button onclick="toggleSearchPopup('searchPopup-name')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Close</button>
                                            <button class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                        </div>
                                    </div>
                                </th>

                                <!-- Category (Filter) -->
                                <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wide uppercase relative group border-r border-gray-100 dark:border-gray-700/50 w-[200px]">
                                    <div class="flex items-center justify-between">
                                        <span class="transition-colors duration-200">Category</span>
                                        <button onclick="toggleSearchPopup('searchPopup-cat')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                            <ion-icon name="filter-outline" class="text-sm"></ion-icon>
                                        </button>
                                    </div>
                                    <div id="searchPopup-cat" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                        <div class="flex items-center justify-between mb-3 px-1">
                                            <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Filter Category</span>
                                            <ion-icon name="pricetag-outline" class="text-primary text-base"></ion-icon>
                                        </div>
                                        <div class="relative mb-3 group/input">
                                            <select class="w-full px-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white outline-none transition-all">
                                                <option value="">All Categories</option>
                                                <option value="Starters">Starters</option>
                                                <option value="Mains">Mains</option>
                                                <option value="Desserts">Desserts</option>
                                            </select>
                                        </div>
                                         <div class="grid grid-cols-2 gap-2">
                                            <button onclick="toggleSearchPopup('searchPopup-cat')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Close</button>
                                            <button class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                        </div>
                                    </div>
                                </th>

                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Price</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Schedule</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Updated</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Status</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                            <?php foreach ($items as $item): ?>
                            <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                <td class="py-3 px-6">
                                     <div class="w-10 h-10 rounded-lg bg-white dark:bg-slate-700 flex items-center justify-center p-1 border border-gray-100 dark:border-gray-600 shadow-sm overflow-hidden">
                                        <?php if(isset($item['image']) && $item['image']): ?>
                                             <img src="<?php echo $item['image']; ?>" class="w-full h-full object-cover rounded-md" alt="Item">
                                        <?php else: ?>
                                            <ion-icon name="fast-food-outline" class="text-xl text-gray-400"></ion-icon>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td class="py-4 px-4 text-xs font-bold text-gray-500 dark:text-gray-400 tracking-wider">
                                    #<?php echo $item['id']; ?>
                                </td>
                                <td class="py-4 px-4">
                                    <div class="text-sm font-bold text-gray-800 dark:text-white"><?php echo $item['name']; ?></div>
                                     <!-- Optional: Show description excerpt if available -->
                                </td>
                                <td class="py-4 px-4">
                                     <span class="inline-flex items-center px-2 py-1 rounded-md bg-orange-50 dark:bg-orange-900/10 text-orange-600 dark:text-orange-400 text-xs font-bold border border-orange-100 dark:border-orange-900/20">
                                        <?php echo $item['category']; ?>
                                     </span>
                                </td>
                                <td class="py-4 px-6">
                                    <span class="text-sm font-mono font-bold text-gray-800 dark:text-white">£<?php echo $item['price']; ?></span>
                                </td>
                                <td class="py-4 px-6">
                                    <?php if ($item['schedule'] == 'Always'): ?>
                                        <span class="text-xs text-gray-500 flex items-center gap-1.5 font-medium">
                                            <div class="w-1.5 h-1.5 rounded-full bg-green-500"></div> Always
                                        </span>
                                    <?php else: ?>
                                        <span class="text-xs font-bold text-purple-600 dark:text-purple-400 bg-purple-50 dark:bg-purple-900/20 px-2 py-0.5 rounded-md flex w-fit items-center gap-1.5 border border-purple-100 dark:border-purple-900/20">
                                            <ion-icon name="time-outline"></ion-icon> <?php echo $item['schedule']; ?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-2">
                                        <div class="w-6 h-6 rounded-full bg-blue-100 dark:bg-blue-900/30 flex items-center justify-center text-[10px] font-bold text-blue-600 dark:text-blue-400 border border-blue-200 dark:border-blue-800">
                                            <?php echo substr($item['updated_by'], 0, 1); ?>
                                        </div>
                                        <div class="flex flex-col">
                                            <span class="text-[10px] font-bold text-gray-600 dark:text-gray-300"><?php echo $item['updated_by']; ?></span>
                                            <span class="text-[9px] text-gray-400"><?php echo date('d M, H:i', strtotime($item['updated_at'])); ?></span>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-center">
                                     <?php if ($item['active']): ?>
                                     <button class="relative group/status inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full bg-green-50 dark:bg-green-900/10 border border-green-100 dark:border-green-900/30 transition-all hover:bg-green-100 dark:hover:bg-green-900/20 cursor-pointer">
                                        <div class="w-1.5 h-1.5 rounded-full bg-green-500 animate-pulse"></div>
                                        <span class="text-[10px] font-bold text-green-600 dark:text-green-400 uppercase tracking-wider">ACTIVE</span>
                                    </button>
                                    <?php else: ?>
                                    <button class="relative group/status inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full bg-gray-50 dark:bg-slate-700 border border-gray-200 dark:border-gray-600 transition-all hover:bg-gray-100 dark:hover:bg-slate-600 cursor-pointer">
                                        <div class="w-1.5 h-1.5 rounded-full bg-gray-400"></div>
                                        <span class="text-[10px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">INACTIVE</span>
                                    </button>
                                    <?php endif; ?>
                                </td>
                                <td class="py-4 px-6 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                         <a href="menu_items_form.php?id=<?php echo $item['id']; ?>" class="w-8 h-8 rounded-lg flex items-center justify-center text-gray-400 hover:text-blue-500 hover:bg-blue-50 dark:hover:bg-blue-900/10 border border-transparent hover:border-blue-100 dark:hover:border-blue-900/30 transition-all" title="Edit">
                                            <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                        </a>
                                        <button class="w-8 h-8 rounded-lg flex items-center justify-center text-gray-400 hover:text-purple-500 hover:bg-purple-50 dark:hover:bg-purple-900/10 border border-transparent hover:border-purple-100 dark:hover:border-purple-900/30 transition-all" title="Modifiers">
                                            <ion-icon name="options-outline" class="text-lg"></ion-icon>
                                        </button>
                                         <button class="w-8 h-8 rounded-lg flex items-center justify-center text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 border border-transparent hover:border-red-100 dark:hover:border-red-900/30 transition-all" title="Delete">
                                            <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    function toggleSearchPopup(id) {
        const popup = document.getElementById(id);
        const allPopups = document.querySelectorAll('[id^="searchPopup-"]');
        
        allPopups.forEach(p => {
            if (p.id !== id) {
                p.classList.add('invisible', 'opacity-0', 'translate-y-4');
            }
        });

        if (popup.classList.contains('invisible')) {
            popup.classList.remove('invisible', 'opacity-0', 'translate-y-4');
        } else {
            popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
        }
    }

    // Close on click outside
    document.addEventListener('click', function(event) {
        if (!event.target.closest('th')) {
            const allPopups = document.querySelectorAll('[id^="searchPopup-"]');
            allPopups.forEach(p => {
                p.classList.add('invisible', 'opacity-0', 'translate-y-4');
            });
        }
    });
</script>
