<?php
include 'includes/session.php';
// menu_categories_form.php - Create/Edit Menu Category
$catId = $_GET['id'] ?? null;
$mode = $catId ? 'edit' : 'create';
$pageTitle = $mode === 'edit' ? "Edit Menu Category" : "Create Menu Category";
$currentPage = "menu_categories";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Helper Functions
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '', $searchable = false) {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    
    $optionsHtml = '';
    foreach ($options as $val => $data) {
        $text = is_array($data) ? $data['label'] : $data;
        $attrString = '';
        if(is_array($data)) {
            foreach($data as $k => $v) {
                if($k !== 'label') $attrString .= ' '.$k.'="'.$v.'"';
            }
        }
        
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'"'.$attrString.'>
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    $searchHtml = $searchable ? '
    <div class="p-2 sticky top-0 bg-white dark:bg-slate-800 z-10 border-b border-gray-50 dark:border-gray-700/50">
        <div class="relative">
            <ion-icon name="search" class="absolute left-2.5 top-2.5 text-gray-400 text-sm"></ion-icon>
            <input type="text" class="w-full pl-8 pr-3 py-1.5 bg-gray-50 dark:bg-slate-700/50 border border-gray-100 dark:border-gray-600 rounded-lg text-xs text-gray-600 dark:text-gray-300 placeholder-gray-400 focus:outline-none focus:border-primary/50 transition-colors custom-select-search" placeholder="Search...">
        </div>
    </div>' : '';

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            '.$searchHtml.'
            <div class="p-1 space-y-0.5 custom-select-options">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}

function renderMultiSelect($label, $name, $options, $selectedKeys = []) {
    $optionsHtml = '';
    
    foreach ($options as $val => $data) {
        $text = is_array($data) ? $data['label'] : $data;
        $code = is_array($data) && isset($data['code']) ? $data['code'] : '';
        
        $isSelected = in_array((string)$val, $selectedKeys);
        $checkClass = $isSelected ? 'opacity-100' : 'opacity-0';
        $bgClass = $isSelected ? 'bg-orange-50/50 dark:bg-orange-900/10' : '';
        
        $badgeHtml = '';
        if($code) {
            $badgeHtml = '<span class="min-w-[40px] h-8 flex items-center justify-center rounded-lg bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400 text-xs font-bold uppercase tracking-wide mr-3">'.$code.'</span>';
        }

        $optionsHtml .= '
        <div class="multi-select-option group flex items-center justify-between w-full px-2 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-xl cursor-pointer transition-all '.$bgClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
            <div class="flex items-center">
                '.$badgeHtml.'
                <span class="font-medium">'.$text.'</span>
            </div>
            <ion-icon name="checkmark-circle" class="text-xl text-orange-500 transition-all transform scale-90 '.$checkClass.' check-icon"></ion-icon>
        </div>';
    }

    return '
    <div class="relative multi-select-container" id="multi-select-'.$name.'">
        <input type="hidden" name="'.$name.'" value="'.implode(',', $selectedKeys).'" class="multi-select-input">
        
        <div class="multi-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-2 py-2 outline-none focus-within:ring-2 focus-within:ring-orange-500/20 focus-within:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 min-h-[50px] cursor-pointer flex flex-wrap gap-2 relative">
            
            <div class="flex-1 flex flex-wrap gap-2 items-center px-1" id="tags-container-'.$name.'">
                <span class="text-gray-400 py-1.5 px-1 select-placeholder">'.$label.'</span>
            </div>

            <div class="absolute right-3 top-3.5 pointer-events-none">
                 <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg"></ion-icon>
            </div>
        </div>
        
        <div class="multi-select-dropdown absolute top-full left-0 mt-2 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-2xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar flex flex-col">
            
            <!-- Search -->
            <div class="p-2 sticky top-0 bg-white dark:bg-slate-800 z-10 border-b border-gray-50 dark:border-gray-700/50">
                <div class="relative">
                    <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 text-sm"></ion-icon>
                    <input type="text" class="multi-select-search w-full pl-9 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-gray-100 dark:border-gray-600 rounded-xl text-xs text-gray-600 dark:text-gray-300 placeholder-gray-400 focus:outline-none focus:border-primary/50 transition-colors" placeholder="Search...">
                </div>
            </div>

            <div class="p-2 space-y-1" id="options-container-'.$name.'">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="categoryFormContent" class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Glass Panel) -->
            <div class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                <div class="flex items-center gap-4">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">
                            <?php echo $pageTitle; ?>
                        </h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Configure menu category details.</p>
                    </div>
                </div>
                <!-- Actions -->
                <div class="flex items-center gap-3">
                    <button type="submit" form="categoryForm" class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save Menu Category</span>
                    </button>
                </div>
            </div>

            <!-- Main Panel -->
            <div class="glass-panel rounded-2xl animate-fade-in-up p-6 md:p-8">
                <form id="categoryForm" class="p-6 md:p-8 space-y-8" method="POST">
                    
                    <div class="grid grid-cols-1 lg:grid-cols-12 gap-10 items-start">
                        
                        <!-- Left Column (Inputs) - Spans 8 cols -->
                        <div class="lg:col-span-8 space-y-6">
                             <div class="space-y-2">
                                <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Menu Category Name <span class="text-red-500">*</span></label>
                                <input type="text" class="<?php echo $inputClass; ?>" placeholder="Enter Menu Category Name" required>
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Parent Category</label>
                                <?php 
                                    echo renderCustomSelect('Select Parent Category (Optional)', 'parent_category_id', [
                                        'none' => 'None (Top Level)',
                                        '1' => 'Food',
                                        '2' => 'Drinks',
                                        '3' => 'Merchandise'
                                    ], '', '', '', true); 
                                ?>
                            </div>

                             <div class="space-y-2">
                                <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Select Stores <span class="text-red-500">*</span></label>
                                <?php 
                                    echo renderMultiSelect('Select Stores', 'store_ids', [
                                        'all' => ['label' => 'All Stores', 'code' => 'ALL'],
                                        '1001' => ['label' => 'FNF Cardiff', 'code' => 'CDF'],
                                        '1002' => ['label' => 'FNF Bristol', 'code' => 'BRI'],
                                        '1003' => ['label' => 'FNF London', 'code' => 'LDN']
                                    ]); 
                                ?>
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Description <span class="text-red-500">*</span></label>
                                <textarea class="<?php echo $inputClass; ?> min-h-[140px] resize-none" placeholder="Enter Description"></textarea>
                            </div>

                             <!-- Disclaimer Section -->
                             <div class="space-y-4">
                                <label class="text-base font-bold text-gray-800 dark:text-white flex items-center gap-1">
                                    <span class="text-red-500">*</span>Is Parent Category Disclaimer Applied ? :
                                </label>
                                <?php
                                    // Logic for Edit Mode
                                    $isDiscApplied = isset($category['disclaimer']) && $category['disclaimer'] !== 'none' && $category['disclaimer'] !== ''; 
                                    
                                    // User Request: Not Applied -> VISIBLE. Applied -> HIDDEN.
                                    $hasDiscValue = isset($category['disclaimer']) && $category['disclaimer'] !== 'none';
                                    
                                    // If has value, "Not Applied" is CHECKED and container is SHOWN.
                                    $discCheckedNotApplied = $hasDiscValue ? 'checked' : '';
                                    $discCheckedApplied = !$hasDiscValue ? 'checked' : '';
                                    $discClass = $hasDiscValue ? '' : 'hidden';
                                    
                                    $discVal = $category['disclaimer'] ?? 'none';
                                ?>
                                <div class="flex items-center gap-8 mb-2">
                                    <label class="flex items-center gap-3 cursor-pointer group select-none">
                                        <div class="relative flex items-center justify-center">
                                             <input type="radio" name="is_disclaimer_applied" value="0" class="peer sr-only" <?php echo $discCheckedNotApplied; ?> onchange="toggleDisclaimer(this)">
                                             <!-- Outer Ring -->
                                             <div class="w-6 h-6 rounded-full border-[2px] border-gray-300 dark:border-gray-600 bg-white dark:bg-slate-700 peer-checked:bg-blue-600 peer-checked:border-blue-600 transition-all"></div>
                                             <!-- Inner Dot -->
                                             <div class="absolute w-2.5 h-2.5 rounded-full bg-white opacity-0 peer-checked:opacity-100 transition-opacity transform scale-0 peer-checked:scale-100 duration-200"></div>
                                        </div>
                                        <span class="text-base font-bold text-red-500 group-hover:opacity-80 transition-opacity">Not Applied</span>
                                    </label>
                                    
                                    <label class="flex items-center gap-3 cursor-pointer group select-none">
                                        <div class="relative flex items-center justify-center">
                                             <input type="radio" name="is_disclaimer_applied" value="1" class="peer sr-only" <?php echo $discCheckedApplied; ?> onchange="toggleDisclaimer(this)">
                                              <!-- Outer Ring -->
                                             <div class="w-6 h-6 rounded-full border-[2px] border-gray-300 dark:border-gray-600 bg-white dark:bg-slate-700 peer-checked:bg-blue-600 peer-checked:border-blue-600 transition-all"></div>
                                             <!-- Inner Dot -->
                                             <div class="absolute w-2.5 h-2.5 rounded-full bg-white opacity-0 peer-checked:opacity-100 transition-opacity transform scale-0 peer-checked:scale-100 duration-200"></div>
                                        </div>
                                        <span class="text-base font-bold text-gray-700 dark:text-gray-300 group-hover:opacity-80 transition-opacity">Applied</span>
                                    </label>
                                </div>

                                <div class="space-y-2 <?php echo $discClass; ?> animate-fade-in-up" id="disclaimerContainer">
                                    <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Select Disclaimer <span class="text-red-500">*</span></label>
                                    <?php 
                                        echo renderCustomSelect('Select Disclaimer', 'disclaimer', [
                                            'none' => 'None',
                                            '18plus' => '18+ Age Restriction',
                                            'allergy' => 'Allergy Warning'
                                        ], $discVal); 
                                    ?>
                                </div>
                            </div>
                        </div>

                        <!-- Right Column (Image & Tax) - Spans 4 cols -->
                        <div class="lg:col-span-4 space-y-8 flex flex-col">
                            
                            <!-- Image Upload (Exact Match to Product Form) -->
                            <div class="space-y-2">
                                <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Upload Image</label>
                                <div class="w-full sm:w-48 sm:h-48 aspect-square rounded-2xl bg-gray-50 dark:bg-slate-800 border-2 border-dashed border-gray-300 dark:border-gray-600 flex items-center justify-center relative overflow-hidden group hover:border-primary transition-colors cursor-pointer" onclick="document.getElementById('catImageInput').click()">
                                    <img id="catImagePreview" class="w-full h-full object-cover hidden z-10 relative" alt="Category Image">
                                    
                                     <!-- Remove Button -->
                                    <button type="button" id="removeCatImageBtn" class="absolute top-1 right-1 z-20 bg-white/90 dark:bg-black/50 text-red-500 hover:text-red-600 rounded-full p-1 shadow-sm hidden opacity-0 group-hover:opacity-100 transition-all hover:bg-white" onclick="event.stopPropagation(); removeCatImage(event);">
                                        <ion-icon name="close-circle" class="text-xl"></ion-icon>
                                    </button>

                                    <div class="absolute inset-0 flex flex-col items-center justify-center text-gray-400 group-hover:text-primary transition-colors z-0" id="catImagePlaceholder">
                                        <ion-icon name="add-outline" class="text-5xl text-gray-300 group-hover:text-primary mb-2 transition-colors"></ion-icon>
                                        <!-- <span class="text-xs font-medium">Upload</span> -->
                                    </div>
                                    
                                    <!-- Overlay -->
                                    <div class="absolute inset-0 bg-black/50 hidden group-hover:flex items-center justify-center text-white text-xs font-medium opacity-0 group-hover:opacity-100 transition-opacity z-10" id="imageOverlay">
                                        Change
                                    </div>
                                </div>
                                <input type="file" id="catImageInput" name="category_image" class="hidden" accept="image/png, image/jpeg, image/gif, image/svg+xml">
                            </div>

                             <!-- Tax Slab Section -->
                             <div class="space-y-4">
                                <label class="text-base font-bold text-gray-800 dark:text-white flex items-center gap-1">
                                    <span class="text-red-500">*</span>Is Parent Category Tax Applied ? :
                                </label>
                                <?php
                                    // Logic for Edit Mode
                                    $hasTaxValue = isset($category['tax_slab']) && $category['tax_slab'] != '0';
                                    
                                    // User Request: Not Applied -> VISIBLE. Applied -> HIDDEN.
                                    $taxCheckedNotApplied = $hasTaxValue ? 'checked' : '';
                                    $taxCheckedApplied = !$hasTaxValue ? 'checked' : '';
                                    $taxClass = $hasTaxValue ? '' : 'hidden';
                                    
                                    $taxVal = $category['tax_slab'] ?? '0';
                                ?>
                                <div class="flex items-center gap-8 mb-2">
                                    <label class="flex items-center gap-3 cursor-pointer group select-none">
                                        <div class="relative flex items-center justify-center">
                                             <input type="radio" name="is_tax_applied" value="0" class="peer sr-only" <?php echo $taxCheckedNotApplied; ?> onchange="toggleTaxSlab(this)">
                                              <!-- Outer Ring -->
                                             <div class="w-6 h-6 rounded-full border-[2px] border-gray-300 dark:border-gray-600 bg-white dark:bg-slate-700 peer-checked:bg-blue-600 peer-checked:border-blue-600 transition-all"></div>
                                             <!-- Inner Dot -->
                                             <div class="absolute w-2.5 h-2.5 rounded-full bg-white opacity-0 peer-checked:opacity-100 transition-opacity transform scale-0 peer-checked:scale-100 duration-200"></div>
                                        </div>
                                        <span class="text-base font-bold text-red-500 group-hover:opacity-80 transition-opacity">Not Applied</span>
                                    </label>
                                    
                                    <label class="flex items-center gap-3 cursor-pointer group select-none">
                                        <div class="relative flex items-center justify-center">
                                             <input type="radio" name="is_tax_applied" value="1" class="peer sr-only" <?php echo $taxCheckedApplied; ?> onchange="toggleTaxSlab(this)">
                                              <!-- Outer Ring -->
                                             <div class="w-6 h-6 rounded-full border-[2px] border-gray-300 dark:border-gray-600 bg-white dark:bg-slate-700 peer-checked:bg-blue-600 peer-checked:border-blue-600 transition-all"></div>
                                             <!-- Inner Dot -->
                                             <div class="absolute w-2.5 h-2.5 rounded-full bg-white opacity-0 peer-checked:opacity-100 transition-opacity transform scale-0 peer-checked:scale-100 duration-200"></div>
                                        </div>
                                        <span class="text-base font-bold text-gray-700 dark:text-gray-300 group-hover:opacity-80 transition-opacity">Applied</span>
                                    </label>
                                </div>

                                <div class="space-y-2 <?php echo $taxClass; ?> animate-fade-in-up" id="taxSlabContainer">
                                    <label class="text-sm font-bold text-gray-700 dark:text-gray-300">Select Tax Slab <span class="text-red-500">*</span></label>
                                    <?php 
                                        echo renderCustomSelect('Select Value', 'tax_slab', [
                                            '0' => '0% (Zero Rated)',
                                            '5' => '5% (Reduced Rate)',
                                            '20' => '20% (Standard Rate)'
                                        ], $taxVal); 
                                    ?>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    // --- Multi Select Logic ---
    function initMultiSelect(name) {
        const container = document.getElementById('multi-select-' + name);
        if (!container) return;

        const trigger = container.querySelector('.multi-select-trigger');
        const dropdown = container.querySelector('.multi-select-dropdown');
        const options = container.querySelectorAll('.multi-select-option');
        const hiddenInput = container.querySelector('.multi-select-input');
        const tagsContainer = container.querySelector('#tags-container-' + name);
        const placeholder = tagsContainer.querySelector('.select-placeholder');
        const searchInput = container.querySelector('.multi-select-search');
        
        // State
        let selectedValues = hiddenInput.value ? hiddenInput.value.split(',').filter(Boolean) : [];

        // Search Logic
        if(searchInput) {
            searchInput.addEventListener('input', (e) => {
                const term = e.target.value.toLowerCase();
                options.forEach(opt => {
                    const label = opt.dataset.label.toLowerCase();
                    const code = opt.querySelector('span') ? opt.querySelector('span').innerText.toLowerCase() : ''; 
                    // Search in label or code (if badge exists)
                    if(label.includes(term) || code.includes(term)) {
                        opt.classList.remove('hidden');
                    } else {
                        opt.classList.add('hidden');
                    }
                });
            });
        }

        // Toggle Dropdown
        trigger.addEventListener('click', (e) => {
            if(e.target.closest('.tag-remove')) return; // Ignore remove clicks
            dropdown.classList.toggle('invisible');
            dropdown.classList.toggle('opacity-0');
            dropdown.classList.toggle('translate-y-2');
            
            // Focus search
            if(!dropdown.classList.contains('invisible') && searchInput) {
                setTimeout(() => searchInput.focus(), 100);
            }
        });

        // Close on click outside
        document.addEventListener('click', (e) => {
            if (!container.contains(e.target)) {
                dropdown.classList.add('invisible', 'opacity-0', 'translate-y-2');
            }
        });

        // Update UI
        function updateUI() {
            // Update Hidden Input
            hiddenInput.value = selectedValues.join(',');

            // Render Tags
            tagsContainer.innerHTML = '';
            
            if (selectedValues.length === 0) {
                 tagsContainer.appendChild(placeholder);
                 placeholder.style.display = 'block';
            } else {
                placeholder.style.display = 'none'; 
                
                // If 'all' is selected, nicely format it or standard tag
                selectedValues.forEach(val => {
                    const option = Array.from(options).find(opt => opt.dataset.value === val);
                    const label = option ? option.dataset.label : val;

                    const tag = document.createElement('div');
                    tag.className = 'bg-orange-100 dark:bg-orange-900/30 text-orange-700 dark:text-orange-400 text-xs px-2 py-1 rounded-md flex items-center gap-1 font-bold animate-fade-in-up';
                    tag.innerHTML = `
                        <span>${label}</span>
                        <ion-icon name="close" class="tag-remove text-sm cursor-pointer hover:text-orange-900 dark:hover:text-white transition-colors" data-val="${val}"></ion-icon>
                    `;
                    tag.querySelector('.tag-remove').addEventListener('click', (e) => {
                        e.stopPropagation();
                        toggleSelection(val);
                    });
                    tagsContainer.appendChild(tag);
                });
            }

            // Update Options List (Checkmarks & BG)
            options.forEach(opt => {
                const val = opt.dataset.value;
                const icon = opt.querySelector('.check-icon');
                const isSelected = selectedValues.includes(val);

                if (isSelected) {
                    opt.classList.add('bg-orange-50', 'dark:bg-orange-900/10');
                    icon.classList.remove('opacity-0');
                    icon.classList.add('opacity-100'); 
                } else {
                    opt.classList.remove('bg-orange-50', 'dark:bg-orange-900/10');
                    icon.classList.add('opacity-0');
                    icon.classList.remove('opacity-100');
                }
            });
        }

        // Toggle Selection
        function toggleSelection(val) {
            // "All Stores" Logic
            if (val === 'all') {
                if (selectedValues.includes('all')) {
                    selectedValues = []; // Deselect All
                } else {
                    selectedValues = ['all']; // Select Only All
                }
            } else {
                // Remove 'all' if present
                const allIndex = selectedValues.indexOf('all');
                if (allIndex !== -1) {
                    selectedValues.splice(allIndex, 1);
                }

                const index = selectedValues.indexOf(val);
                if (index === -1) {
                    selectedValues.push(val);
                } else {
                    selectedValues.splice(index, 1);
                }
            }
            updateUI();
        }

        // Click Option
        options.forEach(opt => {
            opt.addEventListener('click', () => {
                toggleSelection(opt.dataset.value);
            });
        });

        // Initial Render
        updateUI();
    }

    // Initialize Store Select
    document.addEventListener('DOMContentLoaded', () => {
         initMultiSelect('store_ids');
    });

    // Validation Logic
    document.getElementById('categoryForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Simulating form submission
        const btn = this.querySelector('button[type="submit"]');
        const originalContent = btn.innerHTML;
        
        btn.disabled = true;
        btn.innerHTML = '<ion-icon name="sync-outline" class="animate-spin text-lg"></ion-icon> Saving...';
        
        setTimeout(() => {
            if(window.showToast) {
                showToast('Menu Category saved successfully!', 'success');
            } else {
                alert('Menu Category saved successfully!');
            }
            btn.disabled = false;
            btn.innerHTML = originalContent;
            
            // Redirect after delay
             setTimeout(() => {
                window.location.href = 'menu_categories.php';
            }, 1000);
        }, 1000);
    });

    // Image Upload Logic
    document.getElementById('catImageInput').addEventListener('change', function(e) {
        if (this.files && this.files[0]) {
             const file = this.files[0];
            
            // Validate File Type
            const validTypes = ['image/jpeg', 'image/png', 'image/jpg', 'image/gif', 'image/svg+xml'];
            if (!validTypes.includes(file.type)) {
                if(window.showToast) {
                    showToast('Only JPG, PNG, GIF, and SVG files are allowed.', 'error');
                } else {
                    alert('Invalid file type'); 
                }
                this.value = ''; 
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('catImagePreview');
                const placeholder = document.getElementById('catImagePlaceholder');
                const removeBtn = document.getElementById('removeCatImageBtn');
                
                preview.src = e.target.result;
                preview.classList.remove('hidden');
                placeholder.classList.add('hidden');
                removeBtn.classList.remove('hidden');
            }
            reader.readAsDataURL(file);
        }
    });

    function removeCatImage(e) {
        const preview = document.getElementById('catImagePreview');
        const placeholder = document.getElementById('catImagePlaceholder');
        const removeBtn = document.getElementById('removeCatImageBtn');
        const input = document.getElementById('catImageInput');
        
        preview.src = '';
        preview.classList.add('hidden');
        placeholder.classList.remove('hidden');
        removeBtn.classList.add('hidden');
        input.value = ''; 
    }

    // Toggle Logic
    // User Requirement: Not Applied (value="0") -> Show Dropdown. Applied (value="1") -> Hide Dropdown.
    function toggleDisclaimer(radio) {
        const container = document.getElementById('disclaimerContainer');
        if (radio.value === '0') { // Not Applied -> Show
            container.classList.remove('hidden');
        } else { // Applied -> Hide
            container.classList.add('hidden');
        }
    }

    function toggleTaxSlab(radio) {
        const container = document.getElementById('taxSlabContainer');
        if (radio.value === '0') { // Not Applied -> Show
            container.classList.remove('hidden');
        } else { // Applied -> Hide
            container.classList.add('hidden');
        }
    }

    // --- Parent Dependency Logic ---
    function checkParentDependency() {
        const parentInput = document.querySelector('input[name="parent_category_id"]');
        if(!parentInput) return;

        const parentVal = parentInput.value;
        const hasParent = (parentVal && parentVal !== 'none');
        
        // 1. Disclaimer Logic
        const discAppliedLabel = document.querySelector('input[name="is_disclaimer_applied"][value="1"]').closest('label');
        const discAppliedInput = discAppliedLabel.querySelector('input');
        const discNotAppliedInput = document.querySelector('input[name="is_disclaimer_applied"][value="0"]');

        if (!hasParent) {
            // Disable 'Applied'
            discAppliedLabel.classList.add('opacity-50', 'cursor-not-allowed', 'pointer-events-none');
            discAppliedInput.disabled = true;
            
            // If currently applied, switch to Not Applied
            if (discAppliedInput.checked) {
                discNotAppliedInput.checked = true;
                discNotAppliedInput.dispatchEvent(new Event('change')); // Trigger toggle
            }
        } else {
            // Enable 'Applied'
            discAppliedLabel.classList.remove('opacity-50', 'cursor-not-allowed', 'pointer-events-none');
            discAppliedInput.disabled = false;
        }

        // 2. Tax Logic
        const taxAppliedLabel = document.querySelector('input[name="is_tax_applied"][value="1"]').closest('label');
        const taxAppliedInput = taxAppliedLabel.querySelector('input');
        const taxNotAppliedInput = document.querySelector('input[name="is_tax_applied"][value="0"]');

        if (!hasParent) {
            // Disable 'Applied'
            taxAppliedLabel.classList.add('opacity-50', 'cursor-not-allowed', 'pointer-events-none');
            taxAppliedInput.disabled = true;
            
            // If currently applied, switch to Not Applied
            if (taxAppliedInput.checked) {
                taxNotAppliedInput.checked = true;
                taxNotAppliedInput.dispatchEvent(new Event('change'));
            }
        } else {
            // Enable 'Applied'
            taxAppliedLabel.classList.remove('opacity-50', 'cursor-not-allowed', 'pointer-events-none');
            taxAppliedInput.disabled = false;
        }
    }

    // Observe changes to Parent Category Hidden Input (since Custom Select modifies it directly)
    // Alternatively, attach click listeners to the options of the parent select.
    document.addEventListener('DOMContentLoaded', () => {
        const parentContainer = document.querySelector('input[name="parent_category_id"]').closest('.custom-select-container');
        if(parentContainer) {
            parentContainer.querySelectorAll('.custom-select-option').forEach(opt => {
                opt.addEventListener('click', () => {
                    // Slight delay to allow value update
                    setTimeout(checkParentDependency, 50);
                });
            });
        }
        
        // Initial Check
        checkParentDependency();
    });
</script>
