<?php
include 'includes/session.php';
$pageTitle = "Menu Categories";
$currentPage = "menu_categories";
require_once 'includes/header.php';

// Mock Data (Enhanced)
$categories = [
    [
        'id' => 1,
        'name' => 'Starters',
        'image' => 'https://images.unsplash.com/photo-1546069901-ba9599a7e63c?auto=format&fit=crop&w=100&h=100',
        'parent' => null,
        'items_count' => 12,
        'sort_order' => 1,
        'active' => true,
        'updated_by' => 'Admin',
        'updated_at' => '2 days ago',
        'stores' => ['CDF', 'BRI']
    ],
    [
        'id' => 2,
        'name' => 'Mains',
        'image' => 'https://images.unsplash.com/photo-1555939594-58d7cb561ad1?auto=format&fit=crop&w=100&h=100',
        'parent' => null,
        'items_count' => 24,
        'sort_order' => 2,
        'active' => true,
        'updated_by' => 'Manager',
        'updated_at' => '1 day ago',
        'stores' => ['ALL']
    ],
    [
        'id' => 3,
        'name' => 'Steaks',
        'image' => 'https://images.unsplash.com/photo-1600891964092-4316c288032e?auto=format&fit=crop&w=100&h=100',
        'parent' => 'Mains',
        'items_count' => 5,
        'sort_order' => 1,
        'active' => true,
        'updated_by' => 'Admin',
        'updated_at' => '5 hours ago',
        'stores' => ['LDN']
    ],
    [
        'id' => 4,
        'name' => 'Drinks',
        'image' => 'https://images.unsplash.com/photo-1544145945-f90425340c7e?auto=format&fit=crop&w=100&h=100',
        'parent' => null,
        'items_count' => 40,
        'sort_order' => 3,
        'active' => true,
        'updated_by' => 'System',
        'updated_at' => 'Just now',
        'stores' => ['CDF']
    ],
    [
        'id' => 5,
        'name' => 'Seasonal Specials',
        'image' => null,
        'parent' => null,
        'items_count' => 3,
        'sort_order' => 4,
        'active' => false,
        'updated_by' => 'Admin',
        'updated_at' => '1 week ago',
        'stores' => ['BRI', 'LDN']
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col sm:flex-row sm:items-center justify-between gap-6 relative z-20">
                <div class="flex items-center gap-4">
                    <div class="h-12 w-12 rounded-xl bg-gradient-to-br from-orange-500 to-orange-600 flex items-center justify-center shadow-lg shadow-orange-500/30 text-white">
                        <ion-icon name="restaurant-outline" class="text-2xl"></ion-icon>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Menu Categories</h1>
                         <p class="text-gray-500 dark:text-gray-400 text-sm font-medium">Manage your menu structure and organization.</p>
                    </div>
                </div>

                <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto">
                    <!-- Global Search -->
                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <ion-icon name="search-outline" class="text-gray-400 text-lg group-focus-within:text-orange-500 transition-colors"></ion-icon>
                        </div>
                        <input type="text" class="w-full sm:w-64 pl-10 pr-4 py-2.5 bg-gray-50 dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 text-sm font-medium transition-all shadow-sm" placeholder="Search categories...">
                    </div>

                    <button class="px-4 py-2.5 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-700 dark:text-gray-200 rounded-xl text-sm font-bold hover:bg-gray-50 dark:hover:bg-slate-700 transition-all shadow-sm hover:shadow-md flex items-center justify-center gap-2">
                        <ion-icon name="cloud-upload-outline" class="text-lg"></ion-icon>
                        <span>Import</span>
                    </button>

                    <a href="menu_categories_form.php" class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center justify-center gap-2">
                        <ion-icon name="add-circle-outline" class="text-xl"></ion-icon>
                        <span>Add Category</span>
                    </a>
                </div>
            </div>

            <!-- Table Section -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm relative z-10">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="w-16 py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Img</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider w-20">ID</th>
                                
                                <!-- Category Name Filter -->
                                <th class="p-4 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider relative min-w-[200px]">
                                    <div class="flex items-center gap-2 cursor-pointer hover:text-gray-700 dark:hover:text-gray-200 group" onclick="toggleSearchPopup('search-name-popup')">
                                        <span>Category Name</span>
                                        <ion-icon name="filter" class="text-gray-400 group-hover:text-primary transition-colors"></ion-icon>
                                    </div>
                                    <div id="search-name-popup" class="hidden absolute top-full left-0 mt-2 w-64 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 p-3 z-50 animate-fade-in-up">
                                        <div class="relative">
                                            <input type="text" placeholder="Filter by name..." class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700 border border-gray-200 dark:border-gray-600 rounded-lg text-xs focus:ring-2 focus:ring-primary/20 focus:border-primary outline-none">
                                            <ion-icon name="search" class="absolute left-2.5 top-2.5 text-gray-400"></ion-icon>
                                        </div>
                                        <div class="flex justify-end gap-2 mt-3">
                                            <button class="px-3 py-1.5 text-xs font-bold text-gray-500 hover:bg-gray-100 dark:hover:bg-slate-700 rounded-lg" onclick="event.stopPropagation(); toggleSearchPopup('search-name-popup')">Close</button>
                                            <button class="px-3 py-1.5 text-xs font-bold bg-primary text-white rounded-lg shadow-sm">Apply</button>
                                        </div>
                                    </div>
                                </th>

                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Parent Category</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Stores</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Items</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Sort</th>
                                
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Updated By</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Updated At</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">Status</th>
                                <th class="py-4 px-6 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                            <?php foreach ($categories as $cat): ?>
                            <tr class="group hover:bg-gray-50/80 dark:hover:bg-slate-800/50 transition-colors duration-200">
                                <td class="py-4 px-6 text-center">
                                    <div class="h-10 w-10 rounded-lg bg-gray-100 dark:bg-slate-700 flex items-center justify-center overflow-hidden border border-gray-200 dark:border-gray-600 group-hover:border-indigo-300 dark:group-hover:border-indigo-700 transition-colors">
                                        <?php if(isset($cat['image']) && $cat['image']): ?>
                                            <img src="<?php echo $cat['image']; ?>" alt="" class="w-full h-full object-cover">
                                        <?php else: ?>
                                            <ion-icon name="image-outline" class="text-lg text-gray-400"></ion-icon>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td class="py-4 px-6">
                                    <span class="font-mono text-xs text-gray-500">#<?php echo str_pad($cat['id'], 3, '0', STR_PAD_LEFT); ?></span>
                                </td>
                                <td class="py-4 px-6">
                                    <div class="flex flex-col">
                                        <div class="text-sm font-bold text-gray-800 dark:text-white group-hover:text-indigo-600 dark:group-hover:text-indigo-400 transition-colors"><?php echo $cat['name']; ?></div>
                                    </div>
                                </td>
                                <td class="py-4 px-6">
                                     <?php if ($cat['parent']): ?>
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-lg bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300 text-xs font-bold border border-gray-200 dark:border-gray-600">
                                        <ion-icon name="return-down-forward" class="text-gray-400"></ion-icon> <?php echo $cat['parent']; ?>
                                    </span>
                                    <?php else: ?>
                                    <span class="text-xs text-gray-400 italic font-medium px-2">Top Level</span>
                                    <?php endif; ?>
                                </td>
                                <td class="py-4 px-6">
                                    <div class="flex flex-wrap gap-1">
                                        <?php foreach($cat['stores'] as $store): ?>
                                            <?php if($store == 'ALL'): ?>
                                                <span class="px-2 py-0.5 rounded-md bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400 text-[10px] font-bold uppercase tracking-wide border border-blue-100 dark:border-blue-800">ALL</span>
                                            <?php else: ?>
                                                <span class="px-2 py-0.5 rounded-md bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300 text-[10px] font-bold uppercase tracking-wide border border-gray-200 dark:border-gray-600"><?php echo $store; ?></span>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center justify-center min-w-[30px] h-6 px-2 rounded-full bg-orange-50 dark:bg-orange-900/20 text-orange-600 dark:text-orange-400 text-xs font-bold">
                                        <?php echo $cat['items_count']; ?>
                                    </span>
                                </td>
                                <td class="py-4 px-6 text-center">
                                    <span class="text-sm font-mono text-gray-500 font-bold"><?php echo $cat['sort_order']; ?></span>
                                </td>
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-2">
                                        <div class="w-6 h-6 rounded-full bg-indigo-100 dark:bg-indigo-900/30 text-indigo-600 dark:text-indigo-400 flex items-center justify-center text-[10px] font-bold">
                                            <?php echo substr($cat['updated_by'], 0, 1); ?>
                                        </div>
                                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400"><?php echo $cat['updated_by']; ?></span>
                                    </div>
                                </td>
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-1.5 text-gray-500">
                                        <ion-icon name="time-outline" class="text-xs"></ion-icon>
                                        <span class="text-xs"><?php echo $cat['updated_at']; ?></span>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-center">
                                    <?php if ($cat['active']): ?>
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full bg-emerald-50 dark:bg-emerald-900/20 text-emerald-600 dark:text-emerald-400 text-[10px] font-bold uppercase tracking-wider border border-emerald-100 dark:border-emerald-900/30">
                                        <span class="w-1.5 h-1.5 rounded-full bg-emerald-500"></span> Active
                                    </span>
                                    <?php else: ?>
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full bg-gray-100 dark:bg-slate-700 text-gray-500 dark:text-gray-400 text-[10px] font-bold uppercase tracking-wider border border-gray-200 dark:border-gray-600">
                                        <span class="w-1.5 h-1.5 rounded-full bg-gray-400"></span> Hidden
                                    </span>
                                    <?php endif; ?>
                                </td>
                                <td class="py-4 px-6 text-right">
                                    <div class="flex items-center justify-end gap-2 opacity-0 group-hover:opacity-100 transition-opacity duration-200">
                                        <button class="p-2 rounded-lg bg-gray-50 dark:bg-slate-700 text-gray-400 hover:text-indigo-500 dark:hover:text-indigo-400 hover:bg-white dark:hover:bg-slate-600 shadow-sm transition-all" title="Manage Items">
                                            <ion-icon name="list-outline" class="text-lg"></ion-icon>
                                        </button>
                                         <a href="menu_categories_form.php?id=<?php echo $cat['id']; ?>" class="p-2 rounded-lg bg-gray-50 dark:bg-slate-700 text-gray-400 hover:text-indigo-500 dark:hover:text-indigo-400 hover:bg-white dark:hover:bg-slate-600 shadow-sm transition-all" title="Edit">
                                            <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                        </a>
                                        <button class="p-2 rounded-lg bg-gray-50 dark:bg-slate-700 text-gray-400 hover:text-red-500 hover:bg-white dark:hover:bg-slate-600 shadow-sm transition-all" title="Delete">
                                            <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                 <!-- Pagination -->
                <div class="px-6 py-4 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between bg-gray-50/30 dark:bg-slate-800/30">
                    <div class="text-xs text-gray-500 dark:text-gray-400 font-medium">
                        Showing <span class="font-bold text-gray-700 dark:text-gray-200">1-5</span> of <span class="font-bold text-gray-700 dark:text-gray-200">24</span> categories
                    </div>
                    <div class="flex items-center gap-2">
                        <button class="p-2 rounded-lg border border-gray-200 dark:border-gray-600 text-gray-400 hover:bg-white dark:hover:bg-slate-700 transition-colors disabled:opacity-50" disabled>
                            <ion-icon name="chevron-back-outline"></ion-icon>
                        </button>
                        <button class="p-2 rounded-lg border border-gray-200 dark:border-gray-600 text-gray-600 dark:text-gray-300 hover:bg-white dark:hover:bg-slate-700 transition-colors">
                            <ion-icon name="chevron-forward-outline"></ion-icon>
                        </button>
                    </div>
                </div>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
function toggleSearchPopup(id) {
    const popup = document.getElementById(id);
    if (!popup) return;
    
    // Close others
    document.querySelectorAll('[id^="search-"][id$="-popup"]').forEach(el => {
        if (el.id !== id) el.classList.add('hidden');
    });

    popup.classList.toggle('hidden');
}

// Close popups on outside click
document.addEventListener('click', (e) => {
    if (!e.target.closest('th')) {
        document.querySelectorAll('[id^="search-"][id$="-popup"]').forEach(el => {
            el.classList.add('hidden');
        });
    }
});
</script>
