<?php
include 'includes/session.php';
$pageTitle = "Inventory Adjustments";
$currentPage = "inventory_adjustments";
require_once 'includes/header.php';

// Mock Data
$adjustments = [
    [
        'id' => 1,
        'date' => '2026-01-16 10:00',
        'store' => 'FNF Cardiff',
        'product' => 'Coca Cola 500ml',
        'qty' => -2,
        'type' => 'Waste',
        'reason' => 'Damaged/Leaking',
        'user' => 'Ali K.'
    ],
    [
        'id' => 2,
        'date' => '2026-01-16 11:30',
        'store' => 'FNF Cardiff',
        'product' => 'Heinz Baked Beans',
        'qty' => +5,
        'type' => 'Adjustment',
        'reason' => 'Count Correction',
        'user' => 'System'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header (Glass Panel) -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col xl:flex-row justify-between items-center gap-6 relative z-50 overflow-visible bg-white dark:bg-slate-800 shadow-sm border border-gray-100 dark:border-gray-700">
                <div class="flex items-center gap-4">
                    <div class="h-12 w-12 rounded-xl bg-gradient-to-br from-orange-500 to-orange-600 flex items-center justify-center shadow-lg shadow-orange-500/30 text-white">
                        <ion-icon name="clipboard-outline" class="text-2xl"></ion-icon>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Inventory Adjustments</h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm font-medium">Log wastage, breakage, and stock corrections.</p>
                    </div>
                </div>
                
                <!-- Controls Bar -->
                <div class="flex flex-col sm:flex-row items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-1.5 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                    
                     <!-- Store Filter -->
                     <div class="relative z-50">
                        <button id="invStoreFilterBtn" onclick="toggleInvStoreDropdown()" class="flex items-center gap-2 px-3 py-2 text-sm font-medium text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-white dark:hover:bg-slate-700 rounded-lg transition-colors whitespace-nowrap cursor-pointer">
                            <ion-icon name="storefront-outline" class="text-gray-400"></ion-icon>
                            <span id="invStoreFilterText">All Stores</span>
                            <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 ml-1 transition-transform duration-300"></ion-icon>
                        </button>
                        
                        <!-- Dropdown Menu -->
                        <div id="invStoreFilterDropdown" class="absolute top-full right-0 sm:left-auto sm:right-0 mt-2 w-64 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 z-50 p-2 space-y-1 opacity-0 invisible transform -translate-y-2 transition-all duration-200">
                            <!-- All Stores -->
                            <button class="inv-store-option w-full flex items-center justify-between p-2 rounded-lg bg-gray-50 dark:bg-slate-700/50 text-gray-800 dark:text-gray-200 transition-colors active" onclick="selectInvStore('all', 'All Stores', this)">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-orange-100 dark:bg-orange-500/20 flex items-center justify-center text-orange-600 dark:text-orange-400">
                                        <ion-icon name="storefront" class="text-lg"></ion-icon>
                                    </div>
                                    <span class="font-medium text-sm">All Stores</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-100"></ion-icon>
                            </button>
                             <!-- FNF Cardiff -->
                            <button class="inv-store-option w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group" onclick="selectInvStore('cdf', 'FNF Cardiff', this)">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-blue-50 dark:bg-blue-900/20 flex items-center justify-center text-blue-600 dark:text-blue-400 text-xs font-bold">
                                        CDF
                                    </div>
                                    <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">FNF Cardiff</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                            </button>
                            <!-- FNF Swansea -->
                            <button class="inv-store-option w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group" onclick="selectInvStore('swa', 'FNF Swansea', this)">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-emerald-50 dark:bg-emerald-900/20 flex items-center justify-center text-emerald-600 dark:text-emerald-400 text-xs font-bold">
                                        SWA
                                    </div>
                                    <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">FNF Swansea</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                            </button>
                        </div>
                    </div>

                    <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                    <!-- Date Filter (Reusable Component) -->
                    <?php 
                    $pickerId = 'inventory';
                    $showApplyButton = false;
                    include 'includes/components/date_picker.php'; 
                    ?>
                    
                    <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>
                    
                     <!-- Apply Button -->
                    <button class="px-4 py-2 text-sm font-bold rounded-lg bg-primary hover:bg-orange-600 text-white shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all flex items-center gap-2" onclick="applyFilters()">
                        <ion-icon name="filter-outline"></ion-icon>
                        Apply
                    </button>

                    <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                    <!-- Create Button (Secondary Style) -->
                    <!-- Create Button (Secondary Style) -->
                    <a href="inventory_adjustment_form.php" class="flex items-center gap-2 px-3 py-2 text-primary font-bold text-sm hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors shrink-0 whitespace-nowrap">
                        <ion-icon name="add-circle-outline" class="text-lg"></ion-icon>
                        <span>New</span>
                    </a>

                    <!-- Export Button (Primary Style) -->
                     <button class="px-4 py-2 text-sm font-bold rounded-lg bg-primary hover:bg-orange-600 text-white shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all flex items-center gap-2 ml-4 sm:ml-0">
                        <ion-icon name="download-outline" class="text-lg"></ion-icon>
                        <span>Export</span>
                    </button>
                </div>
            </div>

            <!-- Table -->
            <div class="glass-panel rounded-2xl overflow-visible shadow-sm min-h-[500px]">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                             <!-- Date/Time Filter -->
                            <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider relative group w-[180px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-date" class="transition-colors duration-200">Date/Time</span>
                                    <button onclick="toggleSearchPopup('searchPopup-date')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-date" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Date</span>
                                        <ion-icon name="calendar-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-date" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Date...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('date')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('date')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                             <!-- Store (Separate) -->
                            <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider relative group w-[120px] text-center">
                                Store
                            </th>

                             <!-- Product Filter -->
                            <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider relative group w-[220px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-product" class="transition-colors duration-200">Product</span>
                                    <button onclick="toggleSearchPopup('searchPopup-product')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-product" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Product</span>
                                        <ion-icon name="cube-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-product" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Product Name...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('product')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('product')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                             <!-- Qty Delta Filter -->
                            <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider relative group text-center w-[120px]">
                                <div class="flex items-center justify-center gap-2">
                                    <span id="header-qty" class="transition-colors duration-200">Qty Delta</span>
                                    <button onclick="toggleSearchPopup('searchPopup-qty')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="filter-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-qty" class="absolute top-full left-1/2 -translate-x-1/2 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top backdrop-blur-xl text-left">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Filter Qty</span>
                                        <ion-icon name="stats-chart-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                     <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="number" id="input-qty" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Quantity...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('qty')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('qty')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                             <!-- Reason Filter -->
                            <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider relative group w-[200px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-reason" class="transition-colors duration-200">Reason</span>
                                    <button onclick="toggleSearchPopup('searchPopup-reason')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-reason" class="absolute top-full right-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-right backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Reason</span>
                                        <ion-icon name="document-text-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-reason" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Reason...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('reason')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('reason')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                             <!-- Updated By (New) -->
                             <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center w-[150px]">
                                Updated By <ion-icon name="search-outline" class="text-gray-400 ml-1"></ion-icon>
                            </th>

                             <!-- Actions (Edit/Delete) -->
                             <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right w-[120px]">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                        <?php foreach ($adjustments as $row): ?>
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                            <td class="py-4 px-6">
                                <div class="text-sm text-gray-600 dark:text-gray-300"><?php echo date('d M H:i', strtotime($row['date'])); ?></div>
                            </td>
                            <!-- Store -->
                            <td class="py-4 px-6 text-center">
                                <span class="inline-flex items-center px-2 py-1 rounded-md bg-white dark:bg-slate-700 border border-gray-200 dark:border-gray-600 text-xs font-bold text-gray-600 dark:text-gray-300 shadow-sm">
                                    <?php echo $row['store']; ?>
                                </span>
                            </td>
                            <td class="py-4 px-6">
                                <span class="text-sm font-medium text-gray-800 dark:text-white"><?php echo $row['product']; ?></span>
                            </td>
                             <td class="py-4 px-6 text-center">
                                <?php if ($row['qty'] < 0): ?>
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-full bg-red-100 text-red-700 dark:bg-red-900/30 dark:text-red-400 text-xs font-bold border border-red-200 dark:border-red-800"><?php echo $row['qty']; ?></span>
                                <?php else: ?>
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-full bg-green-100 text-green-700 dark:bg-green-900/30 dark:text-green-400 text-xs font-bold border border-green-200 dark:border-green-800">+<?php echo $row['qty']; ?></span>
                                <?php endif; ?>
                            </td>
                             <td class="py-4 px-6">
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1.5 rounded-lg bg-gray-100 dark:bg-slate-700/50 text-xs font-bold text-gray-600 dark:text-gray-300 border border-gray-200 dark:border-gray-700">
                                    <?php if($row['type'] == 'Waste') echo '<ion-icon name="trash-outline" class="text-red-500"></ion-icon>'; ?>
                                    <?php echo $row['reason']; ?>
                                </span>
                            </td>
                            <!-- Updated By -->
                             <td class="py-4 px-6 text-center">
                                <div class="text-xs font-medium text-gray-900 dark:text-white"><?php echo $row['user']; ?></div>
                                <div class="text-[10px] text-gray-400"><?php echo date('d M H:i', strtotime($row['date'])); ?></div>
                            </td>
                            <!-- Actions -->
                            <td class="py-4 px-6 text-right">
                                <div class="flex items-center justify-end gap-2">
                                     <button class="w-8 h-8 flex items-center justify-center bg-gray-50 dark:bg-slate-700/50 text-blue-500 rounded-lg hover:bg-blue-50 hover:text-blue-600 dark:hover:bg-blue-900/20 dark:hover:text-blue-400 transition-colors" title="Edit">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <button class="w-8 h-8 flex items-center justify-center bg-gray-50 dark:bg-slate-700/50 text-red-500 rounded-lg hover:bg-red-50 hover:text-red-600 dark:hover:bg-red-900/20 dark:hover:text-red-400 transition-colors" title="Delete">
                                        <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>

    <script>
    // --- Store Dropdown Logic ---
    function toggleInvStoreDropdown() {
        const dropdown = document.getElementById('invStoreFilterDropdown');
        const btn = document.getElementById('invStoreFilterBtn');
        const icon = btn.querySelector('ion-icon[name="chevron-down-outline"]');
        if (dropdown && dropdown.classList.contains('invisible')) {
            dropdown.classList.remove('invisible', 'opacity-0', '-translate-y-2');
            if(icon) icon.classList.add('rotate-180');
        } else if (dropdown) {
            dropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
            if(icon) icon.classList.remove('rotate-180');
        }
    }

    function selectInvStore(value, label, optionBtn) {
        document.getElementById('invStoreFilterText').textContent = label;
        // Reset active state
        document.querySelectorAll('.inv-store-option').forEach(btn => {
            const check = btn.querySelector('.check-icon');
            btn.classList.remove('bg-gray-50', 'dark:bg-slate-700/50', 'active');
            if(check) check.classList.add('opacity-0');
        });
        // Set new active state
        optionBtn.classList.add('bg-gray-50', 'dark:bg-slate-700/50', 'active');
        const check = optionBtn.querySelector('.check-icon');
        if(check) check.classList.remove('opacity-0');
        // Close dropdown
        toggleInvStoreDropdown();
    }
    
    // Close dropdown on click outside
    document.addEventListener('click', (e) => {
        const storeBtn = document.getElementById('invStoreFilterBtn');
        const storeDropdown = document.getElementById('invStoreFilterDropdown');
        if (storeBtn && storeDropdown && !storeBtn.contains(e.target) && !storeDropdown.contains(e.target)) {
            storeDropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
            const icon = storeBtn.querySelector('ion-icon[name="chevron-down-outline"]');
            if(icon) icon.classList.remove('rotate-180');
        }
    });

    // --- Apply Function (Simulated) ---
    function applyFilters() {
        const store = document.getElementById('invStoreFilterText').textContent;
        // Removed alert as per user request
        console.log(`Applying filters: Store = ${store}`);

         // Visual feedback
        const btn = document.querySelector('button[onclick="applyFilters()"]');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<ion-icon name="checkmark-outline" class="text-lg"></ion-icon> Applied';
        btn.classList.add('bg-green-600', 'hover:bg-green-700');
        btn.classList.remove('bg-primary', 'hover:bg-orange-600');
        
        setTimeout(() => {
            btn.innerHTML = originalText;
            btn.classList.remove('bg-green-600', 'hover:bg-green-700');
            btn.classList.add('bg-primary', 'hover:bg-orange-600');
        }, 1500);
    }

    // --- Table Search Logic ---
    function toggleSearchPopup(popupId) {
        // Close all others first
        document.querySelectorAll('[id^="searchPopup-"]').forEach(el => {
            if(el.id !== popupId) {
                el.classList.add('invisible', 'opacity-0', 'translate-y-4');
            }
        });

        const popup = document.getElementById(popupId);
        if(popup) {
            if(popup.classList.contains('invisible')) {
                popup.classList.remove('invisible', 'opacity-0', 'translate-y-4');
            } else {
                popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
            }
        }
    }

    // Close on click outside (Table Popups)
    document.addEventListener('click', (e) => {
        if (!e.target.closest('th')) {
            document.querySelectorAll('[id^="searchPopup-"]').forEach(el => {
                 el.classList.add('invisible', 'opacity-0', 'translate-y-4');
            });
        }
    });

    // Prevent closing when clicking inside the popup
    document.querySelectorAll('[id^="searchPopup-"]').forEach(popup => {
        popup.addEventListener('click', (e) => {
            e.stopPropagation();
        });
    });

    function applyTextFilter(type) {
        // Just mock visual update
        const header = document.getElementById('header-' + type);
        const popupId = 'searchPopup-' + type;
        const input = document.getElementById('input-' + type);
        
        if (input && input.value.trim() !== "") {
            header.classList.add('text-primary');
        } else {
            header.classList.remove('text-primary');
        }
        
        const popup = document.getElementById(popupId);
        popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
    }

    function clearTextFilter(type) {
        const header = document.getElementById('header-' + type);
        const input = document.getElementById('input-' + type);
        if(input) input.value = "";
        header.classList.remove('text-primary');
    }
    </script>
</main>
