<?php
include 'includes/session.php';
$pageTitle = "New Adjustment";
$currentPage = "inventory_adjustments";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

// Custom Select Helper (Reused)
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    // Identify selected label
    $selectedLabel = $label; // Default fallback
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    if ($selectedVal === '' && !empty($options)) {
        $selectedVal = array_key_first($options);
        $selectedLabel = $options[$selectedVal];
    }

    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            <div class="p-1 space-y-0.5">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}

require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col sm:flex-row sm:items-center justify-between gap-6 relative z-20">
                <div class="flex items-center gap-4">
                     <!-- Back Button Removed -->
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">New Adjustment</h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm font-medium">Record stock wastage or count corrections.</p>
                    </div>
                </div>
                
                <div class="flex gap-3">
                    <button type="submit" form="adjForm" class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-xl"></ion-icon> 
                        <span>Save Adjustment</span>
                    </button>
                </div>
            </div>

            <form id="adjForm" method="POST" class="space-y-6">
                <!-- General Info Card -> Z-Index 30 for DatePicker -->
                <div class="glass-panel rounded-2xl p-6 relative z-30">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white mb-6 flex items-center gap-2">
                        <ion-icon name="settings-outline" class="text-primary text-xl"></ion-icon>
                        Details
                    </h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                        <div class="space-y-2">
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider px-1">Structure / Store <span class="text-red-500">*</span></label>
                            <?php 
                                echo renderCustomSelect('Select Store', 'store_id', [
                                    'cdf' => 'FNF Cardiff',
                                    'swa' => 'FNF Swansea',
                                    'npt' => 'FNF Newport'
                                ]); 
                            ?>
                        </div>
                        <div class="space-y-2">
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider px-1">Adjustment Date</label>
                            <?php 
                                $pickerId = 'adj_date'; 
                                $urlParam = 'date';
                                $btnClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between cursor-pointer";
                                include 'includes/components/date_picker.php'; 
                            ?>
                            <input type="hidden" name="date" id="hidden_adj_date" value="<?php echo date('Y-m-d'); ?>">
                        </div>
                        <div class="space-y-2 md:col-span-2">
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider px-1">Notes / Reason</label>
                            <input type="text" name="notes" class="<?php echo $inputClass; ?>" placeholder="e.g. Weekly wastage log...">
                        </div>
                    </div>
                </div>

                <!-- Items Section -> Z-Index 20 -->
                <div class="glass-panel rounded-2xl relative z-20">
                    <div class="p-4 border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 flex flex-col sm:flex-row sm:items-center justify-between gap-4">
                        <h3 class="text-lg font-bold text-gray-800 dark:text-white flex items-center gap-2">
                            <ion-icon name="list-outline" class="text-primary text-xl"></ion-icon>
                            Stock Items
                        </h3>
                         <div class="relative group w-full sm:w-96">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <ion-icon name="search-outline" class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                            </div>
                            <input type="text" id="productSearch" class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 pl-10 py-2 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400" placeholder="Search product to adjust...">
                            
                            <!-- Search Results Dropdown -->
                            <div id="searchResults" class="absolute top-full left-0 mt-2 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl z-50 hidden max-h-60 overflow-y-auto custom-scrollbar">
                                <div class="p-2 space-y-1">
                                    <div class="p-2 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer flex justify-between items-center group" onclick="addItem('Coca Cola 330ml', '54', 'COKE330', 'assets/images/products/coke.png')">
                                        <div>
                                            <div class="font-bold text-gray-700 dark:text-gray-200">Coca Cola 330ml</div>
                                            <div class="text-xs text-gray-500">Current Stock: 54</div>
                                        </div>
                                        <ion-icon name="add-circle" class="text-primary text-xl opacity-0 group-hover:opacity-100 transition-opacity"></ion-icon>
                                    </div>
                                    <div class="p-2 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer flex justify-between items-center group" onclick="addItem('Fries Large', '120', 'FRIESL', 'assets/images/products/fries.png')">
                                        <div>
                                            <div class="font-bold text-gray-700 dark:text-gray-200">Fries Large</div>
                                            <div class="text-xs text-gray-500">Current Stock: 120</div>
                                        </div>
                                        <ion-icon name="add-circle" class="text-primary text-xl opacity-0 group-hover:opacity-100 transition-opacity"></ion-icon>
                                    </div>
                                    <div class="p-2 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer flex justify-between items-center group" onclick="addItem('Heinz Beans', '22', 'BEANS1', 'assets/images/products/beans.png')">
                                        <div>
                                            <div class="font-bold text-gray-700 dark:text-gray-200">Heinz Beans</div>
                                            <div class="text-xs text-gray-500">Current Stock: 22</div>
                                        </div>
                                        <ion-icon name="add-circle" class="text-primary text-xl opacity-0 group-hover:opacity-100 transition-opacity"></ion-icon>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="overflow-visible">
                        <table class="w-full text-left" id="adjTable">
                            <thead>
                                <tr class="bg-gray-50 dark:bg-slate-800/80 text-gray-500 dark:text-gray-400 text-xs uppercase tracking-wider font-bold">
                                    <th class="py-4 px-6 w-16">Image</th>
                                    <th class="py-4 px-6 min-w-[200px]">Product / Barcode</th>
                                    <th class="py-4 px-6 w-32 text-center">Current Stock</th>
                                    <th class="py-4 px-6 w-40 text-center">Adjustment Qty</th>
                                    <th class="py-4 px-6 w-[200px]">Reason Code</th>
                                    <th class="py-4 px-6 w-16"></th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100 dark:divide-gray-700" id="adjTableBody">
                                <!-- Empty State -->
                                <tr id="emptyRow">
                                    <td colspan="6" class="py-12 text-center text-gray-400 italic">
                                        Search and select products to adjust.
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    // --- Date Picker Handler ---
    window.handleDateChange = async function(url, pickerId, formattedDate) {
        if(pickerId === 'adj_date') {
            const hiddenInput = document.getElementById('hidden_adj_date');
            if(hiddenInput) hiddenInput.value = formattedDate;
        }
    };

    // --- Consolidated Custom Select Logic (Delegated) ---
    function closeAllSelects() {
        document.querySelectorAll('.custom-select-container').forEach(container => {
            const dropdown = container.querySelector('.custom-select-dropdown');
            const trigger = container.querySelector('.custom-select-trigger');
            if (dropdown && !dropdown.classList.contains('invisible')) {
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                if (chevron) chevron.classList.remove('rotate-180', 'text-primary');
            }
        });
    }

    document.addEventListener('click', (e) => {
        // Toggle Trigger
        const trigger = e.target.closest('.custom-select-trigger');
        if (trigger) {
            e.stopPropagation();
            const container = trigger.closest('.custom-select-container');
            const dropdown = container.querySelector('.custom-select-dropdown');
            
            if (dropdown) {
                const wasOpen = !dropdown.classList.contains('invisible');
                closeAllSelects(); // Close everything first
                
                if (!wasOpen) {
                    // It was closed, so open it
                    dropdown.classList.remove('opacity-0', 'invisible', '-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron) chevron.classList.add('rotate-180', 'text-primary');
                }
            }
            return;
        }

        // Option Click
        const option = e.target.closest('.custom-select-option');
        if (option) {
            e.stopPropagation();
            const container = option.closest('.custom-select-container');
            const hiddenInput = container.querySelector('input[type="hidden"]');
            const triggerLabel = container.querySelector('.select-label');
            const dropdown = container.querySelector('.custom-select-dropdown');
            const trigger = container.querySelector('.custom-select-trigger');

            hiddenInput.value = option.dataset.value;
            triggerLabel.textContent = option.dataset.label;

            container.querySelectorAll('.custom-select-option').forEach(opt => {
                opt.classList.remove('active');
                const check = opt.querySelector('.check-icon');
                if (check) check.classList.replace('opacity-100', 'opacity-0');
            });
            option.classList.add('active');
            const check = option.querySelector('.check-icon');
            if (check) check.classList.replace('opacity-0', 'opacity-100');

            closeAllSelects();
            return;
        }
        
        // Close if click outside
        closeAllSelects();
    });

    // --- Search & Barcode Logic ---
    const searchInput = document.getElementById('productSearch');
    const searchResults = document.getElementById('searchResults');
    
    const productDatabase = [
        { name: 'Coca Cola 330ml', stock: '54', sku: 'COKE330', image: 'assets/images/products/coke.png' },
        { name: 'Fries Large', stock: '120', sku: 'FRIESL', image: 'assets/images/products/fries.png' },
        { name: 'Heinz Beans', stock: '22', sku: 'BEANS1', image: 'assets/images/products/beans.png' }
    ];

    if (searchInput) {
        searchInput.addEventListener('focus', () => searchResults.classList.remove('hidden'));
        
        searchInput.addEventListener('keydown', (e) => {
            if (e.key === 'Enter') {
                e.preventDefault();
                const query = searchInput.value.trim().toUpperCase();
                if (!query) return;

                const product = productDatabase.find(p => 
                    p.sku.toUpperCase() === query || 
                    p.name.toUpperCase() === query
                );

                if (product) {
                    addItem(product.name, product.stock, product.sku, product.image);
                    searchInput.value = '';
                    searchResults.classList.add('hidden');
                }
            }
        });

        document.addEventListener('click', (e) => {
            if (!searchInput.contains(e.target) && !searchResults.contains(e.target)) {
                searchResults.classList.add('hidden');
            }
        });
    }

    function addItem(name, stock, sku, image) {
        const tbody = document.getElementById('adjTableBody');
        const emptyRow = document.getElementById('emptyRow');
        if (emptyRow) emptyRow.remove();

        const imgPath = image || 'assets/images/products/placeholder.png';
        const row = document.createElement('tr');
        row.className = "group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors border-b border-gray-50 dark:border-gray-700/50";
        
        const reasonOptions = [
            {val: 'waste', label: 'Waste / Damaged'},
            {val: 'count', label: 'Count Correction'},
            {val: 'theft', label: 'Theft'},
            {val: 'expiry', label: 'Expired'},
            {val: 'transfer', label: 'Store Transfer'}
        ];

        let optionsHtml = '';
        reasonOptions.forEach(opt => {
            const activeClass = opt.val === 'waste' ? 'active' : '';
            const checkOpacity = opt.val === 'waste' ? 'opacity-100' : 'opacity-0';
            optionsHtml += `
            <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors ${activeClass}" data-value="${opt.val}" data-label="${opt.label}">
                <span class="truncate">${opt.label}</span>
                <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 ${checkOpacity} check-icon"></ion-icon>
            </div>`;
        });

        const customSelectHtml = `
        <div class="relative custom-select-container">
            <input type="hidden" name="items[reason][]" value="waste">
            <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group">
                <span class="truncate select-label">Waste / Damaged</span>
                <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
            </button>
            <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
                <div class="p-1 space-y-0.5">${optionsHtml}</div>
            </div>
        </div>`;

        row.innerHTML = `
            <td class="py-3 px-6">
                <div class="w-10 h-10 rounded-lg bg-gray-100 dark:bg-slate-700 flex items-center justify-center overflow-hidden border border-gray-200 dark:border-gray-600">
                    <img src="${imgPath}" alt="" class="w-full h-full object-cover">
                </div>
            </td>
            <td class="py-3 px-6">
                <div class="font-bold text-gray-700 dark:text-gray-200 text-sm">${name}</div>
                <div class="flex items-center gap-1 text-xs text-gray-500 mt-0.5">
                    <ion-icon name="barcode-outline"></ion-icon>
                    <span>${sku}</span>
                </div>
                <input type="hidden" name="items[sku][]" value="${sku}">
            </td>
            <td class="py-3 px-6 text-center">
                 <span class="inline-flex items-center px-2 py-1 rounded bg-gray-100 dark:bg-slate-700 font-mono text-xs font-bold text-gray-600 dark:text-gray-300">${stock}</span>
            </td>
            <td class="py-3 px-6 text-center">
                <div class="flex justify-center">
                    <input type="number" name="items[qty][]" class="w-24 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-600 rounded-lg px-2 py-1.5 text-center text-sm font-bold focus:border-primary focus:ring-0 outline-none" value="-1" placeholder="+ / -">
                </div>
            </td>
            <td class="py-3 px-6">
                ${customSelectHtml}
            </td>
            <td class="py-3 px-6 text-center">
                <button type="button" class="text-gray-400 hover:text-red-500 transition-colors p-1" onclick="this.closest('tr').remove();">
                    <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                </button>
            </td>
        `;
        tbody.appendChild(row);
        if (searchResults) searchResults.classList.add('hidden');
        if (searchInput) searchInput.value = '';
    }
</script>
