<?php
include 'includes/session.php';

$pageTitle = "Dashboard";
$currentPage = "dashboard";

// Scope Logic
$scope = $_GET['scope'] ?? 'all'; 

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <div class="flex-1 p-6 md:p-8 pb-20">
        <!-- Glass Header -->
        <div class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 animate-fade-in-down relative z-50 overflow-visible">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Dashboard Overview</h1>
                <p class="text-gray-500 dark:text-gray-400 mt-1">Welcome back, here's what's happening in your stores today.</p>
            </div>
            
            <div class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                
                <!-- Scope/Type Selector -->
                <div class="relative z-30" id="typeSelector">
                    <button id="typeSelectBtn" class="flex items-center gap-2 px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 rounded-lg text-sm text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white transition-all border border-transparent hover:border-gray-200 dark:hover:border-gray-600 min-w-[140px] justify-between">
                         <div class="flex items-center gap-2">
                            <ion-icon name="filter-outline" class="text-lg text-gray-400"></ion-icon>
                            <span id="currentType" class="font-medium">Grocery</span>
                        </div>
                        <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 transition-transform duration-300"></ion-icon>
                    </button>
                    <!-- Dropdown -->
                    <div id="typeDropdown" class="absolute top-full left-0 mt-2 w-48 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden">
                        <div class="p-2 space-y-1">
                            <button class="type-option w-full flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors text-left" data-value="restaurant" data-label="Restaurant">
                                <span class="text-sm font-medium text-gray-700 dark:text-gray-200">Restaurant</span>
                                <ion-icon name="checkmark-circle" class="ml-auto text-primary text-lg opacity-0 check-icon"></ion-icon>
                            </button>
                            <button class="type-option w-full flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors text-left active" data-value="grocery" data-label="Grocery">
                                <span class="text-sm font-medium text-gray-700 dark:text-gray-200">Grocery</span>
                                <ion-icon name="checkmark-circle" class="ml-auto text-primary text-lg opacity-100 check-icon"></ion-icon>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600"></div>

                <!-- Store Selector (Custom) -->
                <div class="relative z-20" id="storeSelector">
                    <button id="storeSelectBtn" class="flex items-center gap-2 px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 rounded-lg text-sm text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white transition-all border border-transparent hover:border-gray-200 dark:hover:border-gray-600 w-48 justify-between">
                        <div class="flex items-center gap-2">
                             <ion-icon name="storefront-outline" class="text-lg text-gray-400"></ion-icon>
                            <span id="currentStore" class="font-medium">All Stores</span>
                        </div>
                        <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 transition-transform duration-300"></ion-icon>
                    </button>

                     <!-- Dropdown Menu -->
                    <div id="storeDropdown" class="absolute top-full right-0 mt-2 w-56 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden">
                        <div class="p-2 space-y-1">
                            <!-- Option: All -->
                            <button class="store-option w-full flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors text-left active" data-value="all" data-label="All Stores">
                                <span class="w-8 h-8 rounded-lg bg-primary/10 flex items-center justify-center text-primary"><ion-icon name="storefront"></ion-icon></span>
                                <span class="text-sm font-medium text-gray-700 dark:text-gray-200">All Stores</span>
                                <ion-icon name="checkmark-circle" class="ml-auto text-primary text-lg opacity-100 check-icon"></ion-icon>
                            </button>
                            
                            <!-- Option: FNF Cardiff -->
                            <button class="store-option w-full flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors text-left" data-value="cardiff" data-label="FNF Cardiff">
                                <span class="w-8 h-8 rounded-lg bg-blue-50 dark:bg-blue-900/20 flex items-center justify-center text-blue-500 font-bold text-[10px]">CDF</span>
                                <span class="text-sm font-medium text-gray-700 dark:text-gray-200">FNF Cardiff</span>
                                <ion-icon name="checkmark-circle" class="ml-auto text-primary text-lg opacity-0 check-icon"></ion-icon>
                            </button>

                            <!-- Option: FNF Swansea -->
                            <button class="store-option w-full flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors text-left" data-value="swansea" data-label="FNF Swansea">
                                <span class="w-8 h-8 rounded-lg bg-green-50 dark:bg-green-900/20 flex items-center justify-center text-green-500 font-bold text-[10px]">SWA</span>
                                <span class="text-sm font-medium text-gray-700 dark:text-gray-200">FNF Swansea</span>
                                <ion-icon name="checkmark-circle" class="ml-auto text-primary text-lg opacity-0 check-icon"></ion-icon>
                            </button>

                            <!-- Option: 3S Penarth -->
                            <button class="store-option w-full flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors text-left" data-value="penarth" data-label="3S Penarth">
                                <span class="w-8 h-8 rounded-lg bg-orange-50 dark:bg-orange-900/20 flex items-center justify-center text-orange-500 font-bold text-[10px]">PEN</span>
                                <span class="text-sm font-medium text-gray-700 dark:text-gray-200">3S Penarth</span>
                                <ion-icon name="checkmark-circle" class="ml-auto text-primary text-lg opacity-0 check-icon"></ion-icon>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600"></div>

                <button class="flex items-center gap-2 px-4 py-2 bg-primary hover:bg-orange-600 text-white text-sm font-bold rounded-lg shadow-lg shadow-orange-500/30 transition-all transform hover:-translate-y-0.5">
                    <ion-icon name="download-outline"></ion-icon> Export
                </button>
            </div>
        </div>

        <!-- Breakdown Section -->
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold text-gray-700 dark:text-gray-200 flex items-center gap-2">
                <span class="w-1.5 h-6 bg-primary rounded-full"></span> Breakdown
            </h3>
            <button onclick="toggleBreakdown()" id="seeAllBtn" class="text-sm font-semibold text-primary hover:text-orange-600 transition-colors">See All</button>
        </div>

        <!-- Metric Grid -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Cards (Static Top 4) -->
            <?php 
            $cards = [
                ['Walkins', '250', '£5000.02', 'indigo'],
                ['Payouts', '21', '£3500.54', 'orange'],
                ['Penny Sale', '5', '£9.10', 'green'],
                ['TXN Voids', '8', '£250.78', 'red'],
            ];
            foreach($cards as $card): 
                $iconColor = $card[3];
                // Map indigo to orange for consistency if needed, but keeping variety for now
                if($card[3] == 'indigo') $iconColor = 'orange'; 
            ?>
            <div class="glass-panel rounded-2xl p-6 relative group hover:scale-[1.02] transition-transform duration-300">
                <div class="flex justify-between items-start mb-4">
                    <span class="text-sm font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider"><?php echo $card[0]; ?></span>
                    <div class="w-8 h-8 rounded-full bg-<?php echo $iconColor; ?>-50 dark:bg-<?php echo $iconColor; ?>-900/20 flex items-center justify-center text-<?php echo $iconColor; ?>-500 group-hover:bg-<?php echo $iconColor; ?>-500 group-hover:text-white transition-colors duration-300 shadow-sm">
                        <ion-icon name="stats-chart"></ion-icon>
                    </div>
                </div>
                <div class="flex items-baseline gap-2">
                    <span class="text-2xl font-bold text-gray-800 dark:text-white"><?php echo $card[1]; ?></span>
                    <?php if($card[2]): ?>
                        <span class="text-gray-400">-</span>
                        <span class="text-lg font-semibold text-gray-600 dark:text-gray-300"><?php echo $card[2]; ?></span>
                    <?php endif; ?>
                </div>
                <div class="absolute bottom-0 left-0 w-full h-1 bg-gradient-to-r from-<?php echo $iconColor; ?>-400 to-<?php echo $iconColor; ?>-600 opacity-0 group-hover:opacity-100 transition-opacity rounded-b-2xl"></div>
            </div>
            <?php endforeach; ?>
            
            <!-- Hidden Cards (Dynamic) -->
            <div id="hiddenCards" class="hidden contents">
                <?php 
                $extraCards = [
                    ['No Sale', '5', '', 'gray'],
                    ['Refunds', '12', '£87.54', 'blue'],
                    ['Discount', '8', '£115.14', 'purple'],
                    ['Manual Entries', '18', '£480.78', 'pink'],
                    ['CASH', '£25000.78', '', 'green'],
                    ['CARD', '£85050.78', '', 'yellow'],
                    ['Managers', '3', '', 'teal'],
                    ['Admin Users', '8', '', 'indigo'],
                ];
                foreach($extraCards as $card): 
                    $color = $card[3] ?? 'gray';
                ?>
                <div class="glass-panel rounded-2xl p-6 relative group hover:scale-[1.02] transition-transform duration-300 animate-fade-in-up">
                    <div class="flex justify-between items-start mb-4">
                        <span class="text-sm font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider"><?php echo $card[0]; ?></span>
                        <div class="w-8 h-8 rounded-full bg-<?php echo $color; ?>-50 dark:bg-<?php echo $color; ?>-900/20 flex items-center justify-center text-<?php echo $color; ?>-500 group-hover:bg-<?php echo $color; ?>-500 group-hover:text-white transition-colors duration-300 shadow-sm">
                            <ion-icon name="stats-chart"></ion-icon>
                        </div>
                    </div>
                    <div class="flex items-baseline gap-2">
                        <span class="text-2xl font-bold text-gray-800 dark:text-white"><?php echo $card[1]; ?></span>
                        <?php if(!empty($card[2])): ?>
                            <span class="text-gray-400">-</span>
                            <span class="text-lg font-semibold text-gray-600 dark:text-gray-300"><?php echo $card[2]; ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Analytics Row 1 -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
            
            <!-- Weekly Activity (Carousel) -->
            <div class="lg:col-span-2 glass-panel rounded-2xl p-6">
                <div class="flex justify-between items-center mb-6">
                    <h3 id="weeklyChartTitle" class="text-lg font-bold text-gray-800 dark:text-gray-200">Weekly Activity</h3>
                    <div class="flex gap-2">
                        <button onclick="prevWeeklyChart()" class="w-8 h-8 rounded-full bg-gray-100 dark:bg-slate-700 dark:text-gray-300 hover:bg-primary hover:text-white dark:hover:bg-primary flex items-center justify-center transition-all shadow-sm">
                            <ion-icon name="chevron-back"></ion-icon>
                        </button>
                        <button onclick="nextWeeklyChart()" class="w-8 h-8 rounded-full bg-gray-100 dark:bg-slate-700 dark:text-gray-300 hover:bg-primary hover:text-white dark:hover:bg-primary flex items-center justify-center transition-all shadow-sm">
                            <ion-icon name="chevron-forward"></ion-icon>
                        </button>
                    </div>
                </div>
                <div id="weeklyActivityChart" style="min-height: 350px;"></div>
            </div>

            <!-- Recent Sales -->
            <div class="glass-panel rounded-2xl p-6">
                <div class="flex justify-between items-center mb-6">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-gray-200">Recent Sales</h3>
                    <button class="text-primary text-sm font-semibold hover:underline">View All</button>
                </div>
                <div class="space-y-4 max-h-[350px] overflow-y-auto pr-2 custom-scrollbar">
                    <!-- Items -->
                    <div class="flex items-center justify-between p-3 bg-white/50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700 hover:shadow-md transition-shadow">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-lg bg-yellow-100 dark:bg-yellow-900/30 text-yellow-600 dark:text-yellow-400 flex items-center justify-center text-xl">
                                <ion-icon name="card"></ion-icon>
                            </div>
                            <div>
                                <div class="text-sm font-bold text-gray-800 dark:text-gray-200">492054-TP-12</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">11:25 AM</div>
                            </div>
                        </div>
                        <span class="text-sm font-bold text-green-600 dark:text-green-400">+£2,500</span>
                    </div>

                    <div class="flex items-center justify-between p-3 bg-white/50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700 hover:shadow-md transition-shadow">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-lg bg-blue-100 dark:bg-blue-900/30 text-blue-600 dark:text-blue-400 flex items-center justify-center text-xl">
                                <ion-icon name="cash"></ion-icon>
                            </div>
                            <div>
                                <div class="text-sm font-bold text-gray-800 dark:text-gray-200">231144-TP-P-14</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">10:57 AM</div>
                            </div>
                        </div>
                        <span class="text-sm font-bold text-red-500 dark:text-red-400">-£850</span>
                    </div>

                            <div class="flex items-center justify-between p-3 bg-white/50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700 hover:shadow-md transition-shadow">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-red-100 dark:bg-red-900/30 text-red-600 dark:text-red-400 flex items-center justify-center text-xl">
                                        <ion-icon name="alert-circle"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="text-sm font-bold text-gray-800 dark:text-gray-200">492054-TP-Void</div>
                                        <div class="text-xs text-gray-500 dark:text-gray-400">09:15 AM</div>
                                    </div>
                                </div>
                                <span class="text-sm font-bold text-gray-400 dark:text-gray-500 opacity-60">-£120</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- RESTAURANT SPECIFIC WIDGETS -->
                <div id="restaurant-dashboard" class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6 hidden">
                    <!-- Top Dishes Sold -->
                        <div class="lg:col-span-2 glass-panel rounded-2xl p-6 relative"> <!-- relative for chart tooltip -->
                            <div class="flex items-center justify-between mb-6">
                            <div>
                                <h3 class="text-lg font-bold text-gray-800 dark:text-white">Top Dishes Sold</h3>
                                <p class="text-sm text-gray-500 dark:text-gray-400">Best performing items</p>
                            </div>
                            <div class="flex gap-2">
                                    <button class="text-xs px-2 py-1 rounded bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300">Day</button>
                                    <button class="text-xs px-2 py-1 rounded bg-primary text-white">Week</button>
                            </div>
                        </div>
                        <div id="topDishesChart" class="w-full h-[320px]"></div>
                    </div>

                    <!-- Peak Hours / Table Turnover -->
                    <div class="glass-panel rounded-2xl p-6 relative">
                        <div class="flex items-center justify-between mb-6">
                            <div>
                                <h3 class="text-lg font-bold text-gray-800 dark:text-white">Peak Hours</h3>
                                <p class="text-sm text-gray-500 dark:text-gray-400">Traffic analysis</p>
                            </div>
                        </div>
                        <div id="peakHoursChart" class="w-full h-[220px]"></div>
                        
                        <!-- Mini Stat: Avg Table Time -->
                        <div class="mt-6 pt-6 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between">
                                <div>
                                <div class="text-sm text-gray-500 dark:text-gray-400">Avg Table Time</div>
                                <div class="text-2xl font-bold text-gray-800 dark:text-white">45m <span class="text-sm text-green-500 font-medium">-2m</span></div>
                            </div>
                            <div class="w-10 h-10 rounded-full bg-orange-50 dark:bg-orange-900/20 text-orange-500 flex items-center justify-center text-xl">
                                <ion-icon name="time-outline"></ion-icon>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- SHARED INVENTORY WIDGETS (Grocery & Restaurant) -->
                <div id="inventory-dashboard" class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
                    <!-- Low Stock Alerts -->
                    <div class="lg:col-span-2 glass-panel rounded-2xl p-6 relative">
                        <div class="flex items-center justify-between mb-6">
                            <div>
                                <h3 class="text-lg font-bold text-gray-800 dark:text-white">Low Stock Alerts</h3>
                                <p class="text-sm text-gray-500 dark:text-gray-400">Items requiring immediate attention</p>
                            </div>
                            <button class="text-primary text-sm font-semibold hover:underline">View Inventory</button>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="w-full text-left border-collapse">
                                <thead>
                                    <tr class="border-b border-gray-100 dark:border-gray-700">
                                        <th class="p-3 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase">Product</th>
                                        <th class="p-3 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase text-center">Stock</th>
                                        <th class="p-3 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase text-center">Status</th>
                                    </tr>
                                </thead>
                                <tbody id="lowStockBody">
                                    <!-- Populated by JS -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Expiring Soon -->
                    <div class="glass-panel rounded-2xl p-6">
                            <div class="flex items-center justify-between mb-6">
                            <div>
                                <h3 class="text-lg font-bold text-gray-800 dark:text-white">Expiring Soon</h3>
                                <p class="text-sm text-gray-500 dark:text-gray-400">This week</p>
                            </div>
                        </div>
                        <div id="expiringList" class="space-y-4">
                            <!-- Populated by JS -->
                    </div>
                </div>
            </div>

        <!-- Analytics Row 2 -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Comparison -->
            <div class="glass-panel rounded-2xl p-6 h-full flex flex-col">
                <h3 class="text-lg font-bold text-gray-800 dark:text-gray-200 mb-6 shrink-0">Comparison</h3>
                <div id="comparisonChart" class="flex-1 w-full min-h-[300px]"></div>
            </div>
            
            <!-- Monthly Sales -->
            <div class="glass-panel rounded-2xl p-6 h-full flex flex-col">
                <h3 class="text-lg font-bold text-gray-800 dark:text-gray-200 mb-6 shrink-0">Monthly Sales</h3>
                <div id="monthlySalesChart" class="flex-1 w-full min-h-[300px]"></div>
            </div>

            <!-- Breakdown -->
            <div class="glass-panel rounded-2xl p-6 h-full flex flex-col">
                <h3 class="text-lg font-bold text-gray-800 dark:text-gray-200 mb-6 shrink-0">Sales Breakdown</h3>
                <div id="salesBreakdownChart" class="flex-1 w-full flex items-center justify-center min-h-[300px]"></div>
            </div>
        </div>

    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<!-- Tailwind & Logic -->
<style>
    .animate-fade-in-down { animation: fadeInDown 0.5s ease-out; }
    .animate-fade-in-up { animation: fadeInUp 0.5s ease-out; }
    @keyframes fadeInDown { from { opacity: 0; transform: translateY(-10px); } to { opacity: 1; transform: translateY(0); } }
    @keyframes fadeInUp { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
</style>

<script>
    // Toggle Logic
    function toggleBreakdown() {
        const hiddenDiv = document.getElementById('hiddenCards');
        const btn = document.getElementById('seeAllBtn');
        if (hiddenDiv.classList.contains('hidden')) {
            hiddenDiv.classList.remove('hidden');
            hiddenDiv.classList.add('contents'); // Use grid layout
            btn.textContent = 'Show Less';
        } else {
            hiddenDiv.classList.add('hidden');
            hiddenDiv.classList.remove('contents');
            btn.textContent = 'See All';
        }
    }
</script>
<script src="assets/js/dashboard.js?v=<?php echo time(); ?>"></script>
<script>
    // Initialize Dashboard with 'Grocery' default
    window.addEventListener('load', () => {
        // Ensure charts are rendered first
        setTimeout(() => {
            if(window.updateDashboardData) {
                window.updateDashboardData('grocery');
            }
        }, 300);
    });
</script>
