<header id="topbar" class="h-16 bg-white/80 dark:bg-slate-900/80 backdrop-blur-md border-b border-gray-200 dark:border-gray-800 flex items-center justify-between px-4 md:px-8 z-40 transition-all duration-300">
    
    <!-- Left: Toggle & Breadcrumbs -->
    <div class="flex items-center gap-4 text-sm text-gray-500 dark:text-gray-400">
        <button id="sidebarToggle" class="p-2 -ml-2 rounded-lg text-gray-500 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-800 transition-colors">
            <ion-icon name="menu-outline" class="text-2xl"></ion-icon>
        </button>

        <div class="flex items-center">
            <span class="hover:text-primary cursor-pointer transition-colors">Admin</span>
            <ion-icon name="chevron-forward-outline" class="mx-2 text-xs text-gray-400"></ion-icon>
            <span class="font-semibold text-gray-800 dark:text-white tracking-wide"><?php echo isset($pageTitle) ? $pageTitle : 'Page'; ?></span>
        </div>
    </div>

    <!-- Right: Actions -->
    <div class="flex items-center gap-5">
        
        <!-- Search -->
        <div class="relative hidden md:block group">
            <ion-icon name="search-outline" class="absolute left-3 top-2.5 text-gray-400 group-hover:text-primary transition-colors"></ion-icon>
            <input type="text" placeholder="Search..." class="pl-10 pr-4 py-2 bg-gray-50/50 dark:bg-gray-800/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-gray-800 rounded-full text-sm focus:ring-4 focus:ring-primary/10 w-64 transition-all duration-300 outline-none placeholder-gray-400 text-gray-600 dark:text-gray-200">
        </div>

        <!-- Theme Toggle -->
        <button id="themeToggle" class="p-2 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-slate-800 rounded-lg transition-all" onclick="toggleTheme()">
            <ion-icon name="moon-outline" class="text-xl hidden dark:block"></ion-icon>
            <ion-icon name="sunny-outline" class="text-xl block dark:hidden"></ion-icon>
        </button>

        <!-- Fullscreen Toggle -->
        <button id="fullscreenToggle" class="p-2 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-slate-800 rounded-lg transition-all" title="Toggle Fullscreen">
            <ion-icon name="scan-outline" class="text-xl"></ion-icon>
        </button>

        <!-- Notifications -->
        <button class="relative p-2 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-slate-800 rounded-lg transition-all">
            <ion-icon name="notifications-outline" class="text-xl"></ion-icon>
            <span class="absolute top-1.5 right-1.5 w-2 h-2 bg-red-500 rounded-full border-2 border-white dark:border-slate-900 ring-1 ring-red-500/20"></span>
        </button>

        <div class="h-6 w-px bg-gray-200 dark:bg-gray-700 mx-1"></div>

        <!-- Profile (Dropdown) -->
        <div class="relative group" id="profileDropdownTrigger">
            <button class="flex items-center gap-3 cursor-pointer pl-2 hover:opacity-80 transition-opacity focus:outline-none">
                <div class="w-9 h-9 rounded-full bg-gradient-to-tr from-orange-400 to-amber-500 p-[2px] shadow-md shadow-orange-200 dark:shadow-none">
                    <div class="w-full h-full rounded-full bg-white dark:bg-slate-800 border-2 border-transparent flex items-center justify-center text-primary font-bold text-xs">
                        <?php echo htmlspecialchars(substr($_SESSION['username'] ?? 'AD', 0, 2)); ?>
                    </div>
                </div>
                <div class="hidden md:block text-sm leading-tight text-left">
                    <div class="font-bold text-gray-800 dark:text-gray-100"><?php echo htmlspecialchars($_SESSION['username'] ?? 'Admin User'); ?></div>
                    <div class="text-[10px] text-gray-400 font-medium uppercase tracking-wider">Super Admin</div>
                </div>
                <ion-icon name="chevron-down-outline" class="text-gray-400 text-xs ml-1"></ion-icon>
            </button>

            <!-- Dropdown Menu -->
            <div class="absolute right-0 top-full mt-2 w-48 bg-white dark:bg-slate-800 rounded-xl shadow-lg border border-gray-100 dark:border-gray-700 transform scale-95 opacity-0 invisible group-hover:scale-100 group-hover:opacity-100 group-hover:visible transition-all duration-200 origin-top-right z-50">
                <div class="p-2 space-y-1">
                    <a href="#" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors">
                        <ion-icon name="person-outline"></ion-icon>
                        My Profile
                    </a>
                    <a href="#" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors">
                        <ion-icon name="settings-outline"></ion-icon>
                        Settings
                    </a>
                    <div class="h-px bg-gray-100 dark:bg-gray-700 my-1"></div>
                    <a href="logout.php" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm text-red-600 dark:text-red-400 hover:bg-red-50 dark:hover:bg-red-900/20 transition-colors">
                        <ion-icon name="log-out-outline"></ion-icon>
                        Sign Out
                    </a>
                </div>
            </div>
        </div>

    </div>
</header>

<script>
    function toggleTheme() {
        if (document.documentElement.classList.contains('dark')) {
            document.documentElement.classList.remove('dark');
            localStorage.theme = 'light';
        } else {
            document.documentElement.classList.add('dark');
            localStorage.theme = 'dark';
        }
    }
</script>
