<aside id="sidebar"
    class="w-64 bg-white dark:bg-slate-900 border-r border-gray-200 dark:border-gray-800 flex flex-col flex-shrink-0 z-20 transition-all duration-300">
    <!-- Brand -->
    <div class="h-16 flex items-center px-6 border-b border-gray-200 dark:border-gray-800 overflow-hidden">
        <a href="index.php" class="flex items-center gap-2 text-primary font-bold text-xl tracking-tight group">
            <div
                class="p-1.5 rounded-lg bg-primary/10 text-primary group-hover:bg-primary group-hover:text-white transition-all duration-300">
                <ion-icon name="cube" class="text-xl"></ion-icon>
            </div>
            <span
                class="sidebar-text transition-opacity duration-300 whitespace-nowrap opacity-100 font-black">CashBox</span>
        </a>
    </div>

    <!-- Menu -->
    <div class="flex-1 overflow-y-auto py-6 px-4 space-y-8 custom-scrollbar overflow-x-hidden">

        <!-- Admin Main Menu -->
        <div>
            <div
                class="px-2 mb-3 text-[10px] font-black text-gray-400 dark:text-slate-500 uppercase tracking-widest sidebar-text">
                Admin Main Menu</div>
            <nav class="space-y-1">
                <a href="admin_dashboard.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'admin_dashboard') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Admin Dashboard">
                    <ion-icon name="speedometer-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Admin Dashboard</span>
                </a>
                <a href="service_providers.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'service_providers') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Service Providers">
                    <ion-icon name="construct-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Service Providers</span>
                </a>
                <a href="admin_payables.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'admin_payables') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="OpEx Payables">
                    <ion-icon name="receipt-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">OpEx Payables</span>
                </a>
                <a href="finance_receivables.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'finance_receivables') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Store Receivables">
                    <ion-icon name="trending-up-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Store Receivables</span>
                </a>
            </nav>
        </div>

        <!-- Finance Group (Store Level) -->
        <div>
            <div
                class="px-2 mb-3 text-[10px] font-black text-gray-400 dark:text-slate-500 uppercase tracking-widest sidebar-text">
                Store Finance</div>
            <nav class="space-y-1">
                <a href="finance_payables.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'finance_payables') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Store Payables">
                    <ion-icon name="card-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Store Payables</span>
                </a>
                <a href="finance_debtors.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'finance_debtors') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Customer Debtors">
                    <ion-icon name="people-circle-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Customer Debtors</span>
                </a>
            </nav>
        </div>

        <!-- Store Main Menu -->
        <div>
            <div
                class="px-2 mb-3 text-[10px] font-black text-gray-400 dark:text-slate-500 uppercase tracking-widest sidebar-text">
                Store Operations</div>
            <nav class="space-y-1">
                <a href="index.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'dashboard') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Store Overview">
                    <ion-icon name="storefront-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Store Overview</span>
                </a>

                <!-- Stores Submenu -->
                <?php
                $currentFile = basename($_SERVER['PHP_SELF']);
                $isStoresActive = ($currentPage == 'stores' || $currentFile == 'store_devices.php' || $currentFile == 'store_form.php' || $currentFile == 'store_health.php');
                ?>
                <div>
                    <button onclick="toggleSubmenu('stores-submenu')"
                        class="w-full group flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-xl cursor-pointer <?php echo $isStoresActive ? 'bg-orange-50 dark:bg-primary/10 text-primary' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200">
                        <div class="flex items-center gap-3">
                            <ion-icon name="business-outline" class="text-lg w-5 h-5"></ion-icon>
                            <span class="sidebar-text whitespace-nowrap">My Stores</span>
                        </div>
                        <ion-icon name="chevron-down-outline" id="stores-chevron"
                            class="text-sm transition-transform duration-300 <?php echo $isStoresActive ? 'rotate-180' : ''; ?>"></ion-icon>
                    </button>
                    <div id="stores-submenu"
                        class="mt-1 space-y-1 overflow-hidden transition-all duration-300 ease-in-out <?php echo $isStoresActive ? 'max-h-56 opacity-100' : 'max-h-0 opacity-50'; ?>">
                        <a href="stores.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentFile == 'stores.php') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Stores List
                        </a>
                        <a href="store_form.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentFile == 'store_form.php') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            <?php echo isset($_GET['id']) ? 'Edit Store' : 'Create Store'; ?>
                        </a>
                        <a href="store_devices.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentFile == 'store_devices.php') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Devices
                        </a>
                        <a href="store_health.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentFile == 'store_health.php') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Health Status
                        </a>
                    </div>
                </div>

                <a href="customers.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'customers') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Customers">
                    <ion-icon name="people-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Customers</span>
                </a>
            </nav>
        </div>

        <!-- Food & Beverage -->
        <div>
            <div
                class="px-2 mb-3 text-[10px] font-black text-gray-400 dark:text-slate-500 uppercase tracking-widest sidebar-text">
                Food & Beverage</div>
            <nav class="space-y-1">
                <!-- Menu / Categories -->
                <?php
                $currentFileMenu = basename($_SERVER['PHP_SELF']);
                $isMenuCatsActive = ($currentPage == 'menu_categories' || $currentFileMenu == 'menu_categories_form.php');
                ?>
                <div>
                    <button onclick="toggleSubmenu('menu-cats-submenu')"
                        class="w-full group flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-xl cursor-pointer <?php echo $isMenuCatsActive ? 'bg-orange-50 dark:bg-primary/10 text-primary' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200">
                        <div class="flex items-center gap-3">
                            <ion-icon name="library-outline" class="text-lg w-5 h-5"></ion-icon>
                            <span class="sidebar-text whitespace-nowrap">Menu Categories</span>
                        </div>
                        <ion-icon name="chevron-down-outline" id="menu-cats-chevron"
                            class="text-sm transition-transform duration-300 <?php echo $isMenuCatsActive ? 'rotate-180' : ''; ?>"></ion-icon>
                    </button>
                    <div id="menu-cats-submenu"
                        class="mt-1 space-y-1 overflow-hidden transition-all duration-300 ease-in-out <?php echo $isMenuCatsActive ? 'max-h-56 opacity-100' : 'max-h-0 opacity-50'; ?>">
                        <a href="menu_categories.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'menu_categories') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            View All
                        </a>
                        <a href="menu_categories_form.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentFileMenu == 'menu_categories_form.php') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Add Category
                        </a>
                    </div>
                </div>

                <!-- Menu Items -->
                <?php
                $currentFileItems = basename($_SERVER['PHP_SELF']);
                $isMenuItemsActive = ($currentPage == 'menu_items' || $currentFileItems == 'menu_items_form.php');
                ?>
                <div>
                    <button onclick="toggleSubmenu('menu-items-submenu')"
                        class="w-full group flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-xl cursor-pointer <?php echo $isMenuItemsActive ? 'bg-orange-50 dark:bg-primary/10 text-primary' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200">
                        <div class="flex items-center gap-3">
                            <ion-icon name="fast-food-outline" class="text-lg w-5 h-5"></ion-icon>
                            <span class="sidebar-text whitespace-nowrap">Menu Items</span>
                        </div>
                        <ion-icon name="chevron-down-outline" id="menu-items-chevron"
                            class="text-sm transition-transform duration-300 <?php echo $isMenuItemsActive ? 'rotate-180' : ''; ?>"></ion-icon>
                    </button>
                    <div id="menu-items-submenu"
                        class="mt-1 space-y-1 overflow-hidden transition-all duration-300 ease-in-out <?php echo $isMenuItemsActive ? 'max-h-56 opacity-100' : 'max-h-0 opacity-50'; ?>">
                        <a href="menu_items.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'menu_items') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            View All
                        </a>
                        <a href="menu_items_form.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentFileItems == 'menu_items_form.php') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Add Item
                        </a>
                    </div>
                </div>

                <!-- Modifiers -->
                <?php
                $currentFileMods = basename($_SERVER['PHP_SELF']);
                $isModifiersActive = ($currentPage == 'menu_modifiers' || $currentFileMods == 'menu_modifiers_form.php');
                ?>
                <div>
                    <button onclick="toggleSubmenu('modifiers-submenu')"
                        class="w-full group flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-xl cursor-pointer <?php echo $isModifiersActive ? 'bg-orange-50 dark:bg-primary/10 text-primary' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200">
                        <div class="flex items-center gap-3">
                            <ion-icon name="options-outline" class="text-lg w-5 h-5"></ion-icon>
                            <span class="sidebar-text whitespace-nowrap">Modifiers</span>
                        </div>
                        <ion-icon name="chevron-down-outline" id="modifiers-chevron"
                            class="text-sm transition-transform duration-300 <?php echo $isModifiersActive ? 'rotate-180' : ''; ?>"></ion-icon>
                    </button>
                    <div id="modifiers-submenu"
                        class="mt-1 space-y-1 overflow-hidden transition-all duration-300 ease-in-out <?php echo $isModifiersActive ? 'max-h-56 opacity-100' : 'max-h-0 opacity-50'; ?>">
                        <a href="menu_modifiers.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'menu_modifiers') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Modifier Groups
                        </a>
                        <a href="menu_modifiers_form.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentFileMods == 'menu_modifiers_form.php') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Create Group
                        </a>
                    </div>
                </div>

                <a href="table_layout.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'table_layout') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Table Layout">
                    <ion-icon name="grid-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Table Layout</span>
                </a>
                <a href="reservation_rules.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'reservation_rules') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Reservations">
                    <ion-icon name="calendar-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Reservations</span>
                </a>
            </nav>
        </div>

        <!-- Transactions -->
        <div>
            <div
                class="px-2 mb-3 text-[10px] font-black text-gray-400 dark:text-slate-500 uppercase tracking-widest sidebar-text">
                Transactions</div>
            <nav class="space-y-1">
                <a href="transactions_live.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'transactions_live') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Live">
                    <ion-icon name="pulse-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Live Feed</span>
                </a>
                <a href="transactions_search.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'transactions_search') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Search">
                    <ion-icon name="search-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Search & History</span>
                </a>

                <?php
                $isTransOpsActive = ($currentPage == 'transactions_penny' || $currentPage == 'transactions_void' || $currentPage == 'transactions_refund');
                ?>
                <div>
                    <button onclick="toggleSubmenu('trans-ops-submenu')"
                        class="w-full group flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-xl cursor-pointer <?php echo $isTransOpsActive ? 'bg-orange-50 dark:bg-primary/10 text-primary' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200">
                        <div class="flex items-center gap-3">
                            <ion-icon name="card-outline" class="text-lg w-5 h-5"></ion-icon>
                            <span class="sidebar-text whitespace-nowrap">Adjustments</span>
                        </div>
                        <ion-icon name="chevron-down-outline" id="trans-ops-chevron"
                            class="text-sm transition-transform duration-300 <?php echo $isTransOpsActive ? 'rotate-180' : ''; ?>"></ion-icon>
                    </button>
                    <div id="trans-ops-submenu"
                        class="mt-1 space-y-1 overflow-hidden transition-all duration-300 ease-in-out <?php echo $isTransOpsActive ? 'max-h-56 opacity-100' : 'max-h-0 opacity-50'; ?>">
                        <a href="transactions_penny.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'transactions_penny') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Penny Sale
                        </a>
                        <a href="transactions_void.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'transactions_void') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Void Transaction
                        </a>
                        <a href="transactions_refund.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'transactions_refund') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Process Refund
                        </a>
                    </div>
                </div>
            </nav>
        </div>

        <!-- Inventory / Products (Groceries) -->
        <div>
            <div
                class="px-2 mb-3 text-[10px] font-black text-gray-400 dark:text-slate-500 uppercase tracking-widest sidebar-text">
                Retail & Stock</div>
            <nav class="space-y-1">
                <a href="products.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'products') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Products">
                    <ion-icon name="cart-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Product Catalog</span>
                </a>

                <?php
                $currentFile = basename($_SERVER['PHP_SELF']);
                $isCategoriesActive = ($currentPage == 'product_categories' || $currentFile == 'product_category_form.php' || $currentPage == 'product_subcategories');
                ?>
                <div>
                    <button onclick="toggleSubmenu('retail-cats-submenu')"
                        class="w-full group flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-xl cursor-pointer <?php echo $isCategoriesActive ? 'bg-orange-50 dark:bg-primary/10 text-primary' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200">
                        <div class="flex items-center gap-3">
                            <ion-icon name="pricetags-outline" class="text-lg w-5 h-5"></ion-icon>
                            <span class="sidebar-text whitespace-nowrap">Categories</span>
                        </div>
                        <ion-icon name="chevron-down-outline" id="retail-cats-chevron"
                            class="text-sm transition-transform duration-300 <?php echo $isCategoriesActive ? 'rotate-180' : ''; ?>"></ion-icon>
                    </button>
                    <div id="retail-cats-submenu"
                        class="mt-1 space-y-1 overflow-hidden transition-all duration-300 ease-in-out <?php echo $isCategoriesActive ? 'max-h-56 opacity-100' : 'max-h-0 opacity-50'; ?>">
                        <a href="product_categories.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'product_categories') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Main Categories
                        </a>
                        <a href="product_subcategories.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'product_subcategories') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Sub Categories
                        </a>
                    </div>
                </div>

                <a href="grn.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'grn') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="GRN">
                    <ion-icon name="receipt-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Goods Received</span>
                </a>
                <a href="inventory_adjustments.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'inventory_adjustments') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Stock Adjustments">
                    <ion-icon name="create-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Manual Stock Entry</span>
                </a>
            </nav>
        </div>


        <!-- Workforce Group -->
        <div>
            <div
                class="px-2 mb-3 text-[10px] font-black text-gray-400 dark:text-slate-500 uppercase tracking-widest sidebar-text">
                Workforce</div>
            <nav class="space-y-1">
                <a href="rota.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'rota') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Rota">
                    <ion-icon name="calendar-number-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Rota Scheduler</span>
                </a>
                <a href="attendance.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'attendance') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Attendance">
                    <ion-icon name="time-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Attendance</span>
                </a>
                <a href="payroll.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'payroll') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Payroll">
                    <ion-icon name="wallet-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Payroll</span>
                </a>
            </nav>
        </div>

        <!-- Procurement Group -->
        <div>
            <div
                class="px-2 mb-3 text-[10px] font-black text-gray-400 dark:text-slate-500 uppercase tracking-widest sidebar-text">
                Procurement</div>
            <nav class="space-y-1">
                <a href="suppliers.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'suppliers') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Suppliers">
                    <ion-icon name="people-circle-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Suppliers</span>
                </a>
                <a href="purchase_orders.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'purchase_orders') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Purchase Orders">
                    <ion-icon name="bag-handle-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Purchase Orders</span>
                </a>
            </nav>
        </div>

        <!-- Reports & Audit -->
        <div>
            <div
                class="px-2 mb-3 text-[10px] font-black text-gray-400 dark:text-slate-500 uppercase tracking-widest sidebar-text">
                Analytics & Audit</div>
            <nav class="space-y-1">
                <?php
                $isReportsActive = ($currentPage == 'reports' || strpos($currentPage, 'report_') === 0);
                ?>
                <div>
                    <button onclick="toggleSubmenu('reports-submenu')"
                        class="w-full group flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-xl cursor-pointer <?php echo $isReportsActive ? 'bg-orange-50 dark:bg-primary/10 text-primary' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200">
                        <div class="flex items-center gap-3">
                            <ion-icon name="analytics-outline" class="text-lg w-5 h-5"></ion-icon>
                            <span class="sidebar-text whitespace-nowrap">Reports</span>
                        </div>
                        <ion-icon name="chevron-down-outline" id="reports-chevron"
                            class="text-sm transition-transform duration-300 <?php echo $isReportsActive ? 'rotate-180' : ''; ?>"></ion-icon>
                    </button>
                    <div id="reports-submenu"
                        class="mt-1 space-y-1 overflow-hidden transition-all duration-300 ease-in-out <?php echo $isReportsActive ? 'max-h-96 opacity-100' : 'max-h-0 opacity-50'; ?>">
                        <a href="reports.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'reports') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">Overview</a>
                        <a href="report_sales_summary.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'report_sales_summary') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">Sales
                            Summary</a>
                        <a href="report_monthly_sales.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'report_monthly_sales') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">Monthly
                            Sales</a>
                        <a href="report_z_read.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'report_z_read') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">Z-Reports</a>
                        <a href="report_vat.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'report_vat') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">VAT
                            Reports</a>
                        <!-- New Reports -->
                        <a href="report_orders.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'report_orders') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">Orders</a>
                        <a href="report_payments.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'report_payments') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">Payments</a>
                        <a href="report_payouts.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'report_payouts') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">Payouts</a>
                        <a href="report_refunds.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'report_refunds') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">Refunds</a>
                        <a href="report_product_status.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'report_product_status') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">Product
                            Status</a>
                    </div>
                </div>

                <a href="audit_logs.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'audit_logs') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Audit Logs">
                    <ion-icon name="shield-checkmark-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Audit Logs</span>
                </a>
                <a href="approvals_log.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'approvals_log') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Approvals">
                    <ion-icon name="thumbs-up-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Approvals</span>
                </a>
                <a href="audit_tracker.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'audit_tracker') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Audit Tracker">
                    <ion-icon name="git-compare-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Audit Tracker</span>
                </a>
                <a href="analytics_buttons.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl <?php echo ($currentPage == 'analytics_buttons') ? 'bg-orange-50 dark:bg-primary/10 text-primary shadow-sm ring-1 ring-primary/10' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200 hover:translate-x-1"
                    title="Button Analytics">
                    <ion-icon name="finger-print-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Button Analytics</span>
                </a>
            </nav>
        </div>

        <!-- System & Settings -->
        <div>
            <div
                class="px-2 mb-3 text-[10px] font-black text-gray-400 dark:text-slate-500 uppercase tracking-widest sidebar-text">
                System</div>
            <nav class="space-y-1">
                <?php
                $isSystemActive = ($currentPage == 'users' || $currentPage == 'employees' || $currentPage == 'roles' || $currentPage == 'sessions_active' || $currentPage == 'settings' || $currentPage == 'settings_email' || $currentPage == 'settings_security');
                ?>
                <div>
                    <button onclick="toggleSubmenu('system-submenu')"
                        class="w-full group flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-xl cursor-pointer <?php echo $isSystemActive ? 'bg-orange-50 dark:bg-primary/10 text-primary' : 'text-gray-600 dark:text-slate-400 hover:bg-gray-50 dark:hover:bg-slate-800 hover:text-gray-900 dark:hover:text-white'; ?> transition-all duration-200">
                        <div class="flex items-center gap-3">
                            <ion-icon name="settings-outline" class="text-lg w-5 h-5"></ion-icon>
                            <span class="sidebar-text whitespace-nowrap">Configuration</span>
                        </div>
                        <ion-icon name="chevron-down-outline" id="system-chevron"
                            class="text-sm transition-transform duration-300 <?php echo $isSystemActive ? 'rotate-180' : ''; ?>"></ion-icon>
                    </button>
                    <div id="system-submenu"
                        class="mt-1 space-y-1 overflow-hidden transition-all duration-300 ease-in-out <?php echo $isSystemActive ? 'max-h-96 opacity-100' : 'max-h-0 opacity-50'; ?>">
                        <a href="users.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'users') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Users
                        </a>
                        <a href="employees.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'employees') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Employees
                        </a>
                        <a href="roles.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'roles') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Roles & Perms
                        </a>
                        <a href="sessions_active.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'sessions_active') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Active Sessions
                        </a>
                        <a href="settings_system.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'settings') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Global Settings
                        </a>
                        <a href="settings_email.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'settings_email') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Email Config
                        </a>
                        <a href="settings_security.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'settings_security') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Security
                        </a>
                        <a href="tools_clone.php"
                            class="flex items-center gap-3 pl-11 pr-3 py-2 text-sm font-bold <?php echo ($currentPage == 'tools_clone') ? 'text-primary' : 'text-gray-400 dark:text-slate-500 hover:text-gray-600 dark:hover:text-slate-300'; ?> transition-colors relative before:absolute before:left-8 before:top-1/2 before:-translate-y-1/2 before:w-1.5 before:h-1.5 before:rounded-full before:bg-current before:opacity-20 hover:before:opacity-100">
                            Clone Wizard
                        </a>
                    </div>
                </div>

                <a href="logout.php"
                    class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-xl text-red-600 dark:text-red-400 hover:bg-red-50 dark:hover:bg-red-900/10 transition-all duration-200 hover:translate-x-1"
                    title="Logout">
                    <ion-icon name="log-out-outline" class="text-lg w-5 h-5"></ion-icon>
                    <span class="sidebar-text whitespace-nowrap">Logout</span>
                </a>
            </nav>
        </div>

    </div>
</aside>

<script>
    function toggleSubmenu(id) {
        const submenu = document.getElementById(id);
        const chevronId = id.replace('-submenu', '-chevron');
        const chevron = document.getElementById(chevronId);

        if (!submenu) return;

        // Check current state by max-height class
        if (submenu.classList.contains('max-h-0')) {
            // Expand
            submenu.classList.remove('max-h-0', 'opacity-50');
            submenu.classList.add('max-h-96', 'opacity-100'); // Use large enough max-height
            if (chevron) chevron.classList.add('rotate-180');
        } else {
            // Collapse
            submenu.classList.remove('max-h-96', 'opacity-100');
            submenu.classList.add('max-h-0', 'opacity-50');
            if (chevron) chevron.classList.remove('rotate-180');
        }
    }
</script>